/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.unionpay.sdk;

import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.CertUtil;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.LogUtil;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.SDKConfig;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.SDKUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class CertUtil {
    private static final Map<String, KeyStore> keyStoreMap = new ConcurrentHashMap();
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static PublicKey encryptTrackKey = null;
    private static X509Certificate validateCert = null;
    private static X509Certificate middleCert = null;
    private static X509Certificate rootCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap();

    private static void init() {
        try {
            CertUtil.addProvider();
            CertUtil.initSignCert();
            CertUtil.initMiddleCert();
            CertUtil.initRootCert();
            CertUtil.initEncryptCert();
            CertUtil.initTrackKey();
            CertUtil.initValidateCertFromDir();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"init\u5931\u8d25\u3002\uff08\u5982\u679c\u662f\u7528\u5bf9\u79f0\u5bc6\u94a5\u7b7e\u540d\u7684\u53ef\u65e0\u89c6\u6b64\u5f02\u5e38\u3002\uff09", (Throwable)e);
        }
    }

    private static void addProvider() {
        if (Security.getProvider("BC") == null) {
            LogUtil.writeLog((String)"add BC provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            LogUtil.writeLog((String)"re-add BC provider");
        }
        CertUtil.printSysInfo();
    }

    private static void initSignCert() {
        if (!"01".equals(SDKConfig.getConfig().getSignMethod())) {
            LogUtil.writeLog((String)"\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u3002");
            return;
        }
        if (SDKConfig.getConfig().getSignCertPath() == null || SDKConfig.getConfig().getSignCertPwd() == null || SDKConfig.getConfig().getSignCertType() == null) {
            LogUtil.writeErrorLog((String)"WARN: acpsdk.signCert.path\u6216acpsdk.signCert.pwd\u6216acpsdk.signCert.type\u4e3a\u7a7a\u3002 \u505c\u6b62\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u3002");
            return;
        }
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo((String)SDKConfig.getConfig().getSignCertPath(), (String)SDKConfig.getConfig().getSignCertPwd(), (String)SDKConfig.getConfig().getSignCertType());
            LogUtil.writeLog((String)("InitSignCert Successful. CertId=[" + CertUtil.getSignCertId() + "]"));
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)"InitSignCert Error", (Throwable)e);
        }
    }

    private static void initMiddleCert() {
        LogUtil.writeLog((String)("\u52a0\u8f7d\u4e2d\u7ea7\u8bc1\u4e66==>" + SDKConfig.getConfig().getMiddleCertPath()));
        if (!SDKUtil.isEmpty((String)SDKConfig.getConfig().getMiddleCertPath())) {
            middleCert = CertUtil.initCert((String)SDKConfig.getConfig().getMiddleCertPath());
            LogUtil.writeLog((String)"Load MiddleCert Successful");
        } else {
            LogUtil.writeLog((String)"WARN: acpsdk.middle.path is empty");
        }
    }

    private static void initRootCert() {
        LogUtil.writeLog((String)("\u52a0\u8f7d\u6839\u8bc1\u4e66==>" + SDKConfig.getConfig().getRootCertPath()));
        if (!SDKUtil.isEmpty((String)SDKConfig.getConfig().getRootCertPath())) {
            rootCert = CertUtil.initCert((String)SDKConfig.getConfig().getRootCertPath());
            LogUtil.writeLog((String)"Load RootCert Successful");
        } else {
            LogUtil.writeLog((String)"WARN: acpsdk.rootCert.path is empty");
        }
    }

    private static void initEncryptCert() {
        LogUtil.writeLog((String)("\u52a0\u8f7d\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u8bc1\u4e66==>" + SDKConfig.getConfig().getEncryptCertPath()));
        if (!SDKUtil.isEmpty((String)SDKConfig.getConfig().getEncryptCertPath())) {
            encryptCert = CertUtil.initCert((String)SDKConfig.getConfig().getEncryptCertPath());
            LogUtil.writeLog((String)"Load EncryptCert Successful");
        } else {
            LogUtil.writeLog((String)"WARN: acpsdk.encryptCert.path is empty");
        }
    }

    private static void initTrackKey() {
        if (!SDKUtil.isEmpty((String)SDKConfig.getConfig().getEncryptTrackKeyModulus()) && !SDKUtil.isEmpty((String)SDKConfig.getConfig().getEncryptTrackKeyExponent())) {
            encryptTrackKey = CertUtil.getPublicKey((String)SDKConfig.getConfig().getEncryptTrackKeyModulus(), (String)SDKConfig.getConfig().getEncryptTrackKeyExponent());
            LogUtil.writeLog((String)"LoadEncryptTrackKey Successful");
        } else {
            LogUtil.writeLog((String)"WARN: acpsdk.encryptTrackKey.modulus or acpsdk.encryptTrackKey.exponent is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initValidateCertFromDir() {
        if (!"01".equals(SDKConfig.getConfig().getSignMethod())) {
            LogUtil.writeLog((String)"\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u9a8c\u7b7e\u8bc1\u4e66\u3002");
            return;
        }
        certMap.clear();
        String dir = SDKConfig.getConfig().getValidateCertDir();
        LogUtil.writeLog((String)("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u76ee\u5f55==>" + dir + " \u6ce8\uff1a\u5982\u679c\u8bf7\u6c42\u62a5\u6587\u4e2dversion=5.1.0\u90a3\u4e48\u6b64\u9a8c\u7b7e\u8bc1\u4e66\u76ee\u5f55\u4f7f\u7528\u4e0d\u5230\uff0c\u53ef\u4ee5\u4e0d\u9700\u8981\u8bbe\u7f6e\uff08version=5.0.0\u5fc5\u987b\u8bbe\u7f6e\uff09\u3002"));
        if (SDKUtil.isEmpty((String)dir)) {
            LogUtil.writeErrorLog((String)"WARN: acpsdk.validateCert.dir is empty");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            LogUtil.writeErrorLog((String)"LoadVerifyCert Error: No BC Provider", (Throwable)e);
            return;
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog((String)"LoadVerifyCert Error", (Throwable)e);
            return;
        }
        File fileDir = new File(dir);
        File[] files = fileDir.listFiles((FilenameFilter)new CerFilter());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                if (validateCert == null) {
                    LogUtil.writeErrorLog((String)("Load verify cert error, " + file.getAbsolutePath() + " has error cert content."));
                    continue;
                }
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                LogUtil.writeLog((String)("[" + file.getAbsolutePath() + "][CertId=" + validateCert.getSerialNumber().toString() + "]"));
                continue;
            }
            catch (CertificateException e) {
                LogUtil.writeErrorLog((String)"LoadVerifyCert Error", (Throwable)e);
                continue;
            }
            catch (FileNotFoundException e) {
                LogUtil.writeErrorLog((String)"LoadVerifyCert Error File Not Found", (Throwable)e);
                continue;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LogUtil.writeErrorLog((String)e.toString());
                    }
                }
            }
        }
        LogUtil.writeLog((String)"LoadVerifyCert Finish");
    }

    private static void loadSignCert(String certFilePath, String certPwd) {
        KeyStore keyStore = null;
        try {
            keyStore = CertUtil.getKeyInfo((String)certFilePath, (String)certPwd, (String)"PKCS12");
            keyStoreMap.put(certFilePath, keyStore);
            LogUtil.writeLog((String)"LoadRsaCert Successful");
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)"LoadRsaCert Error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        URL url = null;
        HttpURLConnection httpUrlConnection = null;
        BufferedInputStream fis = null;
        try {
            url = new URL(path);
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setConnectTimeout(5000);
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.setRequestProperty("Charsert", "UTF-8");
            httpUrlConnection.connect();
            fis = new BufferedInputStream(httpUrlConnection.getInputStream());
            cf = CertificateFactory.getInstance("X.509", "BC");
            encryptCertTemp = (X509Certificate)cf.generateCertificate(fis);
            LogUtil.writeLog((String)("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]"));
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog((String)"InitCert Error", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            LogUtil.writeErrorLog((String)"LoadVerifyCert Error No BC Provider", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (httpUrlConnection != null) {
                    httpUrlConnection.disconnect();
                }
            }
            catch (IOException e) {
                LogUtil.writeErrorLog((String)e.toString());
            }
        }
        return encryptCertTemp;
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, SDKConfig.getConfig().getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String certPwd) {
        if (!keyStoreMap.containsKey(certPath)) {
            CertUtil.loadSignCert((String)certPath, (String)certPwd);
        }
        try {
            Enumeration<String> aliasenum = ((KeyStore)keyStoreMap.get(certPath)).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)((KeyStore)keyStoreMap.get(certPath)).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        if (null == encryptCert) {
            String path = SDKConfig.getConfig().getEncryptCertPath();
            if (!SDKUtil.isEmpty((String)path)) {
                encryptCert = CertUtil.initCert((String)path);
                return encryptCert.getPublicKey();
            }
            LogUtil.writeErrorLog((String)"acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getPublicKey();
    }

    public static void resetEncryptCertPublicKey() {
        encryptCert = null;
    }

    public static PublicKey getEncryptTrackPublicKey() {
        if (null == encryptTrackKey) {
            CertUtil.initTrackKey();
        }
        return encryptTrackKey;
    }

    public static PublicKey getValidatePublicKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = (X509Certificate)certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = (X509Certificate)certMap.get(certId);
            return cf.getPublicKey();
        }
        LogUtil.writeErrorLog((String)("\u7f3a\u5c11certId=[" + certId + "]\u5bf9\u5e94\u7684\u9a8c\u7b7e\u8bc1\u4e66."));
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"getSignCertId Error", (Throwable)e);
            return null;
        }
    }

    public static String getEncryptCertId() {
        if (null == encryptCert) {
            String path = SDKConfig.getConfig().getEncryptCertPath();
            if (!SDKUtil.isEmpty((String)path)) {
                encryptCert = CertUtil.initCert((String)path);
                return encryptCert.getSerialNumber().toString();
            }
            LogUtil.writeErrorLog((String)"acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getSerialNumber().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        LogUtil.writeLog((String)("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + pfxkeyfile));
        URL url = null;
        HttpURLConnection httpUrlConnection = null;
        BufferedInputStream fis = null;
        try {
            url = new URL(pfxkeyfile);
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setConnectTimeout(5000);
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.setRequestProperty("Charsert", "UTF-8");
            httpUrlConnection.connect();
            fis = new BufferedInputStream(httpUrlConnection.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            KeyStore ks = KeyStore.getInstance(type, "BC");
            LogUtil.writeLog((String)("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "],type=[" + type + "]"));
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"getKeyInfo Error", (Throwable)e);
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
    }

    public static String getCertIdByKeyStoreMap(String certPath, String certPwd) {
        if (!keyStoreMap.containsKey(certPath)) {
            CertUtil.loadSignCert((String)certPath, (String)certPwd);
        }
        return CertUtil.getCertIdIdByStore((KeyStore)((KeyStore)keyStoreMap.get(certPath)));
    }

    private static String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog((String)"getCertIdIdByStore Error", (Throwable)e);
            return null;
        }
    }

    private static PublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)("\u6784\u9020RSA\u516c\u94a5\u5931\u8d25\uff1a" + e));
            return null;
        }
    }

    public static X509Certificate genCertificateByStr(String x509CertString) {
        X509Certificate x509Cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream tIn = new ByteArrayInputStream(x509CertString.getBytes("ISO-8859-1"));
            x509Cert = (X509Certificate)cf.generateCertificate(tIn);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"gen certificate error", (Throwable)e);
        }
        return x509Cert;
    }

    public static X509Certificate getMiddleCert() {
        if (null == middleCert) {
            String path = SDKConfig.getConfig().getMiddleCertPath();
            if (!SDKUtil.isEmpty((String)path)) {
                CertUtil.initMiddleCert();
            } else {
                LogUtil.writeErrorLog((String)"acpsdk.middleCert.path not set in acp_sdk.properties");
                return null;
            }
        }
        return middleCert;
    }

    public static void initCert() {
        CertUtil.init();
    }

    public static X509Certificate getRootCert() {
        if (null == rootCert) {
            String path = SDKConfig.getConfig().getRootCertPath();
            if (!SDKUtil.isEmpty((String)path)) {
                CertUtil.initRootCert();
            } else {
                LogUtil.writeErrorLog((String)"acpsdk.rootCert.path not set in acp_sdk.properties");
                return null;
            }
        }
        return rootCert;
    }

    private static String getIdentitiesFromCertficate(X509Certificate aCert) {
        String[] tSplitStr;
        String tDN = aCert.getSubjectDN().toString();
        String tPart = "";
        if (tDN != null && (tSplitStr = tDN.substring(tDN.indexOf("CN=")).split("@")) != null && tSplitStr.length > 2 && tSplitStr[2] != null) {
            tPart = tSplitStr[2];
        }
        return tPart;
    }

    private static boolean verifyCertificateChain(X509Certificate cert) {
        if (null == cert) {
            LogUtil.writeErrorLog((String)"cert must Not null");
            return false;
        }
        X509Certificate middleCert = CertUtil.getMiddleCert();
        if (null == middleCert) {
            LogUtil.writeErrorLog((String)"middleCert must Not null");
            return false;
        }
        X509Certificate rootCert = CertUtil.getRootCert();
        if (null == rootCert) {
            LogUtil.writeErrorLog((String)"rootCert or cert must Not null");
            return false;
        }
        try {
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(cert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            trustAnchors.add(new TrustAnchor(rootCert, null));
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            intermediateCerts.add(rootCert);
            intermediateCerts.add(middleCert);
            intermediateCerts.add(cert);
            pkixParams.setRevocationEnabled(false);
            CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(intermediateCerts), "BC");
            pkixParams.addCertStore(intermediateCertStore);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(pkixParams);
            LogUtil.writeLog((String)"verify certificate chain succeed.");
            return true;
        }
        catch (CertPathBuilderException e) {
            LogUtil.writeErrorLog((String)"verify certificate chain fail.", (Throwable)e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"verify certificate chain exception: ", (Throwable)e);
        }
        return false;
    }

    public static boolean verifyCertificate(X509Certificate cert) {
        if (null == cert) {
            LogUtil.writeErrorLog((String)"cert must Not null");
            return false;
        }
        try {
            cert.checkValidity();
            if (!CertUtil.verifyCertificateChain((X509Certificate)cert)) {
                return false;
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"verifyCertificate fail", (Throwable)e);
            return false;
        }
        if (SDKConfig.getConfig().isIfValidateCNName()) {
            if (!"\u4e2d\u56fd\u94f6\u8054\u80a1\u4efd\u6709\u9650\u516c\u53f8".equals(CertUtil.getIdentitiesFromCertficate((X509Certificate)cert))) {
                LogUtil.writeErrorLog((String)("cer owner is not CUP:" + CertUtil.getIdentitiesFromCertficate((X509Certificate)cert)));
                return false;
            }
        } else if (!"\u4e2d\u56fd\u94f6\u8054\u80a1\u4efd\u6709\u9650\u516c\u53f8".equals(CertUtil.getIdentitiesFromCertficate((X509Certificate)cert)) && !"00040000:SIGN".equals(CertUtil.getIdentitiesFromCertficate((X509Certificate)cert))) {
            LogUtil.writeErrorLog((String)("cer owner is not CUP:" + CertUtil.getIdentitiesFromCertficate((X509Certificate)cert)));
            return false;
        }
        return true;
    }

    private static void printSysInfo() {
        LogUtil.writeLog((String)"================= SYS INFO begin====================");
        LogUtil.writeLog((String)("os_name:" + System.getProperty("os.name")));
        LogUtil.writeLog((String)("os_arch:" + System.getProperty("os.arch")));
        LogUtil.writeLog((String)("os_version:" + System.getProperty("os.version")));
        LogUtil.writeLog((String)("java_vm_specification_version:" + System.getProperty("java.vm.specification.version")));
        LogUtil.writeLog((String)("java_vm_specification_vendor:" + System.getProperty("java.vm.specification.vendor")));
        LogUtil.writeLog((String)("java_vm_specification_name:" + System.getProperty("java.vm.specification.name")));
        LogUtil.writeLog((String)("java_vm_version:" + System.getProperty("java.vm.version")));
        LogUtil.writeLog((String)("java_vm_name:" + System.getProperty("java.vm.name")));
        LogUtil.writeLog((String)("java.version:" + System.getProperty("java.version")));
        LogUtil.writeLog((String)("java.vm.vendor=[" + System.getProperty("java.vm.vendor") + "]"));
        LogUtil.writeLog((String)("java.version=[" + System.getProperty("java.version") + "]"));
        CertUtil.printProviders();
        LogUtil.writeLog((String)"================= SYS INFO end=====================");
    }

    private static void printProviders() {
        LogUtil.writeLog((String)"Providers List:");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            LogUtil.writeLog((String)(i + 1 + "." + providers[i].getName()));
        }
    }

    static {
        CertUtil.init();
    }
}

