/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.ThirdPartyRelation;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestOfflineOederQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrCodeCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrIsSweptCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayService;
import com.ebaiyihui.aggregation.payment.server.dto.GetPayBillReqDTO;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundBySplitAccountReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundBySplitAccountRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundPayOrderRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPayTrade;
import com.ebaiyihui.aggregation.payment.server.hypay.HyProfitSharing;
import com.ebaiyihui.aggregation.payment.server.mapper.PayBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ProfitSharingRecordMapper;
import com.ebaiyihui.aggregation.payment.server.service.ChannelBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PlatformBillService;
import com.ebaiyihui.aggregation.payment.server.service.ThirdPartyRelationService;
import com.ebaiyihui.aggregation.payment.server.service.WxProfitSharingService;
import com.ebaiyihui.aggregation.payment.server.service.impl.AlipayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.impl.UnionPayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.impl.WechatPayServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingFinishRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingQueryRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingQueryResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReceiverRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReceiverResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnQueryRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnResult;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trade"})
@Api(tags={"\u652f\u4ed8\u63a5\u53e3"})
public class TradeController {
    private static final Logger log = LoggerFactory.getLogger(TradeController.class);
    @Autowired
    WechatPayServiceImpl wechatPayService;
    @Autowired
    AlipayServiceImpl alipayService;
    @Autowired
    PayBillService payBillService;
    @Autowired
    UnionPayServiceImpl unionPayService;
    @Autowired
    PayService payService;
    @Autowired
    WxProfitSharingService profitSharingService;
    @Autowired
    ChannelBillService channelBillService;
    @Autowired
    PlatformBillService platformBillService;
    @Resource
    ThirdPartyRelationService relationService;
    @Resource
    HyPayTrade hyPayTrade;
    final String SUCCESS_RETURN_CODE = "SUCCESS";
    @Resource
    PayBillMapper payBillMapper;
    @Resource
    ProfitSharingRecordMapper profitSharingRecordMapper;
    @Resource
    HyProfitSharing hyProfitSharing;
    static final Integer BILL_STATUS = 3;

    @PostMapping(value={"/create-order"})
    public BaseResponse<String> createOrder(HttpServletRequest request, @Valid @RequestBody RequestCreateOrderVo requestCreateOrderVo) throws Exception {
        log.info("{request=" + request + "}/t{requestCreateOrderVo=" + requestCreateOrderVo + "}");
        if (null != requestCreateOrderVo.getPayChannel()) {
            return this.payService.createOrderLauncher(request, requestCreateOrderVo);
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/refund"})
    public BaseResponse<String> refund(@Valid @RequestBody RequestRefundOrderVo requestRefundOrderVo) {
        if (null != requestRefundOrderVo.getPayChannel()) {
            BaseResponse hyResponse = this.hyRefundPackaging(requestRefundOrderVo);
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)hyResponse.getData())) && ((String)hyResponse.getData()).equals(Boolean.FALSE.toString())) {
                return this.payService.refundOrderLauncher(requestRefundOrderVo);
            }
            return hyResponse;
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    public BaseResponse<String> hyRefundPackaging(RequestRefundOrderVo requestRefundOrderVo) {
        ThirdPartyRelation relationInfoByApplyCode = this.relationService.getRelationInfoByApplyCode(requestRefundOrderVo.getMchCode());
        if (Objects.nonNull(relationInfoByApplyCode)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"out_trade_no", (Object)requestRefundOrderVo.getDealTradeNo());
            List profitSharingRecords = this.profitSharingRecordMapper.selectList((Wrapper)queryWrapper);
            if (Objects.nonNull(profitSharingRecords)) {
                HyRefundBySplitAccountReqVO hyRefundBySplitAccountReqVO = new HyRefundBySplitAccountReqVO();
                hyRefundBySplitAccountReqVO.setOut_trade_no(requestRefundOrderVo.getDealTradeNo());
                HyRefundBySplitAccountRespVO hyRefundBySplitAccountRespVO = this.hyProfitSharing.refundBySplitAccount(hyRefundBySplitAccountReqVO);
                if (hyRefundBySplitAccountRespVO.getReturn_code().equals("SUCCESS") && hyRefundBySplitAccountRespVO.getResult_code().equals("FAIL")) {
                    return BaseResponse.error((String)hyRefundBySplitAccountRespVO.getError_msg());
                }
                if (hyRefundBySplitAccountRespVO.getReturn_code().equals("FAIL")) {
                    return BaseResponse.error((String)hyRefundBySplitAccountRespVO.getReturn_msg());
                }
            } else {
                BaseResponse refundPayOrderRespVOBaseResponse = this.hyPayTrade.refundOrder(requestRefundOrderVo);
                if (((HyRefundPayOrderRespVO)refundPayOrderRespVOBaseResponse.getData()).getReturn_code().equals("SUCCESS") && ((HyRefundPayOrderRespVO)refundPayOrderRespVOBaseResponse.getData()).getResult_code().equals("FAIL")) {
                    return BaseResponse.error((String)((HyRefundPayOrderRespVO)refundPayOrderRespVOBaseResponse.getData()).getError_msg());
                }
                if (((HyRefundPayOrderRespVO)refundPayOrderRespVOBaseResponse.getData()).getReturn_code().equals("FAIL")) {
                    return BaseResponse.error((String)((HyRefundPayOrderRespVO)refundPayOrderRespVOBaseResponse.getData()).getReturn_msg());
                }
            }
            return BaseResponse.success((Object)"\u7533\u8bf7\u9000\u6b3e\u6210\u529f");
        }
        return BaseResponse.success((Object)Boolean.FALSE.toString());
    }

    @PostMapping(value={"/download"})
    public BaseResponse<WxPayBillResult> downloadBill(@RequestBody RequestDownloadVo requestDownloadVo) {
        if (PayChanEnum.WECHAT.getDisplay().equals(requestDownloadVo.getPayChannel())) {
            return this.wechatPayService.downLoadBill(requestDownloadVo);
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/query-order"})
    public BaseResponse<ResponseQueryOrderVo> queryOrder(@RequestBody RequestQueryOrderVo requestQueryOrderVo) throws Exception {
        GetPayBillReqDTO getPayBillReqDTO = new GetPayBillReqDTO();
        BeanUtils.copyProperties((Object)requestQueryOrderVo, (Object)getPayBillReqDTO);
        log.info("\u67e5\u8be2\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570DTO:{}", (Object)getPayBillReqDTO);
        PayBill payBill = this.payBillService.getPayBillByTradeNoOrDealTradeNoOrOutTradeNo(getPayBillReqDTO);
        if (null == payBill) {
            log.info("=========\u67e5\u8be2\u8ba2\u5355\u4e0d\u5b58\u5728=========");
            return BaseResponse.error((String)"\u67e5\u8be2\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (null != payBill.getTradeChannel()) {
            ResponseQueryOrderVo queryOrderVo = this.payService.queryOrderLauncher(payBill);
            return BaseResponse.success((Object)queryOrderVo);
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/query-refund-order"})
    public BaseResponse<ResponseQueryRefundOrderVo> queryRefundOrder(@RequestBody RequestQueryRefundOrderVo requestQueryRefundOrderVo) {
        GetPayBillReqDTO getPayBillReqDTO = new GetPayBillReqDTO();
        BeanUtils.copyProperties((Object)requestQueryRefundOrderVo, (Object)getPayBillReqDTO);
        log.info("\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570DTO:{}", (Object)getPayBillReqDTO);
        PayBill payBill = this.payBillService.getPayBillByTradeNoOrDealTradeNoOrOutTradeNo(getPayBillReqDTO);
        if (null == payBill) {
            log.info("=========\u67e5\u8be2\u8ba2\u5355\u4e0d\u5b58\u5728=========");
            return BaseResponse.error((String)"\u67e5\u8be2\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (PayChanEnum.WECHAT.getDisplay().equals(payBill.getTradeChannel())) {
            return BaseResponse.success((Object)this.wechatPayService.queryRefundOrder(requestQueryRefundOrderVo, payBill));
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/close-order"})
    public BaseResponse<ResponseCloseOrderVo> closeOrder(@RequestBody RequestCloseOrderVo requestCloseOrderVo) {
        GetPayBillReqDTO getPayBillReqDTO = new GetPayBillReqDTO();
        BeanUtils.copyProperties((Object)requestCloseOrderVo, (Object)getPayBillReqDTO);
        log.info("\u67e5\u8be2\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570DTO:{}", (Object)getPayBillReqDTO);
        PayBill payBill = this.payBillService.getPayBillByTradeNoOrDealTradeNoOrOutTradeNo(getPayBillReqDTO);
        if (null == payBill) {
            log.info("=========\u67e5\u8be2\u8ba2\u5355\u4e0d\u5b58\u5728=========");
            return BaseResponse.error((String)"\u67e5\u8be2\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (PayChanEnum.WECHAT.getDisplay().equals(payBill.getTradeChannel())) {
            return BaseResponse.success((Object)this.wechatPayService.closeOrder(payBill));
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/offline_order_query"})
    public BaseResponse<ResponseQueryOrderVo> offlineOrderQuery(@RequestBody RequestOfflineOederQueryVO reqVo) throws Exception {
        log.info("\u67e5\u8be2\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570DTO:{}", (Object)reqVo);
        if (PayChanEnum.WECHAT.getDisplay().equals(reqVo.getChanCode())) {
            return BaseResponse.success((Object)this.wechatPayService.offlineQueryOrder(reqVo));
        }
        return BaseResponse.error((String)"\u6b64\u6e20\u9053\u4e0d\u652f\u6301");
    }

    @PostMapping(value={"qrCode"})
    public BaseResponse<String> qrCode(RequestQrCodeCreateOrderVo qrCodeCreateOrderVo) throws IOException {
        if (qrCodeCreateOrderVo.getPayChannel().equals(PayChanEnum.UNIONPAY.getDisplay())) {
            return this.unionPayService.qrCode(qrCodeCreateOrderVo);
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"qrIsSwept"})
    public BaseResponse<String> qrIsSwept(RequestQrIsSweptCreateOrderVo orderVo) throws IOException {
        if (orderVo.getPayChannel().equals(PayChanEnum.UNIONPAY.getDisplay())) {
            return this.unionPayService.qrIsSwept(orderVo);
        }
        return BaseResponse.error((String)"\u6e20\u9053\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"addReceiver"})
    public BaseResponse<ProfitSharingReceiverResult> addReceiver(@RequestBody ProfitSharingReceiverRequest request) throws Exception {
        ProfitSharingReceiverResult receiverResult = this.profitSharingService.addReceiver(request);
        return BaseResponse.success((Object)receiverResult);
    }

    @PostMapping(value={"multiProfitSharing"})
    public BaseResponse<ProfitSharingResult> multiProfitSharing(@RequestBody ProfitSharingRequest request) throws Exception {
        log.info(JSONObject.toJSONString((Object)request));
        ProfitSharingResult receiverResult = this.profitSharingService.multiProfitSharing(request);
        return BaseResponse.success((Object)receiverResult);
    }

    @PostMapping(value={"profitSharing"})
    public BaseResponse<ProfitSharingResult> profitSharing(@RequestBody ProfitSharingRequest request) throws Exception {
        ProfitSharingResult receiverResult = this.profitSharingService.profitSharing(request);
        return BaseResponse.success((Object)receiverResult);
    }

    @PostMapping(value={"profitSharingFinish"})
    public BaseResponse<ProfitSharingResult> profitSharingFinish(@RequestBody ProfitSharingFinishRequest request) throws Exception {
        ProfitSharingResult receiverResult = this.profitSharingService.profitSharingFinish(request);
        return BaseResponse.success((Object)receiverResult);
    }

    @PostMapping(value={"profitSharingQuery"})
    public BaseResponse<ProfitSharingQueryResult> profitSharingQuery(@RequestBody ProfitSharingQueryRequest request) throws Exception {
        ProfitSharingQueryResult result = this.profitSharingService.profitSharingQuery(request);
        return BaseResponse.success((Object)result);
    }

    @PostMapping(value={"profitSharingReturn"})
    public BaseResponse<ProfitSharingReturnResult> profitSharingReturn(@RequestBody ProfitSharingReturnRequest returnRequest) throws Exception {
        return this.profitSharingService.profitSharingReturn(returnRequest);
    }

    @PostMapping(value={"profitSharingReturnQuery"})
    public BaseResponse<ProfitSharingReturnResult> profitSharingReturnQuery(@RequestBody ProfitSharingReturnQueryRequest queryRequest) throws Exception {
        ProfitSharingReturnResult returnResult = this.profitSharingService.profitSharingReturnQuery(queryRequest);
        return BaseResponse.success((Object)returnResult);
    }

    @PostMapping(value={"removeReceiver"})
    public BaseResponse<ProfitSharingReceiverResult> removeReceiver(@RequestBody ProfitSharingReceiverRequest request) throws Exception {
        ProfitSharingReceiverResult returnResult = this.profitSharingService.removeReceiver(request);
        return BaseResponse.success((Object)returnResult);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u76d1\u63a7")
    @GetMapping(value={"check_health"})
    public BaseResponse monitoring() {
        this.channelBillService.selectList();
        return BaseResponse.success();
    }

    @GetMapping(value={"/business_refund"})
    public BaseResponse<String> businessRefund(@RequestParam(name="outTradeNo") String outTradeNo, @RequestParam(name="refundNotifyUrl") String refundNotifyUrl, @RequestParam(name="dealTradeNo", required=false) String dealTradeNo, @RequestParam(name="refundAmount", required=false) String refundAmount) {
        String validateResult = this.businessRefundParamValidate(outTradeNo, refundNotifyUrl, dealTradeNo);
        if (StringUtils.isNotBlank((CharSequence)validateResult)) {
            return BaseResponse.error((String)validateResult);
        }
        PayBill payBill = this.queryBillByOutTradeNo(outTradeNo);
        if (StringUtils.isNotBlank((CharSequence)dealTradeNo) && Objects.isNull(payBill)) {
            payBill = this.queryBillByDealTradeNo(dealTradeNo);
        }
        if (Objects.isNull(payBill)) {
            throw new RuntimeException("\u4ea4\u6613\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        RequestRefundOrderVo requestRefundOrderVo = this.requestRefundOrderVoAssignment(payBill, refundNotifyUrl, refundAmount);
        return this.payService.refundOrderLauncher(requestRefundOrderVo);
    }

    private String businessRefundParamValidate(String outTradeNo, String refundNotifyUrl, String dealTradeNo) {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            return "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)dealTradeNo) && StringUtils.isBlank((CharSequence)refundNotifyUrl)) {
            return "\u56de\u8c03\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return "";
    }

    private RequestRefundOrderVo requestRefundOrderVoAssignment(PayBill payBill, String refundNotifyUrl, String refundAmount) {
        RequestRefundOrderVo requestRefundOrderVo = new RequestRefundOrderVo();
        requestRefundOrderVo.setApplyCode(payBill.getMchCode());
        requestRefundOrderVo.setPayChannel(payBill.getTradeChannel());
        requestRefundOrderVo.setMchCode(payBill.getMchCode());
        requestRefundOrderVo.setRefundAmount(StringUtils.isNotBlank((CharSequence)refundAmount) && Float.parseFloat(refundAmount) > 0.0f ? new BigDecimal(refundAmount) : payBill.getDealAmount());
        requestRefundOrderVo.setTotalAmount(payBill.getOrderAmount());
        requestRefundOrderVo.setDealTradeNo(payBill.getDealTradeNo());
        requestRefundOrderVo.setRefundNotifyUrl(refundNotifyUrl);
        requestRefundOrderVo.setSign(payBill.getOutTradeNo());
        requestRefundOrderVo.setOutTradeNo(payBill.getOutTradeNo());
        return requestRefundOrderVo;
    }

    private PayBill queryBillByOutTradeNo(String outTradeNo) {
        PayBill queryPayBill = new PayBill();
        queryPayBill.setOutTradeNo(outTradeNo);
        QueryWrapper queryWrapper = new QueryWrapper((Object)queryPayBill);
        List payBills = this.payBillMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)payBills)) {
            return null;
        }
        return (PayBill)payBills.get(0);
    }

    private PayBill queryBillByDealTradeNo(String dealTradeNo) {
        PayBill queryPayBill = new PayBill();
        queryPayBill.setDealTradeNo(dealTradeNo);
        QueryWrapper queryWrapper = new QueryWrapper((Object)queryPayBill);
        PayBill payBill = (PayBill)this.payBillMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(payBill)) {
            throw new RuntimeException("\u4ea4\u6613\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!payBill.getStatus().equals(BILL_STATUS)) {
            throw new RuntimeException("\u8bf7\u68c0\u67e5\u5f53\u524d\u8ba2\u5355\u7684\u652f\u4ed8\u72b6\u6001\u662f\u5426\u6b63\u786e,\u8ba2\u5355\u5fc5\u987b\u4e3a\u5df2\u652f\u4ed8");
        }
        return payBill;
    }
}

