/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayOpenAuthTokenAppModel;
import com.alipay.api.request.AlipayOpenAuthTokenAppRequest;
import com.alipay.api.response.AlipayOpenAuthTokenAppResponse;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.UserTransferInfo;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderH5VO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestWxH5PayVo;
import com.ebaiyihui.aggregation.payment.server.business.IPay;
import com.ebaiyihui.aggregation.payment.server.business.PayFactory;
import com.ebaiyihui.aggregation.payment.server.constant.URLConstant;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayApplyMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.UserTransferInfoMapper;
import com.ebaiyihui.aggregation.payment.server.service.AggregationService;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.utils.PayHtmlUtils;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.aggregation.payment.server.utils.WxAuthApiClient;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.ui.ModelMap;

@Service
public class AggregationServiceImpl
implements AggregationService {
    private static final Logger log = LoggerFactory.getLogger(AggregationServiceImpl.class);
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private URLConstant wxConfigConstant;
    @Autowired
    private PayMchMapper payMchMapper;
    @Autowired
    MchChanMapper mchChanMapper;
    @Autowired
    PayApplyMapper payApplyMapper;
    @Resource
    private UserTransferInfoMapper userTransferInfoMapper;
    @Value(value="${h5.unifiedH5Pay.url}")
    private String unifiedH5PayUrl;
    @Value(value="${qrcode.url}")
    private String url;
    private String heecode;
    private String userAgentInfo = "user-agent";
    private static Long expiredTime = 1800000L;
    private static String PREPAY = "prePay";
    private static String PAYHTML = "index";
    private static final String STATE = "123";
    private static final String APPID = "wx4ee3ae2857ad1e18";
    private static final String APPSECRET = "564cead5b1a3604411c1d5a15e8c1e3d";

    public BaseResponse prepayment(RequestCreateOrderVo createOrderVo) {
        log.info("*************\u8c03\u7528prepayment\u65b9\u6cd5***********");
        try {
            String outTradeNo = createOrderVo.getOutTradeNo();
            String redisKey = outTradeNo + "_" + createOrderVo.getPayType();
            if (BigDecimal.ZERO.compareTo(createOrderVo.getTotalAmount()) >= 0) {
                return BaseResponse.error((String)"\u8ba2\u5355\u91d1\u989d\u5f02\u5e38");
            }
            String orderViewId = "zz".concat(UniqueKeyGenerator.generateViewId());
            PayBill payBill = this.payBillService.getByCreateOrder(createOrderVo);
            log.info("\u8bb0\u5f55\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)payBill));
            payBill.setDealTradeNo(orderViewId);
            this.payBillService.update(payBill);
            if (!this.redisTemplate.hasKey((Object)redisKey).booleanValue()) {
                log.info("\u8ba2\u5355\u5df2\u5b58\u5728!");
                this.payBillService.save(payBill);
            }
            this.paymentRecordsService.saveByBill(orderViewId, createOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)createOrderVo));
            this.redisTemplate.opsForHash().put((Object)redisKey, (Object)PREPAY, (Object)jsonObject);
            String QrCodeUrl = this.url + "?outTradeNo=" + outTradeNo;
            log.info("\u805a\u5408\u652f\u4ed8\u4e8c\u7ef4\u7801 : {}", (Object)QrCodeUrl);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("codeUrl", QrCodeUrl);
            map.put("outTradeNo", outTradeNo);
            map.put("dealTradeNo", orderViewId);
            return BaseResponse.success((Object)JSON.toJSONString(map));
        }
        catch (Exception e) {
            log.error("prepayment error,e=", (Throwable)e);
            return BaseResponse.error((String)"prepayment error!");
        }
    }

    public String payWithOrder(ModelMap model, HttpServletRequest request, HttpServletResponse httpResponse, String outTradeNo) throws IOException {
        RequestCreateOrderVo orderVo = this.getPyaBillAndRequestCreateOrderVo(outTradeNo);
        log.info("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u4e3a:{}", (Object)orderVo);
        String userAgent = request.getHeader(this.userAgentInfo);
        String payType = null;
        if (userAgent != null && userAgent.contains("AlipayClient")) {
            log.info("\u9009\u62e9\u652f\u4ed8\u5b9d\u652f\u4ed8,useragent\u4e3a:{}", (Object)userAgent);
            payType = PayChanEnum.ALIPAY.getDisplay();
        } else if (userAgent != null && userAgent.contains("MicroMessenger")) {
            log.info("\u9009\u62e9\u5fae\u4fe1\u652f\u4ed8,useragent\u4e3a:{}", (Object)userAgent);
            payType = PayChanEnum.WECHAT.getDisplay();
            String openId = request.getParameter("openId");
            log.info("wechat aggregation openId:{}", (Object)openId);
            if (null == openId) {
                log.info("\u7528\u6237\u672a\u6388\u6743,\u8bf7\u7528\u6237\u6388\u6743\u518d\u83b7\u53d6openId");
                String outTradeNoURL = "?outTradeNo=" + outTradeNo;
                String getOpenIdUrl = new StringBuffer(this.wxConfigConstant.getRemoteCallAddress()).append(URLConstant.GET_OPENID_URI).toString();
                String url = getOpenIdUrl + outTradeNoURL;
                log.info("\u8ba2\u5355\u652f\u4ed8\u8df3\u8f6cURL={}", (Object)url);
                return "redirect:" + url;
            }
        }
        log.info("\u805a\u5408\u652f\u4ed8user-agent:{}", payType);
        IPay type = PayFactory.getPayType(payType);
        log.info("\u652f\u4ed8\u5b9e\u73b0\u7c7b:{}", (Object)type);
        BaseResponse response = type.pay(request, orderVo);
        if (!response.isSuccess()) {
            log.info("\u652f\u4ed8\u5931\u8d25,\u8fd4\u56de\u4fe1\u606f\u4e3anull,{}", (Object)response);
            return "qrpay.html";
        }
        String data = response.getData().toString();
        if (PayChanEnum.WECHAT.getDisplay().equals(payType)) {
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            log.info("\u5fae\u4fe1\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)jsonObject.toJSONString());
            model.put((Object)"appId", (Object)jsonObject.getString("appId"));
            model.put((Object)"nonceStr", (Object)jsonObject.getString("nonceStr"));
            model.put((Object)"packageValue", (Object)jsonObject.getString("packageValue"));
            model.put((Object)"signType", (Object)jsonObject.getString("signType"));
            model.put((Object)"paySign", (Object)jsonObject.getString("paySign"));
            model.put((Object)"timeStamp", (Object)jsonObject.getString("timeStamp"));
            log.info("\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e:{}", (Object)model);
        } else if (PayChanEnum.ALIPAY.getDisplay().equals(payType)) {
            httpResponse.reset();
            request.setAttribute("formUrl", (Object)data);
            httpResponse.setContentType("text/html;charset=UTF-8");
            httpResponse.getWriter().write(data);
            httpResponse.getWriter().flush();
        }
        return "qrpay.html";
    }

    public String getOpenId(HttpServletRequest request, HttpServletResponse response) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u7528\u6237openID\u9875\u9762");
        String outTradeNo = request.getParameter("outTradeNo");
        String redirectUrl = new StringBuffer(this.wxConfigConstant.getRemoteCallAddress()).append(URLConstant.REDIRECT_URI).toString() + "?outTradeNo=" + outTradeNo;
        String code = request.getParameter("code");
        String openId = "";
        WxPayParam payParam = this.getConfig(outTradeNo);
        log.info("\u83b7\u53d6\u5546\u6237jsGZHapi\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)payParam));
        if (!StringUtils.isBlank((CharSequence)code)) {
            openId = WxAuthApiClient.getOAuthOpenId((String)payParam.appId, (String)payParam.secret, (String)code);
            log.info("\u8c03\u7528\u5fae\u4fe1\u8fd4\u56deopenId={}", (Object)openId);
            redirectUrl = redirectUrl.indexOf("?") > 0 ? redirectUrl + "&openId=" + openId : redirectUrl + "?openId=" + openId;
            log.info("\u62ff\u5230openid\u91cd\u65b0\u652f\u4ed8\u8ba2\u5355\u8df3\u8f6cURL={}", (Object)this.url);
            return redirectUrl;
        }
        String timeMillis = String.valueOf(System.currentTimeMillis());
        String getOpenIdUrl = new StringBuffer(this.wxConfigConstant.getRemoteCallAddress()).append(URLConstant.GET_OPENID_URI).toString();
        String redirectUrl4Vx = getOpenIdUrl + "?outTradeNo=" + outTradeNo + "&timeMillis=" + timeMillis;
        log.info("\u5fae\u4fe1\u6388\u6743\u5730\u5740:{},APPID:{},\u56de\u8c03\u5730\u5740:{}", new Object[]{URLConstant.SCOPE_TYPE_SNSAPI_BASE, payParam.appId, WxAuthApiClient.urlEnodeUTF8((String)redirectUrl4Vx)});
        String url = String.format(URLConstant.SCOPE_TYPE_SNSAPI_BASE, payParam.appId, WxAuthApiClient.urlEnodeUTF8((String)redirectUrl4Vx), STATE);
        log.info("\u83b7\u53d6\u7528\u6237\u6388\u6743\u8df3\u8f6cURL={}", (Object)url);
        return url;
    }

    public WxPayParam getConfig(String outTradeNo) {
        PayBill payBill = this.payBillService.getByOutTradeNo(outTradeNo);
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)payBill.toString());
        log.info("\u652f\u4ed8\u7c7b\u578b\u6539\u4e3a:{},\u652f\u4ed8\u6e20\u9053\u4e3a:{}", (Object)WechatTradeTypeEnum.JSGZHAPI.getDisplay(), (Object)PayChanEnum.WECHAT.getDisplay());
        payBill.setTradeType(WechatTradeTypeEnum.JSGZHAPI.getDisplay());
        payBill.setTradeChannel(PayChanEnum.WECHAT.getDisplay());
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        if (null == mchChan) {
            return null;
        }
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)mchChan));
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return wxPayParam;
    }

    private String respHtml(String outTradeNo) {
        HashMap<String, String> map = new HashMap<String, String>();
        String html = PayHtmlUtils.getHtmlToString((String)PAYHTML);
        log.info("\u8c03\u7528\u5de5\u5177\u8bfb\u53d6\u9875\u9762:{}", (Object)html);
        map.put("PayHtml", html);
        map.put("outTradeNo", outTradeNo);
        String jsonString = JSON.toJSONString(map);
        return jsonString;
    }

    public RequestCreateOrderVo getPyaBillAndRequestCreateOrderVo(String outTradeNo) {
        RequestCreateOrderVo orderVo = new RequestCreateOrderVo();
        PayBill payBill = this.payBillService.getByOutTradeNo(outTradeNo);
        orderVo.setMchCode(payBill.getMchCode());
        orderVo.setServiceCode(payBill.getServiceCode());
        orderVo.setOutTradeNo(outTradeNo);
        orderVo.setTotalAmount(payBill.getOrderAmount());
        orderVo.setActuallyAmount(payBill.getDealAmount());
        orderVo.setProductInfo(payBill.getGoodsInfo());
        orderVo.setPayChannel(payBill.getTradeChannel());
        return orderVo;
    }

    public BaseResponse<String> createOrderH5(HttpServletRequest request, RequestCreateOrderH5VO requestCreateOrderH5VO) {
        RequestCreateOrderVo orderVo = this.getPyaBillAndRequestCreateOrderVo(requestCreateOrderH5VO.getOutTradeNo());
        log.info("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u4e3a:{}", (Object)orderVo);
        IPay type = PayFactory.getPayType((String)requestCreateOrderH5VO.getPayChannel());
        log.info("H5\u652f\u4ed8\u5b9e\u73b0\u7c7b:{}", (Object)type);
        BaseResponse pay = type.pay(request, orderVo);
        log.info("{}\u652f\u4ed8\u8fd4\u56de\u53c2\u6570:{}", (Object)type, pay.getData());
        return pay;
    }

    public String getUnifiedPayOpenId(String applyCode, String attach, HttpServletRequest request, HttpServletResponse response) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u7528\u6237openID\u9875\u9762");
        String redirectUrl = this.unifiedH5PayUrl + "/qr_code/unifiedPay?applyCode=" + applyCode + "&attach=" + attach;
        String code = request.getParameter("code");
        String openId = request.getParameter("openId");
        log.info("\u53c2\u6570--------------:" + code + ":" + openId);
        if (!StringUtils.isBlank((CharSequence)openId)) {
            return "unifiedPay";
        }
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            mchCode = applyCode;
        }
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(mchCode, "WECHAT", "JSGZHAPI");
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)mchChan.toString());
        if (null == mchChan) {
            return null;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        log.info("\u83b7\u53d6\u5546\u6237jsGZHapi\u914d\u7f6e:{}", (Object)wxPayParam);
        if (!StringUtils.isBlank((CharSequence)code)) {
            openId = WxAuthApiClient.getOAuthOpenId((String)wxPayParam.appId, (String)wxPayParam.secret, (String)code);
            log.info("\u8c03\u7528\u5fae\u4fe1\u8fd4\u56deopenId={}", (Object)openId);
            redirectUrl = redirectUrl.indexOf("?") > 0 ? redirectUrl + "&openId=" + openId : redirectUrl + "?openId=" + openId;
            log.info("\u62ff\u5230openid\u91cd\u65b0\u652f\u4ed8\u8ba2\u5355\u8df3\u8f6cURL={}", (Object)redirectUrl);
            return "redirect:" + redirectUrl;
        }
        String timeMillis = String.valueOf(System.currentTimeMillis());
        String redirectUrl4Vx = redirectUrl + "&timeMillis=" + timeMillis;
        log.info("\u56de\u8c03\u5730\u5740\uff1a{}", (Object)redirectUrl4Vx);
        String wxUrl = String.format(URLConstant.SCOPE_TYPE_SNSAPI_BASE, wxPayParam.appId, WxAuthApiClient.urlEnodeUTF8((String)redirectUrl4Vx), STATE);
        log.info("\u83b7\u53d6\u7528\u6237\u6388\u6743\u8df3\u8f6cURL={}", (Object)wxUrl);
        return "redirect:" + wxUrl;
    }

    public BaseResponse<String> unifiedH5Pay(HttpServletRequest request, HttpServletResponse httpResponse, RequestWxH5PayVo requestWxH5PayVo) throws IOException {
        String applyCode = requestWxH5PayVo.getApplyCode();
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            mchCode = applyCode;
        }
        log.info("\u8fdb\u5165\u65b9\u6cd5:unifiedH5Pay");
        PayBill payBill = new PayBill();
        payBill.setDealTradeNo(UniqueKeyGenerator.generateViewId());
        payBill.setOrderAmount(new BigDecimal(requestWxH5PayVo.getTotalFee()));
        payBill.setOutTradeNo(payBill.getDealTradeNo());
        payBill.setTradeChannel(requestWxH5PayVo.getPayChannel());
        payBill.setTradeType(requestWxH5PayVo.getPayType());
        payBill.setDealAmount(payBill.getOrderAmount());
        payBill.setGoodsInfo("\u95e8\u5e97\u652f\u4ed8");
        payBill.setServiceCode(applyCode);
        payBill.setStatus(Integer.valueOf(1));
        payBill.setMchCode(mchCode);
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        payBill.setPayNotifyUrl(wxPayParam.payNotifyUrl);
        if (null != requestWxH5PayVo.getRemake() && !"".equals(requestWxH5PayVo.getRemake().trim())) {
            payBill.setRemake(requestWxH5PayVo.getRemake());
        }
        payBill.setAttach(requestWxH5PayVo.getAttach());
        this.payBillService.save(payBill);
        RequestCreateOrderH5VO requestCreateOrderH5VO = new RequestCreateOrderH5VO();
        requestCreateOrderH5VO.setOutTradeNo(payBill.getOutTradeNo());
        requestCreateOrderH5VO.setPayChannel(payBill.getTradeChannel());
        BaseResponse data = this.createOrderH5(request, requestCreateOrderH5VO);
        return data;
    }

    public BaseResponse<String> unifiedHeePay(HttpServletRequest request, HttpServletResponse response, RequestWxH5PayVo requestWxH5PayVo) throws IOException {
        log.info("******save\u65b9\u6cd5");
        PayBill payBill = new PayBill();
        payBill.setDealTradeNo(UniqueKeyGenerator.generateViewId());
        payBill.setOrderAmount(new BigDecimal(requestWxH5PayVo.getTotalFee()));
        payBill.setOutTradeNo(payBill.getDealTradeNo());
        payBill.setTradeType(requestWxH5PayVo.getPayType());
        payBill.setTradeType(payBill.getTradeType());
        payBill.setDealAmount(payBill.getOrderAmount());
        payBill.setGoodsInfo("\u95e8\u5e97\u652f\u4ed8");
        payBill.setServiceCode(requestWxH5PayVo.getApplyCode());
        payBill.setStatus(Integer.valueOf(1));
        payBill.setTradeChannel("heePay");
        payBill.setMchCode("FGZQ");
        log.info("*******************paychannel " + requestWxH5PayVo.getPayChannel());
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        payBill.setPayNotifyUrl(wxPayParam.payNotifyUrl);
        if (null != requestWxH5PayVo.getRemake() && !"".equals(requestWxH5PayVo.getRemake().trim())) {
            payBill.setRemake(requestWxH5PayVo.getRemake());
        }
        payBill.setAttach(requestWxH5PayVo.getAttach());
        this.payBillService.save(payBill);
        RequestCreateOrderH5VO requestCreateOrderH5VO = new RequestCreateOrderH5VO();
        log.info("\u8fd4\u56de\u7684OutTradeNo:" + payBill.getOutTradeNo());
        requestCreateOrderH5VO.setOutTradeNo(payBill.getOutTradeNo());
        requestCreateOrderH5VO.setPayChannel("heePay");
        requestCreateOrderH5VO.setQrPayType(requestWxH5PayVo.getPayType());
        requestCreateOrderH5VO.setQrPayChannel(requestWxH5PayVo.getPayChannel());
        BaseResponse data = this.createOrderHeePay(request, requestCreateOrderH5VO);
        log.info("!!!!!!!!!!!!!!!!****paychannel " + requestCreateOrderH5VO.getPayChannel());
        log.info("-------------data" + data);
        return data;
    }

    public String getAppAuthCode(HttpServletRequest request) {
        log.info("\u8fdb\u5165\u963f\u91cc\u6388\u6743\u56de\u8c03---------------");
        String appAuthCode = request.getParameter("app_auth_code");
        String appId = request.getParameter("app_id");
        String applyCode = request.getParameter("applyCode");
        log.info("\u6388\u6743\u4fe1\u606f\uff1acode:{}---appId:{}---applyCode:{}", new Object[]{appAuthCode, appId, applyCode});
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            mchCode = applyCode;
        }
        if (StringUtils.isBlank((CharSequence)appAuthCode)) {
            log.info("\u6ca1\u6709\u6388\u6743code");
            return "authorizationFailure";
        }
        List list = this.mchChanMapper.getApplyCodeAndChannel(mchCode, PayChanEnum.ALIPAY.getDisplay());
        if (null == list && list.size() == 0) {
            log.info("\u6ca1\u6709\u652f\u4ed8\u53c2\u6570\u4fe1\u606f");
            return "authorizationFailure";
        }
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)((MchChan)list.get(0)).toString());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)((MchChan)list.get(0)).getParam()), WxPayParam.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", wxPayParam.getAppId(), wxPayParam.getAppPrivateKey(), "json", "UTF-8", wxPayParam.getMchPublicKey(), "RSA2");
        AlipayOpenAuthTokenAppRequest authTokenAppRequest = new AlipayOpenAuthTokenAppRequest();
        AlipayOpenAuthTokenAppModel authTokenAppModel = new AlipayOpenAuthTokenAppModel();
        authTokenAppModel.setCode(appAuthCode);
        authTokenAppModel.setGrantType("authorization_code");
        authTokenAppRequest.setBizModel((AlipayObject)authTokenAppModel);
        String result = "";
        try {
            AlipayOpenAuthTokenAppResponse authTokenAppResponse = (AlipayOpenAuthTokenAppResponse)alipayClient.execute((AlipayRequest)authTokenAppRequest);
            if (!authTokenAppResponse.getCode().equals("10000")) {
                log.info("\u652f\u4ed8\u5b9d\u83b7\u53d6\u6388\u6743token\u5931\u8d25");
                return "authorizationFailure";
            }
            log.info(authTokenAppResponse.getBody());
            String str = authTokenAppResponse.getBody();
            String strStart = "app_auth_token\":\"";
            int strStartIndex = str.indexOf(strStart);
            int strEndIndex = str.indexOf("\",\"app_refresh_token");
            if (strStartIndex < 0) {
                log.info("\u6388\u6743\u5931\u8d25");
                return "authorizationFailure";
            }
            if (strEndIndex < 0) {
                log.info("\u6388\u6743\u5931\u8d25");
                return "authorizationFailure";
            }
            result = str.substring(strStartIndex, strEndIndex).substring(strStart.length());
            log.info("\u652f\u4ed8\u5b9d\u6388\u6743token\uff1a" + result);
        }
        catch (AlipayApiException e) {
            log.info("\u652f\u4ed8\u5b9d\u6388\u6743\u89e3\u6790code\u5931\u8d25");
            e.printStackTrace();
            return "authorizationFailure";
        }
        for (MchChan mchChan : list) {
            WxPayParam param = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            param.setAppAuthToken(result);
            mchChan.setParam(JSONObject.toJSONString((Object)param));
            this.mchChanMapper.updateById((Object)mchChan);
        }
        return "authorizationSuccess";
    }

    public BaseResponse<String> getNameByApplyCode(String applyCode) {
        PayApply payApply = this.payApplyMapper.getNameByApplyCode(applyCode);
        String name = null == payApply.getPayName() ? "" : payApply.getPayName();
        return BaseResponse.success((Object)name);
    }

    private void initRequestCreateOrderVo(RequestCreateOrderVo orderVo, PayBill payBill) {
    }

    public BaseResponse heePrepayment(RequestCreateOrderVo requestCreateOrderVo) {
        try {
            String outTradeNo = requestCreateOrderVo.getOutTradeNo();
            String redisKey = outTradeNo + "_" + requestCreateOrderVo.getPayType();
            if (BigDecimal.ZERO.compareTo(requestCreateOrderVo.getTotalAmount()) >= 0) {
                return BaseResponse.error((String)"\u8ba2\u5355\u91d1\u989d\u5f02\u5e38");
            }
            String orderView = UniqueKeyGenerator.generateViewId();
            PayBill payBill = this.payBillService.getByCreateOrder(requestCreateOrderVo);
            log.info("\u8bb0\u5f55\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)payBill));
            log.info("************\u8c03\u7528\u65b9\u6cd5---heePrepayment*************");
            payBill.setDealTradeNo(orderView);
            this.payBillService.update(payBill);
            if (!this.redisTemplate.hasKey((Object)redisKey).booleanValue()) {
                log.info("\u8ba2\u5355\u5df2\u5b58\u5728!");
                log.info("save\u65b9\u6cd5***");
                this.payBillService.save(payBill);
            }
            this.paymentRecordsService.saveByBill(orderView, requestCreateOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)requestCreateOrderVo));
            String QrCode = this.heecode + "?outTradeNo=" + outTradeNo;
            log.info("\u805a\u5408\u652f\u4ed8\u4e8c\u7ef4\u7801 : {}", (Object)QrCode);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Qrcode", QrCode);
            return BaseResponse.success((Object)JSON.toJSONString(map));
        }
        catch (Exception e) {
            log.error("prepayment error,e=", (Throwable)e);
            return BaseResponse.error((String)"");
        }
    }

    public String getHeePayOpenId(String applyCode, String attach, HttpServletRequest request, HttpServletResponse response) {
        log.info("\u8fdb\u5165\u6388\u6743\u9875\u9762");
        String redirectUrl = this.unifiedH5PayUrl + "/qr_code/heePay?applyCode=" + applyCode + "&attach=" + attach;
        String code = request.getParameter("code");
        String openId = request.getParameter("openId");
        log.info("\u53c2\u6570--------------:" + code);
        log.info("*********************************:" + openId);
        if (!StringUtils.isBlank((CharSequence)openId)) {
            return "heeUnifiedPay";
        }
        String appId = "wx5bfdc3d1f64c95ff";
        String secret = "3d3360c892adb49b93950ed1ed21b377";
        if (!StringUtils.isBlank((CharSequence)code)) {
            openId = WxAuthApiClient.getOAuthOpenId((String)appId, (String)secret, (String)code);
            log.info("***************openId******************:" + openId);
            log.info("\u8c03\u7528\u5fae\u4fe1\u8fd4\u56deopenId={}", (Object)openId);
            redirectUrl = redirectUrl.indexOf("?") > 0 ? redirectUrl + "&openId=" + openId : redirectUrl + "?openId=" + openId;
            log.info("\u62ff\u5230openid\u91cd\u65b0\u652f\u4ed8\u8ba2\u5355\u8df3\u8f6cURL={}", (Object)redirectUrl);
            return "redirect:" + redirectUrl;
        }
        String timeMillis = String.valueOf(System.currentTimeMillis());
        String redirectUrl4Vx = redirectUrl + "&timeMillis=" + timeMillis;
        log.info("\u56de\u8c03\u5730\u5740\uff1a{}", (Object)redirectUrl4Vx);
        String wxUrl = String.format(URLConstant.SCOPE_TYPE_SNSAPI_BASE, appId, WxAuthApiClient.urlEnodeUTF8((String)redirectUrl4Vx), STATE);
        log.info("\u83b7\u53d6\u7528\u6237\u6388\u6743\u8df3\u8f6cURL={}", (Object)wxUrl);
        return "redirect:" + wxUrl;
    }

    public BaseResponse<String> createOrderHeePay(HttpServletRequest request, RequestCreateOrderH5VO requestCreateOrderH5VO) {
        RequestCreateOrderVo orderVo = this.getPyaBillAndRequestCreateOrderVo(requestCreateOrderH5VO.getOutTradeNo());
        log.info("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u4e3a:{}", (Object)orderVo);
        orderVo.setPayType(requestCreateOrderH5VO.getQrPayType());
        orderVo.setPayChannel(requestCreateOrderH5VO.getQrPayChannel());
        String payChannel = "HEEPAY";
        IPay type = PayFactory.getPayType((String)payChannel);
        log.info("*****************:{}" + type.toString());
        log.info("H5\u652f\u4ed8\u5b9e\u73b0\u7c7b:{}", (Object)type);
        BaseResponse pay = type.pay(request, orderVo);
        log.info("{}\u652f\u4ed8\u8fd4\u56de\u53c2\u6570:{}", (Object)type, pay.getData());
        return pay;
    }

    public String getTransferOpenId(String phone, String merchantNum, String code) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u8f6c\u8d26openID\u9875\u9762");
        WxPayParam payParam = this.getTransferConfig(merchantNum);
        log.info("\u83b7\u53d6\u5546\u6237transfer\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)payParam));
        if (!StringUtils.isBlank((CharSequence)code)) {
            String openId = WxAuthApiClient.getOAuthOpenId((String)payParam.appId, (String)payParam.secret, (String)code);
            log.info("get transfer openId:{}", (Object)openId);
            UserTransferInfo userTransferInfo = new UserTransferInfo();
            userTransferInfo.setMerchantNum(merchantNum);
            userTransferInfo.setPhone(phone);
            userTransferInfo.setOpenId(openId);
            this.userTransferInfoMapper.insert((Object)userTransferInfo);
            return openId;
        }
        String timeMillis = String.valueOf(System.currentTimeMillis());
        String getOpenIdUrl = new StringBuffer(this.wxConfigConstant.getRemoteCallAddress()).append(URLConstant.GET_TRANSFER_OPENID_URI).toString();
        String redirectUrl4Vx = getOpenIdUrl + "?phone=" + phone + "&merchantNum=" + merchantNum + "&timeMillis=" + timeMillis;
        log.info("\u5fae\u4fe1\u6388\u6743\u5730\u5740:{},APPID:{},\u56de\u8c03\u5730\u5740:{}", new Object[]{URLConstant.SCOPE_TYPE_SNSAPI_BASE, payParam.appId, WxAuthApiClient.urlEnodeUTF8((String)redirectUrl4Vx)});
        String url = String.format(URLConstant.SCOPE_TYPE_SNSAPI_BASE, payParam.appId, WxAuthApiClient.urlEnodeUTF8((String)redirectUrl4Vx), STATE);
        log.info("\u83b7\u53d6\u7528\u6237\u6388\u6743\u8df3\u8f6cURL={}", (Object)url);
        return url;
    }

    private WxPayParam getTransferConfig(String merchantNum) {
        MchChan mchChan = this.mchChanMapper.selectTransferMchChan(merchantNum, "WECHAT", "TRANSFER");
        if (null == mchChan) {
            return null;
        }
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)mchChan));
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return wxPayParam;
    }
}

