/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.mybank.notify;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.AdditionRecord;
import com.ebaiyihui.aggregation.payment.common.model.SharingRecord;
import com.ebaiyihui.aggregation.payment.common.model.ThirdNotifyRecord;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyChannelEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.AdditionRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.SharingRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ThirdNotifyRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RequestHead;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.notify.BkcloudfundsRefundShareNotifyModel;
import com.ebaiyihui.aggregation.payment.server.mybank.enums.ShareStatusEnum;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.parser.xml.XmlConverter;
import com.ebaiyihui.aggregation.payment.server.mybank.manage.CommonRequestHandler;
import com.ebaiyihui.aggregation.payment.server.mybank.request.notify.BkcloudfundsRefundShareNotifyRequest;
import com.ebaiyihui.aggregation.payment.server.service.mybank.notify.MybankNotifyService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsRefundShareNotifyService")
public class BkcloudfundsRefundShareNotifyServiceImpl
implements MybankNotifyService {
    @Autowired
    private CommonRequestHandler commonRequestHandler;
    @Resource
    private AdditionRecordMapper additionRecordMapper;
    @Resource
    private ThirdNotifyRecordMapper thirdNotifyRecordMapper;
    @Resource
    private SharingRecordMapper sharingRecordMapper;

    public String notifyHandle(String xmlContext, String function, String privateKey) throws Exception {
        BkcloudfundsRefundShareNotifyRequest refundShareNotifyRequest = (BkcloudfundsRefundShareNotifyRequest)XmlConverter.getInstance().toResponse(xmlContext, BkcloudfundsRefundShareNotifyRequest.class);
        RequestHead head = refundShareNotifyRequest.getBkcloudfundsRefundShareNotify().getRequestHead();
        boolean flag = this.saveNotify(refundShareNotifyRequest.getBkcloudfundsRefundShareNotify().getBkcloudfundsRefundShareNotifyModel(), head);
        return this.commonRequestHandler.getSignResult(flag, head, privateKey);
    }

    private boolean saveNotify(BkcloudfundsRefundShareNotifyModel bkcloudfundsRefundShareNotifyModel, RequestHead head) {
        String tradeNo = bkcloudfundsRefundShareNotifyModel.getRelateOrderNo();
        String refundOutTradeNo = bkcloudfundsRefundShareNotifyModel.getOutTradeNo();
        AdditionRecord additionRecord = this.additionRecordMapper.selectOneByOutTradeNoOrTradeNo(tradeNo);
        ThirdNotifyRecord thirdNotifyRecord = new ThirdNotifyRecord();
        thirdNotifyRecord.setOutTradeNo(additionRecord.getOutTradeNo());
        thirdNotifyRecord.setOutMarkId(refundOutTradeNo);
        thirdNotifyRecord.setThirdMarkId(tradeNo);
        thirdNotifyRecord.setMarkName(head.getFunction());
        thirdNotifyRecord.setType(ApplyChannelEnum.MYBANK.getApplyChannel());
        thirdNotifyRecord.setParam(JSONObject.toJSONString((Object)bkcloudfundsRefundShareNotifyModel));
        this.thirdNotifyRecordMapper.insert((Object)thirdNotifyRecord);
        SharingRecord update = new SharingRecord();
        update.setRefundOutTradeNo(refundOutTradeNo);
        SharingRecord sharingRecord = new SharingRecord();
        sharingRecord.setShareStatus(ShareStatusEnum.REFUND_FINISHED.getValue());
        sharingRecord.setRefundThirdShareNo(bkcloudfundsRefundShareNotifyModel.getShareRefundOrderNo());
        sharingRecord.setRefundDate(bkcloudfundsRefundShareNotifyModel.getShareRefundDate());
        QueryWrapper queryWrapper = new QueryWrapper((Object)update);
        this.sharingRecordMapper.update((Object)sharingRecord, (Wrapper)queryWrapper);
        return true;
    }
}

