/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo;

import com.ebaiyihui.aggregation.payment.common.model.ChannelBill;
import com.ebaiyihui.aggregation.payment.common.model.PlatformBill;
import com.ebaiyihui.aggregation.payment.server.enums.ErrorTypeEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ProcessingStateEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ShowTypeEnum;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationRule;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ChannelBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ErrorBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.PlatformBillBO;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

public class ChannelBillBO {
    protected Integer status;
    private Long id;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;
    private String tradeTime;
    private String transactionId;
    private BigDecimal totalFee;
    private String refundId;
    private BigDecimal refundFee;
    private BigDecimal poundage;
    private String attach;
    private String deviceInfo;
    private String tradeState;
    private String appId;
    private String refundState;
    private String refundTime;
    private String payType;
    private String mchId;
    private String contrastDate;
    private String contrastState;
    private String mchOrderId;
    private String applyCode;
    private String payChannel;
    private BigDecimal payAmount;
    private BigDecimal shouldAmount;
    private String serviceCode;
    private String outTradeNo;
    private ErrorBillBO errorBillBO;
    private PlatformBillBO platformBillBO;
    private Integer reconciliationStatus;
    private ReconciliationRule reconciliationRule = new ReconciliationRule();

    public ChannelBillBO(ChannelBill channelBill) {
        BeanUtils.copyProperties((Object)channelBill, (Object)this);
    }

    public void getPlatformBillBO(PlatformBill platformBill) {
        if (Objects.isNull(this.platformBillBO)) {
            this.platformBillBO = new PlatformBillBO();
        }
        if (Objects.nonNull(platformBill)) {
            BeanUtils.copyProperties((Object)platformBill, (Object)this.platformBillBO);
        }
    }

    public void reconciliationWithBill(String batchNumber, String billDate) {
        this.errorBillBO = ErrorBillBO.builder().batchNumber(batchNumber).errorNumber(UniqueKeyGenerator.generateViewId()).channel(this.payChannel).applyCode(this.applyCode).processingState(ProcessingStateEnum.TO_BE_PROCESSED.getValue()).channelTradeNo(this.transactionId).channelOrderNo(this.mchOrderId).channelShouldAmount(this.shouldAmount).channelPayAmount(this.payAmount).channelOrderAmount(this.payAmount).channelTradeTime(this.tradeTime).channelTradeState(this.tradeState).channelPayTime(this.tradeState.equals("SUCCESS") ? this.tradeTime : "").channelPoundage(this.poundage).status(Integer.valueOf(1)).contrastDate(billDate).build();
        this.reconciliationStatus = this.reconciliation();
    }

    private Integer reconciliation() {
        if (null == this.platformBillBO) {
            this.errorBillBO.setErrorState(ErrorTypeEnum.LEAKAGE_OF_SINGLE.getValue());
            this.errorBillBO.setErrorType(ErrorTypeEnum.LEAKAGE_OF_SINGLE.getDisplay());
            this.errorBillBO.setShowType(ShowTypeEnum.DETAILS.getValue());
            return ShowTypeEnum.DETAILS.getValue();
        }
        this.errorBillBO.setPlatformMchOrderNo(this.platformBillBO.getDealTradeNo());
        this.errorBillBO.setPlatformOrderAmount(this.platformBillBO.getOrderAmount());
        this.errorBillBO.setPlatformPayAmount(this.platformBillBO.getDealAmount());
        this.errorBillBO.setPlatformPayTime(this.platformBillBO.getPayTime());
        this.errorBillBO.setPlatformTradeNo(this.platformBillBO.getTradeNo());
        this.errorBillBO.setPlatformTradeState(this.platformBillBO.getTradeState());
        this.errorBillBO.setPlatformShouldAmount(this.platformBillBO.getDealAmount());
        this.errorBillBO.setPlatformTradeTime(this.platformBillBO.getRefundNo() == null ? this.platformBillBO.getPayTime() : this.platformBillBO.getRefundTime());
        if (this.tradeState.equals("SUCCESS") && this.platformBillBO.getTradeState().equals("REFUND") && !DateUtils.strDate2Date((String)this.tradeTime).equals(DateUtils.dateToString((Date)this.platformBillBO.getPayTime(), (String)"yyyyMMdd")) && Objects.isNull(this.refundId)) {
            this.errorBillBO.setErrorState(ErrorTypeEnum.INCONSISTENT_STATE.getValue());
            this.errorBillBO.setErrorType(ErrorTypeEnum.INCONSISTENT_STATE.getDisplay());
            this.errorBillBO.setShowType(ShowTypeEnum.UPDATE_STATE.getValue());
            this.errorBillBO.setBillId(this.platformBillBO.getBillId());
            return ShowTypeEnum.REFUND.getValue();
        }
        return ShowTypeEnum.UPDATE_STATE.getValue();
    }

    private void setReconciliationRule() {
        this.reconciliationRule.setTransactionId(this.transactionId);
        this.reconciliationRule.setApplyCode(this.applyCode);
        this.reconciliationRule.setPayAmount(this.payAmount);
        this.reconciliationRule.setPayType(this.payType);
        this.reconciliationRule.setRefundFee(this.refundFee);
        this.reconciliationRule.setRefundId(this.refundId);
        this.reconciliationRule.setShouldAmount(this.shouldAmount);
        this.reconciliationRule.setTotalFee(this.totalFee);
        this.reconciliationRule.setTradeState(this.tradeState);
    }

    public ReconciliationRule getReconciliationRule() {
        this.setReconciliationRule();
        return this.reconciliationRule;
    }

    public static ChannelBillBOBuilder builder() {
        return new ChannelBillBOBuilder();
    }

    public Integer getStatus() {
        return this.status;
    }

    public Long getId() {
        return this.id;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getTradeTime() {
        return this.tradeTime;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public BigDecimal getTotalFee() {
        return this.totalFee;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public BigDecimal getRefundFee() {
        return this.refundFee;
    }

    public BigDecimal getPoundage() {
        return this.poundage;
    }

    public String getAttach() {
        return this.attach;
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getTradeState() {
        return this.tradeState;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getRefundState() {
        return this.refundState;
    }

    public String getRefundTime() {
        return this.refundTime;
    }

    public String getPayType() {
        return this.payType;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getContrastDate() {
        return this.contrastDate;
    }

    public String getContrastState() {
        return this.contrastState;
    }

    public String getMchOrderId() {
        return this.mchOrderId;
    }

    public String getApplyCode() {
        return this.applyCode;
    }

    public String getPayChannel() {
        return this.payChannel;
    }

    public BigDecimal getPayAmount() {
        return this.payAmount;
    }

    public BigDecimal getShouldAmount() {
        return this.shouldAmount;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public ErrorBillBO getErrorBillBO() {
        return this.errorBillBO;
    }

    public PlatformBillBO getPlatformBillBO() {
        return this.platformBillBO;
    }

    public Integer getReconciliationStatus() {
        return this.reconciliationStatus;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setTradeTime(String tradeTime) {
        this.tradeTime = tradeTime;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setTotalFee(BigDecimal totalFee) {
        this.totalFee = totalFee;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public void setRefundFee(BigDecimal refundFee) {
        this.refundFee = refundFee;
    }

    public void setPoundage(BigDecimal poundage) {
        this.poundage = poundage;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setRefundState(String refundState) {
        this.refundState = refundState;
    }

    public void setRefundTime(String refundTime) {
        this.refundTime = refundTime;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setContrastDate(String contrastDate) {
        this.contrastDate = contrastDate;
    }

    public void setContrastState(String contrastState) {
        this.contrastState = contrastState;
    }

    public void setMchOrderId(String mchOrderId) {
        this.mchOrderId = mchOrderId;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public void setShouldAmount(BigDecimal shouldAmount) {
        this.shouldAmount = shouldAmount;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setErrorBillBO(ErrorBillBO errorBillBO) {
        this.errorBillBO = errorBillBO;
    }

    public void setPlatformBillBO(PlatformBillBO platformBillBO) {
        this.platformBillBO = platformBillBO;
    }

    public void setReconciliationStatus(Integer reconciliationStatus) {
        this.reconciliationStatus = reconciliationStatus;
    }

    public void setReconciliationRule(ReconciliationRule reconciliationRule) {
        this.reconciliationRule = reconciliationRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelBillBO)) {
            return false;
        }
        ChannelBillBO other = (ChannelBillBO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$tradeTime = this.getTradeTime();
        String other$tradeTime = other.getTradeTime();
        if (this$tradeTime == null ? other$tradeTime != null : !this$tradeTime.equals(other$tradeTime)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        BigDecimal this$totalFee = this.getTotalFee();
        BigDecimal other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        String this$refundId = this.getRefundId();
        String other$refundId = other.getRefundId();
        if (this$refundId == null ? other$refundId != null : !this$refundId.equals(other$refundId)) {
            return false;
        }
        BigDecimal this$refundFee = this.getRefundFee();
        BigDecimal other$refundFee = other.getRefundFee();
        if (this$refundFee == null ? other$refundFee != null : !((Object)this$refundFee).equals(other$refundFee)) {
            return false;
        }
        BigDecimal this$poundage = this.getPoundage();
        BigDecimal other$poundage = other.getPoundage();
        if (this$poundage == null ? other$poundage != null : !((Object)this$poundage).equals(other$poundage)) {
            return false;
        }
        String this$attach = this.getAttach();
        String other$attach = other.getAttach();
        if (this$attach == null ? other$attach != null : !this$attach.equals(other$attach)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$tradeState = this.getTradeState();
        String other$tradeState = other.getTradeState();
        if (this$tradeState == null ? other$tradeState != null : !this$tradeState.equals(other$tradeState)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$refundState = this.getRefundState();
        String other$refundState = other.getRefundState();
        if (this$refundState == null ? other$refundState != null : !this$refundState.equals(other$refundState)) {
            return false;
        }
        String this$refundTime = this.getRefundTime();
        String other$refundTime = other.getRefundTime();
        if (this$refundTime == null ? other$refundTime != null : !this$refundTime.equals(other$refundTime)) {
            return false;
        }
        String this$payType = this.getPayType();
        String other$payType = other.getPayType();
        if (this$payType == null ? other$payType != null : !this$payType.equals(other$payType)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$contrastDate = this.getContrastDate();
        String other$contrastDate = other.getContrastDate();
        if (this$contrastDate == null ? other$contrastDate != null : !this$contrastDate.equals(other$contrastDate)) {
            return false;
        }
        String this$contrastState = this.getContrastState();
        String other$contrastState = other.getContrastState();
        if (this$contrastState == null ? other$contrastState != null : !this$contrastState.equals(other$contrastState)) {
            return false;
        }
        String this$mchOrderId = this.getMchOrderId();
        String other$mchOrderId = other.getMchOrderId();
        if (this$mchOrderId == null ? other$mchOrderId != null : !this$mchOrderId.equals(other$mchOrderId)) {
            return false;
        }
        String this$applyCode = this.getApplyCode();
        String other$applyCode = other.getApplyCode();
        if (this$applyCode == null ? other$applyCode != null : !this$applyCode.equals(other$applyCode)) {
            return false;
        }
        String this$payChannel = this.getPayChannel();
        String other$payChannel = other.getPayChannel();
        if (this$payChannel == null ? other$payChannel != null : !this$payChannel.equals(other$payChannel)) {
            return false;
        }
        BigDecimal this$payAmount = this.getPayAmount();
        BigDecimal other$payAmount = other.getPayAmount();
        if (this$payAmount == null ? other$payAmount != null : !((Object)this$payAmount).equals(other$payAmount)) {
            return false;
        }
        BigDecimal this$shouldAmount = this.getShouldAmount();
        BigDecimal other$shouldAmount = other.getShouldAmount();
        if (this$shouldAmount == null ? other$shouldAmount != null : !((Object)this$shouldAmount).equals(other$shouldAmount)) {
            return false;
        }
        String this$serviceCode = this.getServiceCode();
        String other$serviceCode = other.getServiceCode();
        if (this$serviceCode == null ? other$serviceCode != null : !this$serviceCode.equals(other$serviceCode)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        ErrorBillBO this$errorBillBO = this.getErrorBillBO();
        ErrorBillBO other$errorBillBO = other.getErrorBillBO();
        if (this$errorBillBO == null ? other$errorBillBO != null : !this$errorBillBO.equals(other$errorBillBO)) {
            return false;
        }
        PlatformBillBO this$platformBillBO = this.getPlatformBillBO();
        PlatformBillBO other$platformBillBO = other.getPlatformBillBO();
        if (this$platformBillBO == null ? other$platformBillBO != null : !this$platformBillBO.equals(other$platformBillBO)) {
            return false;
        }
        Integer this$reconciliationStatus = this.getReconciliationStatus();
        Integer other$reconciliationStatus = other.getReconciliationStatus();
        if (this$reconciliationStatus == null ? other$reconciliationStatus != null : !((Object)this$reconciliationStatus).equals(other$reconciliationStatus)) {
            return false;
        }
        ReconciliationRule this$reconciliationRule = this.getReconciliationRule();
        ReconciliationRule other$reconciliationRule = other.getReconciliationRule();
        return !(this$reconciliationRule == null ? other$reconciliationRule != null : !this$reconciliationRule.equals(other$reconciliationRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelBillBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $tradeTime = this.getTradeTime();
        result = result * 59 + ($tradeTime == null ? 43 : $tradeTime.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        BigDecimal $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        String $refundId = this.getRefundId();
        result = result * 59 + ($refundId == null ? 43 : $refundId.hashCode());
        BigDecimal $refundFee = this.getRefundFee();
        result = result * 59 + ($refundFee == null ? 43 : ((Object)$refundFee).hashCode());
        BigDecimal $poundage = this.getPoundage();
        result = result * 59 + ($poundage == null ? 43 : ((Object)$poundage).hashCode());
        String $attach = this.getAttach();
        result = result * 59 + ($attach == null ? 43 : $attach.hashCode());
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $tradeState = this.getTradeState();
        result = result * 59 + ($tradeState == null ? 43 : $tradeState.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $refundState = this.getRefundState();
        result = result * 59 + ($refundState == null ? 43 : $refundState.hashCode());
        String $refundTime = this.getRefundTime();
        result = result * 59 + ($refundTime == null ? 43 : $refundTime.hashCode());
        String $payType = this.getPayType();
        result = result * 59 + ($payType == null ? 43 : $payType.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $contrastDate = this.getContrastDate();
        result = result * 59 + ($contrastDate == null ? 43 : $contrastDate.hashCode());
        String $contrastState = this.getContrastState();
        result = result * 59 + ($contrastState == null ? 43 : $contrastState.hashCode());
        String $mchOrderId = this.getMchOrderId();
        result = result * 59 + ($mchOrderId == null ? 43 : $mchOrderId.hashCode());
        String $applyCode = this.getApplyCode();
        result = result * 59 + ($applyCode == null ? 43 : $applyCode.hashCode());
        String $payChannel = this.getPayChannel();
        result = result * 59 + ($payChannel == null ? 43 : $payChannel.hashCode());
        BigDecimal $payAmount = this.getPayAmount();
        result = result * 59 + ($payAmount == null ? 43 : ((Object)$payAmount).hashCode());
        BigDecimal $shouldAmount = this.getShouldAmount();
        result = result * 59 + ($shouldAmount == null ? 43 : ((Object)$shouldAmount).hashCode());
        String $serviceCode = this.getServiceCode();
        result = result * 59 + ($serviceCode == null ? 43 : $serviceCode.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        ErrorBillBO $errorBillBO = this.getErrorBillBO();
        result = result * 59 + ($errorBillBO == null ? 43 : $errorBillBO.hashCode());
        PlatformBillBO $platformBillBO = this.getPlatformBillBO();
        result = result * 59 + ($platformBillBO == null ? 43 : $platformBillBO.hashCode());
        Integer $reconciliationStatus = this.getReconciliationStatus();
        result = result * 59 + ($reconciliationStatus == null ? 43 : ((Object)$reconciliationStatus).hashCode());
        ReconciliationRule $reconciliationRule = this.getReconciliationRule();
        result = result * 59 + ($reconciliationRule == null ? 43 : $reconciliationRule.hashCode());
        return result;
    }

    public String toString() {
        return "ChannelBillBO(status=" + this.getStatus() + ", id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", tradeTime=" + this.getTradeTime() + ", transactionId=" + this.getTransactionId() + ", totalFee=" + this.getTotalFee() + ", refundId=" + this.getRefundId() + ", refundFee=" + this.getRefundFee() + ", poundage=" + this.getPoundage() + ", attach=" + this.getAttach() + ", deviceInfo=" + this.getDeviceInfo() + ", tradeState=" + this.getTradeState() + ", appId=" + this.getAppId() + ", refundState=" + this.getRefundState() + ", refundTime=" + this.getRefundTime() + ", payType=" + this.getPayType() + ", mchId=" + this.getMchId() + ", contrastDate=" + this.getContrastDate() + ", contrastState=" + this.getContrastState() + ", mchOrderId=" + this.getMchOrderId() + ", applyCode=" + this.getApplyCode() + ", payChannel=" + this.getPayChannel() + ", payAmount=" + this.getPayAmount() + ", shouldAmount=" + this.getShouldAmount() + ", serviceCode=" + this.getServiceCode() + ", outTradeNo=" + this.getOutTradeNo() + ", errorBillBO=" + this.getErrorBillBO() + ", platformBillBO=" + this.getPlatformBillBO() + ", reconciliationStatus=" + this.getReconciliationStatus() + ", reconciliationRule=" + this.getReconciliationRule() + ")";
    }

    public ChannelBillBO(Integer status, Long id, Date createTime, Date updateTime, String tradeTime, String transactionId, BigDecimal totalFee, String refundId, BigDecimal refundFee, BigDecimal poundage, String attach, String deviceInfo, String tradeState, String appId, String refundState, String refundTime, String payType, String mchId, String contrastDate, String contrastState, String mchOrderId, String applyCode, String payChannel, BigDecimal payAmount, BigDecimal shouldAmount, String serviceCode, String outTradeNo, ErrorBillBO errorBillBO, PlatformBillBO platformBillBO, Integer reconciliationStatus, ReconciliationRule reconciliationRule) {
        this.status = status;
        this.id = id;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.tradeTime = tradeTime;
        this.transactionId = transactionId;
        this.totalFee = totalFee;
        this.refundId = refundId;
        this.refundFee = refundFee;
        this.poundage = poundage;
        this.attach = attach;
        this.deviceInfo = deviceInfo;
        this.tradeState = tradeState;
        this.appId = appId;
        this.refundState = refundState;
        this.refundTime = refundTime;
        this.payType = payType;
        this.mchId = mchId;
        this.contrastDate = contrastDate;
        this.contrastState = contrastState;
        this.mchOrderId = mchOrderId;
        this.applyCode = applyCode;
        this.payChannel = payChannel;
        this.payAmount = payAmount;
        this.shouldAmount = shouldAmount;
        this.serviceCode = serviceCode;
        this.outTradeNo = outTradeNo;
        this.errorBillBO = errorBillBO;
        this.platformBillBO = platformBillBO;
        this.reconciliationStatus = reconciliationStatus;
        this.reconciliationRule = reconciliationRule;
    }

    public ChannelBillBO() {
    }
}

