/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.manage;

import com.ebaiyihui.aggregation.payment.common.vo.BaseAliSmsReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseAliSmsVerifyReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseEmailReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseEmailVerifyReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseGetImageCodeReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.ImageCodeRspVO;
import com.ebaiyihui.aggregation.payment.common.vo.ImageCodeVerifyReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.PushInfoReqVO;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.utils.PushInfoUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushInfoManage {
    private static final Logger log = LoggerFactory.getLogger(PushInfoManage.class);
    public static final Integer userType = 1;
    public static final String subject = "\u652f\u4ed8\u4e2d\u53f0";
    public static final String businessCode = "sendAuthCode";
    public static final String SUCCESSCODE = "success";
    public static final long EXPIRE_DATE = 600L;
    private static final String appCode = "BYCS";
    private static final String signCode = "BYH_BY";
    private static final String smsAppCode = "EHOS_BYH";
    private static final String templateCode = "dz_reg_authcode";
    @Autowired
    private PushInfoUtil pushInfoUtil;
    @Autowired
    private RedisTemplateService redisTemplateService;

    public BaseResponse aliSmsPush(PushInfoReqVO pushInfoReqVO) {
        BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
        baseAliSmsReqVO.setSmsAppCode(smsAppCode);
        baseAliSmsReqVO.setTemplateCode(templateCode);
        baseAliSmsReqVO.setPhone(pushInfoReqVO.getAccount());
        baseAliSmsReqVO.setUserType(userType);
        return this.pushInfoUtil.aliSmsPush(appCode, baseAliSmsReqVO, signCode);
    }

    public BaseResponse aliSmsVerify(BaseAliSmsVerifyReqVO baseAliSmsVerifyReqVO) {
        String aliSmsVerifyFlag = this.pushInfoUtil.aliSmsVerify(baseAliSmsVerifyReqVO);
        if (SUCCESSCODE.equals(aliSmsVerifyFlag)) {
            this.setRedisVerify(baseAliSmsVerifyReqVO.getPhoneNum());
        }
        return BaseResponse.success((Object)aliSmsVerifyFlag);
    }

    public BaseResponse emailPush(PushInfoReqVO pushInfoReqVO) {
        BaseEmailReqVO baseEmailReqVO = new BaseEmailReqVO();
        baseEmailReqVO.setMailAddress(pushInfoReqVO.getAccount());
        baseEmailReqVO.setSubject(subject);
        baseEmailReqVO.setBusinessCode(businessCode);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userEmail", pushInfoReqVO.getAccount());
        baseEmailReqVO.setParam(params);
        return this.pushInfoUtil.emailPush(baseEmailReqVO);
    }

    public BaseResponse emailVerify(BaseEmailVerifyReqVO baseEmailVerifyReqVO) {
        String emailVerifyFlag = this.pushInfoUtil.emailVerify(baseEmailVerifyReqVO);
        if (SUCCESSCODE.equals(emailVerifyFlag)) {
            this.setRedisVerify(baseEmailVerifyReqVO.getMailAddress());
        }
        return BaseResponse.success((Object)emailVerifyFlag);
    }

    public BaseResponse getImageCode(BaseGetImageCodeReqVO baseGetImageCodeReqVO) {
        return this.pushInfoUtil.getImageCode(baseGetImageCodeReqVO);
    }

    public BaseResponse imageVerify(ImageCodeRspVO imageCodeRspVO) {
        ImageCodeVerifyReqVO imageCodeVerifyReqVO = new ImageCodeVerifyReqVO();
        imageCodeVerifyReqVO.setImageCode(imageCodeRspVO.getImageData());
        imageCodeVerifyReqVO.setImageId(imageCodeRspVO.getId());
        imageCodeVerifyReqVO.setType(imageCodeRspVO.getType());
        String imageVerifyFlag = this.pushInfoUtil.imageVerify(imageCodeVerifyReqVO);
        return BaseResponse.success((Object)imageVerifyFlag);
    }

    public void setRedisVerify(String redisKey) {
        boolean addLock = this.redisTemplateService.addLock(redisKey, redisKey, 600L);
        log.info("\u9a8c\u8bc1\u6210\u529f\u6dfb\u52a0\u7528\u6237\u4fe1\u606f:{},\u6dfb\u52a0\u72b6\u6001:{}", (Object)redisKey, (Object)addLock);
    }
}

