/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.mapper;

import com.ebaiyihui.aggregation.payment.common.vo.BusinessDataVO;
import com.ebaiyihui.aggregation.payment.common.vo.ConfigKeyVO;
import com.ebaiyihui.aggregation.payment.common.vo.CountVO;
import com.ebaiyihui.aggregation.payment.common.vo.GoodsVO;
import com.ebaiyihui.aggregation.payment.common.vo.ListVO;
import com.ebaiyihui.aggregation.payment.common.vo.QualificationsVO;
import com.ebaiyihui.aggregation.payment.common.vo.QueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.SettlementBankAccountVO;
import com.ebaiyihui.aggregation.payment.common.vo.SettlementRulesVO;
import com.ebaiyihui.aggregation.payment.common.vo.SubjectDataVO;
import com.ebaiyihui.aggregation.payment.common.vo.SuperAdministratorInformationVO;
import com.ebaiyihui.aggregation.payment.common.vo.SupplementaryMaterialsVO;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
public interface MerchantPurchaseMapper {
    public void insertListDisplay(@Param(value="listVO") ListVO var1);

    @Update(value={"update list_display set business_license_info_merchant_name=#{businessLicenseInfoMerchantName} where uuid=#{uuid}"})
    public void updateListDisplay(@Param(value="businessLicenseInfoMerchantName") String var1, @Param(value="uuid") String var2);

    @Update(value={"update list_display set contact_name=#{contactName} where uuid=#{uuid}"})
    public void updateListDisplays(@Param(value="contactName") String var1, @Param(value="uuid") String var2);

    @Select(value={"select * from subject_data where uuid=#{uuid}"})
    public SubjectDataVO selectSubjectData(String var1);

    @Delete(value={"delete from subject_data where uuid=#{uuid}"})
    public void deleteSubjectData(String var1);

    public void insertSubjectData(@Param(value="subjectDataVO") SubjectDataVO var1);

    @Select(value={"select * from business_data where uuid=#{uuid}"})
    public BusinessDataVO selectBusinessData(String var1);

    @Delete(value={"delete from business_data where uuid=#{uuid}"})
    public void deleteBusinessData(String var1);

    public void insertBusinessData(@Param(value="businessDataVO") BusinessDataVO var1);

    @Select(value={"select * from settlement_rules where uuid=#{uuid}"})
    public SettlementRulesVO selectSettlementRules(String var1);

    @Delete(value={"delete from settlement_rules where uuid=#{uuid}"})
    public void deleteSettlementRules(String var1);

    public void insertSettlementRules(@Param(value="settlementRulesVO") SettlementRulesVO var1);

    @Select(value={"select * from settlement_bank_account where uuid=#{uuid}"})
    public SettlementBankAccountVO selectSettlementBankAccount(String var1);

    @Delete(value={"delete from settlement_bank_account where uuid=#{uuid}"})
    public void deleteSettlementBankAccount(String var1);

    public void insertSettlementBankAccount(@Param(value="settlementBankAccountVO") SettlementBankAccountVO var1);

    @Select(value={"select * from super_admin_info where uuid=#{uuid}"})
    public SuperAdministratorInformationVO selectSuperAdminInfo(String var1);

    @Delete(value={"delete from super_admin_info where uuid=#{uuid}"})
    public void deleteSuperAdminInfo(String var1);

    public void insertSuperAdministratorInformation(@Param(value="superAdministratorInformationVO") SuperAdministratorInformationVO var1);

    @Select(value={"select * from supplementary_materials where uuid=#{uuid}"})
    public SupplementaryMaterialsVO selectSupplementaryMaterials(String var1);

    @Delete(value={"delete from supplementary_materials where uuid=#{uuid}"})
    public void deleteSupplementaryMaterials(String var1);

    public void insertSupplementaryMaterials(@Param(value="supplementaryMaterialsVO") SupplementaryMaterialsVO var1);

    @Select(value={"select * from list_display order by create_time desc"})
    public List<ListVO> selectListDisplay();

    @Select(value={"select * from list_display where uuid=#{uuid} order by create_time desc"})
    public ListVO selectListDisplayById(String var1);

    @Select(value={"select * from list_display where applyment_id=#{queryInfo} or business_license_info_merchant_name=#{queryInfo} or sub_mchid=#{queryInfo} order by create_time desc"})
    public List<ListVO> selectByQueryInfo(String var1);

    @Select(value={"select * from list_display where status=#{status} and merchant_type=#{merchantType} order by create_time desc"})
    public List<ListVO> selectWithout(@Param(value="merchantType") String var1, @Param(value="status") int var2);

    @Select(value={"select * from list_display where status=#{status} order by create_time desc"})
    public List<ListVO> selectWithouts(@Param(value="status") int var1);

    @Select(value={"select * from list_display where merchant_type=#{merchantType} order by create_time desc"})
    public List<ListVO> selectWithoutTimeStatus(@Param(value="merchantType") String var1);

    @Select(value={"select * from list_display where create_time > #{startTime} and create_time < #{endTime} and status=#{status} and merchant_type=#{merchantType} order by create_time desc"})
    public List<ListVO> selectListDisplayByInfo(@Param(value="startTime") String var1, @Param(value="endTime") String var2, @Param(value="merchantType") String var3, @Param(value="status") int var4);

    @Select(value={"select * from list_display where create_time > #{startTime} and create_time < #{endTime} and status=#{status} order by create_time desc"})
    public List<ListVO> selectListDisplayByInfos(@Param(value="startTime") String var1, @Param(value="endTime") String var2, @Param(value="status") int var3);

    @Select(value={"select * from list_display where create_time > #{startTime} and create_time < #{endTime} and merchant_type=#{merchantType} order by create_time desc"})
    public List<ListVO> selectWithoutStatus(@Param(value="startTime") String var1, @Param(value="endTime") String var2, @Param(value="merchantType") String var3);

    @Select(value={"select * from list_display where create_time > #{startTime} and create_time < #{endTime} order by create_time desc"})
    public List<ListVO> selectWithoutSta(@Param(value="startTime") String var1, @Param(value="endTime") String var2);

    @Select(value={"select bank_name from deposit_bank_comparison"})
    public List<String> selectBankName();

    @Select(value={"select * from config_key where merchant_id=#{merchantId}"})
    public ConfigKeyVO selectConfigKey(String var1);

    @Select(value={"select status as status,COUNT(*) as count from list_display group by status"})
    public List<CountVO> countList();

    @Select(value={"select bank_name from other_bank"})
    public List<String> selectOtherBank();

    @Select(value={"select merchant_id,goods_name from goods"})
    public List<GoodsVO> selectGoodsName();

    @Select(value={"select special_qualification_requirements,special_qualification_status from rate_settlement_rules where settlement_rules_id=#{settlementRulesId} and special_qualification_requirements is not NULL"})
    public List<QualificationsVO> selectSpecialQualification(String var1);

    @Select(value={"select settlement_rules_id,settlement_rules,applicable_industry from rate_settlement_rules where subject_type=#{subjectType} group by settlement_rules_id"})
    public List<QueryVO> selectBySubjectType(String var1);

    @Select(value={"select deposit_bank_full_name from deposit_bank_full_name where deposit_bank_full_name LIKE CONCAT('%',#{city},'%') and deposit_bank_full_name LIKE CONCAT('%',#{bankName},'%')"})
    public List<String> selectByProvinceAndCity(@Param(value="city") String var1, @Param(value="bankName") String var2);

    @Update(value={"update list_display set sub_mchid=#{subMchid} where uuid=#{uuid}"})
    public void updateList(@Param(value="subMchid") String var1, @Param(value="uuid") String var2);

    @Update(value={"update list_display set applyment_id=#{applymentId},status=#{status} where uuid=#{uuid}"})
    public void updateDisplay(@Param(value="applymentId") String var1, @Param(value="status") int var2, @Param(value="uuid") String var3);

    @Update(value={"<script> UPDATE list_display SET <if test='subMchid != null '> sub_mchid = #{subMchid},</if> status = #{status} WHERE uuid = #{uuid} </script>"})
    public void updateDisplayByStatus(@Param(value="uuid") String var1, @Param(value="status") int var2, @Param(value="subMchid") String var3);

    @Select(value={"select status from list_display where uuid=#{uuid} "})
    public Integer selectDisplayByIdAndMerchantId(@Param(value="uuid") String var1);
}

