/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.ebaiyihui.aggregation.payment.common.vo.RequestBillVo;
import com.ebaiyihui.aggregation.payment.server.service.ChannelBillService;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ChannelBillBO;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6e20\u9053\u8d26\u5355"})
@RequestMapping(value={"/channel_bill"}, produces={"application/json;charset:UTF-8"})
public class ChannelBillController {
    private static final Logger log = LoggerFactory.getLogger(ChannelBillController.class);
    @Autowired
    private ChannelBillService channelBillService;

    @PostMapping(value={"/download_channel_bill"})
    @ApiOperation(value="\u4e0b\u8f7d\u7b2c\u4e09\u65b9\u8d26\u5355")
    public BaseResponse<List<ChannelBillBO>> downloadChannelBill(@RequestBody RequestBillVo requestBillVo) {
        List channelBillBoS = this.channelBillService.newDownloadChannelBill(requestBillVo);
        log.info("\u7b2c\u4e09\u65b9\u8d26\u5355\u67e5\u8be2\u7ed3\u679c:" + channelBillBoS);
        return BaseResponse.success((Object)channelBillBoS);
    }

    @GetMapping(value={"/getBillsByDate"})
    @ApiOperation(value="\u6839\u636e\u5bf9\u8d26\u65e5\u671f\u67e5\u8be2\u5bf9\u8d26\u5355\u4fe1\u606f")
    public BaseResponse<List<ChannelBillBO>> getBillsByDate(@RequestParam(value="contrastDate", required=false) String contrastDate, @RequestParam(value="merchantIds") List<Long> merchantIds) {
        if (StringUtils.isEmpty((Object)contrastDate)) {
            contrastDate = DateUtils.getBeforeDay();
        }
        log.info("\u83b7\u53d6{}\u5bf9\u8d26\u5355\u4fe1\u606f", (Object)contrastDate);
        return BaseResponse.success((Object)this.channelBillService.getBillsByDate(contrastDate, merchantIds));
    }
}

