/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.ebaiyihui.aggregation.payment.common.vo.ConfigKeyVO;
import com.ebaiyihui.aggregation.payment.common.vo.CountVO;
import com.ebaiyihui.aggregation.payment.common.vo.GoodsVO;
import com.ebaiyihui.aggregation.payment.common.vo.ListVO;
import com.ebaiyihui.aggregation.payment.common.vo.MerchantPurchaseVO;
import com.ebaiyihui.aggregation.payment.common.vo.QualificationsVO;
import com.ebaiyihui.aggregation.payment.common.vo.QueryVO;
import com.ebaiyihui.aggregation.payment.server.applyment.ApplymentFactory;
import com.ebaiyihui.aggregation.payment.server.config.MediaConfiguration;
import com.ebaiyihui.aggregation.payment.server.config.MerchantPurchaseConfiguration;
import com.ebaiyihui.aggregation.payment.server.service.MerchantPurchaseService;
import com.ebaiyihui.aggregation.payment.server.service.impl.MerchantPurchaseServiceImpl;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.applyment.ApplymentStateQueryResult;
import com.github.binarywang.wxpay.bean.applyment.ModifySettlementRequest;
import com.github.binarywang.wxpay.bean.applyment.SettlementInfoResult;
import com.github.binarywang.wxpay.bean.applyment.WxPayApplyment4SubCreateRequest;
import com.github.binarywang.wxpay.bean.applyment.enums.ApplymentStateEnum;
import com.github.binarywang.wxpay.bean.media.ImageUploadResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.Applyment4SubServiceImpl;
import com.github.binarywang.wxpay.service.impl.MerchantMediaServiceImpl;
import io.swagger.annotations.Api;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5546\u6237\u8fdb\u4ef6"})
@RequestMapping(value={"/merchantPurchase"})
public class MerchantPurchaseController {
    private static final Logger log = LoggerFactory.getLogger(MerchantPurchaseController.class);
    @Resource
    public MerchantPurchaseConfiguration merchantPurchaseConfiguration;
    @Resource
    public MediaConfiguration mediaConfiguration;
    @Resource
    public MerchantPurchaseService merchantPurchaseService;
    @Resource
    public MerchantPurchaseServiceImpl merchantPurchaseServiceImpl;

    @PostMapping(value={"/query_goods"})
    public BaseResponse<List<GoodsVO>> queryGoods() {
        List goodsName = this.merchantPurchaseService.selectGoods();
        return BaseResponse.success((Object)goodsName);
    }

    @PostMapping(value={"/save_edit_draft"})
    public BaseResponse<String> merchantInfoSaveDraft(@RequestBody MerchantPurchaseVO merchantPurchaseVO) {
        String uuid = null;
        if (StringUtils.isEmpty((Object)merchantPurchaseVO.getUuid())) {
            uuid = UUID.randomUUID().toString().trim().replaceAll("-", "");
            this.merchantPurchaseService.insertDraft(merchantPurchaseVO, uuid);
        } else {
            uuid = merchantPurchaseVO.getUuid();
            this.merchantPurchaseService.deleteDraft(uuid, merchantPurchaseVO.getType());
            this.merchantPurchaseService.insertDraft(merchantPurchaseVO, uuid);
        }
        return BaseResponse.success((Object)uuid);
    }

    @PostMapping(value={"/draft_echo"})
    public BaseResponse<MerchantPurchaseVO> merchantDraftEcho(@RequestParam(value="uuid") String uuid) {
        MerchantPurchaseVO showDraft = this.merchantPurchaseService.showDraft(uuid);
        return BaseResponse.success((Object)showDraft);
    }

    @PostMapping(value={"/submit_application"})
    public BaseResponse<String> submitApplication(@RequestBody MerchantPurchaseVO merchantPurchaseVO) {
        MerchantPurchaseVO showDraft = this.merchantPurchaseService.showDraft(merchantPurchaseVO.getUuid());
        WxPayApplyment4SubCreateRequest wxPayApplyment4SubCreateRequest = ApplymentFactory.getInstance((MerchantPurchaseVO)showDraft);
        ConfigKeyVO configKey = new ConfigKeyVO();
        if (!StringUtils.isEmpty((Object)merchantPurchaseVO.getMerchantId())) {
            configKey = this.merchantPurchaseServiceImpl.getConfigKeyVO(merchantPurchaseVO.getMerchantId());
        }
        Applyment4SubServiceImpl applyment4SubService = new Applyment4SubServiceImpl(this.merchantPurchaseConfiguration.wxService(configKey));
        String applymentId = null;
        try {
            applymentId = applyment4SubService.createApply(wxPayApplyment4SubCreateRequest).getApplymentId();
        }
        catch (WxPayException e) {
            log.error("submit application error,e=", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
        int status = 1;
        this.merchantPurchaseService.fix(applymentId, status, merchantPurchaseVO.getUuid());
        return BaseResponse.success((Object)"\u7533\u8bf7\u5355\u63d0\u4ea4\u6210\u529f");
    }

    @GetMapping(value={"/query_application"})
    public BaseResponse<ApplymentStateQueryResult> queryApplication(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="uuid") String uuid) {
        ConfigKeyVO configKey = this.merchantPurchaseServiceImpl.getConfigKeyVO(merchantId);
        Applyment4SubServiceImpl applyment4SubService = new Applyment4SubServiceImpl(this.merchantPurchaseConfiguration.wxService(configKey));
        ApplymentStateQueryResult applymentStateQueryResult = applyment4SubService.queryApplyStatusByBusinessCode(uuid);
        String subMchid = applymentStateQueryResult.getSubMchid();
        ApplymentStateEnum applymentState = applymentStateQueryResult.getApplymentState();
        this.merchantPurchaseService.updateStatus(applymentState, uuid, subMchid);
        return BaseResponse.success((Object)applymentStateQueryResult);
    }

    @PostMapping(value={"/list_query"})
    public BaseResponse<PageResult<ListVO>> listQuery(@RequestBody ListVO listVO) {
        PageResult listDisplayVO = this.merchantPurchaseService.listQuery(listVO);
        return BaseResponse.success((Object)listDisplayVO);
    }

    @PostMapping(value={"/status_return"})
    public BaseResponse<List<CountVO>> statusReturn() {
        List countList = this.merchantPurchaseService.countList();
        return BaseResponse.success((Object)countList);
    }

    @PostMapping(value={"/account_type_query"})
    public BaseResponse<List<String>> accountTypeQuery() {
        List bankNameList = this.merchantPurchaseService.accountTypeQuery();
        return BaseResponse.success((Object)bankNameList);
    }

    @PostMapping(value={"/other_bank"})
    public BaseResponse<List<String>> otherBankQuery() {
        List bankNameList = this.merchantPurchaseService.otherBank();
        return BaseResponse.success((Object)bankNameList);
    }

    @PostMapping(value={"/subject_type_query"})
    public BaseResponse<List<QueryVO>> queryBySubjectType(@RequestParam(value="subjectType") String subjectType) {
        List resultList = this.merchantPurchaseService.queryBySubjectType(subjectType);
        return BaseResponse.success((Object)resultList);
    }

    @PostMapping(value={"/settlement_rules_id_query"})
    public BaseResponse<List<QualificationsVO>> queryBySettlementRulesId(@RequestParam(value="settlementRulesId") String settlementRulesId) {
        List resultList = this.merchantPurchaseService.settlementRulesIdQuery(settlementRulesId);
        return BaseResponse.success((Object)resultList);
    }

    @PostMapping(value={"/province_city_query"})
    public BaseResponse<List<String>> provinceCityQuery(@RequestParam(value="city") String city, @RequestParam(value="bankName") String bankName) {
        List resultList = this.merchantPurchaseService.provinceCityQuery(city, bankName);
        return BaseResponse.success((Object)resultList);
    }

    @PostMapping(value={"/modify_settlement"})
    public BaseResponse<String> modifySettlement(@RequestBody ModifySettlementRequest modifySettlementRequest, @RequestBody MerchantPurchaseVO merchantPurchaseVO) {
        ConfigKeyVO configKey = new ConfigKeyVO();
        if (!StringUtils.isEmpty((Object)merchantPurchaseVO.getMerchantId())) {
            configKey = this.merchantPurchaseServiceImpl.getConfigKeyVO(merchantPurchaseVO.getMerchantId());
        }
        Applyment4SubServiceImpl applyment4SubService = new Applyment4SubServiceImpl(this.merchantPurchaseConfiguration.wxService(configKey));
        String subMchId = applyment4SubService.queryApplyStatusByBusinessCode(merchantPurchaseVO.getSubjectDataVO().getBusinessCode()).getSubMchid();
        applyment4SubService.modifySettlement(subMchId, modifySettlementRequest);
        return BaseResponse.success((Object)"\u4fee\u6539\u7ed3\u7b97\u8d26\u53f7\u6210\u529f");
    }

    @GetMapping(value={"/query_settlement"})
    public BaseResponse<SettlementInfoResult> querySettlement(@RequestBody MerchantPurchaseVO merchantPurchaseVO) {
        ConfigKeyVO configKey = new ConfigKeyVO();
        if (!StringUtils.isEmpty((Object)merchantPurchaseVO.getMerchantId())) {
            configKey = this.merchantPurchaseServiceImpl.getConfigKeyVO(merchantPurchaseVO.getMerchantId());
        }
        Applyment4SubServiceImpl applyment4SubService = new Applyment4SubServiceImpl(this.merchantPurchaseConfiguration.wxService(configKey));
        String subMchId = applyment4SubService.queryApplyStatusByBusinessCode(merchantPurchaseVO.getSubjectDataVO().getBusinessCode()).getSubMchid();
        SettlementInfoResult settlementInfoResult = applyment4SubService.querySettlementBySubMchid(subMchId);
        return BaseResponse.success((Object)settlementInfoResult);
    }

    @PostMapping(value={"/change_media_id"})
    public BaseResponse<ImageUploadResult> changeMediaID(@RequestParam(value="baseUrl") String baseUrl, @RequestParam(value="fileName") String fileName, @RequestParam(value="merchantId") String merchantId) {
        ConfigKeyVO configKey = new ConfigKeyVO();
        if (!StringUtils.isEmpty((Object)merchantId)) {
            configKey = this.merchantPurchaseServiceImpl.getConfigKeyVO(merchantId);
        }
        MerchantMediaServiceImpl merchantMediaService = new MerchantMediaServiceImpl(this.mediaConfiguration.wxService(configKey));
        InputStream input = new URL(baseUrl).openStream();
        ImageUploadResult mediaID = merchantMediaService.imageUploadV3(input, fileName);
        return BaseResponse.success((Object)mediaID);
    }
}

