/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.ebaiyihui.aggregation.payment.common.model.ChannelBill;
import com.ebaiyihui.aggregation.payment.common.vo.RequestBillVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestGetAppIdVo;
import com.ebaiyihui.aggregation.payment.server.enums.ContrastEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.ChannelBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.bill.BkcloudfundsBillRecordsModel;
import com.ebaiyihui.aggregation.payment.server.pojo.BillEnvironmentEntity;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.ChannelBillService;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.impl.AlipayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.impl.WechatPayServiceImpl;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ChannelBillBO;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.FileUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ChannelBillServiceImpl
extends BaseService
implements ChannelBillService {
    private static final Logger log = LoggerFactory.getLogger(ChannelBillServiceImpl.class);
    @Autowired
    ChannelBillMapper channelBillMapper;
    @Autowired
    WechatPayServiceImpl wechatPayService;
    @Autowired
    MchChanService mchChanService;
    @Autowired
    PayMchMapper payMchMapper;
    @Autowired
    AlipayServiceImpl alipayService;
    @Value(value="${pay.bill.environment}")
    protected String payEnvironment;

    public void save(ChannelBill channelBill) {
        this.channelBillMapper.insert((Object)channelBill);
    }

    public void saveChannelBill(RequestBillVo requestBillVo) {
        String applyCode = requestBillVo.getApplyCode();
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            mchCode = applyCode;
        }
        RequestDownloadVo requestDownloadVo = new RequestDownloadVo();
        requestDownloadVo.setBillDate(requestBillVo.getBillDate());
        requestDownloadVo.setMchCode(mchCode);
        requestDownloadVo.setPayChannel(requestBillVo.getPayChannel());
        this.channelBillMapper.deleteByDateAndMchCodeAndChannel(requestBillVo.getBillDate(), applyCode, requestBillVo.getPayChannel());
        if (requestBillVo.getPayChannel().equals(PayChanEnum.WECHAT.getDisplay())) {
            RequestGetAppIdVo requestGetAppIdVo = new RequestGetAppIdVo();
            requestGetAppIdVo.setMchCode(requestDownloadVo.getMchCode());
            requestGetAppIdVo.setPayChannel(requestDownloadVo.getPayChannel());
            BaseResponse idList = this.mchChanService.getAppIdList(requestGetAppIdVo);
            BaseResponse baseResponse = this.wechatPayService.downLoadBill(requestDownloadVo);
            ((WxPayBillResult)baseResponse.getData()).getBillInfoList().forEach(e -> {
                if (((List)idList.getData()).contains(e.getAppId())) {
                    ChannelBill channelBill = new ChannelBill();
                    channelBill.setStatus(Integer.valueOf(1));
                    channelBill.setTradeTime(e.getTradeTime());
                    channelBill.setRefundFee(new BigDecimal(e.getSettlementRefundFee()));
                    channelBill.setRefundState(e.getRefundState());
                    channelBill.setTradeState(e.getTradeState());
                    channelBill.setPoundage(new BigDecimal(e.getPoundage()));
                    channelBill.setRefundTime(e.getTradeState().equals("REFUND") ? e.getTradeTime() : e.getRefundTime());
                    channelBill.setPayChannel("WECHAT");
                    channelBill.setShouldAmount(new BigDecimal(e.getTotalFee()));
                    channelBill.setApplyCode(applyCode);
                    channelBill.setAppId(e.getAppId());
                    channelBill.setAttach(e.getAttach());
                    channelBill.setContrastDate(requestDownloadVo.getBillDate());
                    channelBill.setMchId(e.getMchId());
                    channelBill.setMchOrderId(e.getOutTradeNo());
                    channelBill.setTransactionId(e.getTransactionId());
                    channelBill.setTotalFee(new BigDecimal(e.getTotalAmount()));
                    channelBill.setRefundId(e.getRefundId());
                    channelBill.setPayType(e.getTradeType());
                    channelBill.setPayAmount(new BigDecimal(e.getTotalAmount()));
                    channelBill.setContrastState(ContrastEnum.UN_CONTRAST.getValue());
                    this.channelBillMapper.insert((Object)channelBill);
                }
            });
        } else if (requestBillVo.getPayChannel().equals(PayChanEnum.ALIPAY.getDisplay())) {
            this.saveAliPayBill(requestBillVo);
        }
    }

    public void saveAliPayBill(RequestBillVo requestBillVo) {
        String applyCode = requestBillVo.getApplyCode();
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            mchCode = applyCode;
        }
        RequestDownloadVo requestDownloadVo = new RequestDownloadVo();
        requestDownloadVo.setBillDate(requestBillVo.getBillDate());
        requestDownloadVo.setMchCode(mchCode);
        requestDownloadVo.setPayChannel(requestBillVo.getPayChannel());
        requestDownloadVo.setBillDate(DateUtils.strDate2StrDate((String)requestDownloadVo.getBillDate()));
        BaseResponse baseResponse = this.alipayService.downLoadBill(requestDownloadVo);
        log.info(baseResponse.toString());
        if (!baseResponse.getCode().equals("1") || !((AlipayDataDataserviceBillDownloadurlQueryResponse)baseResponse.getData()).getCode().equals("10000")) {
            log.info("\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7durl\u5931\u8d25\uff0c\u4e0b\u8f7d\u53c2\u6570\uff1a{}", (Object)requestDownloadVo.toString());
            return;
        }
        String url = ((AlipayDataDataserviceBillDownloadurlQueryResponse)baseResponse.getData()).getBillDownloadUrl();
        log.info("\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7durl\uff1a{}", (Object)url);
        String path = this.getClass().getClassLoader().getResource("bootstrap.yml").getPath();
        path = FileUtils.getPath((String)path, (String)"zip/");
        String filePath = FileUtils.downloadFile((String)path, (String)url);
        if (null != filePath) {
            log.info("\u652f\u4ed8\u5b9d\u8d26\u5355\u6587\u4ef6\u5730\u5740\uff1a{}", (Object)filePath);
            List lists = FileUtils.readCSVFileData((String)filePath);
            if (null != lists && lists.size() != 0) {
                lists.forEach(e -> {
                    if (e.size() == 25) {
                        if (((String)e.get(0)).equals("\u652f\u4ed8\u5b9d\u4ea4\u6613\u53f7")) {
                            return;
                        }
                        log.info(e.toString());
                        ChannelBill channelBill = new ChannelBill();
                        channelBill.setStatus(Integer.valueOf(1));
                        channelBill.setTradeTime((String)e.get(5));
                        channelBill.setRefundFee(new BigDecimal((String)e.get(12)));
                        channelBill.setRefundState(((String)e.get(2)).equals("\u4ea4\u6613") ? "" : "SUCCESS");
                        channelBill.setTradeState(((String)e.get(2)).equals("\u4ea4\u6613") ? "SUCCESS" : "REFUND");
                        channelBill.setPoundage(new BigDecimal((String)e.get(22)).multiply(new BigDecimal(-1)));
                        channelBill.setRefundTime(((String)e.get(2)).equals("\u4ea4\u6613") ? "" : (String)e.get(5));
                        channelBill.setPayChannel(PayChanEnum.ALIPAY.getDisplay());
                        channelBill.setShouldAmount(new BigDecimal((String)e.get(11)));
                        channelBill.setApplyCode(applyCode);
                        channelBill.setAttach((String)e.get(24));
                        channelBill.setContrastDate(requestBillVo.getBillDate());
                        channelBill.setMchOrderId((String)e.get(1));
                        channelBill.setTransactionId((String)e.get(0));
                        channelBill.setTotalFee(new BigDecimal((String)e.get(11)));
                        channelBill.setPayType("H5");
                        channelBill.setPayAmount(new BigDecimal((String)e.get(12)));
                        channelBill.setContrastState(ContrastEnum.UN_CONTRAST.getValue());
                        this.channelBillMapper.insert((Object)channelBill);
                    }
                });
            }
        }
        FileUtils.deleteDir((String)path);
    }

    public void selectList() {
        this.channelBillMapper.selectListChannel();
    }

    public BaseResponse downloadChannelBill(RequestBillVo requestBillVo) {
        List downloadList = new ArrayList();
        String applyCode = requestBillVo.getApplyCode();
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            mchCode = applyCode;
        }
        RequestDownloadVo requestDownloadVo = new RequestDownloadVo();
        requestDownloadVo.setBillDate(requestBillVo.getBillDate());
        requestDownloadVo.setMchCode(mchCode);
        requestDownloadVo.setPayChannel(requestBillVo.getPayChannel());
        if (requestBillVo.getPayChannel().equals(PayChanEnum.WECHAT.getDisplay())) {
            downloadList = this.downloadWechatBill(requestDownloadVo);
        } else if (requestBillVo.getPayChannel().equals(PayChanEnum.ALIPAY.getDisplay())) {
            downloadList = this.downloadAliPayBill(requestDownloadVo);
        }
        return BaseResponse.success(downloadList);
    }

    public List<ChannelBillBO> newDownloadChannelBill(RequestBillVo requestBillVo) {
        return null;
    }

    public List<ChannelBillBO> getBillsByDate(String contrastDate, List<Long> merchantIds) {
        List<ChannelBillBO> channelBills = this.channelBillMapper.selectListByMerchantIds(contrastDate, merchantIds);
        channelBills = channelBills.stream().filter(arg_0 -> this.filterPayBill(arg_0)).collect(Collectors.toList());
        return channelBills;
    }

    private boolean filterPayBill(ChannelBillBO e) {
        String attach = e.getAttach();
        if (StringUtils.isNotBlank((CharSequence)attach)) {
            BillEnvironmentEntity billEnvironmentEntity = (BillEnvironmentEntity)JSONObject.parseObject((String)(attach = StringEscapeUtils.unescapeJava((String)attach.replace(' ', ','))), BillEnvironmentEntity.class);
            if (StringUtils.isNotBlank((CharSequence)billEnvironmentEntity.getS())) {
                return billEnvironmentEntity.getE().equals(this.payEnvironment);
            }
            return billEnvironmentEntity.getEnv().equals(this.payEnvironment);
        }
        return false;
    }

    public List<ChannelBill> downloadWechatBill(RequestDownloadVo requestDownloadVo) {
        ArrayList<ChannelBill> wxList = new ArrayList<ChannelBill>();
        RequestGetAppIdVo requestGetAppIdVo = new RequestGetAppIdVo();
        requestGetAppIdVo.setMchCode(requestDownloadVo.getMchCode());
        requestGetAppIdVo.setPayChannel(requestDownloadVo.getPayChannel());
        BaseResponse idList = this.mchChanService.getAppIdList(requestGetAppIdVo);
        BaseResponse baseResponse = this.wechatPayService.downLoadBill(requestDownloadVo);
        ((WxPayBillResult)baseResponse.getData()).getBillInfoList().forEach(e -> {
            if (((List)idList.getData()).contains(e.getAppId())) {
                ChannelBill channelBill = new ChannelBill();
                channelBill.setStatus(Integer.valueOf(1));
                channelBill.setTradeTime(e.getTradeTime());
                channelBill.setRefundFee(new BigDecimal(e.getSettlementRefundFee()));
                channelBill.setRefundState(e.getRefundState());
                channelBill.setTradeState(e.getTradeState());
                channelBill.setPoundage(new BigDecimal(e.getPoundage()));
                channelBill.setRefundTime(e.getTradeState().equals("REFUND") ? e.getTradeTime() : e.getRefundTime());
                channelBill.setPayChannel("WECHAT");
                channelBill.setShouldAmount(new BigDecimal(e.getTotalFee()));
                channelBill.setApplyCode(requestDownloadVo.getApplyCode());
                channelBill.setAppId(e.getAppId());
                channelBill.setAttach(e.getAttach());
                channelBill.setContrastDate(requestDownloadVo.getBillDate());
                channelBill.setMchId(e.getMchId());
                channelBill.setMchOrderId(e.getOutTradeNo());
                channelBill.setTransactionId(e.getTransactionId());
                channelBill.setTotalFee(new BigDecimal(e.getTotalAmount()));
                channelBill.setRefundId(e.getRefundId());
                channelBill.setPayType(e.getTradeType());
                channelBill.setPayAmount(new BigDecimal(e.getTotalAmount()));
                channelBill.setContrastState(ContrastEnum.UN_CONTRAST.getValue());
                wxList.add(channelBill);
            }
        });
        return wxList;
    }

    public List<ChannelBill> downloadAliPayBill(RequestDownloadVo requestDownloadVo) {
        ArrayList<ChannelBill> aliPayList = new ArrayList<ChannelBill>();
        requestDownloadVo.setBillDate(DateUtils.strDate2StrDate((String)requestDownloadVo.getBillDate()));
        BaseResponse baseResponse = this.alipayService.downLoadBill(requestDownloadVo);
        if (!baseResponse.getCode().equals("1") || !((AlipayDataDataserviceBillDownloadurlQueryResponse)baseResponse.getData()).getCode().equals("10000")) {
            log.info("\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7durl\u5931\u8d25\uff0c\u4e0b\u8f7d\u53c2\u6570\uff1a{}", (Object)requestDownloadVo.toString());
            return null;
        }
        String url = ((AlipayDataDataserviceBillDownloadurlQueryResponse)baseResponse.getData()).getBillDownloadUrl();
        log.info("\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7durl\uff1a{}", (Object)url);
        String path = this.getClass().getClassLoader().getResource("bootstrap.yml").getPath();
        path = FileUtils.getPath((String)path, (String)"zip/");
        String filePath = FileUtils.downloadFile((String)path, (String)url);
        if (null != filePath) {
            log.info("\u652f\u4ed8\u5b9d\u8d26\u5355\u6587\u4ef6\u5730\u5740\uff1a{}", (Object)filePath);
            List lists = FileUtils.readCSVFileData((String)filePath);
            System.out.println("===================lists" + lists);
            if (null != lists && lists.size() != 0) {
                lists.forEach(e -> {
                    if (e.size() == 25) {
                        if (((String)e.get(0)).equals("\u652f\u4ed8\u5b9d\u4ea4\u6613\u53f7")) {
                            return;
                        }
                        log.info("===e" + e.toString());
                        ChannelBill channelBill = new ChannelBill();
                        channelBill.setStatus(Integer.valueOf(1));
                        channelBill.setTradeTime((String)e.get(5));
                        channelBill.setRefundFee(new BigDecimal((String)e.get(12)));
                        channelBill.setRefundState(((String)e.get(2)).equals("\u4ea4\u6613") ? "" : "SUCCESS");
                        channelBill.setTradeState(((String)e.get(2)).equals("\u4ea4\u6613") ? "SUCCESS" : "REFUND");
                        channelBill.setPoundage(new BigDecimal((String)e.get(22)).multiply(new BigDecimal(-1)));
                        channelBill.setRefundTime(((String)e.get(2)).equals("\u4ea4\u6613") ? "" : (String)e.get(5));
                        channelBill.setPayChannel(PayChanEnum.ALIPAY.getDisplay());
                        channelBill.setShouldAmount(new BigDecimal((String)e.get(11)));
                        channelBill.setApplyCode(requestDownloadVo.getApplyCode());
                        channelBill.setAttach((String)e.get(24));
                        channelBill.setContrastDate(requestDownloadVo.getBillDate());
                        channelBill.setMchOrderId((String)e.get(1));
                        channelBill.setTransactionId((String)e.get(0));
                        channelBill.setTotalFee(new BigDecimal((String)e.get(11)));
                        channelBill.setPayType("H5");
                        channelBill.setPayAmount(new BigDecimal((String)e.get(12)));
                        channelBill.setContrastState(ContrastEnum.UN_CONTRAST.getValue());
                        aliPayList.add(channelBill);
                    }
                });
            }
        }
        FileUtils.deleteDir((String)path);
        return aliPayList;
    }

    public List<BkcloudfundsBillRecordsModel> getByBilllDate(String billdate, List<String> applyCodeList) {
        return this.channelBillMapper.getByBilllDate(billdate, applyCodeList);
    }
}

