/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation;

import com.ebaiyihui.aggregation.payment.server.service.reconciliation.IBillFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillFileProcessor {
    private static final Logger log = LoggerFactory.getLogger(BillFileProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> downloadBill(String downloadUrl, IBillFile iBillFile) {
        ArrayList result = new ArrayList();
        HttpURLConnection conn = null;
        ZipInputStream in = null;
        BufferedReader br = null;
        try {
            ZipEntry zipFile;
            URL url = new URL(downloadUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("GET");
            conn.connect();
            in = new ZipInputStream(conn.getInputStream(), Charset.forName("GBK"));
            br = new BufferedReader(new InputStreamReader((InputStream)in, "GBK"));
            while ((zipFile = in.getNextEntry()) != null) {
                if (zipFile.isDirectory()) continue;
                String fileName = zipFile.getName();
                log.info("\u5bf9\u8d26\u5355\u89e3\u6790\uff0c\u8f93\u51fa\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)fileName);
                iBillFile.getBillByFile(result, br, fileName);
            }
        }
        catch (IOException e) {
            log.error("\u5bf9\u8d26\u5355\u89e3\u6790\u5f02\u5e38,e=", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (in != null) {
                    in.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException e) {
                log.error("\u6d41\u5173\u95ed\u5f02\u5e38,e=", (Throwable)e);
            }
        }
        return result;
    }
}

