/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final DateUtil COMPAT = new DateUtil(new SimpleDateFormat("yyyyMMdd"));
    public static final DateUtil COMMON = new DateUtil(new SimpleDateFormat("yyyy-MM-dd"));
    public static final DateUtil COMMON_FULL = new DateUtil(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    public static final DateUtil SLASH = new DateUtil(new SimpleDateFormat("yyyy/MM/dd"));
    public static final DateUtil CHINESE = new DateUtil(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5"));
    public static final DateUtil CHINESE_FULL = new DateUtil(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"));
    private final SimpleDateFormat format;

    public DateUtil(SimpleDateFormat format) {
        this.format = format;
    }

    public static String getDateText(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date getTextDate(String dateText, String format) throws ParseException {
        return new SimpleDateFormat(format).parse(dateText);
    }

    public static int getWeekDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int w = calendar.get(7);
        int ret = w == 1 ? 7 : w - 1;
        return ret;
    }

    public static String getSeqString() {
        SimpleDateFormat fm = new SimpleDateFormat("yyyyMMddHHmmss");
        return fm.format(new Date());
    }

    public SimpleDateFormat getFormat() {
        return this.format;
    }

    public String getDateText(Date date) {
        return this.getFormat().format(date);
    }

    public Date getTextDate(String text) throws ParseException {
        return this.getFormat().parse(text);
    }
}

