/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.utils;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.aggregation.payment.common.vo.BaseAliSmsReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseAliSmsVerifyReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseEmailReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseEmailVerifyReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.BaseGetImageCodeReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.ImageCodeRspVO;
import com.ebaiyihui.aggregation.payment.common.vo.ImageCodeVerifyReqVO;
import com.ebaiyihui.aggregation.payment.server.constant.URLConstant;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PushInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(PushInfoUtil.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private URLConstant wxConfigConstant;

    public BaseResponse aliSmsPush(String appCode, BaseAliSmsReqVO baseAliSmsReqVO, String signCode) {
        block4: {
            StringBuffer url = new StringBuffer(this.wxConfigConstant.getByhCallAddress());
            String authKey = null;
            BaseResponse aliSmsResponse = null;
            try {
                url = url.append("/cloud/push/alismsapi/sendAuthCodeWithPhone");
                baseAliSmsReqVO.setAppCode(appCode);
                baseAliSmsReqVO.setSignCode(signCode);
                log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u77ed\u4fe1]\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url.toString(), (Object)JSON.toJSONString((Object)baseAliSmsReqVO));
                aliSmsResponse = this.postHeaders(url.toString(), (Object)baseAliSmsReqVO);
                log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u77ed\u4fe1]\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)aliSmsResponse.toString());
                if (aliSmsResponse.getCode().equals("1")) {
                    Map map = (Map)aliSmsResponse.getData();
                    if (StringUtil.isNotEmpty((String)((String)map.get("authKey")))) {
                        authKey = (String)map.get("authKey");
                        return BaseResponse.success((Object)authKey);
                    }
                    break block4;
                }
                return BaseResponse.error((String)aliSmsResponse.getMsg());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String aliSmsVerify(BaseAliSmsVerifyReqVO baseAliSmsVerifyReqVO) {
        StringBuffer url = new StringBuffer(this.wxConfigConstant.getByhCallAddress());
        String flag = "failure";
        try {
            url = url.append("/cloud/push/alismsapi/verifialismsauthcode");
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u77ed\u4fe1]\u9a8c\u8bc1\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url.toString(), (Object)JSON.toJSONString((Object)baseAliSmsVerifyReqVO));
            BaseResponse aliSmsVerifyResponse = this.postHeaders(url.toString(), (Object)baseAliSmsVerifyReqVO);
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u77ed\u4fe1]\u9a8c\u8bc1\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)aliSmsVerifyResponse.toString());
            if (aliSmsVerifyResponse.getCode().equals("1")) {
                flag = "success";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public BaseResponse emailPush(BaseEmailReqVO baseEmailReqVO) {
        block4: {
            StringBuffer url = new StringBuffer(this.wxConfigConstant.getByhCallAddress());
            String authKey = null;
            try {
                url = url.append("/cloud/push/mail/send");
                log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url.toString(), (Object)JSON.toJSONString((Object)baseEmailReqVO));
                BaseResponse emailResponse = this.postHeaders(url.toString(), (Object)baseEmailReqVO);
                log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)emailResponse.toString());
                if (emailResponse.getCode().equals("1")) {
                    Map map = (Map)emailResponse.getData();
                    if (StringUtil.isNotEmpty((String)((String)map.get("authKey")))) {
                        authKey = (String)map.get("authKey");
                        authKey.trim();
                        authKey = authKey.replaceAll("\n", "").replaceAll("\r", "");
                        return BaseResponse.success((Object)authKey);
                    }
                    break block4;
                }
                return BaseResponse.error((String)emailResponse.getMsg());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String emailVerify(BaseEmailVerifyReqVO baseEmailVerifyReqVO) {
        StringBuffer url = new StringBuffer(this.wxConfigConstant.getByhCallAddress());
        String flag = "failure";
        try {
            url = url.append("/cloud/push/mail/verify");
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u9a8c\u8bc1\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url.toString(), (Object)JSON.toJSONString((Object)baseEmailVerifyReqVO));
            BaseResponse emailVerifyResponse = this.postHeaders(url.toString(), (Object)baseEmailVerifyReqVO);
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u9a8c\u8bc1\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)emailVerifyResponse.toString());
            if (emailVerifyResponse.getCode().equals("1")) {
                flag = "success";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public BaseResponse getImageCode(BaseGetImageCodeReqVO baseGetImageCodeReqVO) {
        StringBuffer url = new StringBuffer(this.wxConfigConstant.getByhCallAddress());
        ImageCodeRspVO imageCodeRspVO = new ImageCodeRspVO();
        Object authKey = null;
        try {
            url = url.append("/cloud/push/imageapi/getimagecode");
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url.toString(), (Object)JSON.toJSONString((Object)baseGetImageCodeReqVO));
            BaseResponse imageResponse = this.postHeaders(url.toString(), (Object)baseGetImageCodeReqVO);
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)imageResponse.toString());
            if (imageResponse.getCode().equals("1")) {
                Map map = (Map)imageResponse.getData();
                imageCodeRspVO.setId((String)map.get("id"));
                imageCodeRspVO.setImageData((String)map.get("imageData"));
                imageCodeRspVO.setType((String)map.get("type"));
                return BaseResponse.success((Object)imageCodeRspVO);
            }
            return BaseResponse.error((String)imageResponse.getMsg());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String imageVerify(ImageCodeVerifyReqVO imageCodeVerifyReqVO) {
        StringBuffer url = new StringBuffer(this.wxConfigConstant.getByhCallAddress());
        String flag = "failure";
        try {
            url = url.append("/cloud/push/imageapi/verifiImageCode");
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u9a8c\u8bc1\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url.toString(), (Object)JSON.toJSONString((Object)imageCodeVerifyReqVO));
            BaseResponse emailVerifyResponse = this.postHeaders(url.toString(), (Object)imageCodeVerifyReqVO);
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001[\u90ae\u4ef6]\u9a8c\u8bc1\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)emailVerifyResponse.toString());
            if (emailVerifyResponse.getCode().equals("1")) {
                flag = "success";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public BaseResponse postHeaders(String url, Object object) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(object);
        HttpEntity formEntity = new HttpEntity((Object)json, (MultiValueMap)headers);
        String result = (String)this.restTemplate.postForObject(url, (Object)formEntity, String.class, new Object[0]);
        BaseResponse response = (BaseResponse)mapper.readValue(result, BaseResponse.class);
        return response;
    }
}

