/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.Factory;

import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayFactory;
import com.ebaiyihui.aggregation.payment.server.Factory.PayService;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyChannelEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.PayApplyMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.service.TradeService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements PayService {
    @Autowired
    private PayMchMapper payMchMapper;
    @Autowired
    private PayApplyMapper payApplyMapper;

    public BaseResponse<String> createOrderLauncher(HttpServletRequest request, RequestCreateOrderVo reqVo) {
        String applyCode = reqVo.getApplyCode();
        PayApply payApply = this.payApplyMapper.getByApplyCode(applyCode);
        if (Objects.isNull(payApply)) {
            return BaseResponse.error((String)"\u8bf7\u68c0\u67e5\u5e94\u7528Code,\u6ca1\u6709\u67e5\u8be2\u5230\u5f53\u524d\u5e94\u7528");
        }
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            reqVo.setMchCode(applyCode);
        } else {
            reqVo.setMchCode(mchCode);
        }
        String payChannel = reqVo.getPayChannel();
        String ICBC = PayChanEnum.ICBC.getDisplay();
        if (ICBC.equals(payApply.getApplyType())) {
            payChannel = ICBC;
        }
        TradeService tradeType = PayFactory.getTradeType((String)payChannel);
        return tradeType.createOrder(request, reqVo);
    }

    public BaseResponse<String> refundOrderLauncher(RequestRefundOrderVo reqVo) {
        String applyCode = reqVo.getApplyCode();
        PayApply payApply = this.payApplyMapper.getByApplyCode(applyCode);
        if (Objects.isNull(payApply)) {
            return BaseResponse.error((String)"\u8bf7\u68c0\u67e5\u5e94\u7528Code,\u6ca1\u6709\u67e5\u8be2\u5230\u5f53\u524d\u5e94\u7528");
        }
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            reqVo.setMchCode(applyCode);
        } else {
            reqVo.setMchCode(mchCode);
        }
        String applyType = payApply.getApplyType();
        TradeService tradeType = ApplyChannelEnum.ZWBY.getApplyChannel().equals(applyType) ? PayFactory.getTradeType((String)reqVo.getPayChannel()) : PayFactory.getTradeType((String)applyType);
        return tradeType.refundOrder(reqVo);
    }

    public ResponseQueryOrderVo queryOrderLauncher(PayBill payBill) {
        TradeService tradeType = PayFactory.getTradeType((String)payBill.getTradeChannel());
        ResponseQueryOrderVo queryOrderRespVo = tradeType.queryOrder(payBill);
        return queryOrderRespVo;
    }
}

