/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.applyment;

import com.ebaiyihui.aggregation.payment.common.vo.MerchantPurchaseVO;
import com.ebaiyihui.aggregation.payment.common.vo.SubjectDataVO;
import com.ebaiyihui.aggregation.payment.server.applyment.Applyment;
import com.github.binarywang.wxpay.bean.applyment.WxPayApplyment4SubCreateRequest;
import com.github.binarywang.wxpay.bean.applyment.enums.CertTypeEnum;
import com.github.binarywang.wxpay.bean.applyment.enums.IdTypeEnum;
import com.github.binarywang.wxpay.bean.applyment.enums.SubjectTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SubjectInfoBuilder
implements Applyment {
    private Boolean owner = false;

    public void build(MerchantPurchaseVO merchantPurchaseVO, WxPayApplyment4SubCreateRequest wxPayApplyment4SubCreateRequest) {
        String subjectType;
        SubjectDataVO subjectDataVO = merchantPurchaseVO.getSubjectDataVO();
        if (StringUtils.isBlank((CharSequence)wxPayApplyment4SubCreateRequest.getBusinessCode())) {
            String businessCode = subjectDataVO.getBusinessCode();
            wxPayApplyment4SubCreateRequest.setBusinessCode(businessCode);
        }
        if ((subjectType = subjectDataVO.getSubjectType()).equals(SubjectTypeEnum.SUBJECT_TYPE_INDIVIDUAL.toString())) {
            wxPayApplyment4SubCreateRequest.setSubjectInfo(WxPayApplyment4SubCreateRequest.SubjectInfo.builder().subjectType(SubjectTypeEnum.SUBJECT_TYPE_INDIVIDUAL).businessLicenseInfo(this.getBusinessLicenseInfo(subjectDataVO)).identityInfo(this.getIdentityInfo(subjectDataVO)).uboInfo(this.getUboInfo(subjectDataVO)).build());
            return;
        }
        if (subjectType.equals(SubjectTypeEnum.SUBJECT_TYPE_ENTERPRISE.toString())) {
            if (this.owner.booleanValue()) {
                wxPayApplyment4SubCreateRequest.setSubjectInfo(WxPayApplyment4SubCreateRequest.SubjectInfo.builder().subjectType(SubjectTypeEnum.SUBJECT_TYPE_ENTERPRISE).businessLicenseInfo(this.getBusinessLicenseInfo(subjectDataVO)).identityInfo(this.getIdentityInfo(subjectDataVO)).build());
                return;
            }
            wxPayApplyment4SubCreateRequest.setSubjectInfo(WxPayApplyment4SubCreateRequest.SubjectInfo.builder().subjectType(SubjectTypeEnum.SUBJECT_TYPE_ENTERPRISE).businessLicenseInfo(this.getBusinessLicenseInfo(subjectDataVO)).identityInfo(this.getIdentityInfo(subjectDataVO)).uboInfo(this.getUboInfo(subjectDataVO)).build());
            return;
        }
        if (subjectType.equals(SubjectTypeEnum.SUBJECT_TYPE_INSTITUTIONS.toString())) {
            wxPayApplyment4SubCreateRequest.setSubjectInfo(WxPayApplyment4SubCreateRequest.SubjectInfo.builder().subjectType(SubjectTypeEnum.SUBJECT_TYPE_INSTITUTIONS).certificateInfo(this.getCertificateInfo(subjectDataVO)).certificateLetterCopy(subjectDataVO.getCertificateLetterCopyMedia()).identityInfo(this.getIdentityInfo(subjectDataVO)).build());
            return;
        }
        if (subjectType.equals(SubjectTypeEnum.SUBJECT_TYPE_OTHERS.toString())) {
            wxPayApplyment4SubCreateRequest.setSubjectInfo(WxPayApplyment4SubCreateRequest.SubjectInfo.builder().subjectType(SubjectTypeEnum.SUBJECT_TYPE_OTHERS).certificateInfo(this.getCertificateInfo(subjectDataVO)).certificateLetterCopy(subjectDataVO.getCertificateLetterCopyMedia()).identityInfo(this.getIdentityInfo(subjectDataVO)).build());
            return;
        }
    }

    private WxPayApplyment4SubCreateRequest.SubjectInfo.BusinessLicenseInfo getBusinessLicenseInfo(SubjectDataVO subjectDataVO) {
        return WxPayApplyment4SubCreateRequest.SubjectInfo.BusinessLicenseInfo.builder().licenseCopy(subjectDataVO.getLicenseCopyMedia()).licenseNumber(subjectDataVO.getLicenseNumber()).merchantName(subjectDataVO.getBusinessLicenseInfoMerchantName()).legalPerson(subjectDataVO.getBusinessLicenseInfoLegalPerson()).build();
    }

    private WxPayApplyment4SubCreateRequest.SubjectInfo.CertificateInfo getCertificateInfo(SubjectDataVO subjectDataVO) {
        return WxPayApplyment4SubCreateRequest.SubjectInfo.CertificateInfo.builder().certCopy(subjectDataVO.getCertCopyMedia()).certType(CertTypeEnum.valueOf((String)subjectDataVO.getCertType())).certNumber(subjectDataVO.getCertNumber()).merchantName(subjectDataVO.getCertificateInfoMerchantName()).companyAddress(subjectDataVO.getCompanyAddress()).legalPerson(subjectDataVO.getCertificateInfoLegalPerson()).periodBegin(subjectDataVO.getPeriodBegin()).periodEnd(subjectDataVO.getPeriodEnd()).build();
    }

    private WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo getIdentityInfo(SubjectDataVO subjectDataVO) {
        String idDocType = subjectDataVO.getIdDocType();
        IdTypeEnum idTypeEnum = IdTypeEnum.valueOf((String)idDocType);
        String subjectType = subjectDataVO.getSubjectType();
        this.owner = Boolean.valueOf(subjectDataVO.getOwner());
        boolean flag = subjectType.equals(SubjectTypeEnum.SUBJECT_TYPE_ENTERPRISE.toString());
        if (idDocType.equals(IdTypeEnum.IDENTIFICATION_TYPE_IDCARD.toString())) {
            if (flag) {
                return WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.builder().idDocType(idTypeEnum).idCardInfo(this.getIdCardInfo(subjectDataVO)).owner(this.owner.booleanValue()).build();
            }
            return WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.builder().idDocType(idTypeEnum).idCardInfo(this.getIdCardInfo(subjectDataVO)).build();
        }
        if (flag) {
            return WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.builder().idDocType(idTypeEnum).idDocInfo(this.getIdDocInfo(subjectDataVO)).owner(this.owner.booleanValue()).build();
        }
        return WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.builder().idDocType(idTypeEnum).idDocInfo(this.getIdDocInfo(subjectDataVO)).build();
    }

    private WxPayApplyment4SubCreateRequest.SubjectInfo.UboInfo getUboInfo(SubjectDataVO subjectDataVO) {
        String idType = subjectDataVO.getIdType();
        if (idType.equals(IdTypeEnum.IDENTIFICATION_TYPE_IDCARD.toString())) {
            return WxPayApplyment4SubCreateRequest.SubjectInfo.UboInfo.builder().idCardCopy(subjectDataVO.getUboInfoIdCardCopyMedia()).idCardNational(subjectDataVO.getUboInfoIdCardNationalMedia()).name(subjectDataVO.getName()).idNumber(subjectDataVO.getIdNumber()).idPeriodBegin(subjectDataVO.getIdPeriodBegin()).idPeriodEnd(subjectDataVO.getIdPeriodEnd()).build();
        }
        return WxPayApplyment4SubCreateRequest.SubjectInfo.UboInfo.builder().idDocCopy(subjectDataVO.getUboInfoIdDocCopyMedia()).name(subjectDataVO.getName()).idNumber(subjectDataVO.getIdNumber()).idPeriodBegin(subjectDataVO.getIdPeriodBegin()).idPeriodEnd(subjectDataVO.getIdPeriodEnd()).build();
    }

    private WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdCardInfo getIdCardInfo(SubjectDataVO subjectDataVO) {
        return WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdCardInfo.builder().idCardCopy(subjectDataVO.getIdCardInfoIdCardCopyMedia()).idCardNational(subjectDataVO.getIdCardInfoIdCardNationalMedia()).idCardName(subjectDataVO.getIdCardName()).idCardNumber(subjectDataVO.getIdCardNumber()).cardPeriodBegin(subjectDataVO.getCardPeriodBegin()).cardPeriodEnd(subjectDataVO.getCardPeriodEnd()).build();
    }

    private WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdDocInfo getIdDocInfo(SubjectDataVO subjectDataVO) {
        return WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdDocInfo.builder().idDocCopy(subjectDataVO.getIdDocInfoIdDocCopyMedia()).idDocName(subjectDataVO.getIdDocName()).idDocNumber(subjectDataVO.getIdDocNumber()).docPeriodBegin(subjectDataVO.getDocPeriodBegin()).docPeriodEnd(subjectDataVO.getDocPeriodEnd()).build();
    }
}

