/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ebaiyihui.aggregation.payment.common.model.ErrorBill;
import com.ebaiyihui.aggregation.payment.common.vo.RequestErrorBillVo;
import com.ebaiyihui.aggregation.payment.server.service.ErrorBillService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5dee\u9519\u8d26\u5355\u63a5\u53e3"})
@RestController
@RequestMapping(value={"errorBill"})
public class ErrorBillController {
    @Autowired
    ErrorBillService errorBillService;

    @PostMapping(value={"getByQuery"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5dee\u9519\u8d26\u5355")
    public BaseResponse<IPage<ErrorBill>> getByQuery(@RequestBody RequestErrorBillVo requestErrorBillVo) {
        IPage page = this.errorBillService.getByQuery(requestErrorBillVo);
        return BaseResponse.success((Object)page);
    }

    @GetMapping(value={"exportListByQuery"})
    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u5bfc\u51faexcel")
    public void exportListByQuery(RequestErrorBillVo requestErrorBillVo, HttpServletResponse response) {
        List errorBills = this.errorBillService.getByQueryList(requestErrorBillVo);
        if (errorBills.size() == 0) {
            return;
        }
        try {
            errorBills.forEach(System.out::print);
            response.reset();
            response.setContentType("application/octet-stream");
            String name = URLEncoder.encode("\u5dee\u9519\u8bb0\u5f55", "UTF-8") + ".xlsx";
            response.setHeader("Content-Disposition", "attachment;filename=" + name);
            ServletOutputStream out = response.getOutputStream();
            XSSFWorkbook workBook = new XSSFWorkbook();
            XSSFSheet sheet = workBook.createSheet();
            XSSFRow head = sheet.createRow(0);
            head.createCell(0).setCellValue("\u5bf9\u8d26\u65e5\u671f");
            head.createCell(1).setCellValue("\u5bf9\u8d26\u6279\u6b21\u7f16\u53f7");
            head.createCell(2).setCellValue("\u5dee\u9519\u7f16\u53f7");
            head.createCell(3).setCellValue("\u5bf9\u8d26\u6e20\u9053");
            head.createCell(4).setCellValue("\u5dee\u9519\u7c7b\u578b");
            head.createCell(5).setCellValue("\u5904\u7406\u72b6\u6001");
            int i = 1;
            for (ErrorBill errorBill : errorBills) {
                XSSFRow headi = sheet.createRow(i);
                headi.createCell(0).setCellValue(DateUtils.strDate2StrDate((String)errorBill.getContrastDate()));
                headi.createCell(1).setCellValue(errorBill.getBatchNumber());
                headi.createCell(2).setCellValue(errorBill.getErrorNumber());
                headi.createCell(3).setCellValue(errorBill.getChannel());
                headi.createCell(4).setCellValue(errorBill.getErrorType());
                headi.createCell(5).setCellValue(errorBill.getProcessingState() == 0 ? "\u5f85\u5904\u7406" : "\u5df2\u5904\u7406");
                ++i;
            }
            workBook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"getByBatchNumber"})
    @ApiOperation(value="\u6839\u636e\u5bf9\u8d26\u7f16\u53f7\u67e5\u8be2\u5dee\u9519\u8d26\u5355")
    public BaseResponse<List<ErrorBill>> getByBatchNumber(@RequestParam(value="batchNumber") String batchNumber) {
        return BaseResponse.success((Object)this.errorBillService.getByBatchNumber(batchNumber));
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u770b\u8be6\u60c5")
    public BaseResponse<ErrorBill> getById(@RequestParam(value="id") Long id) {
        return BaseResponse.success((Object)this.errorBillService.getById(id));
    }

    @ApiOperation(value="\u66f4\u6539\u5dee\u9519\u72b6\u6001")
    @GetMapping(value={"updateState"})
    public BaseResponse updateState(@RequestParam(value="id") Long id, @RequestParam(value="remake") String remake) {
        return this.errorBillService.updateState(id, remake);
    }
}

