/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.manage;

import com.ebaiyihui.aggregation.payment.common.model.PayCompany;
import com.ebaiyihui.aggregation.payment.common.model.PayUser;
import com.ebaiyihui.aggregation.payment.common.vo.PayApplyReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.paycompanyvo.CompanyInfoVO;
import com.ebaiyihui.aggregation.payment.common.vo.payuservo.LoginUserVO;
import com.ebaiyihui.aggregation.payment.common.vo.payuservo.RegisterUserVO;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayCompanyService;
import com.ebaiyihui.aggregation.payment.server.service.PayUserService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.utils.CheckUserNameUtil;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.UUIDUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayUserManage {
    private static final Logger log = LoggerFactory.getLogger(PayUserManage.class);
    private static final long ROLR_MANAGE = 1L;
    private static final String defaultCode = "defaultApply";
    private static final String defaultName = "\u9ed8\u8ba4\u5e94\u7528";
    private static final String remark = "\u7ed9\u6ce8\u518c\u7528\u6237\u9ed8\u8ba4\u521b\u5efa\u5e94\u7528";
    @Autowired
    private PayUserService payUserService;
    @Autowired
    private PayCompanyService payCompanyService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PayApplyService payApplyService;

    public BaseResponse<Map<String, Object>> login(LoginUserVO loginUserVO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PayUser user = null;
        log.info("\u7528\u6237\u540d\u957f\u5ea6:{}", (Object)loginUserVO.getUserName().length());
        boolean checkEmail = CheckUserNameUtil.isEmail((String)loginUserVO.getUserName());
        if (checkEmail) {
            user = this.payUserService.findPayUserByUserName(loginUserVO.getUserName());
        } else if (CheckUserNameUtil.isPhone((String)loginUserVO.getUserName())) {
            user = this.payUserService.findPayUserByMobile(loginUserVO.getUserName());
        } else {
            return BaseResponse.error((String)"\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1\u6216\u624b\u673a\u53f7");
        }
        if (null == user) {
            return BaseResponse.error((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        log.info("\u7528\u6237\u767b\u5f55,\u67e5\u8be2\u7528\u6237\u4fe1\u606f:{}", (Object)user);
        if (!user.getPassword().equals(loginUserVO.getPassWord())) {
            return BaseResponse.error((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        map.put("userInfo", user);
        CompanyInfoVO companyById = this.payCompanyService.getPayCompanyById(user.getCompanyId());
        map.put("companyInfo", companyById);
        int diffDay = DateUtils.diffDay((Date)companyById.getCreateTime(), (Date)new Date());
        map.put("diffDay", diffDay);
        int applyNumber = 0;
        BaseResponse appliListCompanyId = this.payApplyService.getAppliListCompanyId(companyById.getId());
        if (appliListCompanyId.getCode().equals("1")) {
            List data = (List)appliListCompanyId.getData();
            applyNumber = data.size();
        }
        map.put("applyNumber", applyNumber);
        return BaseResponse.success(map);
    }

    @Transactional
    public BaseResponse register(RegisterUserVO registerUserVO) {
        PayUser user = null;
        log.info("\u7528\u6237\u6ce8\u518c\u4fe1\u606f:{}", (Object)registerUserVO.toString());
        boolean checkEmail = CheckUserNameUtil.isEmail((String)registerUserVO.getUsername());
        user = this.payUserService.findPayUserByUserName(registerUserVO.getUsername());
        if (null != user) {
            return BaseResponse.error((String)"\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c!");
        }
        user = this.payUserService.findPayUserByMobile(registerUserVO.getMobile());
        if (null != user) {
            return BaseResponse.error((String)"\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c!");
        }
        PayCompany payCompany = new PayCompany();
        BeanUtils.copyProperties((Object)registerUserVO, (Object)payCompany);
        payCompany.setEmail(registerUserVO.getUsername());
        payCompany.setPrincipalName(registerUserVO.getName());
        payCompany.setContactMobile(registerUserVO.getMobile());
        this.payCompanyService.insertPayCompany(payCompany);
        PayUser payUser = new PayUser();
        BeanUtils.copyProperties((Object)registerUserVO, (Object)payUser);
        payUser.setCompanyId(payCompany.getId());
        String uuid = UUIDUtil.getUUID();
        payUser.setUuid(uuid);
        payUser.setRoleId(Long.valueOf(1L));
        this.payUserService.savePayUser(payUser);
        PayApplyReqVO payApplyReqVO = new PayApplyReqVO();
        Long companyId = payCompany.getId();
        String applyCode = defaultCode + companyId;
        String applyName = defaultName + companyId;
        payApplyReqVO.setApplyName(applyName);
        payApplyReqVO.setApplyCode(applyCode);
        payApplyReqVO.setCompanyId(companyId);
        payApplyReqVO.setRemark(remark);
        this.payApplyService.addPayApply(payApplyReqVO);
        return BaseResponse.success();
    }

    public BaseResponse updatePassword(LoginUserVO loginUserVO) {
        String userName = loginUserVO.getUserName();
        boolean userFlag = this.redisTemplateService.get(userName);
        if (!userFlag) {
            return BaseResponse.error((String)"\u7528\u6237\u672a\u901a\u8fc7\u9a8c\u8bc1,\u8bf7\u5148\u9a8c\u8bc1\u7528\u6237");
        }
        HashMap map = new HashMap();
        PayUser user = null;
        log.info("\u7528\u6237\u540d\u957f\u5ea6:{}", (Object)userName.length());
        log.info("\u7528\u6237\u540d:{}", (Object)userName);
        boolean checkEmail = CheckUserNameUtil.isEmail((String)userName);
        if (checkEmail) {
            user = this.payUserService.findPayUserByUserName(userName);
        } else if (CheckUserNameUtil.isPhone((String)userName)) {
            user = this.payUserService.findPayUserByMobile(userName);
        } else {
            return BaseResponse.error((String)"\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1\u6216\u624b\u673a\u53f7");
        }
        if (Objects.isNull(user)) {
            return BaseResponse.error((String)"\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        PayUser payUser = new PayUser();
        payUser.setId(user.getId());
        payUser.setPassword(loginUserVO.getPassWord());
        this.payUserService.updatePayUser(payUser);
        this.redisTemplateService.del(userName);
        return BaseResponse.success();
    }

    public BaseResponse userVerify(String emailOrMobile) {
        String flag = "failure";
        if (null == emailOrMobile) {
            return BaseResponse.success((Object)flag);
        }
        PayUser user = null;
        log.info("\u7528\u6237\u540d\u957f\u5ea6:{}", (Object)emailOrMobile.length());
        log.info("\u7528\u6237\u540d:{}", (Object)emailOrMobile);
        boolean checkEmail = CheckUserNameUtil.isEmail((String)emailOrMobile);
        if (checkEmail) {
            user = this.payUserService.findPayUserByUserName(emailOrMobile);
        } else if (CheckUserNameUtil.isPhone((String)emailOrMobile)) {
            user = this.payUserService.findPayUserByMobile(emailOrMobile);
        } else {
            return BaseResponse.error((String)"\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1\u6216\u624b\u673a\u53f7");
        }
        if (null != user) {
            flag = "success";
        }
        return BaseResponse.success((Object)flag);
    }
}

