/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestOfflineOederQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrCodeCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrIsSweptCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseReverseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.UnionPayVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayFactory;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.OrderRabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitProduct;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.TradeService;
import com.ebaiyihui.aggregation.payment.server.unionpay.DemoBase;
import com.ebaiyihui.aggregation.payment.server.unionpay.UnionPayClient;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.AcpService;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.LogUtil;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionPayServiceImpl
implements TradeService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UnionPayServiceImpl.class);
    public static final String FAIL = "FAIL";
    @Autowired
    PayMchService payMchService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private RabbitProduct rabbitProduct;
    @Autowired
    private PaymentRecordsService paymentRecordsService;

    public void afterPropertiesSet() throws Exception {
        PayFactory.register((String)PayChanEnum.UNIONPAY.getDisplay(), (TradeService)this);
    }

    public BaseResponse<String> createOrder(HttpServletRequest request, RequestCreateOrderVo requestCreateOrderVo) {
        String redisKey = requestCreateOrderVo.getOutTradeNo() + "_" + requestCreateOrderVo.getPayType();
        PayBill payBill = this.payBillService.getByOutTradeNo(requestCreateOrderVo.getOutTradeNo());
        if (null == payBill) {
            payBill = this.payBillService.getByCreateOrder(requestCreateOrderVo);
        }
        String tradeType = payBill.getTradeType();
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType);
        UnionPayVo payParam = (UnionPayVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), UnionPayVo.class);
        String redirectUrl = null;
        if (null != payBill.getAttach()) {
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            redirectUrl = "https://paydevapi.chinachdu.com/qr_code/unifiedPay?applyCode=" + payMch.getApplyCode() + "&attach=" + payBill.getAttach();
        }
        try {
            String payhtml = UnionPayClient.pay(redirectUrl, (String)payBill.getDealTradeNo(), (String)UnionPayClient.getPayType((String)tradeType), (String)requestCreateOrderVo.getActuallyAmount().toString(), (String)requestCreateOrderVo.getProductInfo(), (Date)payBill.getPayTime(), (UnionPayVo)payParam);
            OrderRabbitInfo orderRabbitInfo = new OrderRabbitInfo();
            orderRabbitInfo.setRedisKey(redisKey);
            orderRabbitInfo.setOutTradeNo(requestCreateOrderVo.getOutTradeNo());
            orderRabbitInfo.setTradeChannl(requestCreateOrderVo.getPayChannel());
            this.rabbitProduct.pushOrderOverTimeDelay(orderRabbitInfo);
            return BaseResponse.success((Object)payhtml);
        }
        catch (Exception e) {
            log.error("\u3010\u94f6\u8054\u3011\u9884\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u5f02\u5e38\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{payBill.getDealTradeNo(), e.getMessage(), e});
            return BaseResponse.error((String)("\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage()));
        }
    }

    public ResponseQueryOrderVo queryOrder(PayBill payBill) {
        ResponseQueryOrderVo queryOrderVo = new ResponseQueryOrderVo();
        String tradeType = payBill.getTradeType();
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType);
        if (null == mchChan) {
            queryOrderVo.setReturnMsg("\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u786e\u8ba4");
            queryOrderVo.setReturnCode(FAIL);
            return queryOrderVo;
        }
        log.info("\u4e0b\u5355\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)mchChan.toString());
        UnionPayVo payParam = (UnionPayVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), UnionPayVo.class);
        String txnTime = DateUtils.dateToString((Date)payBill.getPayTime(), (String)"yyyyMMddHHmmss");
        Map rspData = UnionPayClient.query((String)payBill.getDealTradeNo(), (String)txnTime, (UnionPayVo)payParam);
        if (!rspData.isEmpty()) {
            if (AcpService.validate((Map)rspData, (String)DemoBase.encoding)) {
                LogUtil.writeLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f");
                if ("00".equals(rspData.get("respCode"))) {
                    String origRespCode = (String)rspData.get("origRespCode");
                    if ("00".equals(origRespCode)) {
                        System.out.println("\u4ea4\u6613\u6210\u529f\u4e86\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                        queryOrderVo.setResultCode("SUCCESS");
                        queryOrderVo.setResultMsg("\u4ea4\u6613\u6210\u529f");
                        queryOrderVo.setOutTradeNo(payBill.getOutTradeNo());
                        queryOrderVo.setTradeNo(payBill.getTradeNo());
                        queryOrderVo.setDealTradeNo(payBill.getDealTradeNo());
                        queryOrderVo.setTradeType(payBill.getTradeType());
                        return queryOrderVo;
                    }
                    if (!("03".equals(origRespCode) || "04".equals(origRespCode) || "05".equals(origRespCode))) {
                        queryOrderVo.setResultMsg("\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
                        queryOrderVo.setResultCode(FAIL);
                    }
                }
            } else {
                LogUtil.writeErrorLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
                queryOrderVo.setResultMsg("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
                queryOrderVo.setResultCode(FAIL);
            }
        } else {
            LogUtil.writeErrorLog((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
            queryOrderVo.setResultMsg("\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
            queryOrderVo.setResultCode(FAIL);
        }
        return queryOrderVo;
    }

    public BaseResponse<String> refundOrder(RequestRefundOrderVo requestRefundOrderVo) {
        String refundNo = UniqueKeyGenerator.generateViewId();
        PayBill payBill = this.payBillService.getByDealTradeNo(requestRefundOrderVo.getDealTradeNo());
        log.info("\u9000\u6b3e\u539f\u59cb\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
        if (null == payBill) {
            return BaseResponse.error((String)"\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u3010\u94f6\u8054\u3011\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570{}", (Object)mchChan.toString());
        if (null == mchChan) {
            return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458");
        }
        UnionPayVo payParam = (UnionPayVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), UnionPayVo.class);
        Map rspData = UnionPayClient.refund((String)refundNo, (String)UnionPayClient.getPayType((String)payBill.getTradeType()), (String)payBill.getOrderAmount().toString(), (String)payBill.getTradeNo(), (UnionPayVo)payParam);
        if (!rspData.isEmpty()) {
            if (AcpService.validate((Map)rspData, (String)DemoBase.encoding)) {
                LogUtil.writeLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f");
                String respCode = (String)rspData.get("respCode");
                if ("00".equals(respCode)) {
                    this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
                    PayBill refundBill = payBill;
                    log.info("\u8bb0\u5f55\u9000\u6b3e\u8d26\u5355{}", (Object)refundBill.toString());
                    refundBill.setOutRefundNo(refundNo);
                    refundBill.setStatus(OrderStatusEnum.REFUNDING.getValue());
                    refundBill.setRefundAmount(requestRefundOrderVo.getRefundAmount());
                    refundBill.setRefundNotifyUrl(requestRefundOrderVo.getRefundNotifyUrl());
                    this.payBillService.update(refundBill);
                    return BaseResponse.success((Object)"\u7533\u8bf7\u9000\u6b3e\u6210\u529f");
                }
                if ("03".equals(respCode) || "04".equals(respCode) || "05".equals(respCode)) {
                    return BaseResponse.error((String)"\u540e\u7eed\u9700\u53d1\u8d77\u4ea4\u6613\u72b6\u6001\u67e5\u8be2\u4ea4\u6613\u786e\u5b9a\u4ea4\u6613\u72b6\u6001");
                }
                return BaseResponse.error((String)"\u5176\u4ed6\u5e94\u7b54\u7801\u4e3a\u5931\u8d25\u8bf7\u6392\u67e5\u539f\u56e0");
            }
            LogUtil.writeErrorLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            return BaseResponse.error((String)"\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
        }
        LogUtil.writeErrorLog((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
        return BaseResponse.error((String)"\u7533\u8bf7\u9000\u6b3e\u5931\u8d25");
    }

    public ResponseQueryRefundOrderVo queryRefundOrder(RequestQueryRefundOrderVo requestQueryRefundOrderVo, PayBill payBill) {
        return null;
    }

    public ResponseCloseOrderVo closeOrder(PayBill payBill) {
        return null;
    }

    public BaseResponse downLoadBill(RequestDownloadVo requestDownloadVo) {
        return null;
    }

    public ResponseQueryOrderVo offlineQueryOrder(RequestOfflineOederQueryVO reqVo) {
        return null;
    }

    public BaseResponse<String> qrCode(RequestQrCodeCreateOrderVo qrCodeCreateOrderVo) throws IOException {
        String redisKey = qrCodeCreateOrderVo.getOutTradeNo() + "_" + qrCodeCreateOrderVo.getPayType();
        if (BigDecimal.ZERO.compareTo(qrCodeCreateOrderVo.getTotalAmount()) >= 0) {
            return BaseResponse.error((String)"\u8ba2\u5355\u91d1\u989d\u5f02\u5e38");
        }
        PayBill payBillExist = this.payBillService.getByOutTradeNo(qrCodeCreateOrderVo.getOutTradeNo());
        if (null != payBillExist && OrderStatusEnum.PAID.getValue().equals(payBillExist.getStatus())) {
            return BaseResponse.error((String)"\u5df2\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
        }
        String orderViewId = UniqueKeyGenerator.generateViewId();
        RequestCreateOrderVo createOrderVo = new RequestCreateOrderVo();
        BeanUtils.copyProperties((Object)qrCodeCreateOrderVo, (Object)createOrderVo);
        PayBill payBill = this.payBillService.getByCreateOrder(createOrderVo);
        String tradeType = payBill.getTradeType();
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType);
        if (null == mchChan) {
            return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458\u68c0\u67e5\u914d\u7f6e");
        }
        log.info("\u4e0b\u5355\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)mchChan.toString());
        UnionPayVo payParam = (UnionPayVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), UnionPayVo.class);
        log.info("\u8bb0\u5f55\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
        payBill.setDealTradeNo(orderViewId);
        this.payBillService.save(payBill);
        String url = UnionPayClient.qrCode((String)orderViewId, (String)qrCodeCreateOrderVo.getActuallyAmount().toString(), (UnionPayVo)payParam);
        OrderRabbitInfo orderRabbitInfo = new OrderRabbitInfo();
        orderRabbitInfo.setRedisKey(redisKey);
        orderRabbitInfo.setOutTradeNo(qrCodeCreateOrderVo.getOutTradeNo());
        orderRabbitInfo.setTradeChannl(qrCodeCreateOrderVo.getPayChannel());
        this.rabbitProduct.pushOrderOverTimeDelay(orderRabbitInfo);
        return BaseResponse.success((Object)url);
    }

    public BaseResponse<String> createPolymericOrder(HttpServletRequest request, PayBill payBill, RequestCreateOrderVo requestCreateOrderVo) {
        return null;
    }

    public BaseResponse<String> qrIsSwept(RequestQrIsSweptCreateOrderVo orderVo) throws IOException {
        String redisKey = orderVo.getOutTradeNo() + "_" + orderVo.getPayType();
        if (BigDecimal.ZERO.compareTo(orderVo.getTotalAmount()) >= 0) {
            return BaseResponse.error((String)"\u8ba2\u5355\u91d1\u989d\u5f02\u5e38");
        }
        PayBill payBillExist = this.payBillService.getByOutTradeNo(orderVo.getOutTradeNo());
        if (null != payBillExist && OrderStatusEnum.PAID.getValue().equals(payBillExist.getStatus())) {
            return BaseResponse.error((String)"\u5df2\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
        }
        String orderViewId = UniqueKeyGenerator.generateViewId();
        RequestCreateOrderVo createOrderVo = new RequestCreateOrderVo();
        BeanUtils.copyProperties((Object)orderVo, (Object)createOrderVo);
        PayBill payBill = this.payBillService.getByCreateOrder(createOrderVo);
        String tradeType = payBill.getTradeType();
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType);
        if (null == mchChan) {
            return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458\u68c0\u67e5\u914d\u7f6e");
        }
        log.info("\u4e0b\u5355\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)mchChan.toString());
        UnionPayVo payParam = (UnionPayVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), UnionPayVo.class);
        log.info("\u8bb0\u5f55\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
        payBill.setDealTradeNo(orderViewId);
        this.payBillService.save(payBill);
        String url = UnionPayClient.qrIsSwept((String)orderViewId, (String)orderVo.getActuallyAmount().toString(), (String)orderVo.getQrNo(), (UnionPayVo)payParam);
        OrderRabbitInfo orderRabbitInfo = new OrderRabbitInfo();
        orderRabbitInfo.setRedisKey(redisKey);
        orderRabbitInfo.setOutTradeNo(orderVo.getOutTradeNo());
        orderRabbitInfo.setTradeChannl(orderVo.getPayChannel());
        this.rabbitProduct.pushOrderOverTimeDelay(orderRabbitInfo);
        return BaseResponse.success((Object)url);
    }

    public ResponseReverseOrderVo reverseOrderVo(PayBill payBill) {
        return null;
    }
}

