/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.ThirdPartyRelation;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyPayNotifyOrderVO;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.ThirdPartyRelationService;
import com.ebaiyihui.aggregation.payment.server.service.notify.INotify;
import com.ebaiyihui.aggregation.payment.server.service.notify.NotifyFactory;
import com.ebaiyihui.aggregation.payment.server.service.notify.RabbitMqPusher;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HyPay
implements INotify,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HyPay.class);
    public static final String RESLUT_CODE = "SUCCESS";
    public static final String RETURN_CODE = "SUCCESS";
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PayMchMapper payMchMapper;
    @Autowired
    private ThirdPartyRelationService relationService;
    @Autowired
    private PayApplyService payApplyService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitMqPusher rabbitMqPusher;
    @Autowired
    private MchChanService mchChanService;

    public String notify(HttpServletRequest request) {
        try {
            log.info("=====\u3010\u6c47\u4ed8\u5b9d\u3011\u8fdb\u5165\u4e86\u6c47\u4ed8\u5b9d\u56de\u8c03=====");
            String xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            log.info("===\u6c47\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570:{}", (Object)xmlResult);
            Map notifyparams = (Map)JSON.parseObject((String)xmlResult, HashMap.class);
            log.info("===\u6c47\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570Map:{}", (Object)notifyparams);
            PayBill payBill = this.payBillService.getByDealTradeNo((String)notifyparams.get("out_trade_no"));
            log.info("===\u6839\u636e\u56de\u8c03\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)payBill));
            ThirdPartyRelation partyRelation = this.relationService.getRelationInfoByApplyCode(payBill.getMchCode());
            MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
            String param = mchChan.getParam();
            WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
            String hyApplykey = hyParam.getHyApplyKey();
            log.info("\u6c47\u4ed8\u5b9d\u8ba2\u5355,\u6c47\u4ed8\u5b9d\u5173\u8054\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)mchChan.getParam()));
            log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u8ba2\u5355,\u6c47\u4ed8\u5b9d\u5173\u8054\u4fe1\u606f:{} ", (Object)JSONObject.toJSONString((Object)mchChan));
            boolean check = this.createSign(notifyparams, hyApplykey);
            if (!check) {
                log.error("=======\u3010\u6c47\u4ed8\u5b9d\u3011\u6c47\u4ed8\u5b9d\u9a8c\u7b7e\u5931\u8d25=======");
                return "error";
            }
            HyPayNotifyOrderVO orderRespVO = (HyPayNotifyOrderVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)notifyparams), HyPayNotifyOrderVO.class);
            payBill.setTradeNo(orderRespVO.getHy_bill_no());
            payBill.setStatus(OrderStatusEnum.PAID.getValue());
            payBill.setPayTime(DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)orderRespVO.getTime_end()));
            log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)JSONObject.toJSONString((Object)payBill));
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
            log.info("-------------\u3010\u5fae\u4fe1\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
            responseNotifyRestVo.setTradeNo(orderRespVO.getHy_bill_no());
            responseNotifyRestVo.setReturnCode("SUCCESS");
            responseNotifyRestVo.setReturnMsg(orderRespVO.getReturn_msg());
            responseNotifyRestVo.setResultCode("SUCCESS");
            responseNotifyRestVo.setErrCode(orderRespVO.getError_code());
            responseNotifyRestVo.setErrCodeDes(orderRespVO.getError_msg());
            responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseNotifyRestVo.setOutTradeNo(payBill.getDealTradeNo());
            responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                responseNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseNotifyRestVo.setAttach(payBill.getAttach());
            responseNotifyRestVo.setMchCode(payBill.getMchCode());
            responseNotifyRestVo.setMchId(orderRespVO.getMch_uid());
            responseNotifyRestVo.setMchName(payBill.getMchCode());
            String payTime = DateUtils.strToDateLong((String)orderRespVO.getTime_end());
            responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime));
            responseNotifyRestVo.setNotifyResultStr(JSON.toJSONString((Object)orderRespVO));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
            this.rabbitMqPusher.notify("pay", JSON.toJSONString((Object)responseNotifyRestVo));
            String rediskey = payBill.getServiceCode() + "_" + payBill.getOutTradeNo();
            this.redisTemplateService.del(rediskey);
            return "ok";
        }
        catch (Exception e) {
            log.error("\u3010\u6c47\u4ed8\u5b9d\u3011\u6c47\u4ed8\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return "error";
        }
    }

    public boolean createSign(Map map, String applyKey) {
        StringBuilder builder = new StringBuilder();
        builder.append("app_id").append("=").append(map.get("app_id")).append("&").append("attach").append("=").append(map.get("attach")).append("&").append("channel_trade_no").append("=").append(map.get("channel_trade_no")).append("&").append("channel_type").append("=").append(map.get("channel_type")).append("&").append("hy_bill_no").append("=").append(map.get("hy_bill_no")).append("&").append("mch_uid").append("=").append(map.get("mch_uid")).append("&").append("out_trade_no").append("=").append(map.get("out_trade_no")).append("&").append("pay_option").append("=").append(map.get("pay_option")).append("&").append("real_fee").append("=").append(map.get("real_fee")).append("&").append("subject").append("=").append(map.get("subject")).append("&").append("time_end").append("=").append(map.get("time_end")).append("&").append("total_fee").append("=").append(map.get("total_fee")).append("&").append("trade_status").append("=").append(map.get("trade_status")).append("&").append("version").append("=").append(map.get("version")).append("&").append("key").append("=").append(applyKey);
        System.out.println("\u7b7e\u540d\u5b57\u7b26\u4e32\u53c2\u6570\uff1a" + builder.toString());
        String sign = com.ebaiyihui.aggregation.payment.server.hypay.hyutil.SignUtil.MD5en((String)builder.toString()).toUpperCase();
        log.info("\u7b7e\u540d\u7ed3\u679c\uff1a" + sign);
        boolean equals = sign.equals(map.get("sign"));
        return equals;
    }

    public void afterPropertiesSet() throws Exception {
        NotifyFactory.register((String)this.getClass().getSimpleName().toLowerCase(), (INotify)this);
    }
}

