/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.profit.sharing;

import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyChannelEnum;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.ProfitSharingReqVO;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayApplyMapper;
import com.ebaiyihui.aggregation.payment.server.profitSharing.IProfitSharing;
import com.ebaiyihui.aggregation.payment.server.profitSharing.ProfitSharingFactory;
import com.ebaiyihui.aggregation.payment.server.profitSharing.ProfitSharingTypeEnum;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.profit.sharing.PaymentProfitSharingService;
import com.ebaiyihui.framework.response.BaseResponse;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentProfitSharingServiceImpl
implements PaymentProfitSharingService {
    private static final Logger log = LoggerFactory.getLogger(PaymentProfitSharingServiceImpl.class);
    @Resource
    private ProfitSharingFactory profitSharingFactory;
    @Resource
    private PayBillService payBillService;
    @Resource
    private PayApplyMapper payApplyMapper;
    @Resource
    private MchChanMapper mchChanMapper;

    public BaseResponse profitSharing(ProfitSharingReqVO profitSharingReqVO) {
        PayBill payBill = this.payBillService.getByOutTradeNo(profitSharingReqVO.getOutTradeNo());
        PayApply payApply = this.payApplyMapper.getByApplyCode(payBill.getMchCode());
        String applyType = payApply.getApplyType().toUpperCase();
        IProfitSharing profitSharing = this.getIProfitSharing(payBill, applyType);
        if (StringUtils.isNotBlank((CharSequence)profitSharingReqVO.getRuleId())) {
            // empty if block
        }
        return profitSharing.profitSharing(profitSharingReqVO, payApply.getApplyCode());
    }

    private IProfitSharing getIProfitSharing(PayBill payBill, String applyType) {
        IProfitSharing profitSharing;
        if (ApplyChannelEnum.ZWBY.getDisplay().equals(applyType)) {
            MchChan mchChan = this.mchChanMapper.selectThirdMchChan(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
            profitSharing = this.profitSharingFactory.getProfitSharing(ProfitSharingTypeEnum.getStrategyValue((String)mchChan.getChanCode().toUpperCase()));
        } else {
            profitSharing = this.profitSharingFactory.getProfitSharing(ProfitSharingTypeEnum.getStrategyValue((String)applyType));
        }
        return profitSharing;
    }

    public BaseResponse getProfitSharingData(String outTradeNo) {
        return null;
    }
}

