/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.ChannelBill;
import com.ebaiyihui.aggregation.payment.common.vo.ReWriteBillVO;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyPublicParameReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRequestDownloadBO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRequestDownloadRespVO;
import com.ebaiyihui.aggregation.payment.server.mapper.ChannelBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ErrorBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PlatformBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ReconciliationMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ThirdPartyRelationMapper;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.AReconciliationBill;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.BillFileProcessor;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.IBillFile;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationTypeFactory;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ChannelBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.DateCondition;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.HeeMoneyBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.PlatformBillBO;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class HeeMoney
extends AReconciliationBill
implements IBillFile,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HeeMoney.class);
    private static final String RETURN_CODE = "SUCCESS";
    private static final String RESULT_CODE = "SUCCESS";
    private static final String BILL_PAY_STATUS = "SUCCESS";
    private static final String BILL_REFUND_CODE = "SUCCESS";
    private static final String PAY_HEAD = "01";
    private static final String REFUND_HEAD = "10";
    final ThirdPartyRelationMapper thirdPartyRelationMapper;
    final ChannelBillMapper channelBillMapper;
    final PlatformBillMapper platformBillMapper;
    final ErrorBillMapper errorBillMapper;
    final ReconciliationMapper reconciliationMapper;
    final PayBillMapper payBillMapper;

    public void saveChannelBill(String billDate) {
        List thirdPartyRelations = this.thirdPartyRelationMapper.selectList();
        thirdPartyRelations.forEach(one -> {
            DateCondition dateCondition = new DateCondition(billDate);
            HyRequestDownloadBO downloadBO = new HyRequestDownloadBO(dateCondition);
            HyPublicParameReqVO parameReqVO = new HyPublicParameReqVO();
            HyPublicParameReqVO downloadOrder = parameReqVO.downloadOrder(one, JSONObject.toJSONString((Object)downloadBO));
            String url = "https://api.heemoney.com/v1/MerchBillReport";
            JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)downloadOrder));
            log.info(" [\u6c47\u4ed8\u5b9d] \u4e0b\u8f7d\u8d26\u5355\u8fd4\u56de:{}", (Object)jsonObject);
            HyRequestDownloadRespVO orderRespVO = (HyRequestDownloadRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyRequestDownloadRespVO.class);
            if (!"SUCCESS".equals(orderRespVO.getReturn_msg()) || !"SUCCESS".equals(orderRespVO.getResult_code())) {
                log.info("\u83b7\u53d6 [\u6c47\u4ed8\u5b9d] \u8d26\u5355\u4e0b\u8f7durl\u5931\u8d25\uff0c\u4e0b\u8f7d\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)orderRespVO));
                return;
            }
            String downloadBillUrl = orderRespVO.getUrl();
            log.info("\u83b7\u53d6 [\u6c47\u4ed8\u5b9d] \u8d26\u5355\u4e0b\u8f7durl\uff1a{}", (Object)downloadBillUrl);
            List heePayBillBOS = BillFileProcessor.downloadBill((String)url, (IBillFile)this);
            heePayBillBOS.forEach(e -> {
                ChannelBillBO channelBillBO = e.buildChannelBillBO(billDate);
                ChannelBill channelBill = new ChannelBill();
                BeanUtils.copyProperties((Object)channelBillBO, (Object)channelBill);
                this.channelBillMapper.insert((Object)channelBill);
            });
        });
    }

    public void savePlatformBill(String billDate) {
        DateCondition dateCondition = new DateCondition(billDate);
        List payBillList = this.payBillMapper.selectListByReconciliation(dateCondition.getStartTime(), dateCondition.getEndTime(), "HEEMONEY");
        payBillList.forEach(e -> {
            PlatformBillBO platformBillBO = new PlatformBillBO();
            platformBillBO.init(e, billDate);
            this.platformBillMapper.insert((Object)platformBillBO.getPlatformBill());
        });
    }

    public void reconciliationBill(String billDate, String batchNumber) {
    }

    public void getBillByFile(List result, BufferedReader br, String fileName) throws IOException {
        block5: {
            String line;
            block4: {
                String line2;
                if (Objects.isNull(fileName) || fileName.indexOf(".") == -1 || fileName.substring(0, 2).equals(PAY_HEAD)) break block4;
                int i = 0;
                while ((line2 = br.readLine()) != null) {
                    log.info("\u89e3\u6790\u6570\u636e\uff1a{}", (Object)line2);
                    if (i > 0) {
                        String[] lines = line2.split(",", -1);
                        HeeMoneyBillBO heeBillInfo = this.getPaymentHeeMoneyBillBO(lines);
                        result.add(heeBillInfo);
                    }
                    ++i;
                }
                break block5;
            }
            if (Objects.isNull(fileName) || fileName.indexOf(".") == -1 || fileName.substring(0, 2).equals(REFUND_HEAD)) break block5;
            int i = 0;
            while ((line = br.readLine()) != null) {
                log.info("\u89e3\u6790\u6570\u636e\uff1a{}", (Object)line);
                if (i > 0) {
                    String[] lines = line.split(",", -1);
                    HeeMoneyBillBO heeBillInfo = this.getHeeMoneyRefundBillBO(lines);
                    result.add(heeBillInfo);
                }
                ++i;
            }
        }
    }

    private HeeMoneyBillBO getHeeMoneyRefundBillBO(String[] lines) {
        return HeeMoneyBillBO.builder().hyTradeNo(lines[0].trim()).hyRefundNo(lines[1].trim()).outRefundNo(lines[2].trim()).outTradeNo(lines[3].trim()).mchUid(lines[4].trim()).mchName(lines[5].trim()).orderRefundAmount(lines[6].trim()).submitRefundAmount(lines[7].trim()).actuallyRefundAmount(lines[8].trim()).channelType(lines[9].trim()).tradeState("SUCCESS").submitTime(lines[11].trim()).handleTime(lines[12].trim()).build();
    }

    private HeeMoneyBillBO getPaymentHeeMoneyBillBO(String[] lines) {
        return HeeMoneyBillBO.builder().hyTradeNo(lines[0].trim()).outTradeNo(lines[1].trim()).channelType(lines[2].trim()).mchUid(lines[3].trim()).mchName(lines[4].trim()).orderAmount(lines[5].trim()).actuallyAmount(lines[6].trim()).tradeState("SUCCESS").settlementAmount(lines[8].trim()).submitTime(lines[9].trim()).handleTime(lines[10].trim()).build();
    }

    public Boolean reWriteBills(ReWriteBillVO reWriteBillVO) {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        ReconciliationTypeFactory.register((String)PayChanEnum.HEEPAY.name(), (AReconciliationBill)this);
    }

    public HeeMoney(ThirdPartyRelationMapper thirdPartyRelationMapper, ChannelBillMapper channelBillMapper, PlatformBillMapper platformBillMapper, ErrorBillMapper errorBillMapper, ReconciliationMapper reconciliationMapper, PayBillMapper payBillMapper) {
        this.thirdPartyRelationMapper = thirdPartyRelationMapper;
        this.channelBillMapper = channelBillMapper;
        this.platformBillMapper = platformBillMapper;
        this.errorBillMapper = errorBillMapper;
        this.reconciliationMapper = reconciliationMapper;
        this.payBillMapper = payBillMapper;
    }
}

