/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.transfer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayFundTransCommonQueryModel;
import com.alipay.api.request.AlipayFundTransCommonQueryRequest;
import com.alipay.api.request.AlipayFundTransUniTransferRequest;
import com.alipay.api.response.AlipayFundTransCommonQueryResponse;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.AlipayFundTransUniTransferReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.CrtUploadResp;
import com.ebaiyihui.aggregation.payment.server.service.transfer.AlipayTransferApi;
import com.ebaiyihui.aggregation.payment.server.utils.RequestHolder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlipayTransferApiImpl
implements AlipayTransferApi {
    private static final Logger log = LoggerFactory.getLogger(AlipayTransferApiImpl.class);

    private WxPayParam convertAlipParam(String param) {
        return (WxPayParam)JSONObject.parseObject((String)param, WxPayParam.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCrtPath(String appId, String crtName, String content) {
        String path = "/data/log/crt/" + appId + "/" + crtName;
        File dest = new File(path);
        if (dest.exists()) {
            return path;
        }
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            dest.mkdirs();
            fw = new FileWriter(path, true);
            bw = new BufferedWriter(fw);
            bw.write(content);
            bw.flush();
        }
        catch (IOException e) {
            log.error("crt\u6587\u4ef6\u5199\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u540d:{}", (Object)content);
        }
        finally {
            try {
                if (Objects.nonNull(bw)) {
                    bw.close();
                    fw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    private AlipayClient buildAlipayClient() throws AlipayApiException {
        MchChan mtc = RequestHolder.getMtc();
        WxPayParam alipayParam = this.convertAlipParam(mtc.getParam());
        String appId = alipayParam.getAppId();
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl("https://openapi.alipay.com/gateway.do");
        certAlipayRequest.setAppId(appId);
        certAlipayRequest.setPrivateKey(alipayParam.getAppPrivateKey());
        certAlipayRequest.setFormat("json");
        certAlipayRequest.setCharset("UTF-8");
        certAlipayRequest.setSignType("RSA2");
        CrtUploadResp certPath = alipayParam.getCertPath();
        certAlipayRequest.setCertPath(this.getCrtPath(appId, certPath.getName(), certPath.getContent()));
        CrtUploadResp alipayPublicCertPath = alipayParam.getAlipayPublicCertPath();
        certAlipayRequest.setAlipayPublicCertPath(this.getCrtPath(appId, alipayPublicCertPath.getName(), alipayPublicCertPath.getContent()));
        CrtUploadResp rootCertPath = alipayParam.getRootCertPath();
        certAlipayRequest.setRootCertPath(this.getCrtPath(appId, rootCertPath.getName(), rootCertPath.getContent()));
        return new DefaultAlipayClient(certAlipayRequest);
    }

    public AlipayFundTransUniTransferResponse alipayFundTransUniTransfer(AlipayFundTransUniTransferReq model) throws AlipayApiException {
        AlipayClient alipayClient = this.buildAlipayClient();
        AlipayFundTransUniTransferRequest request = new AlipayFundTransUniTransferRequest();
        request.setBizContent(JSON.toJSONString((Object)model));
        log.info("alipay alipayFundTransUniTransfer req={}", (Object)JSON.toJSONString((Object)request));
        AlipayFundTransUniTransferResponse res = (AlipayFundTransUniTransferResponse)alipayClient.certificateExecute((AlipayRequest)request);
        log.info("alipay alipayFundTransUniTransfer resp={}", (Object)JSON.toJSONString((Object)res));
        return res;
    }

    public AlipayFundTransCommonQueryResponse alipayFundTransCommonQuery(AlipayFundTransCommonQueryModel model) throws AlipayApiException {
        AlipayClient alipayClient = this.buildAlipayClient();
        AlipayFundTransCommonQueryRequest request = new AlipayFundTransCommonQueryRequest();
        JSONObject j = new JSONObject();
        j.put("product_code", (Object)model.getProductCode());
        j.put("biz_scene", (Object)model.getBizScene());
        j.put("out_biz_no", (Object)model.getOutBizNo());
        j.put("order_id", (Object)model.getOrderId());
        request.setBizContent(JSON.toJSONString((Object)j));
        log.info("alipay alipayFundTransCommonQuery req={}", (Object)JSON.toJSONString((Object)request));
        AlipayFundTransCommonQueryResponse res = (AlipayFundTransCommonQueryResponse)alipayClient.certificateExecute((AlipayRequest)request);
        log.info("alipay alipayFundTransCommonQuery resp={}", (Object)JSON.toJSONString((Object)res));
        return res;
    }
}

