/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.mybank;

import com.ebaiyihui.aggregation.payment.server.mybank.DefaultRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankApiException;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankApiExceptionEnum;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankParser;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankResponse;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankUploadRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.mapping.SignChecker;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.mapping.Signer;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.parser.xml.ObjectXmlParser;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.util.HttpsUtil;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.util.MybankLogger;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.util.StringUtils;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.util.WebUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;

public abstract class AbstractMybankClient
implements MybankClient {
    private String serverUrl;
    private String format = "XML";
    private String signType = "RSA";
    private String charset = "UTF-8";
    private int connectTimeout = 3000;
    private int readTimeout = 15000;

    public AbstractMybankClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public AbstractMybankClient(String serverUrl, String charset) {
        this.serverUrl = serverUrl;
        this.charset = charset;
    }

    public AbstractMybankClient(String serverUrl, String charset, String signType) {
        this(serverUrl, charset);
        if (!StringUtils.isEmpty((String)signType)) {
            this.signType = signType;
        }
    }

    public AbstractMybankClient(String serverUrl, String format, String charset, String signType) {
        this(serverUrl, charset);
        if (!StringUtils.isEmpty((String)format)) {
            this.format = format;
        }
        if (!StringUtils.isEmpty((String)signType)) {
            this.signType = signType;
        }
    }

    public <T extends MybankResponse> T execute(MybankRequest<T> request) throws MybankApiException {
        ObjectXmlParser parser = null;
        if (!"XML".equals(this.format)) {
            throw new MybankApiException(MybankApiExceptionEnum.NOT_XML_TYPE);
        }
        parser = new ObjectXmlParser(request.getResponseClass());
        return (T)this.execute(request, (MybankParser)parser);
    }

    public <T extends MybankResponse> T execute(MybankUploadRequest<T> request) throws MybankApiException {
        ObjectXmlParser parser = new ObjectXmlParser(request.getResponseClass());
        return (T)this.execute(request, (MybankParser)parser);
    }

    private <T extends MybankResponse> T execute(DefaultRequest<T> request, MybankParser<T> parser) throws MybankApiException {
        long beginTime = System.currentTimeMillis();
        Map rt = new HashMap();
        rt = request instanceof MybankRequest ? this.doPost((MybankRequest)request) : this.doPost((MybankUploadRequest)request);
        HashMap<String, Long> costTimeMap = new HashMap<String, Long>();
        if (rt.containsKey("prepareTime")) {
            costTimeMap.put("prepareCostTime", (Long)rt.get("prepareTime") - beginTime);
            if (rt.containsKey("requestTime")) {
                costTimeMap.put("requestCostTime", (Long)rt.get("requestTime") - (Long)rt.get("prepareTime"));
            }
        }
        MybankResponse tRsp = null;
        try {
            tRsp = parser.parse((String)rt.get("rspContent"));
            tRsp.setXmlContent((String)rt.get("rspContent"));
            tRsp.setRequestContent((String)rt.get("requestContent"));
            this.checkResponseSign((String)rt.get("rspContent"));
            if (costTimeMap.containsKey("requestCostTime")) {
                costTimeMap.put("postCostTime", System.currentTimeMillis() - (Long)rt.get("requestTime"));
            }
        }
        catch (RuntimeException e) {
            MybankLogger.logBizError((String)((String)rt.get("rspContent")), costTimeMap);
            throw new MybankApiException((Throwable)e);
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError((String)((String)rt.get("rspContent")), costTimeMap);
            throw e;
        }
        MybankLogger.logBizSummary(rt, costTimeMap);
        return (T)tRsp;
    }

    private <T extends MybankResponse> Map<String, Object> doPost(MybankRequest<T> request) throws MybankApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String xmlContent = null;
        try {
            xmlContent = request.xmlBuild();
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError((Throwable)e);
            throw new MybankApiException((Throwable)e);
        }
        if (request.isNeedSign()) {
            try {
                xmlContent = this.getSigner().sign(xmlContent, this.charset, this.signType);
            }
            catch (MybankApiException e) {
                MybankLogger.logBizError((Throwable)e);
                throw new MybankApiException((Throwable)e);
            }
        }
        result.put("requestContent", xmlContent);
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            rsp = WebUtils.doPost((String)this.serverUrl, (String)xmlContent, (String)request.getCookieValue(), (String)this.charset, (int)this.connectTimeout, (int)this.readTimeout, (String)request.getApiFunction(), (String)request.getApiVersion());
        }
        catch (MybankApiException e) {
            throw new MybankApiException((Throwable)e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rspContent", rsp);
        result.put("url", this.serverUrl);
        return result;
    }

    private <T extends MybankResponse> Map<String, Object> doPost(MybankUploadRequest<T> request) throws MybankApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map map = null;
        try {
            map = request.getMapByModel();
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError((Throwable)e);
            throw new MybankApiException(MybankApiExceptionEnum.SDK_SYSTEM_EXCEPTION, (Throwable)e);
        }
        String signString = request.uploadRequestSignString(map);
        try {
            signString = this.getSigner().webSign(signString, this.charset, this.signType);
        }
        catch (MybankApiException e) {
            MybankLogger.logBizError((Throwable)e);
            throw new MybankApiException(MybankApiExceptionEnum.SDK_SYSTEM_EXCEPTION, (Throwable)e);
        }
        map.put("Signature", signString);
        HttpEntity httpEntity = request.entityBuilder(map);
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)httpEntity.getContentLength());
        try {
            httpEntity.writeTo((OutputStream)out);
            result.put("requestContent", out.toString());
        }
        catch (IOException e) {
            MybankLogger.logBizError((Throwable)e);
            throw new MybankApiException(MybankApiExceptionEnum.SDK_SYSTEM_EXCEPTION, (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                MybankLogger.logBizError((Throwable)e);
                throw new MybankApiException(MybankApiExceptionEnum.SDK_SYSTEM_EXCEPTION, (Throwable)e);
            }
        }
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            rsp = HttpsUtil.httpPost((String)this.serverUrl, (HttpEntity)httpEntity, (String)this.charset, (String)request.getApiFunction(), (String)request.getApiVersion());
        }
        catch (MybankApiException e) {
            throw new MybankApiException(MybankApiExceptionEnum.REQUEST_REMOTE_SERVER_ERROR, (Throwable)e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rspContent", rsp);
        result.put("url", this.serverUrl);
        return result;
    }

    private void checkResponseSign(String rspContent) throws MybankApiException {
        boolean checkResult = this.getSignChecker().check(rspContent, this.charset, this.signType);
        if (!checkResult) {
            throw new MybankApiException(MybankApiExceptionEnum.VERIFY_FAIL);
        }
    }

    void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setSignType(String signType) {
        this.signType = signType;
    }

    void setCharset(String charset) {
        this.charset = charset;
    }

    void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    abstract Signer getSigner();

    abstract SignChecker getSignChecker();

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

