/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitProduct;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqPusher {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqPusher.class);
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private RabbitProduct rabbitProduct;

    public void notify(String type, String notifyRestVo) {
        String notifyUrl;
        log.info("\u83b7\u53d6\u56de\u8c03\u5730\u5740\uff0c\u51c6\u5907\u56de\u8c03");
        if ("refund".equals(type)) {
            ResponseRefundNotifyRestVo responseRefundNotifyRestVo = (ResponseRefundNotifyRestVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)notifyRestVo), ResponseRefundNotifyRestVo.class);
            PayBill payBill = this.payBillService.getByDealTradeNo(responseRefundNotifyRestVo.getDealTradeNo());
            if (null == payBill || null == payBill.getRefundNotifyUrl()) {
                return;
            }
            notifyUrl = payBill.getRefundNotifyUrl();
        } else {
            ResponseNotifyRestVo responseNotifyRestVo = (ResponseNotifyRestVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)notifyRestVo), ResponseNotifyRestVo.class);
            PayBill payBill = this.payBillService.getByDealTradeNo(responseNotifyRestVo.getDealTradeNo());
            if (null == payBill || null == payBill.getPayNotifyUrl()) {
                return;
            }
            notifyUrl = payBill.getPayNotifyUrl();
        }
        RabbitInfo rabbitInfo = new RabbitInfo();
        if (StringUtil.isEmpty((String)notifyUrl)) {
            log.info("====\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u672c\u6b21\u64cd\u4f5c\u65e0\u56de\u8c03====");
            return;
        }
        rabbitInfo.setUrl(notifyUrl);
        rabbitInfo.setType(type);
        rabbitInfo.setNotifyRestVo(notifyRestVo);
        this.rabbitProduct.pushA(rabbitInfo);
    }
}

