/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.bo;

import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.server.bo.RequestCreateOrderBO;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayRequestBO;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import java.util.Date;
import org.springframework.beans.BeanUtils;

public class PayCreateOrderBO {
    public static final int ADD_MINUTES = 35;
    public static final int MICROPAY_MINUTES = 5;
    private String requestIp;
    private String notifyUrl;
    private String returnUrl;
    private String dealTradeNo;
    private String outTradeNo;
    private WxPayParam wxPayParam;
    private WxPayUnifiedOrderRequest orderRequest;
    private WxPayMicropayRequestBO micropayRequest;
    private RequestCreateOrderBO createOrderBO = new RequestCreateOrderBO();

    public PayCreateOrderBO() {
    }

    public PayCreateOrderBO(RequestCreateOrderVo createOrderVo, WxPayParam wxPayParam, String requestIp, String dealTradeNo) {
        BeanUtils.copyProperties((Object)createOrderVo, (Object)this.createOrderBO);
        this.requestIp = requestIp;
        this.dealTradeNo = dealTradeNo;
        this.wxPayParam = wxPayParam;
    }

    public PayCreateOrderBO(RequestCreateOrderVo createOrderVo, String notifyUrl, String returnUrl, String outTradeNo) {
        BeanUtils.copyProperties((Object)createOrderVo, (Object)this.createOrderBO);
        this.notifyUrl = notifyUrl;
        this.returnUrl = returnUrl;
        this.outTradeNo = outTradeNo;
    }

    public WxPayUnifiedOrderRequest getWxPayUnifiedOrderRequest() {
        Date timeExpire = DateUtils.dateAddMinutes((Date)new Date(), (int)35);
        String orderTimeExpire = DateUtils.dateToString((Date)timeExpire, (String)"yyyyMMddHHmmss");
        WxPayUnifiedOrderRequest createOrderVO = this.createOrderBO.getWxPayCreateOrder(this.requestIp, orderTimeExpire, this.dealTradeNo);
        return createOrderVO;
    }

    public WxPayMicropayRequestBO getWxPayMicropayRequest() {
        Date timeExpire = DateUtils.dateAddMinutes((Date)new Date(), (int)5);
        String orderTimeExpire = DateUtils.dateToString((Date)timeExpire, (String)"yyyyMMddHHmmss");
        WxPayMicropayRequestBO micropayOrder = this.createOrderBO.getWxMicropayOrder(this.wxPayParam, this.requestIp, orderTimeExpire, this.dealTradeNo);
        return micropayOrder;
    }

    public AlipayTradePagePayRequest getAliPayPageRequest() {
        AlipayTradePagePayRequest aliPayPageCreateOrder = this.createOrderBO.getAliPayPageCreateOrder(this.dealTradeNo);
        aliPayPageCreateOrder.setNotifyUrl(this.notifyUrl);
        aliPayPageCreateOrder.setReturnUrl(this.returnUrl);
        return aliPayPageCreateOrder;
    }

    public AlipayTradePrecreateRequest getAliPrecreateRequest() {
        AlipayTradePrecreateRequest precreateCreateOrder = this.createOrderBO.getAliPayPrecreateCreateOrder(this.dealTradeNo);
        precreateCreateOrder.setNotifyUrl(this.notifyUrl);
        precreateCreateOrder.setReturnUrl(this.returnUrl);
        return precreateCreateOrder;
    }

    public AlipayTradePayRequest getAliMicropayRequest() {
        AlipayTradePayRequest aliMicropayOrder = this.createOrderBO.getAliMicropayOrder(this.outTradeNo);
        return aliMicropayOrder;
    }

    public String getRequestIp() {
        return this.requestIp;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getDealTradeNo() {
        return this.dealTradeNo;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public WxPayParam getWxPayParam() {
        return this.wxPayParam;
    }

    public WxPayUnifiedOrderRequest getOrderRequest() {
        return this.orderRequest;
    }

    public WxPayMicropayRequestBO getMicropayRequest() {
        return this.micropayRequest;
    }

    public RequestCreateOrderBO getCreateOrderBO() {
        return this.createOrderBO;
    }

    public void setRequestIp(String requestIp) {
        this.requestIp = requestIp;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public void setDealTradeNo(String dealTradeNo) {
        this.dealTradeNo = dealTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setWxPayParam(WxPayParam wxPayParam) {
        this.wxPayParam = wxPayParam;
    }

    public void setOrderRequest(WxPayUnifiedOrderRequest orderRequest) {
        this.orderRequest = orderRequest;
    }

    public void setMicropayRequest(WxPayMicropayRequestBO micropayRequest) {
        this.micropayRequest = micropayRequest;
    }

    public void setCreateOrderBO(RequestCreateOrderBO createOrderBO) {
        this.createOrderBO = createOrderBO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayCreateOrderBO)) {
            return false;
        }
        PayCreateOrderBO other = (PayCreateOrderBO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$requestIp = this.getRequestIp();
        String other$requestIp = other.getRequestIp();
        if (this$requestIp == null ? other$requestIp != null : !this$requestIp.equals(other$requestIp)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
            return false;
        }
        String this$dealTradeNo = this.getDealTradeNo();
        String other$dealTradeNo = other.getDealTradeNo();
        if (this$dealTradeNo == null ? other$dealTradeNo != null : !this$dealTradeNo.equals(other$dealTradeNo)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        WxPayParam this$wxPayParam = this.getWxPayParam();
        WxPayParam other$wxPayParam = other.getWxPayParam();
        if (this$wxPayParam == null ? other$wxPayParam != null : !this$wxPayParam.equals(other$wxPayParam)) {
            return false;
        }
        WxPayUnifiedOrderRequest this$orderRequest = this.getOrderRequest();
        WxPayUnifiedOrderRequest other$orderRequest = other.getOrderRequest();
        if (this$orderRequest == null ? other$orderRequest != null : !this$orderRequest.equals(other$orderRequest)) {
            return false;
        }
        WxPayMicropayRequestBO this$micropayRequest = this.getMicropayRequest();
        WxPayMicropayRequestBO other$micropayRequest = other.getMicropayRequest();
        if (this$micropayRequest == null ? other$micropayRequest != null : !this$micropayRequest.equals(other$micropayRequest)) {
            return false;
        }
        RequestCreateOrderBO this$createOrderBO = this.getCreateOrderBO();
        RequestCreateOrderBO other$createOrderBO = other.getCreateOrderBO();
        return !(this$createOrderBO == null ? other$createOrderBO != null : !this$createOrderBO.equals(other$createOrderBO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayCreateOrderBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestIp = this.getRequestIp();
        result = result * 59 + ($requestIp == null ? 43 : $requestIp.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        String $dealTradeNo = this.getDealTradeNo();
        result = result * 59 + ($dealTradeNo == null ? 43 : $dealTradeNo.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        WxPayParam $wxPayParam = this.getWxPayParam();
        result = result * 59 + ($wxPayParam == null ? 43 : $wxPayParam.hashCode());
        WxPayUnifiedOrderRequest $orderRequest = this.getOrderRequest();
        result = result * 59 + ($orderRequest == null ? 43 : $orderRequest.hashCode());
        WxPayMicropayRequestBO $micropayRequest = this.getMicropayRequest();
        result = result * 59 + ($micropayRequest == null ? 43 : $micropayRequest.hashCode());
        RequestCreateOrderBO $createOrderBO = this.getCreateOrderBO();
        result = result * 59 + ($createOrderBO == null ? 43 : $createOrderBO.hashCode());
        return result;
    }

    public String toString() {
        return "PayCreateOrderBO(requestIp=" + this.getRequestIp() + ", notifyUrl=" + this.getNotifyUrl() + ", returnUrl=" + this.getReturnUrl() + ", dealTradeNo=" + this.getDealTradeNo() + ", outTradeNo=" + this.getOutTradeNo() + ", wxPayParam=" + this.getWxPayParam() + ", orderRequest=" + this.getOrderRequest() + ", micropayRequest=" + this.getMicropayRequest() + ", createOrderBO=" + this.getCreateOrderBO() + ")";
    }
}

