/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.vo.PayChanResponse;
import com.ebaiyihui.aggregation.payment.common.vo.PayWayResponse;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.PayBillQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.RequesstPayBillPageVo;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.ResponsePayBillDetailVo;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d26\u5355\u63a5\u53e3"})
@RequestMapping(value={"/payBill"})
public class PayBillController {
    private static final Logger log = LoggerFactory.getLogger(PayBillController.class);
    @Autowired
    private PayBillService payBillService;

    @PostMapping(value={"getById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    public BaseResponse getById(@RequestParam(value="id") Long id) {
        ResponsePayBillDetailVo payBill = this.payBillService.getById(id);
        return BaseResponse.success((Object)payBill);
    }

    @PostMapping(value={"getPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public BaseResponse<IPage<PayBill>> getPage(@RequestBody RequesstPayBillPageVo requesstPayBillPageVo) {
        IPage mchIPage = this.payBillService.getPage(requesstPayBillPageVo);
        return BaseResponse.success((Object)mchIPage);
    }

    @PostMapping(value={"/query_pay_bill"})
    public BaseResponse<IPage<PayBill>> queryPayBill(@RequestBody PayBillQueryVO payBillQueryVO) {
        log.info("\u8bf7\u6c42\u53c2\u6570:[" + payBillQueryVO + "]");
        IPage payBillPage = this.payBillService.queryPayBill(payBillQueryVO);
        log.info("\u67e5\u8be2\u8d26\u5355\u6570\u636e\u7ed3\u679c:[" + payBillPage + "]");
        return BaseResponse.success((Object)payBillPage);
    }

    @GetMapping(value={"/query_pay_channel"})
    public BaseResponse<List<PayChanResponse>> queryPayChan(@RequestParam(value="mchCode") String mchCode) {
        if (StringUtils.isNotBlank((CharSequence)mchCode)) {
            return BaseResponse.success((Object)this.payBillService.queryPayChan(mchCode));
        }
        return BaseResponse.error((String)"\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @GetMapping(value={"query_pay_way"})
    public BaseResponse<List<PayWayResponse>> queryPayWay(@RequestParam(value="mchCode") String mchCode, @RequestParam(value="chanCode") String chanCode) {
        if (StringUtils.isNotBlank((CharSequence)mchCode) && StringUtils.isNotBlank((CharSequence)chanCode)) {
            return BaseResponse.success((Object)this.payBillService.queryPayWay(mchCode, chanCode));
        }
        return BaseResponse.error((String)"\u5546\u6237\u53f7\u6216\u8005\u6e20\u9053\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

