/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.core;

import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.utils.SpringUtils;
import javax.servlet.http.HttpServletRequest;

public abstract class PaymentHandler {
    private PayMchMapper payMchMapper = (PayMchMapper)SpringUtils.getBean(PayMchMapper.class);

    public void paymentHandle(HttpServletRequest request, RequestCreateOrderVo reqVo) {
        this.getPaymentConfig(reqVo);
        this.aggregatePaymentParam(request, reqVo);
        this.pay();
    }

    protected void getPaymentConfig(RequestCreateOrderVo reqVo) {
        String applyCode = reqVo.getApplyCode();
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            reqVo.setMchCode(applyCode);
        } else {
            reqVo.setMchCode(mchCode);
        }
    }

    protected abstract void aggregatePaymentParam(HttpServletRequest var1, RequestCreateOrderVo var2);

    protected abstract void pay();
}

