/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ebaiyihui.aggregation.payment.common.model.BaseEntity;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.server.enums.AliPayTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.utils.RequestHolder;
import com.ebaiyihui.aggregation.payment.server.utils.SpringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class McInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(McInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        JSONObject jsonData = this.getJsonData(request);
        String mchCode = jsonData.getString("mchCode");
        String chanCode = jsonData.getString("chanCode");
        log.info("McInterceptor \u62e6\u622a\u5668\u83b7\u53d6 mchCode={},chanCode={}", (Object)mchCode, (Object)chanCode);
        if (StringUtils.isNotBlank((CharSequence)mchCode) && StringUtils.isNotBlank((CharSequence)chanCode)) {
            MchChanService service = (MchChanService)SpringUtils.getBean(MchChanService.class);
            LambdaQueryWrapper q = new LambdaQueryWrapper();
            q.select(new SFunction[]{MchChan::getParam});
            q.eq(MchChan::getMchCode, (Object)mchCode);
            q.eq(MchChan::getChanCode, (Object)chanCode);
            q.eq(BaseEntity::getStatus, (Object)1);
            q.eq(MchChan::getType, (Object)AliPayTradeTypeEnum.TRANSFER.name());
            MchChan one = (MchChan)service.getOne((Wrapper)q);
            if (Objects.isNull(one)) {
                throw new RuntimeException("\u5546\u6237\u4e0d\u5b58\u5728");
            }
            RequestHolder.add((MchChan)one);
            return true;
        }
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        RequestHolder.remove();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestHolder.remove();
    }

    public JSONObject getJsonData(HttpServletRequest request) throws IOException {
        BufferedReader streamReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while (true) {
            Object[] objectArray = new Object[1];
            String inputStr = streamReader.readLine();
            objectArray[0] = inputStr;
            if (!ObjectUtils.allNotNull((Object[])objectArray)) break;
            sb.append(inputStr);
        }
        return JSONObject.parseObject((String)sb.toString());
    }
}

