/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayDataDataserviceBillDownloadurlQueryModel;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeCloseModel;
import com.alipay.api.domain.AlipayTradeCreateModel;
import com.alipay.api.domain.AlipayTradeFastpayRefundQueryModel;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.domain.ExtendParams;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradeCreateRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradeCreateResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradePayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingRecord;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestOfflineOederQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrCodeCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrIsSweptCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseReverseOrderVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayFactory;
import com.ebaiyihui.aggregation.payment.server.bo.PayCreateOrderBO;
import com.ebaiyihui.aggregation.payment.server.enums.AliPayTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ProfitSharingEnums;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.OrderRabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.SynchroNotifyRabbit;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.TradeService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.MapToJsonUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayResultBO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayServiceImpl
extends BaseService
implements TradeService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AlipayServiceImpl.class);
    @Autowired
    private NotifyService notifyService;

    public void afterPropertiesSet() throws Exception {
        PayFactory.register((String)PayChanEnum.ALIPAY.getDisplay(), (TradeService)this);
    }

    public BaseResponse<String> createOrder(HttpServletRequest request, RequestCreateOrderVo requestCreateOrderVo) {
        log.info("\u652f\u4ed8\u4e0b\u5355\u5165\u53c2:{}", (Object)requestCreateOrderVo.toString());
        String redisKey = requestCreateOrderVo.getOutTradeNo() + "_" + requestCreateOrderVo.getPayType();
        boolean res = this.redisTemplateService.addLock(redisKey, redisKey, 2100L);
        if (!res) {
            return BaseResponse.error((String)"\u8ba2\u5355\u6b63\u5728\u652f\u4ed8\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8\u64cd\u4f5c\uff0c\u4ee5\u514d\u9020\u6210\u4e0d\u5fc5\u8981\u7684\u635f\u5931");
        }
        String orderViewId = "zz".concat(UniqueKeyGenerator.generateViewId());
        PayBill payBill = this.payBillService.getByCreateOrder(requestCreateOrderVo);
        log.info("\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
        payBill.setDealTradeNo(orderViewId);
        this.payBillService.save(payBill);
        this.paymentRecordsService.saveByBill(orderViewId, requestCreateOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
        log.info("\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5165\u53c2:{}", (Object)payBill.toString());
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)mchChan.toString());
        if (null == mchChan) {
            return null;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", wxPayParam.getAppId(), wxPayParam.getAppPrivateKey(), "json", "UTF-8", wxPayParam.getMchPublicKey(), "RSA2");
        if (null == alipayClient) {
            log.error("=====\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25=====");
            this.redisTemplateService.del(redisKey);
            return BaseResponse.error((String)"\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25,\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
        }
        BaseResponse payResponse = this.getAliPayResponse((AlipayClient)alipayClient, requestCreateOrderVo, orderViewId, redisKey, payBill, mchChan, wxPayParam);
        if (payResponse != null && payResponse.isSuccess()) {
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONObject.parseObject((String)((String)payResponse.getData()));
            }
            catch (Exception e) {
                jsonObject = new JSONObject();
                jsonObject.put("form", payResponse.getData());
            }
            jsonObject.put("outTradeNo", (Object)requestCreateOrderVo.getOutTradeNo());
            jsonObject.put("dealTradeNo", (Object)orderViewId);
            return BaseResponse.success((Object)jsonObject.toJSONString());
        }
        return payResponse;
    }

    public ResponseQueryOrderVo queryOrder(PayBill payBill) {
        ResponseQueryOrderVo responseQueryOrderVo = new ResponseQueryOrderVo();
        AlipayClient alipayClient = this.getAlipayClient(payBill);
        if (null == alipayClient) {
            log.error("=====\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25=====");
            responseQueryOrderVo.setReturnCode("FAIL");
            responseQueryOrderVo.setReturnMsg("\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25,\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            return responseQueryOrderVo;
        }
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        AlipayTradeQueryRequest alipayTradeQueryRequest = new AlipayTradeQueryRequest();
        if (!StringUtils.isBlank((CharSequence)wxPayParam.getAppAuthToken())) {
            alipayTradeQueryRequest.putOtherTextParam("app_auth_token", wxPayParam.getAppAuthToken());
        }
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(payBill.getOutTradeNo());
        model.setTradeNo(payBill.getTradeNo());
        alipayTradeQueryRequest.setBizModel((AlipayObject)model);
        log.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)alipayTradeQueryRequest));
        AlipayTradeQueryResponse tradeQueryResponse = null;
        try {
            tradeQueryResponse = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)alipayTradeQueryRequest);
            log.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u6210\u529f,\u8fd4\u56de\u7684\u6570\u636e\u4e3a{}", (Object)JSON.toJSONString((Object)tradeQueryResponse));
            if ("10000".equals(tradeQueryResponse.getCode()) && "TRADE_SUCCESS".equals(tradeQueryResponse.getTradeStatus())) {
                responseQueryOrderVo.setReturnCode("SUCCESS");
                responseQueryOrderVo.setReturnMsg(tradeQueryResponse.getMsg());
                responseQueryOrderVo.setResultCode("SUCCESS");
                responseQueryOrderVo.setResultMsg("SUCCESS");
                responseQueryOrderVo.setTradeNo(tradeQueryResponse.getTradeNo());
                responseQueryOrderVo.setOutTradeNo(tradeQueryResponse.getOutTradeNo());
                responseQueryOrderVo.setOpenid(tradeQueryResponse.getBuyerLogonId());
                responseQueryOrderVo.setTradeState(tradeQueryResponse.getTradeStatus());
                responseQueryOrderVo.setDealTradeNo(tradeQueryResponse.getOutTradeNo());
                responseQueryOrderVo.setPayTime(tradeQueryResponse.getSendPayDate());
                return responseQueryOrderVo;
            }
            responseQueryOrderVo.setReturnCode("FAIL");
            responseQueryOrderVo.setReturnMsg(tradeQueryResponse.getMsg());
            responseQueryOrderVo.setResultCode("FAIL");
            responseQueryOrderVo.setResultMsg(tradeQueryResponse.getSubMsg());
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getErrMsg(), (Object)e);
            responseQueryOrderVo.setReturnCode("FAIL");
            responseQueryOrderVo.setReturnMsg(e.getErrMsg());
            return responseQueryOrderVo;
        }
        return responseQueryOrderVo;
    }

    public BaseResponse<String> refundOrder(RequestRefundOrderVo requestRefundOrderVo) {
        log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7684\u5165\u53c2\uff1a{}", (Object)requestRefundOrderVo.toString());
        ProfitSharingRecord queryProfitSharingRecord = new ProfitSharingRecord();
        queryProfitSharingRecord.setOutTradeNo(requestRefundOrderVo.getOutTradeNo());
        QueryWrapper queryWrapper = new QueryWrapper((Object)queryProfitSharingRecord);
        ProfitSharingRecord profitSharingRecord = (ProfitSharingRecord)this.profitSharingRecordMapper.selectOne((Wrapper)queryWrapper);
        boolean checkResult = Objects.nonNull(profitSharingRecord) && profitSharingRecord.getProfitSharingType().equals(ProfitSharingEnums.ProfitSharingTypeEnum.ALIPAY_PROFIT_SHARING.getProfitSharingTypeId()) && profitSharingRecord.getProfitSharingResultStatus().equals(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_SUCCESS.getProfitSharingStatusCode());
        ProfitSharingRecord saveProfitSharingRecord = new ProfitSharingRecord();
        if (checkResult) {
            saveProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_DEFAULT.getProfitSharingStatusCode());
            saveProfitSharingRecord.setProfitSharingType(ProfitSharingEnums.ProfitSharingTypeEnum.ALIPAY_PROFIT_SHARING.getProfitSharingTypeId());
            saveProfitSharingRecord.setOutTradeNo(requestRefundOrderVo.getOutTradeNo());
            saveProfitSharingRecord.setProfitSharingOperatingData(JSONObject.toJSONString((Object)requestRefundOrderVo));
            this.profitSharingRecordMapper.insert((Object)saveProfitSharingRecord);
        }
        try {
            boolean firstRefund = true;
            PayBill payBill = this.payBillService.getByDealTradeNo(requestRefundOrderVo.getDealTradeNo());
            String refundNo = requestRefundOrderVo.getOutTradeNo();
            if (refundNo.equals(payBill.getOutTradeNo())) {
                refundNo = UniqueKeyGenerator.generateViewId();
            }
            if (payBill.getOutRefundNo() != null) {
                firstRefund = false;
            }
            String tradeType = payBill.getTradeType();
            MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType);
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            AlipayClient alipayClient = this.getAlipayClient(payBill);
            if (null == alipayClient) {
                log.error("=====\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25=====");
                return BaseResponse.error((String)"\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25,\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            }
            AlipayTradeRefundRequest alipayTradeRefundRequest = new AlipayTradeRefundRequest();
            if (!StringUtils.isBlank((CharSequence)wxPayParam.getAppAuthToken())) {
                alipayTradeRefundRequest.putOtherTextParam("app_auth_token", wxPayParam.getAppAuthToken());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("out_trade_no", payBill.getOutTradeNo());
            map.put("trade_no", payBill.getTradeNo());
            map.put("refund_amount", requestRefundOrderVo.getRefundAmount());
            map.put("refund_reason", "\u5546\u54c1\u9000\u6b3e");
            map.put("out_request_no", refundNo);
            alipayTradeRefundRequest.setNotifyUrl(this.returnUrl);
            alipayTradeRefundRequest.setBizContent(JSONObject.toJSONString(map));
            log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)alipayTradeRefundRequest));
            AlipayTradeRefundResponse tradeRefundResponse = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)alipayTradeRefundRequest);
            if (checkResult) {
                if (Objects.nonNull(tradeRefundResponse) && tradeRefundResponse.isSuccess()) {
                    saveProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_PROCESSING.getProfitSharingStatusCode());
                    saveProfitSharingRecord.setProfitSharingResultMsg(tradeRefundResponse.getMsg());
                } else {
                    saveProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_REFUND_FAIL.getProfitSharingStatusCode());
                    saveProfitSharingRecord.setProfitSharingResultMsg(tradeRefundResponse.getSubMsg());
                    saveProfitSharingRecord.setProfitSharingErrorCode(tradeRefundResponse.getSubCode());
                }
                this.profitSharingRecordMapper.insert((Object)saveProfitSharingRecord);
            }
            log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7684\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)tradeRefundResponse));
            this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND, refundNo);
            if (!tradeRefundResponse.isSuccess()) {
                log.info("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25:", (Object)tradeRefundResponse.getSubMsg());
                return BaseResponse.error((String)("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25" + tradeRefundResponse.getMsg()));
            }
            PayBill refundBill = payBill;
            String fundChange = tradeRefundResponse.getFundChange();
            ResponseQueryOrderVo responseQueryOrderVo = this.queryOrder(payBill);
            boolean flag = false;
            if ("TRADE_SUCCESS".equals(responseQueryOrderVo.getTradeState())) {
                flag = true;
            }
            if (this.synNotify(tradeType, fundChange, flag)) {
                refundBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
            } else {
                refundBill.setStatus(OrderStatusEnum.REFUNDING.getValue());
            }
            refundBill.setRefundAmount(new BigDecimal(tradeRefundResponse.getRefundFee()));
            refundBill.setRefundTime(tradeRefundResponse.getGmtRefundPay());
            refundBill.setRefundNotifyUrl(requestRefundOrderVo.getRefundNotifyUrl());
            refundBill.setOutRefundNo(refundNo);
            if (firstRefund) {
                this.payBillService.update(refundBill);
            } else {
                this.payBillService.save(refundBill);
            }
            if (this.synNotify(tradeType, fundChange, flag)) {
                ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
                responseRefundNotifyRestVo.setReturnCode("trade_status_sync");
                responseRefundNotifyRestVo.setReturnMsg("TRADE_FINISHED");
                responseRefundNotifyRestVo.setErrCode("");
                responseRefundNotifyRestVo.setErrCodeDes("");
                responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
                responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                responseRefundNotifyRestVo.setRefundNo(refundNo);
                responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                responseRefundNotifyRestVo.setMchCode(payBill.getMchCode());
                responseRefundNotifyRestVo.setRefundMoney(requestRefundOrderVo.getRefundAmount());
                if (null != payBill.getServiceCode() && !"".equals(payBill.getServiceCode().trim())) {
                    responseRefundNotifyRestVo.setAttach(payBill.getServiceCode());
                }
                if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                    responseRefundNotifyRestVo.setRemake(payBill.getRemake());
                }
                responseRefundNotifyRestVo.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)new Date().toString()));
                PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
                responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
                responseRefundNotifyRestVo.setOutRefundNo(refundNo);
                Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
                String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
                responseRefundNotifyRestVo.setSign(sign);
                this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
                log.info("\u3010\u652f\u4ed8\u5b9d\u3011\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u6570\u636e{}", (Object)responseRefundNotifyRestVo.toString());
                this.notifyServiceImpl.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
            }
            return BaseResponse.success((Object)"\u7533\u8bf7\u9000\u6b3e\u6210\u529f");
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff01\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getErrMsg(), (Object)e);
            return BaseResponse.error((String)("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25" + e.getErrMsg()));
        }
    }

    public ResponseQueryRefundOrderVo queryRefundOrder(RequestQueryRefundOrderVo requestQueryRefundOrderVo, PayBill payBill) {
        ResponseQueryRefundOrderVo responseQueryRefundOrderVo = new ResponseQueryRefundOrderVo();
        AlipayClient alipayClient = this.getAlipayClient(payBill);
        if (null == alipayClient) {
            log.error("=====\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25=====");
            responseQueryRefundOrderVo.setReturnCode("FAIL");
            responseQueryRefundOrderVo.setReturnMsg("\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25,\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            return responseQueryRefundOrderVo;
        }
        AlipayTradeFastpayRefundQueryRequest alipayRefundQueryRequest = new AlipayTradeFastpayRefundQueryRequest();
        AlipayTradeFastpayRefundQueryModel model = new AlipayTradeFastpayRefundQueryModel();
        model.setTradeNo(requestQueryRefundOrderVo.getTradeNo());
        model.setOutTradeNo(payBill.getDealTradeNo());
        model.setOutRequestNo(payBill.getOutRefundNo());
        alipayRefundQueryRequest.setBizModel((AlipayObject)model);
        log.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)alipayRefundQueryRequest));
        AlipayTradeFastpayRefundQueryResponse refundQueryResponse = null;
        try {
            refundQueryResponse = (AlipayTradeFastpayRefundQueryResponse)alipayClient.execute((AlipayRequest)alipayRefundQueryRequest);
            log.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f\u6210\u529f,\u8fd4\u56de\u7684\u6570\u636e\u4e3a{}", (Object)JSON.toJSONString((Object)refundQueryResponse));
            if (refundQueryResponse.isSuccess()) {
                if (!"10000".equals(refundQueryResponse.getCode())) {
                    responseQueryRefundOrderVo.setReturnCode("FAIL");
                    responseQueryRefundOrderVo.setReturnMsg(refundQueryResponse.getMsg());
                    responseQueryRefundOrderVo.setSubCode("FAIL");
                    responseQueryRefundOrderVo.setSubMsg(refundQueryResponse.getSubMsg());
                } else {
                    responseQueryRefundOrderVo.setReturnCode("SUCCESS");
                    responseQueryRefundOrderVo.setReturnMsg(refundQueryResponse.getMsg());
                    responseQueryRefundOrderVo.setSubCode("SUCCESS");
                    responseQueryRefundOrderVo.setSubMsg("SUCCESS");
                    responseQueryRefundOrderVo.setOutTradeNo(refundQueryResponse.getOutTradeNo());
                    responseQueryRefundOrderVo.setTradeNo(refundQueryResponse.getTradeNo());
                    responseQueryRefundOrderVo.setTotalAmount(new BigDecimal(refundQueryResponse.getTotalAmount()));
                    responseQueryRefundOrderVo.setRefundAmount(new BigDecimal(refundQueryResponse.getRefundAmount()));
                    responseQueryRefundOrderVo.setGmtRefundPay(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(refundQueryResponse.getGmtRefundPay()));
                }
            } else {
                responseQueryRefundOrderVo.setReturnCode("FAIL");
                responseQueryRefundOrderVo.setReturnMsg("\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u7684\u67e5\u8be2\u7684\u63a5\u53e3\u5931\u8d25");
            }
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getErrMsg(), (Object)e);
            responseQueryRefundOrderVo.setReturnCode("FAIL");
            responseQueryRefundOrderVo.setReturnMsg(e.getErrMsg());
            return responseQueryRefundOrderVo;
        }
        return responseQueryRefundOrderVo;
    }

    public ResponseCloseOrderVo closeOrder(PayBill payBill) {
        ResponseCloseOrderVo responseCloseOrderVo = new ResponseCloseOrderVo();
        AlipayClient alipayClient = this.getAlipayClient(payBill);
        if (null == alipayClient) {
            log.error("=====\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25=====");
            responseCloseOrderVo.setResultCode("FAIL");
            responseCloseOrderVo.setResultMsg("\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25,\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            return responseCloseOrderVo;
        }
        AlipayTradeCloseModel alipayTradeCloseModel = new AlipayTradeCloseModel();
        alipayTradeCloseModel.setOutTradeNo(payBill.getDealTradeNo());
        AlipayTradeCloseRequest tradeCloseRequest = new AlipayTradeCloseRequest();
        tradeCloseRequest.setBizModel((AlipayObject)alipayTradeCloseModel);
        try {
            log.info("\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u4ea4\u6613\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)tradeCloseRequest));
            AlipayTradeCloseResponse tradeCloseResponse = (AlipayTradeCloseResponse)alipayClient.execute((AlipayRequest)tradeCloseRequest);
            log.info("\u652f\u4ed8\u5b9d\u5173\u95ed\u4ea4\u6613\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)tradeCloseResponse));
            if (tradeCloseResponse.isSuccess()) {
                responseCloseOrderVo.setResultCode(tradeCloseResponse.getCode());
                responseCloseOrderVo.setResultMsg(tradeCloseResponse.getMsg());
                responseCloseOrderVo.setOutTradeNo(tradeCloseResponse.getOutTradeNo());
                responseCloseOrderVo.setTradeNo(tradeCloseResponse.getTradeNo());
            } else {
                responseCloseOrderVo.setResultCode(tradeCloseResponse.getSubCode());
                responseCloseOrderVo.setResultMsg(tradeCloseResponse.getSubMsg());
            }
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u5931\u8d25\uff01\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getErrMsg(), (Object)e);
            responseCloseOrderVo.setResultCode("FAIL");
            responseCloseOrderVo.setResultMsg(e.getErrMsg());
            return responseCloseOrderVo;
        }
        return responseCloseOrderVo;
    }

    public BaseResponse downLoadBill(RequestDownloadVo requestDownloadVo) {
        log.info("\u652f\u4ed8\u5b9d\u4e0b\u8f7d\u8d26\u5355\u7684\u5165\u53c2\uff1a{}", (Object)requestDownloadVo.toString());
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId(requestDownloadVo.getMchCode(), requestDownloadVo.getPayChannel(), null);
        if (null == wxPayParam) {
            return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        log.info("=======\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef========");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", wxPayParam.getAppId(), wxPayParam.getAppPrivateKey(), "json", "UTF-8", wxPayParam.getMchPublicKey(), "RSA2");
        AlipayDataDataserviceBillDownloadurlQueryRequest alipayBillDownloadRequest = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        if (!StringUtils.isBlank((CharSequence)wxPayParam.getAppAuthToken())) {
            alipayBillDownloadRequest.putOtherTextParam("app_auth_token", wxPayParam.getAppAuthToken());
        }
        AlipayDataDataserviceBillDownloadurlQueryModel model = new AlipayDataDataserviceBillDownloadurlQueryModel();
        model.setBillDate(requestDownloadVo.getBillDate());
        model.setBillType("trade");
        alipayBillDownloadRequest.setBizModel((AlipayObject)model);
        log.info("\u4e0b\u8f7d\u8d26\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)alipayBillDownloadRequest));
        AlipayDataDataserviceBillDownloadurlQueryResponse downloadurlQueryResponse = null;
        try {
            downloadurlQueryResponse = (AlipayDataDataserviceBillDownloadurlQueryResponse)alipayClient.execute((AlipayRequest)alipayBillDownloadRequest);
            log.info("\u4e0b\u8f7d\u8d26\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)downloadurlQueryResponse));
        }
        catch (AlipayApiException e) {
            log.error("\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u4ed8\u8d26\u5355\u5931\u8d25\uff01\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getErrMsg(), (Object)e);
            return BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u4e0b\u8f7d\u8d26\u5355\u5931\u8d25" + e.getErrMsg()));
        }
        return BaseResponse.success((Object)downloadurlQueryResponse);
    }

    private AlipayClient getAlipayClient(PayBill payBill) {
        log.info("\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5165\u53c2:{}", (Object)payBill.toString());
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)mchChan.toString());
        if (null == mchChan) {
            return null;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        return new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", wxPayParam.getAppId(), wxPayParam.getAppPrivateKey(), "json", "UTF-8", wxPayParam.getMchPublicKey(), "RSA2");
    }

    private BaseResponse<String> getAliPayResponse(AlipayClient alipayClient, RequestCreateOrderVo requestCreateOrderVo, String orderViewId, String redisKey, PayBill payBill, MchChan mchChan, WxPayParam wxPayParam) {
        PayCreateOrderBO createOrderBO = new PayCreateOrderBO(requestCreateOrderVo, this.notifyUrl, this.returnUrl, orderViewId);
        String result = null;
        if (requestCreateOrderVo.getPayType().equals(AliPayTradeTypeEnum.JSAPI.getDisplay())) {
            AlipayTradeCreateRequest request = new AlipayTradeCreateRequest();
            request.setNotifyUrl(this.notifyUrl);
            AlipayTradeCreateModel model = new AlipayTradeCreateModel();
            model.setOutTradeNo(orderViewId);
            model.setTotalAmount(requestCreateOrderVo.getTotalAmount().toString());
            model.setSubject(requestCreateOrderVo.getProductInfo());
            model.setBuyerId(requestCreateOrderVo.getUserSign());
            model.setBody(MapToJsonUtils.mapInitAndToJsonString((String)requestCreateOrderVo.getServiceCode(), (String)(StringUtils.isBlank((CharSequence)requestCreateOrderVo.getApplyCode()) ? requestCreateOrderVo.getMchCode() : requestCreateOrderVo.getApplyCode()), (String)requestCreateOrderVo.getPayType()));
            ExtendParams extendParams = new ExtendParams();
            extendParams.setSysServiceProviderId(wxPayParam.getSysServiceProviderId());
            model.setExtendParams(extendParams);
            request.setBizModel((AlipayObject)model);
            try {
                AlipayTradeCreateResponse response = (AlipayTradeCreateResponse)alipayClient.execute((AlipayRequest)request);
                log.info("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)response));
                if (response.isSuccess()) {
                    return BaseResponse.success((Object)response.getBody());
                }
                return BaseResponse.error((String)response.getMsg());
            }
            catch (AlipayApiException e) {
                log.error("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{},\u5f02\u5e38:{}", new Object[]{orderViewId, e.getErrMsg(), e});
                return BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u5931\u8d25" + e.getErrMsg()));
            }
        }
        if (requestCreateOrderVo.getPayType().equals(AliPayTradeTypeEnum.APP.getDisplay())) {
            log.info("-------------\u6b64\u8ba2\u5355\u4e3aAPP\u652f\u4ed8--------------");
            AlipayTradeAppPayRequest alipayTradeAppPayRequest = new AlipayTradeAppPayRequest();
            AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
            model.setSubject(requestCreateOrderVo.getProductInfo());
            model.setOutTradeNo(orderViewId);
            model.setTotalAmount(requestCreateOrderVo.getTotalAmount().toString());
            model.setPassbackParams(MapToJsonUtils.mapInitAndToJsonString((String)requestCreateOrderVo.getServiceCode(), (String)(StringUtils.isBlank((CharSequence)requestCreateOrderVo.getApplyCode()) ? requestCreateOrderVo.getMchCode() : requestCreateOrderVo.getApplyCode()), (String)requestCreateOrderVo.getPayType()));
            if (!StringUtils.isBlank((CharSequence)wxPayParam.getAppAuthToken())) {
                alipayTradeAppPayRequest.putOtherTextParam("app_auth_token", wxPayParam.getAppAuthToken());
                ExtendParams extendParams = new ExtendParams();
                extendParams.setSysServiceProviderId(mchChan.getMerchantsMark());
                model.setExtendParams(extendParams);
            }
            Date timeExpire = DateUtils.dateAddMinutes((Date)new Date(), (int)35);
            model.setTimeExpire(DateUtils.dateToString((Date)timeExpire, (String)"yyyy-MM-dd HH:mm"));
            alipayTradeAppPayRequest.setBizModel((AlipayObject)model);
            alipayTradeAppPayRequest.setNotifyUrl(this.notifyUrl);
            log.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)alipayTradeAppPayRequest));
            AlipayTradeAppPayResponse alipayTradeAppPayResponse = null;
            try {
                alipayTradeAppPayResponse = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)alipayTradeAppPayRequest);
                log.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u7684\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)alipayTradeAppPayResponse));
                String responseBody = alipayTradeAppPayResponse.getBody();
                return BaseResponse.success((Object)responseBody);
            }
            catch (AlipayApiException e) {
                log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{},\u5f02\u5e38:{}", new Object[]{orderViewId, e.getErrMsg(), e});
                return BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u4e0b\u5355\u5931\u8d25" + e.getErrMsg()));
            }
        }
        if (requestCreateOrderVo.getPayType().equals(AliPayTradeTypeEnum.PAGE.getDisplay())) {
            log.info("-------------\u6b64\u8ba2\u5355\u4e3a\u7535\u8111\u7f51\u9875\u652f\u4ed8--------------");
            AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
            alipayRequest.setReturnUrl(this.returnUrl);
            alipayRequest.setNotifyUrl(this.notifyUrl);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("out_trade_no", orderViewId);
            map.put("product_code", "FAST_INSTANT_TRADE_PAY");
            map.put("total_amount", requestCreateOrderVo.getTotalAmount().toString());
            map.put("subject", requestCreateOrderVo.getProductInfo());
            map.put("body", MapToJsonUtils.mapInitAndToJsonString((String)requestCreateOrderVo.getServiceCode(), (String)(StringUtils.isBlank((CharSequence)requestCreateOrderVo.getApplyCode()) ? requestCreateOrderVo.getMchCode() : requestCreateOrderVo.getApplyCode()), (String)requestCreateOrderVo.getPayType()));
            alipayRequest.setBizContent(JSON.toJSONString(map));
            try {
                AlipayTradePagePayResponse response = (AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest);
                log.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u7684\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)response));
                String responseBody = response.getBody();
                return BaseResponse.success((Object)responseBody);
            }
            catch (AlipayApiException e) {
                log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{},\u5f02\u5e38:{}", new Object[]{orderViewId, e.getErrMsg(), e});
                return BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u4e0b\u5355\u5931\u8d25" + e.getErrMsg()));
            }
        }
        if (requestCreateOrderVo.getPayType().equals(AliPayTradeTypeEnum.F2FPRECREATE.getDisplay())) {
            log.info("-------------\u6b64\u8ba2\u5355\u4e3a\u5f53\u9762\u4ed8-\u626b\u7801-\u652f\u4ed8--------------");
            AlipayTradePrecreateRequest alipayRequest = new AlipayTradePrecreateRequest();
            alipayRequest.setReturnUrl(this.returnUrl);
            alipayRequest.setNotifyUrl(this.notifyUrl);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("out_trade_no", orderViewId);
            map.put("total_amount", requestCreateOrderVo.getTotalAmount().toString());
            map.put("subject", requestCreateOrderVo.getProductInfo());
            map.put("body", MapToJsonUtils.mapInitAndToJsonString((String)requestCreateOrderVo.getServiceCode(), (String)(StringUtils.isBlank((CharSequence)requestCreateOrderVo.getApplyCode()) ? requestCreateOrderVo.getMchCode() : requestCreateOrderVo.getApplyCode()), (String)requestCreateOrderVo.getPayType()));
            map.put("timeout_express", "90m");
            alipayRequest.setBizContent(JSON.toJSONString(map));
            try {
                AlipayTradePrecreateResponse response = (AlipayTradePrecreateResponse)alipayClient.execute((AlipayRequest)alipayRequest);
                log.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u7684\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)response));
                log.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u7684QRCode\uff1a{}", (Object)JSON.toJSONString((Object)response.getQrCode()));
                String responseBody = response.getBody();
                String responseQrCode = response.getQrCode();
                return BaseResponse.success((Object)responseQrCode);
            }
            catch (AlipayApiException e) {
                log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{},\u5f02\u5e38:{}", new Object[]{orderViewId, e.getErrMsg(), e});
                return BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u4e0b\u5355\u5931\u8d25" + e.getErrMsg()));
            }
        }
        if (requestCreateOrderVo.getPayType().equals(AliPayTradeTypeEnum.F2FPAY.getDisplay())) {
            log.info("-------------\u6b64\u8ba2\u5355\u4e3a\u5f53\u9762\u4ed8-\u6761\u7801-\u652f\u4ed8--------------");
            AlipayTradePayRequest micropayRequest = createOrderBO.getAliMicropayRequest();
            micropayRequest.setNotifyUrl(this.notifyUrl);
            try {
                AlipayTradePayResponse response = (AlipayTradePayResponse)alipayClient.execute((AlipayRequest)micropayRequest);
                log.info("\u652f\u4ed8\u5b9d\u6761\u7801\u4ed8\u7684\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)response));
                this.getMicroPayResult(requestCreateOrderVo, orderViewId, redisKey, response);
                String responseBody = response.getBody();
                JSONObject jsonObject = JSON.parseObject((String)responseBody);
                String code = response.getCode();
                if ("10003".equals(code)) {
                    jsonObject.put("errCodeDes", (Object)"\u9700\u8981\u7528\u6237\u8f93\u5165\u652f\u4ed8\u5bc6\u7801");
                } else if ("10000".equals(code)) {
                    jsonObject.put("tradeNo", (Object)response.getTradeNo());
                    jsonObject.put("serviceCode", (Object)requestCreateOrderVo.getServiceCode());
                    jsonObject.put("mchCode", (Object)requestCreateOrderVo.getMchCode());
                }
                return BaseResponse.success((Object)jsonObject.toJSONString());
            }
            catch (AlipayApiException e) {
                log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{},\u5f02\u5e38:{}", new Object[]{orderViewId, e.getErrMsg(), e});
                return BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u4e0b\u5355\u5931\u8d25" + e.getErrMsg()));
            }
        }
        if (requestCreateOrderVo.getPayType().equals(AliPayTradeTypeEnum.WAP.getDisplay())) {
            log.info("-------------\u6b64\u8ba2\u5355\u4e3a\u624b\u673a\u7f51\u7ad9\u652f\u4ed8--------------");
            AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
            alipayRequest.setNotifyUrl(this.notifyUrl);
            alipayRequest.setReturnUrl(requestCreateOrderVo.getPageUrl());
            AlipayTradeWapPayModel wapPayModel = new AlipayTradeWapPayModel();
            wapPayModel.setBody(MapToJsonUtils.mapInitAndToJsonString((String)requestCreateOrderVo.getServiceCode(), (String)(StringUtils.isBlank((CharSequence)requestCreateOrderVo.getApplyCode()) ? requestCreateOrderVo.getMchCode() : requestCreateOrderVo.getApplyCode()), (String)requestCreateOrderVo.getPayType()));
            wapPayModel.setOutTradeNo(orderViewId);
            wapPayModel.setSubject(requestCreateOrderVo.getProductInfo());
            wapPayModel.setProductCode("QUICK_WAP_PAY");
            wapPayModel.setTotalAmount(requestCreateOrderVo.getTotalAmount().toString());
            if (!StringUtils.isBlank((CharSequence)wxPayParam.getAppAuthToken())) {
                alipayRequest.putOtherTextParam("app_auth_token", wxPayParam.getAppAuthToken());
                ExtendParams extendParams = new ExtendParams();
                extendParams.setSysServiceProviderId(mchChan.getMerchantsMark());
                wapPayModel.setExtendParams(extendParams);
            }
            alipayRequest.setBizModel((AlipayObject)wapPayModel);
            try {
                AlipayTradeWapPayResponse response = (AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest);
                log.info("\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u7684\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)response));
                String responseBody = response.getBody();
                return BaseResponse.success((Object)responseBody);
            }
            catch (AlipayApiException e) {
                log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{},\u5f02\u5e38:{}", new Object[]{orderViewId, e.getErrMsg(), e});
                return BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u4e0b\u5355\u5931\u8d25" + e.getErrMsg()));
            }
        }
        OrderRabbitInfo orderRabbitInfo = new OrderRabbitInfo();
        orderRabbitInfo.setRedisKey(redisKey);
        orderRabbitInfo.setOutTradeNo(requestCreateOrderVo.getOutTradeNo());
        orderRabbitInfo.setTradeChannl(requestCreateOrderVo.getPayChannel());
        this.rabbitProduct.pushOrderOverTime(orderRabbitInfo);
        if (result.isEmpty()) {
            this.redisTemplateService.del(redisKey);
            return BaseResponse.error((String)"\u652f\u4ed8\u6e20\u9053\u672a\u77e5");
        }
        return BaseResponse.success((Object)result);
    }

    private void getMicroPayResult(RequestCreateOrderVo requestCreateOrderVo, String orderViewId, String redisKey, AlipayTradePayResponse response) {
        if (!"10000".equals(response.getCode())) {
            SynchroNotifyRabbit synchroNotifyRabbit = new SynchroNotifyRabbit(new WxPayMicropayResultBO(), response, new Date(), PayChanEnum.ALIPAY.getDisplay(), redisKey, requestCreateOrderVo.getOutTradeNo(), orderViewId);
            this.rabbitProduct.synchroNotifyOrderPush(synchroNotifyRabbit);
        }
    }

    public ResponseQueryOrderVo offlineQueryOrder(RequestOfflineOederQueryVO reqVo) {
        return null;
    }

    public BaseResponse<String> qrIsSwept(RequestQrIsSweptCreateOrderVo orderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> qrCode(RequestQrCodeCreateOrderVo qrCodeCreateOrderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> createPolymericOrder(HttpServletRequest request, PayBill payBill, RequestCreateOrderVo reqVo) {
        log.info("\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5165\u53c2:{}", (Object)payBill.toString());
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u83b7\u53d6\u652f\u4ed8\u53c2\u6570:{}", (Object)mchChan.toString());
        if (null == mchChan) {
            return null;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", wxPayParam.getAppId(), wxPayParam.getAppPrivateKey(), "json", "UTF-8", wxPayParam.getMchPublicKey(), "RSA2");
        String outTradeNo = payBill.getOutTradeNo();
        if (null == alipayClient) {
            log.error("=====\u805a\u5408\u652f\u4ed8-\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25=====");
            this.redisTemplateService.del(outTradeNo);
            return BaseResponse.error((String)"\u805a\u5408\u652f\u4ed8-\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5931\u8d25,\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
        }
        log.info("=====\u805a\u5408\u652f\u4ed8,\u8c03\u7528\u652f\u4ed8\u5b9dAPP\u652f\u4ed8");
        String dealTradeNo = payBill.getDealTradeNo();
        BaseResponse payResponse = this.getAliPayResponse((AlipayClient)alipayClient, reqVo, dealTradeNo, outTradeNo, payBill, mchChan, wxPayParam);
        return payResponse;
    }

    public ResponseReverseOrderVo reverseOrderVo(PayBill payBill) {
        return null;
    }

    private boolean synNotify(String tradeType, String fundChange, boolean flag) {
        return "Y".equals(fundChange) && (tradeType.equals(AliPayTradeTypeEnum.F2FPAY.getDisplay()) || tradeType.equals(AliPayTradeTypeEnum.JSAPI.getDisplay())) && !flag;
    }
}

