/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.response.AlipayTradePayResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestOfflineOederQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrCodeCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrIsSweptCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseReverseOrderVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayFactory;
import com.ebaiyihui.aggregation.payment.server.bo.PayCreateOrderBO;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.OrderRabbitInfo;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.SynchroNotifyRabbit;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.TradeService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.DeduplicationUtil;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.aggregation.payment.server.utils.WechatPayUtil;
import com.ebaiyihui.aggregation.payment.server.wxpay.WxPay;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayRequestBO;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayResultBO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadBillRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderCloseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderReverseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderCloseResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderReverseResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatPayServiceImpl
extends BaseService
implements TradeService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WechatPayServiceImpl.class);
    @Autowired
    private NotifyService notifyService;

    public void afterPropertiesSet() throws Exception {
        PayFactory.register((String)PayChanEnum.WECHAT.getDisplay(), (TradeService)this);
    }

    public BaseResponse<String> createOrder(HttpServletRequest request, RequestCreateOrderVo createOrderVo) {
        log.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString((Object)createOrderVo));
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        log.info("create order wxPayService =" + wxPayService);
        String redisKey = createOrderVo.getOutTradeNo() + "_" + createOrderVo.getPayType();
        log.info("\u3010\u5fae\u4fe1\u3011\u4e1a\u52a1\u4e0b\u5355\u8ba2\u5355rediskey:{}", (Object)redisKey);
        boolean res = this.redisTemplateService.addLock(redisKey, redisKey, 2100L);
        if (!res) {
            return BaseResponse.error((String)"\u8ba2\u5355\u6b63\u5728\u652f\u4ed8\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8\u64cd\u4f5c\uff0c\u4ee5\u514d\u9020\u6210\u4e0d\u5fc5\u8981\u7684\u635f\u5931");
        }
        String orderViewId = "zz".concat(UniqueKeyGenerator.generateViewId());
        PayBill payBill = this.payBillService.getByCreateOrder(createOrderVo);
        String tradeType = payBill.getTradeType();
        if (tradeType.equals(WechatTradeTypeEnum.NATIVE.getDisplay())) {
            tradeType = WechatTradeTypeEnum.JSPAI.getDisplay();
        }
        log.info(payBill.getMchCode() + "  " + payBill.getTradeChannel() + "  " + tradeType);
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType);
        if (null == mchChan) {
            this.redisTemplateService.del(redisKey);
            return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458\u68c0\u67e5\u914d\u7f6e");
        }
        log.info("\u3010\u5fae\u4fe1\u3011\u4e0b\u5355\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)mchChan.toString());
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        log.info("\u3010\u5fae\u4fe1\u3011\u8bb0\u5f55\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
        payBill.setDealTradeNo(orderViewId);
        payBill.setTradeType(tradeType);
        this.payBillService.save(payBill);
        this.paymentRecordsService.saveByBill(orderViewId, createOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
        try {
            PayCreateOrderBO createOrderBO = new PayCreateOrderBO(createOrderVo, wxPayParam, WechatPayUtil.getRealIp((HttpServletRequest)request), orderViewId);
            wxPayService.getConfig().setMchId(mchChan.getMerchantsMark());
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            wxPayService.getConfig().setTradeType(createOrderVo.getPayType());
            wxPayService.getConfig().setAppId(wxPayParam.getAppId());
            if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
                wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
            } else {
                wxPayService.getConfig().setSubMchId(null);
            }
            if (null != wxPayParam.getSubAppId() && !"".equals(wxPayParam.getSubAppId().trim())) {
                wxPayService.getConfig().setSubAppId(wxPayParam.getSubAppId());
            } else {
                wxPayService.getConfig().setSubAppId(null);
            }
            return this.startWechatPay(wxPayService, createOrderVo, redisKey, createOrderBO);
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u5f02\u5e38\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{orderViewId, e.getMessage(), e});
            this.redisTemplateService.del(redisKey);
            return BaseResponse.error((String)("\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage()));
        }
    }

    private BaseResponse<String> startWechatPay(WxPayService wxPayService, RequestCreateOrderVo createOrderVo, String redisKey, PayCreateOrderBO createOrderBO) throws WxPayException {
        String sign;
        WxPayMpOrderResult wxPayMpOrderResult;
        String result = null;
        WxPayUnifiedOrderRequest orderRequest = createOrderBO.getWxPayUnifiedOrderRequest();
        log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)orderRequest.toString());
        if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.JSPAI.getDisplay())) {
            if (StringUtils.isNotBlank((CharSequence)wxPayService.getConfig().getSubAppId())) {
                orderRequest.setSubOpenid(createOrderVo.getUserSign());
                orderRequest.setOpenid(null);
            }
            wxPayMpOrderResult = (WxPayMpOrderResult)wxPayService.createOrder(orderRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)wxPayMpOrderResult.toString());
            sign = wxPayMpOrderResult.getPaySign();
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\u7b7e\u540d\u662f:{}", (Object)sign);
            result = JSON.toJSONString((Object)wxPayMpOrderResult);
        }
        if (createOrderVo.getPayType().equals("JSGZHAPI")) {
            orderRequest.setTradeType("JSAPI");
            wxPayMpOrderResult = (WxPayMpOrderResult)wxPayService.createOrder(orderRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)wxPayMpOrderResult.toString());
            sign = wxPayMpOrderResult.getPaySign();
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\u7b7e\u540d\u662f:{}", (Object)sign);
            result = JSON.toJSONString((Object)wxPayMpOrderResult);
        }
        if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.APP.getDisplay())) {
            wxPayMpOrderResult = (WxPayAppOrderResult)wxPayService.createOrder(orderRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)wxPayMpOrderResult.toString());
            sign = wxPayMpOrderResult.getSign();
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\u7b7e\u540d\u662f:{}", (Object)sign);
            result = JSON.toJSONString((Object)wxPayMpOrderResult);
        }
        if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.NATIVE.getDisplay())) {
            orderRequest.setProductId(orderRequest.getOutTradeNo());
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)orderRequest.toString());
            WxPayNativeOrderResult wxPayNativeOrderResult = (WxPayNativeOrderResult)wxPayService.createOrder(orderRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)wxPayNativeOrderResult.toString());
            result = JSON.toJSONString((Object)wxPayNativeOrderResult);
        }
        if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.MWEB.getDisplay())) {
            orderRequest.setProductId(orderRequest.getOutTradeNo());
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)orderRequest.toString());
            WxPayMwebOrderResult wxPayMwebOrderResult = (WxPayMwebOrderResult)wxPayService.createOrder(orderRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)wxPayMwebOrderResult.toString());
            result = JSON.toJSONString((Object)wxPayMwebOrderResult);
        }
        if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.MICROPAY.getDisplay())) {
            WxPayMicropayRequestBO micropayRequest = createOrderBO.getWxPayMicropayRequest();
            WxPay wxPay = new WxPay();
            if (createOrderVo.getPayType().equals(WechatTradeTypeEnum.MICROPAY.getDisplay())) {
                try {
                    log.info("\u3010\u5fae\u4fe1\u3011\u4ed8\u6b3e\u7801\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)orderRequest.toString());
                    WxPayMicropayResultBO micropayResultBO = wxPay.microPay(micropayRequest);
                    log.info("\u3010\u5fae\u4fe1\u3011\u4ed8\u6b3e\u7801\u652f\u4ed8\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)micropayResultBO));
                    String returnCode = micropayResultBO.getReturnCode();
                    String resultCode = micropayResultBO.getResultCode();
                    String tradeType = micropayResultBO.getTradeType();
                    String dealTradeNo = micropayRequest.getOutTradeNo();
                    result = JSON.toJSONString((Object)micropayResultBO);
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    jsonObject.put("outTradeNo", (Object)createOrderVo.getOutTradeNo());
                    jsonObject.put("dealTradeNo", (Object)createOrderBO.getDealTradeNo());
                    if ("SUCCESS".equals(resultCode) && "SUCCESS".equals(returnCode) && "MICROPAY".equals(tradeType)) {
                        log.info("microPay success,outTradeNo:{}", (Object)dealTradeNo);
                        CompletableFuture.runAsync(() -> this.paidProcessed(dealTradeNo, micropayResultBO));
                        jsonObject.put("tradeNo", (Object)micropayResultBO.getTransactionId());
                        jsonObject.put("serviceCode", (Object)createOrderVo.getServiceCode());
                        jsonObject.put("mchCode", (Object)createOrderVo.getMchCode());
                        return BaseResponse.success((Object)jsonObject.toJSONString());
                    }
                    SynchroNotifyRabbit synchroNotifyRabbit = new SynchroNotifyRabbit(micropayResultBO, new AlipayTradePayResponse(), new Date(), PayChanEnum.WECHAT.getDisplay(), redisKey, createOrderVo.getOutTradeNo(), dealTradeNo);
                    this.rabbitProduct.synchroNotifyOrderPush(synchroNotifyRabbit);
                    return new BaseResponse("2", "\u652f\u4ed8\u4e2d", (Object)jsonObject.toJSONString());
                }
                catch (Exception e) {
                    log.info("\u3010\u5fae\u4fe1\u3011\u4ed8\u6b3e\u7801\u652f\u4ed8\u8fdb\u5165\u5f02\u5e38\u5904\u7406\u72b6\u6001");
                }
            }
        }
        OrderRabbitInfo orderRabbitInfo = new OrderRabbitInfo();
        orderRabbitInfo.setRedisKey(redisKey);
        orderRabbitInfo.setOutTradeNo(createOrderVo.getOutTradeNo());
        orderRabbitInfo.setTradeChannl(createOrderVo.getPayChannel());
        this.rabbitProduct.pushOrderOverTimeDelay(orderRabbitInfo);
        if (result.isEmpty()) {
            this.redisTemplateService.del(redisKey);
            return BaseResponse.error((String)"\u652f\u4ed8\u6e20\u9053\u672a\u77e5");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        jsonObject.put("outTradeNo", (Object)createOrderVo.getOutTradeNo());
        jsonObject.put("dealTradeNo", (Object)createOrderBO.getDealTradeNo());
        return BaseResponse.success((Object)jsonObject.toJSONString());
    }

    private void paidProcessed(String dealTradeNo, WxPayMicropayResultBO micropayResultBO) {
        PayBill payBill = this.payBillService.getByDealTradeNo(dealTradeNo);
        String transactionId = micropayResultBO.getTransactionId();
        payBill.setTradeNo(transactionId);
        payBill.setStatus(OrderStatusEnum.PAID.getValue());
        Date payTime = DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)micropayResultBO.getTimeEnd());
        payBill.setPayTime(payTime);
        log.info("wechat microPay\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
        this.payBillService.update(payBill);
        this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
        log.info("wechat microPay\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
        ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
        responseNotifyRestVo.setTradeNo(transactionId);
        responseNotifyRestVo.setReturnCode(micropayResultBO.getReturnCode());
        responseNotifyRestVo.setReturnMsg(micropayResultBO.getReturnMsg());
        responseNotifyRestVo.setResultCode(micropayResultBO.getResultCode());
        responseNotifyRestVo.setErrCode(null);
        responseNotifyRestVo.setErrCodeDes(micropayResultBO.getReturnMsg());
        responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
        responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
        responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
        responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
        responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
        responseNotifyRestVo.setPayTime(payTime);
        responseNotifyRestVo.setMchCode(payBill.getMchCode());
        PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
        responseNotifyRestVo.setApplyId(payApply.getApplyId());
        Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
        String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
        responseNotifyRestVo.setSign(sign);
        this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
        log.info("\u3010rabbitMq\u3011\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
        this.notifyService.notify("pay", JSON.toJSONString((Object)responseNotifyRestVo));
    }

    public ResponseQueryOrderVo queryOrder(PayBill payBill) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        ResponseQueryOrderVo responseQueryOrderVo = new ResponseQueryOrderVo();
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u3010\u5fae\u4fe1\u3011\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570:{}", (Object)wxPayParam.toString());
        if (null == wxPayParam) {
            responseQueryOrderVo.setReturnMsg("\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u786e\u8ba4");
            responseQueryOrderVo.setReturnCode("FAIL");
            return responseQueryOrderVo;
        }
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
            wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
        } else {
            wxPayService.getConfig().setSubMchId(null);
        }
        WxPayOrderQueryRequest wxPayOrderQueryRequest = new WxPayOrderQueryRequest();
        wxPayOrderQueryRequest.setOutTradeNo(payBill.getDealTradeNo());
        WxPayOrderQueryResult wxPayOrderQueryResult = null;
        try {
            log.info("\u3010\u5fae\u4fe1\u3011\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)wxPayOrderQueryRequest.toString());
            wxPayOrderQueryResult = this.queryOrder(wxPayOrderQueryRequest, wxPayService);
            log.info("\u3010\u5fae\u4fe1\u3011\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)wxPayOrderQueryResult));
            if ("SUCCESS".equals(wxPayOrderQueryResult.getReturnCode())) {
                responseQueryOrderVo.setReturnCode(wxPayOrderQueryResult.getReturnCode());
                responseQueryOrderVo.setReturnMsg(wxPayOrderQueryResult.getReturnMsg());
                responseQueryOrderVo.setResultMsg(wxPayOrderQueryResult.getErrCodeDes());
                responseQueryOrderVo.setResultCode(wxPayOrderQueryResult.getResultCode());
                responseQueryOrderVo.setMchCode(wxPayOrderQueryResult.getMchId());
                if ("SUCCESS".equals(wxPayOrderQueryResult.getResultCode())) {
                    responseQueryOrderVo.setOpenid(wxPayOrderQueryResult.getOpenid());
                    responseQueryOrderVo.setTradeType(wxPayOrderQueryResult.getTradeType());
                    responseQueryOrderVo.setTradeState(wxPayOrderQueryResult.getTradeState());
                    Integer totalFee = wxPayOrderQueryResult.getTotalFee();
                    BigDecimal dealMoney = totalFee == null ? new BigDecimal(BigInteger.ZERO) : new BigDecimal(Integer.parseInt(totalFee.toString()));
                    responseQueryOrderVo.setDealAmount(dealMoney);
                    responseQueryOrderVo.setOutTradeNo(wxPayOrderQueryResult.getOutTradeNo());
                    responseQueryOrderVo.setTradeNo(wxPayOrderQueryResult.getTransactionId());
                    responseQueryOrderVo.setDealTradeNo(wxPayOrderQueryResult.getOutTradeNo());
                    responseQueryOrderVo.setResultMsg(wxPayOrderQueryResult.getTradeStateDesc());
                    responseQueryOrderVo.setServiceCode(wxPayOrderQueryResult.getAttach());
                    responseQueryOrderVo.setTradeState(wxPayOrderQueryResult.getTradeState());
                    if ("SUCCESS".equals(wxPayOrderQueryResult.getTradeState())) {
                        String payTime = DateUtils.strToDateLong((String)wxPayOrderQueryResult.getTimeEnd());
                        responseQueryOrderVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime));
                    }
                }
            } else {
                responseQueryOrderVo.setReturnCode(wxPayOrderQueryResult.getReturnCode());
                responseQueryOrderVo.setReturnMsg(wxPayOrderQueryResult.getReturnMsg());
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u67e5\u8be2\u8ba2\u5355\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            responseQueryOrderVo.setReturnMsg(e.getMessage());
            responseQueryOrderVo.setReturnCode("FAIL");
            return responseQueryOrderVo;
        }
        return responseQueryOrderVo;
    }

    public BaseResponse<String> refundOrder(RequestRefundOrderVo requestRefundOrderVo) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        try {
            String tradeType;
            log.info("-----------\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u539f\u59cb\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)requestRefundOrderVo));
            boolean firstRefund = true;
            PayBill payBill = this.payBillService.getByDealTradeNo(requestRefundOrderVo.getDealTradeNo());
            String refundNo = requestRefundOrderVo.getOutTradeNo();
            if (refundNo.equals(payBill.getOutTradeNo())) {
                refundNo = UniqueKeyGenerator.generateViewId();
            }
            log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u539f\u59cb\u8ba2\u5355\u8bb0\u5f55{}", (Object)JSON.toJSONString((Object)payBill));
            if (null == payBill) {
                return BaseResponse.error((String)"\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u9000\u6b3e\u5931\u8d25");
            }
            if (payBill.getOutRefundNo() != null) {
                firstRefund = false;
            }
            if ((tradeType = payBill.getTradeType()).equals(WechatTradeTypeEnum.NATIVE.getDisplay())) {
                tradeType = WechatTradeTypeEnum.JSPAI.getDisplay();
                payBill.setTradeType(tradeType);
            }
            WxPayRefundRequest wxPayRefundRequest = new WxPayRefundRequest();
            wxPayRefundRequest.setOutTradeNo(requestRefundOrderVo.getDealTradeNo());
            wxPayRefundRequest.setOutRefundNo(refundNo);
            wxPayRefundRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)requestRefundOrderVo.getTotalAmount().toString()));
            wxPayRefundRequest.setRefundFee(BaseWxPayRequest.yuanToFen((String)requestRefundOrderVo.getRefundAmount().toString()));
            wxPayRefundRequest.setNotifyUrl(this.wxRefundNotifyUrl);
            MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
            log.info("\u3010\u5fae\u4fe1\u3011\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570{}", (Object)mchChan.toString());
            if (null == mchChan) {
                return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458");
            }
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            wxPayService.getConfig().setSslContext(null);
            wxPayService.getConfig().setAppId(wxPayParam.getAppId());
            wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
            wxPayService.getConfig().setTradeType(payBill.getTradeType());
            if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
                wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
            } else {
                wxPayService.getConfig().setSubMchId(null);
            }
            PayBill advanceRefundBill = payBill;
            advanceRefundBill.setOutRefundNo(refundNo);
            advanceRefundBill.setRefundAmount(requestRefundOrderVo.getRefundAmount());
            advanceRefundBill.setRefundNotifyUrl(requestRefundOrderVo.getRefundNotifyUrl());
            log.info("\u3010\u5fae\u4fe1\u3011\u63d0\u524d\u8bb0\u5f55\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)advanceRefundBill));
            log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570{}", (Object)wxPayRefundRequest.toString());
            WxPayRefundResult wxPayRefundResult = wxPayService.refund(wxPayRefundRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u8fd4\u56de\u53c2\u6570{}", (Object)wxPayRefundResult.toString());
            this.paymentRecordsService.saveByRefundBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND, refundNo);
            if ("SUCCESS".equals(wxPayRefundResult.getReturnCode())) {
                PayBill refundBill = advanceRefundBill;
                refundBill.setStatus(OrderStatusEnum.REFUNDING.getValue());
                log.info("\u3010\u5fae\u4fe1\u3011\u66f4\u65b0\u9000\u6b3e\u8d26\u5355\u72b6\u6001{}", (Object)JSONObject.toJSONString((Object)refundBill));
                if (firstRefund) {
                    this.payBillService.update(refundBill);
                } else {
                    this.payBillService.save(refundBill);
                }
                return BaseResponse.success((Object)"\u7533\u8bf7\u9000\u6b3e\u6210\u529f");
            }
            log.info("\u3010\u5fae\u4fe1\u3011\u7533\u8bf7\u9000\u6b3e\u5931\u8d25:", (Object)wxPayRefundResult.getErrCodeDes());
            return BaseResponse.error((String)("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25:" + wxPayRefundResult.getErrCodeDes()));
        }
        catch (WxPayException e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff1a\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getErrCodeDes(), (Object)e);
            return BaseResponse.error((String)("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25:" + e.getErrCodeDes()));
        }
    }

    public ResponseQueryRefundOrderVo queryRefundOrder(RequestQueryRefundOrderVo requestQueryRefundOrderVo, PayBill payBill) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        ResponseQueryRefundOrderVo responseQueryRefundOrderVo = new ResponseQueryRefundOrderVo();
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u3010\u5fae\u4fe1\u3011\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570:{}", (Object)wxPayParam.toString());
        if (null == wxPayParam) {
            responseQueryRefundOrderVo.setReturnMsg("\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u786e\u8ba4");
            responseQueryRefundOrderVo.setReturnCode("FAIL");
            return responseQueryRefundOrderVo;
        }
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
            wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
        } else {
            wxPayService.getConfig().setSubMchId(null);
        }
        WxPayRefundQueryRequest wxPayRefundQueryRequest = new WxPayRefundQueryRequest();
        wxPayRefundQueryRequest.setTransactionId(payBill.getTradeNo());
        WxPayRefundQueryResult wxPayRefundQueryResult = null;
        try {
            log.info("\u3010\u5fae\u4fe1\u3011\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570:{}", (Object)wxPayRefundQueryRequest.toString());
            wxPayRefundQueryResult = wxPayService.refundQuery(wxPayRefundQueryRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u67e5\u8be2\u9000\u6b3e\u8fd4\u56de\u53c2\u6570:{}", (Object)wxPayRefundQueryResult.toString());
            if ("SUCCESS".equals(wxPayRefundQueryResult.getReturnCode())) {
                responseQueryRefundOrderVo.setReturnMsg(wxPayRefundQueryResult.getReturnMsg());
                responseQueryRefundOrderVo.setReturnCode(wxPayRefundQueryResult.getReturnCode());
                responseQueryRefundOrderVo.setSubCode(wxPayRefundQueryResult.getResultCode());
                responseQueryRefundOrderVo.setSubMsg(wxPayRefundQueryResult.getErrCodeDes());
                responseQueryRefundOrderVo.setTotalAmount(new BigDecimal(wxPayRefundQueryResult.getTotalFee().toString()));
                responseQueryRefundOrderVo.setOutTradeNo(wxPayRefundQueryResult.getOutTradeNo());
                responseQueryRefundOrderVo.setTradeNo(requestQueryRefundOrderVo.getTradeNo());
                List refundRecords = wxPayRefundQueryResult.getRefundRecords();
                for (WxPayRefundQueryResult.RefundRecord record : refundRecords) {
                    responseQueryRefundOrderVo.setRefundAmount(new BigDecimal(record.getRefundFee().toString()));
                    responseQueryRefundOrderVo.setRefundNo(record.getRefundId());
                    responseQueryRefundOrderVo.setGmtRefundPay(record.getRefundSuccessTime());
                }
            } else {
                responseQueryRefundOrderVo.setReturnMsg(wxPayRefundQueryResult.getReturnMsg());
                responseQueryRefundOrderVo.setReturnCode(wxPayRefundQueryResult.getReturnCode());
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u67e5\u8be2\u9000\u6b3e\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            responseQueryRefundOrderVo.setReturnMsg(e.getMessage());
            responseQueryRefundOrderVo.setReturnCode("FAIL");
            return responseQueryRefundOrderVo;
        }
        return responseQueryRefundOrderVo;
    }

    public ResponseCloseOrderVo closeOrder(PayBill payBill) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        ResponseCloseOrderVo responseCloseOrderVo = new ResponseCloseOrderVo();
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId(payBill.getMchCode(), payBill.getTradeChannel(), null);
        log.info("\u3010\u5fae\u4fe1\u3011\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570:{}", (Object)wxPayParam.toString());
        if (null == wxPayParam) {
            responseCloseOrderVo.setResultMsg("\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u786e\u8ba4");
            responseCloseOrderVo.setResultCode("FAIL");
            return responseCloseOrderVo;
        }
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
            wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
        } else {
            wxPayService.getConfig().setSubMchId(null);
        }
        WxPayOrderCloseRequest wxPayOrderCloseRequest = new WxPayOrderCloseRequest();
        wxPayOrderCloseRequest.setOutTradeNo(payBill.getDealTradeNo());
        WxPayOrderCloseResult wxPayOrderCloseResult = null;
        try {
            log.info("\u3010\u5fae\u4fe1\u3011\u5173\u95ed\u4ea4\u6613\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)wxPayOrderCloseRequest.toString());
            wxPayOrderCloseResult = wxPayService.closeOrder(wxPayOrderCloseRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u5173\u95ed\u4ea4\u6613\u8ba2\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)wxPayOrderCloseResult.toString());
            if ("SUCCESS".equals(wxPayOrderCloseResult.getReturnCode())) {
                responseCloseOrderVo.setResultCode(wxPayOrderCloseResult.getResultCode());
                responseCloseOrderVo.setResultMsg(wxPayOrderCloseResult.getResultMsg());
                responseCloseOrderVo.setOutTradeNo(payBill.getOutTradeNo());
                responseCloseOrderVo.setTradeNo(payBill.getTradeNo());
            } else {
                responseCloseOrderVo.setResultCode(wxPayOrderCloseResult.getReturnCode());
                responseCloseOrderVo.setResultMsg(wxPayOrderCloseResult.getReturnMsg());
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u5173\u95ed\u4ea4\u6613\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            responseCloseOrderVo.setResultMsg(e.getMessage());
            responseCloseOrderVo.setResultCode("FAIL");
            return responseCloseOrderVo;
        }
        return responseCloseOrderVo;
    }

    public BaseResponse<WxPayBillResult> downLoadBill(RequestDownloadVo requestDownloadVo) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        WxPayBillResult wxPayBillResult = null;
        MchChan queryMchchan = new MchChan();
        queryMchchan.setMchCode(requestDownloadVo.getMchCode());
        queryMchchan.setChanCode(requestDownloadVo.getPayChannel());
        QueryWrapper queryWrapper = new QueryWrapper((Object)queryMchchan);
        List mchChans = this.mchChanMapper.selectList((Wrapper)queryWrapper).stream().filter(DeduplicationUtil.distinctByKey(MchChan::getMerchantsMark)).collect(Collectors.toList());
        for (MchChan mchChan : mchChans) {
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
            if (Objects.isNull(wxPayParam)) {
                return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            log.info("\u3010\u5fae\u4fe1\u3011\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570:{}", (Object)wxPayParam.toString());
            wxPayService.getConfig().setAppId(wxPayParam.getAppId());
            wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
                wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
            } else {
                wxPayService.getConfig().setSubMchId(null);
            }
            WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
            request.setBillDate(requestDownloadVo.getBillDate());
            request.setBillType("ALL");
            try {
                log.info("\u3010\u5fae\u4fe1\u3011\u4e0b\u8f7d\u8d26\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)request.toString());
                WxPayBillResult tempWxPayBillResult = wxPayService.downloadBill(request);
                if (Objects.isNull(wxPayBillResult)) {
                    wxPayBillResult = tempWxPayBillResult;
                    continue;
                }
                if (!Objects.nonNull(wxPayBillResult) || !Objects.nonNull(tempWxPayBillResult)) continue;
                wxPayBillResult.getBillInfoList().addAll(tempWxPayBillResult.getBillInfoList());
                wxPayBillResult.setTotalRecord(String.valueOf(Integer.parseInt(StringUtils.isBlank((CharSequence)wxPayBillResult.getTotalRecord()) ? "0" : wxPayBillResult.getTotalRecord()) + Integer.parseInt(StringUtils.isBlank((CharSequence)tempWxPayBillResult.getTotalRecord()) ? "0" : tempWxPayBillResult.getTotalRecord())));
                wxPayBillResult.setTotalFee(String.valueOf(Double.parseDouble(StringUtils.isBlank((CharSequence)wxPayBillResult.getTotalFee()) ? "0" : wxPayBillResult.getTotalFee()) + Double.parseDouble(StringUtils.isBlank((CharSequence)tempWxPayBillResult.getTotalFee()) ? "0" : tempWxPayBillResult.getTotalFee())));
                wxPayBillResult.setTotalCouponFee(String.valueOf(Double.parseDouble(StringUtils.isBlank((CharSequence)wxPayBillResult.getTotalCouponFee()) ? "0" : wxPayBillResult.getTotalCouponFee()) + Double.parseDouble(StringUtils.isBlank((CharSequence)tempWxPayBillResult.getTotalCouponFee()) ? "0" : tempWxPayBillResult.getTotalCouponFee())));
                wxPayBillResult.setTotalPoundageFee(String.valueOf(Double.parseDouble(StringUtils.isBlank((CharSequence)wxPayBillResult.getTotalPoundageFee()) ? "0" : wxPayBillResult.getTotalPoundageFee()) + Double.parseDouble(StringUtils.isBlank((CharSequence)tempWxPayBillResult.getTotalPoundageFee()) ? "0" : tempWxPayBillResult.getTotalPoundageFee())));
                wxPayBillResult.setTotalAmount(String.valueOf(Double.parseDouble(StringUtils.isBlank((CharSequence)wxPayBillResult.getTotalAmount()) ? "0" : wxPayBillResult.getTotalAmount()) + Double.parseDouble(StringUtils.isBlank((CharSequence)tempWxPayBillResult.getTotalAmount()) ? "0" : tempWxPayBillResult.getTotalAmount())));
                wxPayBillResult.setTotalCouponFee(String.valueOf(Double.parseDouble(StringUtils.isBlank((CharSequence)wxPayBillResult.getTotalCouponFee()) ? "0" : wxPayBillResult.getTotalCouponFee()) + Double.parseDouble(StringUtils.isBlank((CharSequence)tempWxPayBillResult.getTotalCouponFee()) ? "0" : tempWxPayBillResult.getTotalCouponFee())));
                wxPayBillResult.setTotalAppliedRefundFee(String.valueOf(Double.parseDouble(StringUtils.isBlank((CharSequence)wxPayBillResult.getTotalAppliedRefundFee()) ? "0" : wxPayBillResult.getTotalAppliedRefundFee()) + Double.parseDouble(StringUtils.isBlank((CharSequence)tempWxPayBillResult.getTotalAppliedRefundFee()) ? "0" : tempWxPayBillResult.getTotalAppliedRefundFee())));
            }
            catch (WxPayException e) {
                log.error("\u3010\u5fae\u4fe1\u3011\u4e0b\u8f7d\u5fae\u4fe1\u4ed8\u8d26\u5355\u5f02\u5e38:{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getErrCodeDes(), (Object)e);
                return BaseResponse.error((String)("\u4e0b\u8f7d\u5fae\u4fe1\u4ed8\u8d26\u5355\u5f02\u5e38" + e.getErrCodeDes()));
            }
        }
        log.info("\u8d26\u5355\u4e0b\u8f7d\u6570\u636e\u4e3a:" + wxPayBillResult);
        return BaseResponse.success(wxPayBillResult);
    }

    public ResponseQueryOrderVo offlineQueryOrder(RequestOfflineOederQueryVO reqVo) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        ResponseQueryOrderVo responseQueryOrderVo = new ResponseQueryOrderVo();
        WxPayParam wxPayParam = this.offlinePayConfigService.getOfflinePayConfigByCodeAndChanId(reqVo.getMchCode(), reqVo.getChanCode(), reqVo.getServiceCode());
        log.info("\u3010\u5fae\u4fe1\u3011\u7ebf\u4e0b\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570:{}", (Object)wxPayParam.toString());
        if (null == wxPayParam) {
            responseQueryOrderVo.setReturnMsg("\u7ebf\u4e0b\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u786e\u8ba4");
            responseQueryOrderVo.setReturnCode("FAIL");
            return responseQueryOrderVo;
        }
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        WxPayOrderQueryRequest wxPayOrderQueryRequest = new WxPayOrderQueryRequest();
        wxPayOrderQueryRequest.setTransactionId(reqVo.getTradeNo());
        WxPayOrderQueryResult wxPayOrderQueryResult = null;
        try {
            log.info("\u3010\u5fae\u4fe1\u3011\u7ebf\u4e0b\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)wxPayOrderQueryRequest.toString());
            wxPayOrderQueryResult = wxPayService.queryOrder(wxPayOrderQueryRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u7ebf\u4e0b\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)wxPayOrderQueryResult.toString());
            if ("SUCCESS".equals(wxPayOrderQueryResult.getReturnCode())) {
                responseQueryOrderVo.setReturnCode(wxPayOrderQueryResult.getReturnCode());
                responseQueryOrderVo.setReturnMsg(wxPayOrderQueryResult.getReturnMsg());
                responseQueryOrderVo.setResultMsg(wxPayOrderQueryResult.getErrCodeDes());
                responseQueryOrderVo.setResultCode(wxPayOrderQueryResult.getResultCode());
                responseQueryOrderVo.setMchCode(wxPayOrderQueryResult.getMchId());
                if ("SUCCESS".equals(wxPayOrderQueryResult.getResultCode())) {
                    responseQueryOrderVo.setOpenid(wxPayOrderQueryResult.getOpenid());
                    responseQueryOrderVo.setTradeType(wxPayOrderQueryResult.getTradeType());
                    responseQueryOrderVo.setTradeState(wxPayOrderQueryResult.getTradeState());
                    responseQueryOrderVo.setDealAmount(new BigDecimal(wxPayOrderQueryResult.getTotalFee().toString()).divide(new BigDecimal(100)));
                    responseQueryOrderVo.setOutTradeNo(wxPayOrderQueryResult.getOutTradeNo());
                    if ("SUCCESS".equals(wxPayOrderQueryResult.getTradeState())) {
                        String payTime = DateUtils.strToDateLong((String)wxPayOrderQueryResult.getTimeEnd());
                        responseQueryOrderVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime));
                    }
                }
            } else {
                responseQueryOrderVo.setReturnCode(wxPayOrderQueryResult.getReturnCode());
                responseQueryOrderVo.setReturnMsg(wxPayOrderQueryResult.getReturnMsg());
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u7ebf\u4e0b\u67e5\u8be2\u8ba2\u5355\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            responseQueryOrderVo.setReturnMsg(e.getMessage());
            responseQueryOrderVo.setReturnCode("FAIL");
            return responseQueryOrderVo;
        }
        return responseQueryOrderVo;
    }

    public BaseResponse<String> qrIsSwept(RequestQrIsSweptCreateOrderVo orderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> qrCode(RequestQrCodeCreateOrderVo qrCodeCreateOrderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> createPolymericOrder(HttpServletRequest request, PayBill payBill, RequestCreateOrderVo reqVo) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        String orderTest = this.orderTest(reqVo);
        if ("SUCCESS" != orderTest) {
            return BaseResponse.error((String)orderTest);
        }
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        log.info("\u3010\u5fae\u4fe1\u3011\u4e0b\u5355\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)mchChan.toString());
        if (null == mchChan) {
            this.redisTemplateService.del(payBill.getOutTradeNo());
            return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458\u68c0\u67e5\u914d\u7f6e");
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)mchChan.getParam()), WxPayParam.class);
        try {
            PayCreateOrderBO createOrderBO = new PayCreateOrderBO(reqVo, wxPayParam, WechatPayUtil.getRealIp((HttpServletRequest)request), payBill.getDealTradeNo());
            wxPayService.getConfig().setMchId(mchChan.getMerchantsMark());
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            wxPayService.getConfig().setTradeType(reqVo.getPayType());
            wxPayService.getConfig().setAppId(wxPayParam.getAppId());
            if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
                wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
            } else {
                wxPayService.getConfig().setSubMchId(null);
            }
            if (null != wxPayParam.getSubAppId() && !"".equals(wxPayParam.getSubAppId().trim())) {
                wxPayService.getConfig().setSubAppId(wxPayParam.getSubAppId());
            } else {
                wxPayService.getConfig().setSubAppId(null);
            }
            return this.startWechatPay(wxPayService, reqVo, payBill.getOutTradeNo(), createOrderBO);
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u5f02\u5e38\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{payBill.getDealTradeNo(), e.getMessage(), e});
            this.redisTemplateService.del(payBill.getOutTradeNo());
            return BaseResponse.error((String)("\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage()));
        }
    }

    public String orderTest(RequestCreateOrderVo createOrderVo) {
        if (BigDecimal.ZERO.compareTo(createOrderVo.getTotalAmount()) >= 0) {
            return "\u8ba2\u5355\u91d1\u989d\u5f02\u5e38";
        }
        PayBill payBillExist = this.payBillService.getByOutTradeNo(createOrderVo.getOutTradeNo());
        if (null != payBillExist && OrderStatusEnum.PAID.getValue().equals(payBillExist.getStatus())) {
            return "\u5df2\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8";
        }
        Boolean flag2 = false;
        Boolean flag3 = false;
        if (null != payBillExist) {
            Integer result = createOrderVo.getActuallyAmount().compareTo(payBillExist.getDealAmount());
            Boolean flag = result == 0;
            if (!flag.booleanValue()) {
                return "\u4e0b\u5355\u5931\u8d25\uff1a\u8ba2\u5355\u53f7\u91cd\u590d\u6216\u91d1\u989d\u4e0d\u4e00\u81f4";
            }
            Boolean flag1 = createOrderVo.getServiceCode().equals(payBillExist.getServiceCode());
            if (!flag1.booleanValue()) {
                return "\u4e0b\u5355\u5931\u8d25\uff1a\u8ba2\u5355\u53f7\u91cd\u590d\u6216\u4e1a\u52a1\u7f16\u7801\u9519\u8bef";
            }
            flag2 = createOrderVo.getPayChannel().equals(payBillExist.getTradeChannel());
            flag3 = createOrderVo.getPayType().equals(payBillExist.getTradeType());
            Boolean flag4 = createOrderVo.getProductInfo().equals(payBillExist.getGoodsInfo());
            if (!flag4.booleanValue()) {
                return "\u4e0b\u5355\u5931\u8d25\uff1a\u8ba2\u5355\u53f7\u91cd\u590d\u6216\u5546\u54c1\u4fe1\u606f\u9519\u8bef";
            }
            Boolean flag5 = createOrderVo.getMchCode().equals(payBillExist.getMchCode());
            if (!flag5.booleanValue()) {
                return "\u4e0b\u5355\u5931\u8d25\uff1a\u8ba2\u5355\u53f7\u91cd\u590d\u6216\u5546\u6237code\u9519\u8bef";
            }
        }
        if (flag2.booleanValue() && flag3.booleanValue() && null != payBillExist) {
            return "SUCCESS";
        }
        return null;
    }

    public ResponseReverseOrderVo reverseOrderVo(PayBill payBill) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        ResponseReverseOrderVo reverseOrderVo = new ResponseReverseOrderVo();
        WxPayParam wxPayParam = this.mchChanService.getMchChanByMchIdAndChanId(payBill.getMchCode(), payBill.getTradeChannel(), null);
        log.info("\u3010\u5fae\u4fe1\u3011\u5546\u6237\u6e20\u9053\u914d\u7f6e\u53c2\u6570:{}", (Object)wxPayParam.toString());
        if (null == wxPayParam) {
            reverseOrderVo.setResultMsg("\u5546\u6237\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u786e\u8ba4");
            reverseOrderVo.setResultCode("FAIL");
            return reverseOrderVo;
        }
        wxPayService.getConfig().setSslContext(null);
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
        if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
            wxPayService.getConfig().setSubMchId(wxPayParam.getSubMchId());
        } else {
            wxPayService.getConfig().setSubMchId(null);
        }
        WxPayOrderReverseRequest wxPayOrderReverseRequest = new WxPayOrderReverseRequest();
        wxPayOrderReverseRequest.setOutTradeNo(payBill.getDealTradeNo());
        WxPayOrderReverseResult wxPayOrderReverseResult = null;
        try {
            log.info("\u3010\u5fae\u4fe1\u3011\u64a4\u9500\u4ea4\u6613\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)wxPayOrderReverseRequest));
            wxPayOrderReverseResult = wxPayService.reverseOrder(wxPayOrderReverseRequest);
            log.info("\u3010\u5fae\u4fe1\u3011\u64a4\u9500\u4ea4\u6613\u8ba2\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)wxPayOrderReverseResult.toString());
            if ("SUCCESS".equals(wxPayOrderReverseResult.getReturnCode())) {
                reverseOrderVo.setResultCode(wxPayOrderReverseResult.getResultCode());
                reverseOrderVo.setResultMsg(wxPayOrderReverseResult.getReturnMsg());
                reverseOrderVo.setOutTradeNo(payBill.getOutTradeNo());
                reverseOrderVo.setTradeNo(payBill.getTradeNo());
            } else {
                reverseOrderVo.setResultCode(wxPayOrderReverseResult.getReturnCode());
                reverseOrderVo.setResultMsg(wxPayOrderReverseResult.getReturnMsg());
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u5173\u95ed\u4ea4\u6613\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            reverseOrderVo.setResultMsg(e.getMessage());
            reverseOrderVo.setResultCode("FAIL");
            return reverseOrderVo;
        }
        return reverseOrderVo;
    }

    public WxPayOrderQueryResult queryOrder(WxPayOrderQueryRequest request, WxPayService wxPayService) throws WxPayException {
        request.checkAndSign(wxPayService.getConfig());
        String url = wxPayService.getPayBaseUrl() + "/pay/orderquery";
        log.info("orderQuery begin,outTradeNo:{}", (Object)request.getOutTradeNo());
        String responseContent = wxPayService.post(url, request.toXML(), false);
        if (StringUtils.isBlank((CharSequence)responseContent)) {
            throw new WxPayException("\u65e0\u54cd\u5e94\u7ed3\u679c");
        }
        log.info("orderQuery end,outTradeNo:{}", (Object)request.getOutTradeNo());
        WxPayOrderQueryResult result = (WxPayOrderQueryResult)BaseWxPayResult.fromXML((String)responseContent, WxPayOrderQueryResult.class);
        result.composeCoupons();
        return result;
    }
}

