/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayDataDataserviceBillDownloadurlQueryModel;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.BaseEntity;
import com.ebaiyihui.aggregation.payment.common.model.ChannelBill;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PlatformBill;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ReWriteBillVO;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayBillMapper;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.AReconciliationBill;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.BillFileProcessor;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.IBillFile;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationTypeFactory;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.AliPayBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.BillFilter;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ChannelBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.DateCondition;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.PlatformBillBO;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AilPay
extends AReconciliationBill
implements IBillFile,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AilPay.class);
    final MchChanMapper mchChanMapper;
    final PayBillMapper payBillMapper;

    public void saveChannelBill(String billDate) {
        LambdaQueryWrapper eq = new LambdaQueryWrapper();
        eq.eq(MchChan::getChanCode, (Object)"ALIPAY");
        eq.eq(BaseEntity::getStatus, (Object)1);
        List arrayList = this.uniqAppId(this.mchChanMapper.selectList((Wrapper)eq));
        for (MchChan mchChan : arrayList) {
            this.buildBillAndSave(mchChan, billDate);
        }
    }

    private boolean buildBillAndSave(MchChan mchChan, String billDate) {
        log.info("Alipay.buildBillAndSave mchChan = {},billDate={}", (Object)mchChan, (Object)billDate);
        String param = mchChan.getParam();
        WxPayParam wxPayParam = (WxPayParam)JSONObject.parseObject((String)param, WxPayParam.class);
        String url = "";
        AlipayDataDataserviceBillDownloadurlQueryResponse baseResponse = null;
        int retry = 1;
        do {
            try {
                baseResponse = this.getBill(wxPayParam, billDate);
                if (baseResponse.isSuccess()) {
                    url = baseResponse.getBillDownloadUrl();
                    log.info("\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7durl\uff1a{}", (Object)url);
                }
                if (!this.volida(baseResponse)) continue;
                break;
            }
            catch (AlipayApiException e2) {
                assert (baseResponse != null);
                log.error("\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u4ed8\u8d26\u5355\u5931\u8d25\uff01retry:{},\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{retry, baseResponse.getSubMsg(), e2});
            }
            catch (Exception e3) {
                log.error("\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u4ed8\u8d26\u5355\u5931\u8d25\uff01retry:{},\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{retry, e3.getMessage(), e3});
            }
        } while ((Objects.isNull(baseResponse) || !baseResponse.isSuccess()) && retry++ < 5);
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                assert (baseResponse != null);
                if (!this.volida(baseResponse)) {
                    this.notifyErrorPush(mchChan, baseResponse.getSubMsg());
                }
                log.error("\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7durl\u5931\u8d25\uff0c \u5931\u8d25\u4fe1\u606f:{} \u4e0b\u8f7d\u53c2\u6570\uff1a{}", (Object)baseResponse.getSubMsg(), (Object)wxPayParam);
                return false;
            }
            List aliPayBillBOS = BillFileProcessor.downloadBill((String)url, (IBillFile)this);
            if (aliPayBillBOS.isEmpty()) {
                log.info("BillFileProcessor.downloadBill aliPayBillBOS={}", (Object)aliPayBillBOS);
                return false;
            }
            ArrayList list = new ArrayList();
            aliPayBillBOS.stream().filter(e -> this.filterBill(e.getRemark(), this.payEnvironment).getEnv()).forEach(e -> {
                String attach = e.getRemark();
                BillFilter billFilter = this.filterBill(attach, this.payEnvironment);
                ChannelBillBO channelBillBO = e.buildChannelBillBO(billDate, billFilter.getApplyCode(), billFilter.getServiceCode(), billFilter.getPayType());
                ChannelBill channelBill = new ChannelBill();
                BeanUtils.copyProperties((Object)channelBillBO, (Object)channelBill);
                list.add(channelBill);
            });
            if (!list.isEmpty()) {
                this.channelBillMapper.insertList(list);
                return true;
            }
        }
        catch (Exception e4) {
            log.error("channelBill \u6784\u5efa\u6216\u4fdd\u5b58\u5f02\u5e38 e=", (Throwable)e4);
        }
        return false;
    }

    private boolean volida(AlipayDataDataserviceBillDownloadurlQueryResponse baseResponse) {
        return Objects.nonNull(baseResponse) && ("BILL_NOT_EXIST".equalsIgnoreCase(baseResponse.getSubCode()) || "40002".equalsIgnoreCase(baseResponse.getCode()) || "isp.bill_not_exist".equals(baseResponse.getSubCode()));
    }

    public void savePlatformBill(String billDate) {
        DateCondition dateCondition = new DateCondition(billDate);
        List payBillList = this.payBillMapper.selectListByReconciliation(dateCondition.getStartTime(), dateCondition.getEndTime(), "ALIPAY");
        ArrayList list = new ArrayList();
        payBillList.forEach(e -> {
            PlatformBillBO platformBillBO = new PlatformBillBO();
            platformBillBO.init(e, billDate);
            PlatformBill platformBill = platformBillBO.getPlatformBill();
            if ("REFUND".equals(platformBill.getTradeState())) {
                platformBill.setRefundNo(e.getOutRefundNo());
            }
            list.add(platformBill);
        });
        this.insertPlatformBill(list);
    }

    private AlipayDataDataserviceBillDownloadurlQueryResponse getBill(WxPayParam wxPayParam, String billDate) throws AlipayApiException {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", wxPayParam.getAppId(), wxPayParam.getAppPrivateKey(), "json", "UTF-8", wxPayParam.getMchPublicKey(), "RSA2");
        AlipayDataDataserviceBillDownloadurlQueryRequest alipayBillDownloadRequest = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        if (!StringUtils.isBlank((CharSequence)wxPayParam.getAppAuthToken())) {
            alipayBillDownloadRequest.putOtherTextParam("app_auth_token", wxPayParam.getAppAuthToken());
        }
        AlipayDataDataserviceBillDownloadurlQueryModel model = new AlipayDataDataserviceBillDownloadurlQueryModel();
        model.setBillDate(DateUtils.strDate2StrDate((String)billDate));
        model.setBillType("trade");
        alipayBillDownloadRequest.setBizModel((AlipayObject)model);
        log.info("\u4e0b\u8f7d\u8d26\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)alipayBillDownloadRequest));
        AlipayDataDataserviceBillDownloadurlQueryResponse downloadurlQueryResponse = (AlipayDataDataserviceBillDownloadurlQueryResponse)alipayClient.execute((AlipayRequest)alipayBillDownloadRequest);
        log.info("\u4e0b\u8f7d\u8d26\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)downloadurlQueryResponse));
        return downloadurlQueryResponse;
    }

    public void reconciliationBill(String billDate, String batchNumber) {
        List allList = this.mchChanMapper.selectListByChanCode("ALIPAY");
        allList.parallelStream().forEach(e -> {
            int errorCount = 0;
            List channelBillList = this.channelBillMapper.getByDateAndPayTypeAndMchCodeAndState(billDate, "ALIPAY", e.getMchCode(), e.getType());
            List platformBillList = this.platformBillMapper.getByDateAndPayTypeAndMchCodeAndState(billDate, "ALIPAY", e.getMchCode(), e.getType());
            this.reconciliationHandler(billDate, batchNumber, e, errorCount, channelBillList, platformBillList, "ALIPAY");
        });
    }

    public void getBillByFile(List result, BufferedReader br, String fileName) throws IOException {
        if (!Objects.isNull(fileName) && fileName.indexOf(".") != -1 && !fileName.contains("\u6c47\u603b")) {
            String line;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                log.info("\u89e3\u6790\u6570\u636e\uff1a{}", (Object)line);
                if (i > 0) {
                    String[] lines = line.split(",", -1);
                    AliPayBillBO aliBillInfo = AliPayBillBO.getAliPayBillBO((String[])lines);
                    result.add(aliBillInfo);
                }
                ++i;
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean reWriteBills(ReWriteBillVO reWriteBillVO) {
        super.reWriteBills(reWriteBillVO);
        List mchChans = this.mchChanMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MchChan::getChanCode, (Object)reWriteBillVO.getPlantform())).eq(MchChan::getMchCode, (Object)reWriteBillVO.getMchCode())).eq(BaseEntity::getStatus, (Object)1));
        mchChans = this.uniqAppId(mchChans);
        if (mchChans.isEmpty()) {
            log.info("\u652f\u4ed8\u5b9d\u91cd\u65b0\u5bf9\u8d26\uff0c\u672a\u67e5\u8be2\u5230\u5546\u6237 \u8bf7\u68c0\u67e5");
            return false;
        }
        String billDate = reWriteBillVO.getBillDate();
        boolean b = false;
        for (MchChan mchChan : mchChans) {
            b = this.buildBillAndSave(mchChan, billDate);
            if (!b) continue;
            super.savePlatformBillByMchCode(reWriteBillVO);
            super.reconBillByMchChan(reWriteBillVO, mchChan.getMerchantsMark());
        }
        super.reconciSavePoly(reWriteBillVO);
        return b;
    }

    public void afterPropertiesSet() throws Exception {
        ReconciliationTypeFactory.register((String)PayChanEnum.ALIPAY.name(), (AReconciliationBill)this);
    }

    public AilPay(MchChanMapper mchChanMapper, PayBillMapper payBillMapper) {
        this.mchChanMapper = mchChanMapper;
        this.payBillMapper = payBillMapper;
    }
}

