/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.transfer;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrderQueryResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrerQueryReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayResp;
import com.ebaiyihui.aggregation.payment.server.config.WxPayConfiguration;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.transfer.ITransferService;
import com.ebaiyihui.aggregation.payment.server.utils.RequestHolder;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.entpay.EntPayQueryResult;
import com.github.binarywang.wxpay.bean.entpay.EntPayRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxPayServiceImpl
implements ITransferService {
    private static final Logger log = LoggerFactory.getLogger(WxPayServiceImpl.class);
    @Autowired
    private WxPayConfiguration wxPayConfiguration;
    @Autowired
    MchChanService mchChanService;

    public BaseResponse<B2CPayResp> B2Ctransfer(B2CPayReq vo) {
        log.info("wx pay B2CTransfer method param={}", (Object)vo);
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        MchChan mtc = RequestHolder.getMtc();
        WxPayParam wxPayParam = (WxPayParam)JSONObject.parseObject((String)mtc.getParam(), WxPayParam.class);
        EntPayRequest request = new EntPayRequest();
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        request.setOpenid(vo.getToUserId());
        request.setPartnerTradeNo(vo.getOutBizNo());
        request.setAmount(vo.getAmount());
        request.setDescription(vo.getRemark());
        request.setCheckName("NO_CHECK");
        request.setSpbillCreateIp("127.0.0.1");
        EntPayResult entPayResult = new EntPayResult();
        try {
            log.info("B2Ctransfer wx pay EntPay req ={}", (Object)request);
            entPayResult = wxPayService.getEntPayService().entPay(request);
            log.info("B2Ctransfer wx pay EntPay resp ={}", (Object)entPayResult);
            if (!this.isOk((BaseWxPayResult)entPayResult)) {
                return BaseResponse.error((String)entPayResult.getReturnMsg());
            }
            B2CPayResp res = new B2CPayResp();
            res.setOutBizNo(entPayResult.getPartnerTradeNo());
            res.setPaymentNo(entPayResult.getPaymentNo());
            res.setPaymentStatus("SUCCESS");
            res.setPaymentTime(entPayResult.getPaymentTime());
            return BaseResponse.success((Object)res);
        }
        catch (WxPayException e) {
            log.error("transfer error,e=", (Throwable)e);
            return BaseResponse.error((String)e.getReturnMsg());
        }
    }

    public BaseResponse<B2CPayOrderQueryResp> transferBillQuery(B2CPayOrerQueryReq vo) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        MchChan mtc = RequestHolder.getMtc();
        WxPayParam wxPayParam = (WxPayParam)JSONObject.parseObject((String)mtc.getParam(), WxPayParam.class);
        wxPayService.getConfig().setSslContext(null);
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
        try {
            log.info("wx pay queryEntPay req ={}", (Object)vo.getOutBizNo());
            EntPayQueryResult result = wxPayService.getEntPayService().queryEntPay(vo.getOutBizNo());
            log.info("wx pay queryEntPay resp ={}", (Object)result);
            if (!this.isOk((BaseWxPayResult)result)) {
                return BaseResponse.error((String)result.getReturnMsg());
            }
            B2CPayOrderQueryResp res = new B2CPayOrderQueryResp();
            res.setPaymentNo(result.getDetailId());
            res.setOutBizNo(result.getPartnerTradeNo());
            res.setToUserId(result.getOpenid());
            res.setToUserName(result.getTransferName());
            res.setPaymentAmount(result.getPaymentAmount() + "");
            res.setStatus(result.getStatus());
            res.setPaymentTime(result.getPaymentTime());
            res.setOrderFee("");
            res.setFailReason(result.getReason());
            res.setError_code(result.getErrCode());
            res.setRemark(result.getDesc());
            return BaseResponse.success((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public boolean isOk(BaseWxPayResult result) {
        return result.getResultCode().equals("SUCCESS") && result.getReturnCode().equals("SUCCESS");
    }
}

