/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.utils;

import com.ebaiyihui.aggregation.payment.server.utils.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalendarUtil {
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String MONTH_FIRST_DAY_TIME = "month_first_day_time";
    public static final String MONTH_LAST_DAY_TIME = "month_last_day_time";

    public static List<String> getPre5Years() {
        ArrayList<String> years = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        for (int i = 0; i < 5; ++i) {
            years.add(year - i + "");
        }
        return years;
    }

    public static List<String> get12MonthStr() {
        ArrayList<String> months = new ArrayList<String>();
        for (int i = 1; i < 13; ++i) {
            months.add(i + "");
        }
        return months;
    }

    public static String getNextDay(String format) {
        Calendar calendar = Calendar.getInstance();
        Calendar tmpCalendar = Calendar.getInstance();
        tmpCalendar.set(5, calendar.getActualMaximum(5));
        int maxDate = tmpCalendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int date = calendar.get(5);
        if (date + 1 > maxDate) {
            if (month + 1 > 11) {
                calendar.add(1, 1);
                calendar.set(2, 0);
                calendar.set(5, 1);
            } else {
                calendar.set(year, month, date + 1);
            }
        } else {
            calendar.set(year, month, date + 1);
        }
        return DateUtil.getDateText((Date)calendar.getTime(), (String)format);
    }

    public static Date getNextNDay(Date startTime, Integer n) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        start.add(5, n);
        return start.getTime();
    }

    public static Date getNextNDayBegin(Date startTime, Integer n) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        start.add(5, n);
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        return start.getTime();
    }

    public static Date getNextNDayEnd(Date startTime, Integer n) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        start.add(5, n);
        start.set(11, 23);
        start.set(12, 59);
        start.set(13, 59);
        return start.getTime();
    }

    public static Date getPreNDay(Date startTime, Integer n) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        start.add(5, -n.intValue());
        return start.getTime();
    }

    public static Date getPreNDayBegin(Date startTime, Integer n) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        start.add(5, -n.intValue());
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        return start.getTime();
    }

    public static Date getPreNDayEnd(Date startTime, Integer n) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        start.add(5, -n.intValue());
        start.set(11, 23);
        start.set(12, 59);
        start.set(13, 59);
        return start.getTime();
    }

    public static String getPreXDay(int x, String format) {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        int year = calendar.get(1);
        int date = calendar.get(5);
        if (date - x < 0) {
            if (month - 1 < 0) {
                calendar.add(1, -1);
                calendar.set(2, 11);
                calendar.set(5, 31 - (x - date));
            } else {
                calendar.add(2, -1);
                calendar.set(5, calendar.getActualMaximum(5));
                int maxDate = calendar.get(5);
                calendar.set(year, month - 1, maxDate - (x - date));
            }
        } else {
            calendar.set(year, month, date - x);
        }
        return DateUtil.getDateText((Date)calendar.getTime(), (String)format);
    }

    public static String getYear() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        return year + "";
    }

    public static String getMonth() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        if (++month > 12) {
            return "12";
        }
        return month + "";
    }

    public static Map<String, String> getMonthFirstEndDayTime(String year, String month) {
        HashMap<String, String> rst = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        int m = Integer.parseInt(month);
        if (--m < 0) {
            m = 0;
        }
        calendar.set(Integer.parseInt(year), m, 1);
        String firstDayTime = DateUtil.COMMON.getDateText(calendar.getTime()) + " 00:00:00";
        calendar.set(5, calendar.getActualMaximum(5));
        String lastDayTime = DateUtil.COMMON.getDateText(calendar.getTime()) + " 23:59:59";
        rst.put("month_first_day_time", firstDayTime);
        rst.put("month_last_day_time", lastDayTime);
        return rst;
    }

    public static Map<String, String> getPreMonth() {
        HashMap<String, String> rst = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        int year = calendar.get(1);
        int month = calendar.get(2);
        rst.put("year", year + "");
        if (++month > 12) {
            rst.put("month", "12");
        } else {
            rst.put("month", month + "");
        }
        return rst;
    }

    public static Map<String, String> getPreMonth(Integer year, Integer month) {
        HashMap<String, String> rst = new HashMap<String, String>();
        if (month == 1) {
            rst.put("year", year - 1 + "");
            rst.put("month", "12");
        } else {
            rst.put("year", year + "");
            rst.put("month", month - 1 + "");
        }
        return rst;
    }

    public static List<String> getBetweenMonths(String startMonth, String endMonth) {
        String[] startArr = startMonth.split("-");
        String[] endArr = endMonth.split("-");
        Integer startY = Integer.parseInt(startArr[0]);
        Integer startM = Integer.parseInt(startArr[1]);
        Integer endY = Integer.parseInt(endArr[0]);
        Integer endM = Integer.parseInt(endArr[1]);
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(startY, startM - 1, 1, 0, 0);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.set(endY, endM - 1, 1, 0, 0);
        ArrayList<String> months = new ArrayList<String>();
        while (startCalendar.getTimeInMillis() <= endCalendar.getTimeInMillis()) {
            months.add(DateUtil.getDateText((Date)startCalendar.getTime(), (String)"yyyy-MM"));
            startCalendar.add(2, 1);
        }
        return months;
    }

    public static List<String> getBetweenDateStr(String startTime, String endTime) {
        ArrayList<String> dateList = new ArrayList<String>();
        try {
            Long startM = DateUtil.COMMON.getTextDate(startTime).getTime();
            Long endM = DateUtil.COMMON.getTextDate(endTime).getTime();
            long result = (endM - startM) / 86400000L;
            String[] startTimeStr = startTime.split("-");
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.set(Integer.parseInt(startTimeStr[0]), Integer.parseInt(startTimeStr[1]) - 1, Integer.parseInt(startTimeStr[2]));
            startCalendar.add(5, -1);
            int i = 0;
            while ((long)i <= result) {
                startCalendar.add(5, 1);
                dateList.add(DateUtil.COMMON.getDateText(startCalendar.getTime()));
                ++i;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateList;
    }

    public static List<String> getBetweenDateStr(String startTime, String endTime, String format) {
        ArrayList<String> dateList = new ArrayList<String>();
        try {
            Long startM = DateUtil.COMMON.getTextDate(startTime).getTime();
            Long endM = DateUtil.COMMON.getTextDate(endTime).getTime();
            long result = (endM - startM) / 86400000L;
            String[] startTimeStr = startTime.split("-");
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.set(Integer.parseInt(startTimeStr[0]), Integer.parseInt(startTimeStr[1]) - 1, Integer.parseInt(startTimeStr[2]));
            startCalendar.add(5, -1);
            int i = 0;
            while ((long)i <= result) {
                startCalendar.add(5, 1);
                dateList.add(DateUtil.getDateText((Date)startCalendar.getTime(), (String)format));
                ++i;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateList;
    }

    public static List<String> getPreNMonths(String curMonth, Integer n) {
        String[] curArr = curMonth.split("-");
        Integer curY = Integer.parseInt(curArr[0]);
        Integer curM = Integer.parseInt(curArr[1]);
        Calendar curCalendar = Calendar.getInstance();
        curCalendar.set(curY, curM - 1, 1, 0, 0);
        Calendar tmpCalendar = Calendar.getInstance();
        tmpCalendar.set(curY, curM - 1 - n, 1, 0, 0);
        ArrayList<String> months = new ArrayList<String>();
        while (tmpCalendar.getTimeInMillis() <= curCalendar.getTimeInMillis()) {
            months.add(DateUtil.getDateText((Date)tmpCalendar.getTime(), (String)"yyyy-MM"));
            tmpCalendar.add(2, 1);
        }
        return months;
    }

    public static String getToday(String format) {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.getDateText((Date)calendar.getTime(), (String)format);
    }

    public static String getFirstDay(String format) {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        int year = calendar.get(1);
        calendar.set(year, month, 1);
        return DateUtil.getDateText((Date)calendar.getTime(), (String)format);
    }

    public static String getLastDay(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtil.getDateText((Date)calendar.getTime(), (String)format);
    }

    public static Date getFirstDate() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        int year = calendar.get(1);
        calendar.set(year, month, 1);
        return calendar.getTime();
    }

    public static Date getLastDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isDayEqual(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        String date1Str = DateUtil.COMPAT.getDateText(date1);
        String date2Str = DateUtil.COMPAT.getDateText(date2);
        return date1Str.equals(date2Str);
    }

    public static boolean isTimeSpace(Date startTime, Date endTime, long space) {
        if (startTime == null || endTime == null) {
            return false;
        }
        return endTime.getTime() - startTime.getTime() <= space;
    }

    public static boolean isTimeBetween(Date startTime, Date endTime, long startSpace, long endSpace) {
        return endTime.getTime() - startTime.getTime() <= endSpace && endTime.getTime() - startTime.getTime() >= startSpace;
    }

    public static boolean isTimeBetween(Date time, Date startTime, Date endTime) {
        return time.getTime() >= startTime.getTime() && time.getTime() <= endTime.getTime();
    }

    public static Integer getYearSpace(Date startTime, Date endTime) {
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return end.get(1) - start.get(1);
    }

    public static Integer getDaySpace(Date startTime, Date endTime) {
        return (int)(endTime.getTime() - startTime.getTime()) / 86400000;
    }

    public static long getTimeInMillis() {
        Calendar now = Calendar.getInstance();
        return now.getTimeInMillis();
    }

    public static long getTimeInSeconds() {
        return CalendarUtil.getTimeInMillis() / 1000L;
    }

    public static void main(String[] args) {
        try {
            Date startTime = DateUtil.COMMON.getTextDate("2015-06-03 00:00:00");
            Date endTime = DateUtil.COMMON_FULL.getTextDate("2015-06-03 23:59:59");
            System.out.println(CalendarUtil.isTimeBetween((Date)new Date(), (Date)startTime, (Date)endTime));
            List month = CalendarUtil.getPreNMonths((String)"2015-06", (Integer)11);
            for (String s : month) {
                System.out.println(s);
            }
            String str = DateUtil.COMMON_FULL.getDateText(CalendarUtil.getPreNDayEnd((Date)new Date(), (Integer)1));
            System.out.println(str);
            List days = CalendarUtil.getBetweenDateStr((String)"2015-03-09", (String)"2015-06-15", (String)"MM/dd");
            for (String s : days) {
                System.out.println(s);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

