/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.wxpay;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.server.wxpay.util.HttpUtil;
import com.ebaiyihui.aggregation.payment.server.wxpay.util.WxUtil;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.BaseWxPayResultBO;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayRequestBO;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayResultBO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class WxPay {
    private static final Logger log = LoggerFactory.getLogger(WxPay.class);
    private static final int OUT_TIME = 50000;
    private static int INTERVAL_TIME = 5000;
    private static WxPay INSTANCE = null;
    private final BASE64Encoder encoder = new BASE64Encoder();
    private final BASE64Decoder decoder = new BASE64Decoder();

    public static WxPay getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WxPay();
        }
        return INSTANCE;
    }

    public WxPayMicropayResultBO microPay(WxPayMicropayRequestBO wxPayMicropayRequestBO) {
        WxPayMicropayResultBO wxPayMicropayResultBO = new WxPayMicropayResultBO();
        try {
            wxPayMicropayResultBO = this.startRequest(wxPayMicropayRequestBO, "https://api.mch.weixin.qq.com/pay/micropay", false);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return wxPayMicropayResultBO;
    }

    private WxPayMicropayResultBO startRequest(WxPayMicropayRequestBO wxPayMicropayRequestBO, String url, boolean isSsl) throws Exception {
        log.info("[WxPay],\u5f00\u59cb\u4ed8\u6b3e\u7801\u652f\u4ed8,\u8bf7\u6c42\u53c2\u6570{},\u8bf7\u6c42URL:{}", (Object)JSONObject.toJSONString((Object)wxPayMicropayRequestBO), (Object)url);
        String publicKey = wxPayMicropayRequestBO.getPublicKey();
        String requestStr = wxPayMicropayRequestBO.toXML();
        log.info("key:{},\u672a\u52a0\u7b7exml:{}", (Object)publicKey, (Object)requestStr);
        Map xmlToMap = WxUtil.xmlToMap((String)requestStr);
        String sign = WxUtil.generateSignature((Map)xmlToMap, (String)publicKey, (String)"MD5");
        xmlToMap.put("sign", sign);
        String requestStrXml = WxUtil.mapToXml((Map)xmlToMap);
        wxPayMicropayRequestBO.setSign(sign);
        log.info("[WxPay],\u4ed8\u6b3e\u7801\u8bf7\u6c42\u5165\u53c2:{}", (Object)requestStrXml);
        WxPayMicropayResultBO wxPayMicropayResultBO = new WxPayMicropayResultBO();
        if (!isSsl) {
            byte[] bytes = HttpUtil.postForBytes((String)url, (String)requestStrXml, (boolean)false);
            String encodedText = this.encoder.encode(bytes);
            log.info("[WxPay],\u5fae\u4fe1\u8fd4\u56debase64\u7f16\u7801:{}", (Object)encodedText);
            String resultStr = new String(this.decoder.decodeBuffer(encodedText), "UTF-8");
            log.info("[WxPay],\u5fae\u4fe1\u8fd4\u56debase64\u89e3\u7801:{}", (Object)resultStr);
            wxPayMicropayResultBO = (WxPayMicropayResultBO)BaseWxPayResultBO.fromXML((String)resultStr, WxPayMicropayResultBO.class);
        } else {
            String resultStr = HttpUtil.httpsSSLRequest((String)url, (String)requestStr);
        }
        return wxPayMicropayResultBO;
    }
}

