/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ebaiyihui.aggregation.payment.common.model.Reconciliation;
import com.ebaiyihui.aggregation.payment.common.vo.ReWriteBillVO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestBillVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestReconciliationVo;
import com.ebaiyihui.aggregation.payment.server.enums.ContrastEnum;
import com.ebaiyihui.aggregation.payment.server.service.ReconciliationService;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.AReconciliationBill;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.IReconciliationService;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationTypeFactory;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"reconciliation"})
@Api(tags={"\u5bf9\u8d26\u63a5\u53e3"})
public class ReconciliationController {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationController.class);
    @Autowired
    ReconciliationService reconciliationService;
    @Autowired
    private IReconciliationService iReconciliationService;

    @PostMapping(value={"system"})
    @ApiOperation(value="\u751f\u6210\u5bf9\u8d26")
    public BaseResponse systemReconciliation(@RequestBody RequestBillVo requestBillVo) {
        return BaseResponse.success();
    }

    @PostMapping(value={"getListByQuery"})
    @ApiOperation(value="\u67e5\u8be2\u5bf9\u8d26\u5217\u8868")
    public BaseResponse<IPage<Reconciliation>> getListByQuery(@RequestBody RequestReconciliationVo requestReconciliationVo) {
        return BaseResponse.success((Object)this.reconciliationService.getListByQuery(requestReconciliationVo));
    }

    @PostMapping(value={"reWriteBills"})
    @ApiOperation(value="\u5546\u6237\u4e00\u5929\u8d26\u5355\u624b\u52a8\u62c9\u53d6\u91cd\u5199")
    public BaseResponse<Object> reWriteBills(@RequestBody ReWriteBillVO reWriteBillVO) {
        AReconciliationBill channel = ReconciliationTypeFactory.getChannel((String)reWriteBillVO.getPlantform());
        String s = reWriteBillVO.getBillDate().replaceAll("-", "");
        reWriteBillVO.setBillDate(s);
        Boolean aBoolean = channel.reWriteBills(reWriteBillVO);
        return aBoolean != false ? BaseResponse.success() : BaseResponse.error((String)"");
    }

    @GetMapping(value={"exportListByQuery"})
    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u5bfc\u51faexcel")
    public void exportListByQuery(RequestReconciliationVo requestReconciliationVo, HttpServletResponse response) {
        List reconciliationList = this.reconciliationService.getByQuery(requestReconciliationVo);
        if (reconciliationList.size() == 0) {
            return;
        }
        try {
            response.reset();
            response.setContentType("application/octet-stream");
            String name = URLEncoder.encode("\u5bf9\u8d26\u6570\u636e", "UTF-8") + ".xlsx";
            response.setHeader("Content-Disposition", "attachment;filename=" + name);
            ServletOutputStream out = response.getOutputStream();
            XSSFWorkbook workBook = new XSSFWorkbook();
            XSSFSheet sheet = workBook.createSheet();
            XSSFRow head = sheet.createRow(0);
            head.createCell(0).setCellValue("\u5bf9\u8d26\u65e5\u671f");
            head.createCell(1).setCellValue("\u5bf9\u8d26\u6279\u6b21\u7f16\u53f7");
            head.createCell(2).setCellValue("\u5bf9\u8d26\u6e20\u9053");
            head.createCell(3).setCellValue("\u5bf9\u8d26\u7ed3\u679c");
            head.createCell(4).setCellValue("\u5bf9\u8d26\u91d1\u989d");
            head.createCell(5).setCellValue("\u5bf9\u8d26\u7b14\u6570");
            head.createCell(6).setCellValue("\u5dee\u9519\u91d1\u989d");
            head.createCell(7).setCellValue("\u5dee\u9519\u6570");
            int i = 1;
            for (Reconciliation reconciliation : reconciliationList) {
                XSSFRow headi = sheet.createRow(i);
                headi.createCell(0).setCellValue(DateUtils.strDate2StrDate((String)reconciliation.getContrastDate()));
                headi.createCell(1).setCellValue(reconciliation.getBatchNumber());
                headi.createCell(2).setCellValue(reconciliation.getChannel());
                headi.createCell(3).setCellValue(ContrastEnum.getByValue((String)reconciliation.getResults()).getDisplay());
                headi.createCell(4).setCellValue(reconciliation.getContrastAmount().toString());
                headi.createCell(5).setCellValue((double)reconciliation.getContrastCount());
                headi.createCell(6).setCellValue(reconciliation.getErrorAmount().toString());
                headi.createCell(7).setCellValue((double)reconciliation.getErrorCount());
                ++i;
            }
            workBook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5bf9\u8d26\u5355\u8be6\u60c5")
    public BaseResponse<Reconciliation> getById(@RequestParam(value="id") Long id) {
        return BaseResponse.success((Object)this.reconciliationService.getById(id));
    }

    @GetMapping(value={"/test"})
    @ApiOperation(value="\u53ea\u4f5c\u4e3a\u5f00\u53d1\u4eba\u5458\u6d4b\u8bd5\u4f7f\u7528\uff0c\u62c9\u53d6\u6307\u5b9a\u65e5\u671f\u7684\u8d26\u5355\u5e76\u5bf9\u8d26")
    public BaseResponse<Object> testReconBills(String billDates) {
        String[] split;
        for (String s : split = billDates.split(",")) {
            this.iReconciliationService.launcher(s);
            this.iReconciliationService.polymerization(s);
        }
        return BaseResponse.success();
    }
}

