/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.hypay.reconciliation;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyPublicParameReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.reconciliation.BillReqBO;
import com.ebaiyihui.aggregation.payment.server.hypay.reconciliation.BillResBO;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillReqBO {
    private static final Logger log = LoggerFactory.getLogger(BillReqBO.class);
    private final String URL = "https://api.heemoney.com/v1/MerchBillReport";
    private final String METHOD = "heemoney.bill.download";
    private HyPublicParameReqVO hyPublicParameReqVO;
    private String begin_time;
    private String end_time;
    private String bill_type;

    public void setHyPublicParameReqVO(HyPublicParameReqVO hyPublicParamReqVOTemp) {
        this.hyPublicParameReqVO = hyPublicParamReqVOTemp;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("begin_time", (Object)this.begin_time);
        jsonObject.put("end_time", (Object)this.end_time);
        jsonObject.put("bill_type", (Object)this.bill_type);
        this.hyPublicParameReqVO.setBiz_content(jsonObject.toJSONString());
        this.hyPublicParameReqVO.setMethod("heemoney.bill.download");
        this.hyPublicParameReqVO.setVersion("1.0");
        this.hyPublicParameReqVO.setTimestamp(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        this.hyPublicParameReqVO.setSign_type("MD5");
        this.hyPublicParameReqVO.setCharset("UTF-8");
        this.hyPublicParameReqVO.createSign("22D2E19B913D4409904F8510");
    }

    public BillResBO getBill() {
        JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)"https://api.heemoney.com/v1/MerchBillReport", (String)JSONObject.toJSONString((Object)this.hyPublicParameReqVO));
        String result = jsonObject.toJSONString();
        log.info("get hy bill =" + result);
        return (BillResBO)JSONObject.parseObject((String)result, BillResBO.class);
    }

    public static BillReqBOBuilder builder() {
        return new BillReqBOBuilder();
    }

    public String getURL() {
        this.getClass();
        return "https://api.heemoney.com/v1/MerchBillReport";
    }

    public String getMETHOD() {
        this.getClass();
        return "heemoney.bill.download";
    }

    public HyPublicParameReqVO getHyPublicParameReqVO() {
        return this.hyPublicParameReqVO;
    }

    public String getBegin_time() {
        return this.begin_time;
    }

    public String getEnd_time() {
        return this.end_time;
    }

    public String getBill_type() {
        return this.bill_type;
    }

    public void setBegin_time(String begin_time) {
        this.begin_time = begin_time;
    }

    public void setEnd_time(String end_time) {
        this.end_time = end_time;
    }

    public void setBill_type(String bill_type) {
        this.bill_type = bill_type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillReqBO)) {
            return false;
        }
        BillReqBO other = (BillReqBO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$URL = this.getURL();
        String other$URL = other.getURL();
        if (this$URL == null ? other$URL != null : !this$URL.equals(other$URL)) {
            return false;
        }
        String this$METHOD = this.getMETHOD();
        String other$METHOD = other.getMETHOD();
        if (this$METHOD == null ? other$METHOD != null : !this$METHOD.equals(other$METHOD)) {
            return false;
        }
        HyPublicParameReqVO this$hyPublicParameReqVO = this.getHyPublicParameReqVO();
        HyPublicParameReqVO other$hyPublicParameReqVO = other.getHyPublicParameReqVO();
        if (this$hyPublicParameReqVO == null ? other$hyPublicParameReqVO != null : !this$hyPublicParameReqVO.equals(other$hyPublicParameReqVO)) {
            return false;
        }
        String this$begin_time = this.getBegin_time();
        String other$begin_time = other.getBegin_time();
        if (this$begin_time == null ? other$begin_time != null : !this$begin_time.equals(other$begin_time)) {
            return false;
        }
        String this$end_time = this.getEnd_time();
        String other$end_time = other.getEnd_time();
        if (this$end_time == null ? other$end_time != null : !this$end_time.equals(other$end_time)) {
            return false;
        }
        String this$bill_type = this.getBill_type();
        String other$bill_type = other.getBill_type();
        return !(this$bill_type == null ? other$bill_type != null : !this$bill_type.equals(other$bill_type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BillReqBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $URL = this.getURL();
        result = result * 59 + ($URL == null ? 43 : $URL.hashCode());
        String $METHOD = this.getMETHOD();
        result = result * 59 + ($METHOD == null ? 43 : $METHOD.hashCode());
        HyPublicParameReqVO $hyPublicParameReqVO = this.getHyPublicParameReqVO();
        result = result * 59 + ($hyPublicParameReqVO == null ? 43 : $hyPublicParameReqVO.hashCode());
        String $begin_time = this.getBegin_time();
        result = result * 59 + ($begin_time == null ? 43 : $begin_time.hashCode());
        String $end_time = this.getEnd_time();
        result = result * 59 + ($end_time == null ? 43 : $end_time.hashCode());
        String $bill_type = this.getBill_type();
        result = result * 59 + ($bill_type == null ? 43 : $bill_type.hashCode());
        return result;
    }

    public String toString() {
        return "BillReqBO(URL=" + this.getURL() + ", METHOD=" + this.getMETHOD() + ", hyPublicParameReqVO=" + this.getHyPublicParameReqVO() + ", begin_time=" + this.getBegin_time() + ", end_time=" + this.getEnd_time() + ", bill_type=" + this.getBill_type() + ")";
    }

    public BillReqBO(HyPublicParameReqVO hyPublicParameReqVO, String begin_time, String end_time, String bill_type) {
        this.hyPublicParameReqVO = hyPublicParameReqVO;
        this.begin_time = begin_time;
        this.end_time = end_time;
        this.bill_type = bill_type;
    }

    public BillReqBO() {
    }
}

