/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.mybank;

import com.ebaiyihui.aggregation.payment.server.mybank.AbstractMybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.DefaultMybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.mapping.DefaultSignChecker;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.mapping.DefaultSigner;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.mapping.SignChecker;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.mapping.Signer;

public class DefaultMybankClient
extends AbstractMybankClient {
    private String privateKey;
    private String mybankPublicKey;
    private Signer signer;
    private SignChecker signChecker;

    public DefaultMybankClient(String serverUrl, String privateKey, String mybankPublicKey) {
        super(serverUrl);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public DefaultMybankClient(String serverUrl, String charset, String privateKey, String mybankPublicKey) {
        super(serverUrl, charset);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public DefaultMybankClient(String serverUrl, String charset, String signType, String privateKey, String mybankPublicKey) {
        super(serverUrl, charset, signType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public DefaultMybankClient(String serverUrl, String format, String charset, String signType, String privateKey, String mybankPublicKey) {
        super(serverUrl, format, charset, signType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public Signer getSigner() {
        return this.signer;
    }

    public SignChecker getSignChecker() {
        return this.signChecker;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        if (this.signer == null) {
            this.signer = new DefaultSigner(privateKey);
        }
    }

    public void setMybankPublicKey(String mybankPublicKey) {
        this.mybankPublicKey = mybankPublicKey;
        if (this.signChecker == null) {
            this.signChecker = new DefaultSignChecker(mybankPublicKey);
        }
    }

    public static Builder builder(String serverUrl, String privateKey, String mybankPublicKey) {
        return new Builder(serverUrl, privateKey, mybankPublicKey);
    }
}

