/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.aggregation.payment.common.model.ChannelBill;
import com.ebaiyihui.aggregation.payment.common.model.ErrorBill;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.Reconciliation;
import com.ebaiyihui.aggregation.payment.common.vo.RequestErrorBillVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ProcessingStateEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.ChannelBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ErrorBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ReconciliationMapper;
import com.ebaiyihui.aggregation.payment.server.service.ErrorBillService;
import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorBillServiceImpl
implements ErrorBillService {
    private static final Logger log = LoggerFactory.getLogger(ErrorBillServiceImpl.class);
    public static final String REFUND = "refund";
    public static final String PAY = "pay";
    @Autowired
    ErrorBillMapper errorBillMapper;
    @Autowired
    ReconciliationMapper reconciliationMapper;
    @Autowired
    PayBillService payBillService;
    @Autowired
    PaymentRecordsService paymentRecordsService;
    @Autowired
    ChannelBillMapper channelBillMapper;
    @Autowired
    NotifyService notifyService;

    public ErrorBill getById(Long id) {
        return (ErrorBill)this.errorBillMapper.selectById((Serializable)id);
    }

    public List<ErrorBill> getByBatchNumber(String number) {
        return this.errorBillMapper.getListByBatchNumber(number);
    }

    public IPage<ErrorBill> getByQuery(RequestErrorBillVo requestErrorBillVo) {
        Page page = new Page((long)requestErrorBillVo.getPageNum(), (long)requestErrorBillVo.getPageSize());
        IPage iPage = this.errorBillMapper.getByQuery(page, requestErrorBillVo);
        iPage.getRecords().forEach(e -> e.setContrastDate(DateUtils.strDate2StrDate((String)e.getContrastDate())));
        Long count = this.errorBillMapper.getCountByQuery(requestErrorBillVo);
        iPage.setCurrent(count.longValue());
        return iPage;
    }

    public List<ErrorBill> getByQueryList(RequestErrorBillVo requestErrorBillVo) {
        return this.errorBillMapper.getByQueryList(requestErrorBillVo);
    }

    public BaseResponse updateState(Long id, String remake) {
        ErrorBill errorBill = (ErrorBill)this.errorBillMapper.selectById((Serializable)id);
        ChannelBill channelBill = this.channelBillMapper.getByTradeNoAndTradeState(errorBill.getChannelTradeNo(), errorBill.getChannelTradeState());
        errorBill.setProcessingState(ProcessingStateEnum.HAVE_TO_DEAL_WITH.getValue());
        errorBill.setRemake(remake);
        this.errorBillMapper.updateById((Object)errorBill);
        Reconciliation reconciliation = this.reconciliationMapper.getByBatchNumber(errorBill.getBatchNumber());
        reconciliation.setUntreatedErrorCount(reconciliation.getUntreatedErrorCount() - 1);
        this.reconciliationMapper.updateById((Object)reconciliation);
        PayBill payBill = this.payBillService.getByTradeNo(errorBill.getChannelTradeNo());
        Date time = DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)errorBill.getChannelTradeTime());
        if (null != payBill) {
            if (errorBill.getChannelTradeState().equals("SUCCESS")) {
                payBill.setStatus(OrderStatusEnum.PAID.getValue());
                payBill.setPayTime(time);
                this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
                log.info("-------------\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
                ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                responseNotifyRestVo.setTradeNo(errorBill.getChannelTradeNo());
                responseNotifyRestVo.setReturnCode("SUCCESS");
                responseNotifyRestVo.setReturnMsg("\u652f\u4ed8\u6210\u529f");
                responseNotifyRestVo.setResultCode("200");
                responseNotifyRestVo.setErrCode("");
                responseNotifyRestVo.setErrCodeDes("");
                responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
                responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                responseNotifyRestVo.setMchCode(payBill.getMchCode());
                responseNotifyRestVo.setMchId(channelBill.getMchId());
                responseNotifyRestVo.setMchName("");
                responseNotifyRestVo.setPayTime(time);
                this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
                log.info("\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
                this.notifyService.notify(PAY, JSON.toJSONString((Object)responseNotifyRestVo));
            } else if (errorBill.getChannelTradeState().equals("REFUND")) {
                payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
                payBill.setRefundTime(time);
                this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
                log.info("-------------\u6784\u5efaResponseRefundNotifyRestVo\uff0c\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
                ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
                responseRefundNotifyRestVo.setMchCode(payBill.getMchCode());
                responseRefundNotifyRestVo.setMchId(channelBill.getMchId());
                responseRefundNotifyRestVo.setMchName("");
                responseRefundNotifyRestVo.setReturnCode("SUCCESS");
                responseRefundNotifyRestVo.setReturnMsg("\u9000\u6b3e\u6210\u529f");
                responseRefundNotifyRestVo.setReturnCode("200");
                responseRefundNotifyRestVo.setErrCode("");
                responseRefundNotifyRestVo.setErrCodeDes("");
                responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
                responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
                responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
                responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
                responseRefundNotifyRestVo.setRefundNo(channelBill.getTransactionId());
                responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
                responseRefundNotifyRestVo.setRefundMoney(channelBill.getRefundFee().divide(new BigDecimal(100)));
                responseRefundNotifyRestVo.setRefundTime(time);
                this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
                log.info("\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseRefundNotifyRestVo.toString());
                this.notifyService.notify(REFUND, JSON.toJSONString((Object)responseRefundNotifyRestVo));
            }
            this.payBillService.update(payBill);
        }
        return BaseResponse.success();
    }
}

