/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.config;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.ProfitSharingService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.ProfitSharingServiceImpl;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS, value="prototype")
public class WxPayConfiguration {
    @Value(value="${wx.pay.payNotifyUrl}")
    private String payNotifyUrl;

    public WxPayService wxService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setNotifyUrl(StringUtils.trimToNull((String)this.payNotifyUrl));
        payConfig.setSignType(StringUtils.trimToNull((String)"MD5"));
        payConfig.setUseSandboxEnv(false);
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        return wxPayService;
    }

    public ProfitSharingService profitSharingService() {
        ProfitSharingServiceImpl profitSharingService = new ProfitSharingServiceImpl(this.wxService());
        return profitSharingService;
    }
}

