/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingBind;
import com.ebaiyihui.aggregation.payment.common.vo.RequestBindReqVO;
import com.ebaiyihui.aggregation.payment.server.service.ProfitSharingBindService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bind"})
public class ProfitSharingBindController {
    private static final Logger log = LoggerFactory.getLogger(ProfitSharingBindController.class);
    @Autowired
    private ProfitSharingBindService profitSharingBindService;

    @PostMapping(value={"/save"})
    public BaseResponse saveBind(@RequestBody ProfitSharingBind profitSharingBind) {
        int save = this.profitSharingBindService.save(profitSharingBind);
        return BaseResponse.success();
    }

    @PostMapping(value={"/update"})
    public BaseResponse updateBind(@RequestBody ProfitSharingBind profitSharingBind) {
        int updateBind = this.profitSharingBindService.updateBind(profitSharingBind);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getBinds"})
    public BaseResponse queryBindList(@RequestBody RequestBindReqVO bindReqVO) {
        PageResult binds = this.profitSharingBindService.getBinds(bindReqVO);
        return BaseResponse.success((Object)binds);
    }

    @PostMapping(value={"/deleteBind"})
    public BaseResponse deleteBind(@RequestBody List<Long> list) {
        if (list.isEmpty()) {
            return BaseResponse.error((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int deleteBind = this.profitSharingBindService.deleteBind(list);
        return BaseResponse.success();
    }

    @GetMapping(value={"/get_bind_info"})
    public BaseResponse getBindInfoByBindCode(@RequestParam(value="bindCode") String bindCode) {
        ProfitSharingBind byBindCode = this.profitSharingBindService.getBindInfoByBindCode(bindCode);
        return BaseResponse.success((Object)byBindCode);
    }

    @GetMapping(value={"/get_bind_list"})
    public BaseResponse getBindInfoByMerchant(@RequestParam(value="merchant") String merchant) {
        List byMainMerchant = this.profitSharingBindService.getBindByMainMerchant(merchant);
        return BaseResponse.success((Object)byMainMerchant);
    }
}

