/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.ebaiyihui.aggregation.payment.common.model.ThirdPartyRelation;
import com.ebaiyihui.aggregation.payment.common.vo.ThirdPartyRelationVO;
import com.ebaiyihui.aggregation.payment.server.service.ThirdPartyRelationService;
import com.ebaiyihui.framework.response.BaseResponse;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/third_party_relation"})
public class ThirdPartyRelationController {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyRelationController.class);
    @Autowired
    private ThirdPartyRelationService relationService;

    @PostMapping(value={"/save"})
    public BaseResponse saveThirdPartyRelation(@RequestBody ThirdPartyRelationVO partyRelationVO) {
        this.relationService.save(partyRelationVO);
        return BaseResponse.success();
    }

    @GetMapping(value={"/get_info"})
    public BaseResponse getInfo(@Param(value="applyCode") String applyCode) {
        ThirdPartyRelation infoByApplyCode = this.relationService.getRelationInfoByApplyCode(applyCode);
        return BaseResponse.success((Object)infoByApplyCode);
    }

    @PostMapping(value={"/update"})
    public BaseResponse update(@RequestBody ThirdPartyRelationVO partyRelationVO) {
        this.relationService.update(partyRelationVO);
        return BaseResponse.success();
    }
}

