/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.hypay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestDownloadVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestOfflineOederQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrCodeCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQrIsSweptCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseCloseOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseQueryRefundOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseReverseOrderVo;
import com.ebaiyihui.aggregation.payment.server.Factory.PayFactory;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyPayCreateOrderReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyPayCreateOrderRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyProfitSharingReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyPublicParameReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyQueryOrderReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyQueryOrderRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyQueryRefundOrderReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyQueryRefundOrderRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundPayOrderReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundPayOrderRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.ProfitSharingDTO;
import com.ebaiyihui.aggregation.payment.server.hypay.hyutil.MoneyUtil;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.rabbitmq.RabbitProduct;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.TradeService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import com.ebaiyihui.aggregation.payment.server.utils.Md5Utils;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class HyPayTrade
implements TradeService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HyPayTrade.class);
    public static final long EXPIRE_DATE = 2100L;
    private static final String RETURN_CODE = "SUCCESS";
    private static final String RESULT_CODE = "SUCCESS";
    private static final String TRADE_STAUTS = "SUCCESS";
    public static final String FAIL = "FAIL";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int ADD_MINUTES = 35;
    @Value(value="${hy.pay.payNotifyUrl}")
    private String refundNotifyUrl;
    @Autowired
    private RabbitProduct rabbitProduct;
    @Autowired
    PayMchService payMchService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private PayMchMapper payMchMapper;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RedisTemplateService redisTemplateService;

    public BaseResponse createOrder(HttpServletRequest request, RequestCreateOrderVo requestCreateOrderVo) {
        String orderViewId = null;
        String redisKey = null;
        try {
            log.info("createOrder\u8bf7\u6c42*************");
            log.info("\u652f\u4ed8\u4e0b\u5355\u5165\u53c2:{}", (Object)requestCreateOrderVo.toString());
            redisKey = requestCreateOrderVo.getServiceCode() + "_" + requestCreateOrderVo.getOutTradeNo();
            if (BigDecimal.ZERO.compareTo(requestCreateOrderVo.getTotalAmount()) >= 0) {
                return BaseResponse.error((String)"\u8ba2\u5355\u91d1\u989d\u5f02\u5e38");
            }
            PayBill pb = this.payBillService.getByOutTradeNoAndStatus(requestCreateOrderVo.getOutTradeNo(), OrderStatusEnum.PAID.getValue());
            if (null != pb) {
                return BaseResponse.error((String)"\u5df2\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            orderViewId = UniqueKeyGenerator.generateViewId();
            PayBill payBill = this.payBillService.getByCreateOrder(requestCreateOrderVo);
            log.info("\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
            payBill.setDealTradeNo(orderViewId);
            log.info("createOrder****save****");
            this.payBillService.save(payBill);
            this.paymentRecordsService.saveByBill(orderViewId, requestCreateOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
            MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
            String param = mchChan.getParam();
            WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
            HyPublicParameReqVO publicParameReqVO = this.pubilcParamCompose(hyParam.getHyApplyId(), hyParam.getUHyId());
            BaseResponse baseResponse = this.startHyPay(publicParameReqVO, requestCreateOrderVo, mchChan, orderViewId);
            if (WechatTradeTypeEnum.JSPAI.getDisplay().equals(requestCreateOrderVo.getPayType())) {
                HyPayCreateOrderRespVO respVO = (HyPayCreateOrderRespVO)baseResponse.getData();
                String params = respVO.getHy_mini_pay_params();
                return BaseResponse.success((Object)params);
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u5f02\u5e38\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{orderViewId, e.getMessage(), e});
            this.redisTemplateService.del(redisKey);
            return BaseResponse.error((String)("\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage()));
        }
    }

    public ResponseQueryOrderVo queryOrder(PayBill payBill) {
        log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u8ba2\u5355\u4fe1\u606fpayBill:{} ", (Object)JSONObject.toJSONString((Object)payBill));
        ResponseQueryOrderVo responseQueryOrderVo = new ResponseQueryOrderVo();
        String mchCode = payBill.getMchCode();
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u8ba2\u5355,\u6c47\u4ed8\u5b9d\u5173\u8054\u4fe1\u606f:{} ", (Object)JSONObject.toJSONString((Object)mchChan));
        HyPublicParameReqVO publicParameReqVO = this.pubilcParamCompose(hyParam.getHyApplyId(), hyParam.getUHyId());
        try {
            HyQueryOrderRespVO hyQueryOrderRespVO = this.queryHyPayBill(payBill, publicParameReqVO, mchChan);
            log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)hyQueryOrderRespVO));
            if ("SUCCESS".equals(hyQueryOrderRespVO.getReturn_code())) {
                responseQueryOrderVo.setReturnCode(hyQueryOrderRespVO.getReturn_code());
                responseQueryOrderVo.setReturnMsg(hyQueryOrderRespVO.getReturn_msg());
                responseQueryOrderVo.setResultMsg(hyQueryOrderRespVO.getResult_code());
                responseQueryOrderVo.setResultCode(hyQueryOrderRespVO.getResult_code());
                responseQueryOrderVo.setMchCode(hyQueryOrderRespVO.getMch_uid());
                if ("SUCCESS".equals(hyQueryOrderRespVO.getResult_code())) {
                    responseQueryOrderVo.setOpenid(hyQueryOrderRespVO.getApp_id());
                    responseQueryOrderVo.setTradeType(hyQueryOrderRespVO.getChannel_type());
                    responseQueryOrderVo.setTradeState(hyQueryOrderRespVO.getTrade_status());
                    responseQueryOrderVo.setDealAmount(new BigDecimal(hyQueryOrderRespVO.getReal_fee()));
                    responseQueryOrderVo.setOutTradeNo(hyQueryOrderRespVO.getOut_trade_no());
                    if ("SUCCESS".equals(hyQueryOrderRespVO.getTrade_status())) {
                        responseQueryOrderVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)hyQueryOrderRespVO.getTime_end()));
                    }
                }
            } else {
                responseQueryOrderVo.setReturnCode(hyQueryOrderRespVO.getReturn_code());
                responseQueryOrderVo.setReturnMsg(hyQueryOrderRespVO.getReturn_msg());
            }
        }
        catch (Exception e) {
            log.error("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u8ba2\u5355\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            responseQueryOrderVo.setReturnMsg(e.getMessage());
            responseQueryOrderVo.setReturnCode("FAIL");
        }
        return responseQueryOrderVo;
    }

    public BaseResponse refundOrder(RequestRefundOrderVo requestRefundOrderVo) {
        PayBill payBill = this.payBillService.getByDealTradeNo(requestRefundOrderVo.getDealTradeNo());
        log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u9000\u6b3e\u539f\u59cb\u8ba2\u5355\u8bb0\u5f55{}", (Object)JSON.toJSONString((Object)payBill));
        if (null == payBill) {
            return BaseResponse.error((String)"\u3010\u6c47\u4ed8\u5b9d\u3011\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        String applyCode = requestRefundOrderVo.getApplyCode();
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u9000\u6b3e\u8ba2\u5355,\u6c47\u4ed8\u5b9d\u5173\u8054\u4fe1\u606f:{} ", (Object)JSONObject.toJSONString((Object)hyParam));
        HyPublicParameReqVO publicParameReqVO = this.pubilcParamCompose(hyParam.getHyApplyId(), hyParam.getUHyId());
        try {
            HyRefundPayOrderRespVO respVO = this.returnHyPay(requestRefundOrderVo, publicParameReqVO, mchChan);
            return BaseResponse.success((Object)respVO);
        }
        catch (Exception e) {
            log.error("\u3010\u6c47\u4ed8\u5b9d\u3011\u9000\u6b3e\u7ed3\u679c\u5f02\u5e38,\u8ba2\u5355\u4fe1\u606f:{},\u5f02\u5e38\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{JSONObject.toJSONString((Object)payBill), e.getMessage(), e});
            return BaseResponse.error((String)"\u3010\u6c47\u4ed8\u5b9d\u3011\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u6b3e\u5931\u8d25!");
        }
    }

    public ResponseQueryRefundOrderVo queryRefundOrder(RequestQueryRefundOrderVo requestQueryRefundOrderVo, PayBill payBill) {
        log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u8ba2\u5355\u4fe1\u606fpayBill:{} ", (Object)JSONObject.toJSONString((Object)payBill));
        ResponseQueryRefundOrderVo refundOrderVo = new ResponseQueryRefundOrderVo();
        String mchCode = payBill.getMchCode();
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u8ba2\u5355,\u6c47\u4ed8\u5b9d\u5173\u8054\u4fe1\u606f:{} ", (Object)JSONObject.toJSONString((Object)param));
        HyPublicParameReqVO publicParameReqVO = this.pubilcParamCompose(hyParam.getHyApplyId(), hyParam.getUHyId());
        try {
            HyQueryRefundOrderRespVO queryRefundOrderHy = this.queryRefundOrderHy(payBill, publicParameReqVO, mchChan);
            log.info("\u3010\u6c47\u4ed8\u5b9d\u3011\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u8fd4\u56de\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)queryRefundOrderHy));
            if ("SUCCESS".equals(queryRefundOrderHy.getReturn_code())) {
                refundOrderVo.setReturnMsg(queryRefundOrderHy.getReturn_msg());
                refundOrderVo.setReturnCode(queryRefundOrderHy.getReturn_code());
                refundOrderVo.setSubCode(queryRefundOrderHy.getResult_code());
                refundOrderVo.setSubMsg(queryRefundOrderHy.getReturn_msg());
                refundOrderVo.setRefundAmount(MoneyUtil.changeF2Y((String)String.valueOf(queryRefundOrderHy.getRefund_fee())));
                refundOrderVo.setTotalAmount(MoneyUtil.changeF2Y((String)String.valueOf(queryRefundOrderHy.getTotal_fee())));
                refundOrderVo.setOutTradeNo(queryRefundOrderHy.getOut_trade_no());
                refundOrderVo.setTradeNo(queryRefundOrderHy.getHy_bill_no());
            } else {
                refundOrderVo.setReturnMsg(queryRefundOrderHy.getError_msg());
                refundOrderVo.setReturnCode(queryRefundOrderHy.getError_code());
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u67e5\u8be2\u9000\u6b3e\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            refundOrderVo.setReturnMsg(e.getMessage());
            refundOrderVo.setReturnCode("FAIL");
        }
        return refundOrderVo;
    }

    public ResponseCloseOrderVo closeOrder(PayBill payBill) {
        return null;
    }

    public ResponseReverseOrderVo reverseOrderVo(PayBill payBill) {
        return null;
    }

    public BaseResponse downLoadBill(RequestDownloadVo requestDownloadVo) {
        return null;
    }

    public ResponseQueryOrderVo offlineQueryOrder(RequestOfflineOederQueryVO reqVo) {
        return null;
    }

    public BaseResponse<String> qrIsSwept(RequestQrIsSweptCreateOrderVo orderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> qrCode(RequestQrCodeCreateOrderVo qrCodeCreateOrderVo) throws IOException {
        return null;
    }

    public BaseResponse<String> createPolymericOrder(HttpServletRequest request, PayBill payBill, RequestCreateOrderVo requestCreateOrderVo) {
        return null;
    }

    private HyPublicParameReqVO pubilcParamCompose(String appid, String mchuid) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = df.format(new Date());
        HyPublicParameReqVO build = HyPublicParameReqVO.newBuilder().version("1.0").app_id(appid).mch_uid(mchuid).charset("UTF-8").timestamp(format).sign_type("MD5").build();
        return build;
    }

    private BaseResponse startHyPay(HyPublicParameReqVO hyPublicParameReqVO, RequestCreateOrderVo requestCreateOrderVo, MchChan mchChan, String orderViewId) {
        try {
            HyPayCreateOrderReqVO biz_content = new HyPayCreateOrderReqVO(requestCreateOrderVo, mchChan, orderViewId, this.refundNotifyUrl);
            String jsonString = JSONObject.toJSONString((Object)biz_content);
            log.info("\u652f\u4ed8\u65b9\u6cd5:**********************");
            hyPublicParameReqVO.setMethod("heemoney.pay.applypay");
            hyPublicParameReqVO.setBiz_content(jsonString);
            log.info("************************" + hyPublicParameReqVO.toString() + "****************");
            String param = mchChan.getParam();
            WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
            boolean reqVOSign = hyPublicParameReqVO.createSign(hyParam.getHyApplyKey());
            if (!reqVOSign) {
                return BaseResponse.error((String)" [\u6c47\u4ed8\u5b9d] \u52a0\u7b7e\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String url = "https://pay.heemoney.com/v1/ApplyPay";
            JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
            log.info(" [\u6c47\u4ed8\u5b9d] \u652f\u4ed8\u8fd4\u56de:{}", (Object)jsonObject);
            HyPayCreateOrderRespVO orderRespVO = (HyPayCreateOrderRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyPayCreateOrderRespVO.class);
            return BaseResponse.success((Object)orderRespVO);
        }
        catch (Exception e) {
            log.info(" [\u6c47\u4ed8\u5b9d] \u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
            return BaseResponse.error((String)(" [\u6c47\u4ed8\u5b9d] \u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{" + e.getMessage() + "}"));
        }
    }

    private HyQueryOrderRespVO queryHyPayBill(PayBill payBill, HyPublicParameReqVO hyPublicParameReqVO, MchChan mchChan) {
        HyQueryOrderRespVO orderRespVO = new HyQueryOrderRespVO();
        try {
            HyQueryOrderReqVO biz_content = new HyQueryOrderReqVO(payBill);
            String jsonString = JSONObject.toJSONString((Object)biz_content);
            hyPublicParameReqVO.setMethod("heemoney.pay.query");
            hyPublicParameReqVO.setBiz_content(jsonString);
            String param = mchChan.getParam();
            WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
            boolean reqVOSign = hyPublicParameReqVO.createSign(hyParam.getHyApplyKey());
            if (!reqVOSign) {
                return new HyQueryOrderRespVO(" [\u6c47\u4ed8\u5b9d] \u67e5\u8be2\u8ba2\u5355\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", "CREATE_SIGN_FAIL");
            }
            String url = "https://pay.heemoney.com/v1/payquery";
            JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
            log.info(" [\u6c47\u4ed8\u5b9d] \u8ba2\u5355\u67e5\u8be2\u8fd4\u56de:{}", (Object)jsonObject);
            orderRespVO = (HyQueryOrderRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyQueryOrderRespVO.class);
        }
        catch (Exception e) {
            log.info(" [\u6c47\u4ed8\u5b9d] \u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        return orderRespVO;
    }

    private HyRefundPayOrderRespVO returnHyPay(RequestRefundOrderVo requestRefundOrderVo, HyPublicParameReqVO hyPublicParameReqVO, MchChan mchChan) {
        HyRefundPayOrderReqVO biz_content = new HyRefundPayOrderReqVO(requestRefundOrderVo);
        biz_content.setRefund_fee(requestRefundOrderVo.getRefundAmount().intValue());
        biz_content.setTotal_fee(requestRefundOrderVo.getTotalAmount().intValue());
        String jsonString = JSONObject.toJSONString((Object)biz_content);
        hyPublicParameReqVO.setMethod("heemoney.pay.refund");
        hyPublicParameReqVO.setBiz_content(jsonString);
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        boolean reqVOSign = hyPublicParameReqVO.createSign(hyParam.getHyApplyKey());
        if (!reqVOSign) {
            return new HyRefundPayOrderRespVO(" [\u6c47\u4ed8\u5b9d] \u67e5\u8be2\u8ba2\u5355\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", "CREATE_SIGN_FAIL");
        }
        String url = "https://pay.heemoney.com/v1/refund";
        JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
        log.info("\u6c47\u5143\u9000\u6b3e\u8fd4\u56de:{}", (Object)jsonObject);
        HyRefundPayOrderRespVO orderRespVO = (HyRefundPayOrderRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyRefundPayOrderRespVO.class);
        return orderRespVO;
    }

    private HyQueryRefundOrderRespVO queryRefundOrderHy(PayBill payBill, HyPublicParameReqVO hyPublicParameReqVO, MchChan mchChan) {
        HyQueryRefundOrderRespVO orderRespVO = new HyQueryRefundOrderRespVO();
        try {
            HyQueryRefundOrderReqVO biz_content = new HyQueryRefundOrderReqVO(payBill);
            String jsonString = JSONObject.toJSONString((Object)biz_content);
            hyPublicParameReqVO.setMethod("heemoney.pay.refund.query");
            hyPublicParameReqVO.setBiz_content(jsonString);
            String param = mchChan.getParam();
            WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
            boolean reqVOSign = hyPublicParameReqVO.createSign(hyParam.getHyApplyKey());
            if (!reqVOSign) {
                return new HyQueryRefundOrderRespVO(" [\u6c47\u4ed8\u5b9d] \u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", "CREATE_SIGN_FAIL");
            }
            String url = "https://pay.heemoney.com/v1/refundquery";
            JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
            log.info(" [\u6c47\u4ed8\u5b9d] \u8ba2\u5355\u67e5\u8be2\u9000\u6b3e\u8fd4\u56de:{}", (Object)jsonObject);
            orderRespVO = (HyQueryRefundOrderRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyQueryRefundOrderRespVO.class);
        }
        catch (Exception e) {
            log.info(" [\u6c47\u4ed8\u5b9d] \u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        return orderRespVO;
    }

    public static BaseResponse HyProfitSharing(HyPublicParameReqVO hyPublicParameReqVO, String hyApplyKey) {
        try {
            String key = "E90468C1AB9E4CA4B6175DFD";
            HyProfitSharingReqVO biz_content = new HyProfitSharingReqVO();
            biz_content.setOut_trade_no("HY7684824769323");
            biz_content.setHy_bill_no("2101251520718421642027001630");
            ProfitSharingDTO profitSharingDTO = new ProfitSharingDTO();
            profitSharingDTO.setLogin_account("15210547569");
            profitSharingDTO.setAllot_amt_fen("2.99");
            ProfitSharingDTO profitSharingDTO2 = new ProfitSharingDTO();
            profitSharingDTO2.setLogin_account("baiyiyun");
            profitSharingDTO2.setAllot_amt_fen("0.99");
            ArrayList<ProfitSharingDTO> dtoList = new ArrayList<ProfitSharingDTO>();
            dtoList.add(profitSharingDTO);
            biz_content.setAllot_data(JSONObject.toJSONString(dtoList));
            String jsonString = JSONObject.toJSONString((Object)biz_content);
            hyPublicParameReqVO.setBiz_content(jsonString);
            hyPublicParameReqVO.setMethod("heemoney.guaranteeallot.submit");
            boolean reqVOSign = hyPublicParameReqVO.createSign(key);
            if (!reqVOSign) {
                return BaseResponse.error((String)" [\u6c47\u4ed8\u5b9d] \u5206\u6da6\u8ba2\u5355\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String url = "https://pay.heemoney.com/v1/GuaranteeAllot";
            JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
            log.info("\u6c47\u5143\u5206\u6da6\u8fd4\u56de:{}", (Object)jsonObject);
            HyPayCreateOrderRespVO hyPayCreateOrderRespVO = (HyPayCreateOrderRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyPayCreateOrderRespVO.class);
        }
        catch (Exception e) {
            log.info(" [\u6c47\u4ed8\u5b9d] \u9000\u6b3e\u8ba2\u5355\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{}", (Object)e.getMessage());
            return BaseResponse.error((String)("[\u6c47\u4ed8\u5b9d] \u9000\u6b3e\u8ba2\u5355\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{" + e.getMessage() + "}"));
        }
        return BaseResponse.error((String)"");
    }

    public static void queryHyProfitSharing() {
        String key = "BA67E9DB7F7E461A81E39DD8";
        HyPublicParameReqVO hyPublicParameReqVO = new HyPublicParameReqVO();
        hyPublicParameReqVO.setApp_id("hyp2101274202700000340614B477B3A");
        hyPublicParameReqVO.setMch_uid("4202702128401");
        hyPublicParameReqVO.setMethod("heemoney.guaranteeallot.query.remain");
        hyPublicParameReqVO.setCharset("UTF-8");
        hyPublicParameReqVO.setVersion("1.0");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = df.format(new Date());
        hyPublicParameReqVO.setTimestamp(format);
        hyPublicParameReqVO.setSign_type("MD5");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hy_bill_no", "2103251748309821742027001492");
        map.put("out_trade_no", "1616665668254589");
        String jsonString = JSONObject.toJSONString(map);
        hyPublicParameReqVO.setBiz_content(jsonString);
        StringBuilder builder = new StringBuilder();
        builder.append("app_id").append("=").append("hyp2101124202700000335633FECAE8D").append("&").append("biz_content").append("=").append(jsonString).append("&").append("charset").append("=").append("UTF-8").append("&").append("mch_uid").append("=").append("4202702128240").append("&").append("method").append("=").append("heemoney.guaranteeallot.query.remain").append("&").append("sign_type").append("=").append("MD5").append("&").append("timestamp").append("=").append(format).append("&").append("version").append("=").append("1.0").append("&").append("key").append("=").append(key);
        log.info("\u7b7e\u540d\u53c2\u6570\uff1a" + builder.toString());
        String sign = Md5Utils.MD5en((String)builder.toString()).toUpperCase();
        hyPublicParameReqVO.setSign(sign);
        String url = "https://pay.heemoney.com/v1/GuaranteeAllot";
        JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
        log.info("\u6c47\u5143\u5206\u6da6\u8fd4\u56de:{}", (Object)jsonObject);
        HyPayCreateOrderRespVO orderRespVO = (HyPayCreateOrderRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyPayCreateOrderRespVO.class);
    }

    public static void main(String[] args) {
        RequestCreateOrderVo createOrderVo = new RequestCreateOrderVo();
        HyPayTrade.queryHyProfitSharing();
    }

    public BaseResponse createOrders(HttpServletRequest request, RequestCreateOrderVo requestCreateOrderVo) {
        String orderViewId = null;
        String redisKey = null;
        log.info("\u8bf7\u6c42\u65b9\u6cd5**********");
        try {
            log.info("\u5165\u53c2:{}", (Object)requestCreateOrderVo.toString());
            redisKey = requestCreateOrderVo.getServiceCode() + "_" + requestCreateOrderVo.getOutTradeNo();
            if (BigDecimal.ZERO.compareTo(requestCreateOrderVo.getTotalAmount()) >= 0) {
                return BaseResponse.error((String)"\u8ba2\u5355\u91d1\u989d\u5f02\u5e38");
            }
            PayBill pb = this.payBillService.getByOutTradeNoAndStatus(requestCreateOrderVo.getOutTradeNo(), OrderStatusEnum.PAID.getValue());
            if (null != pb) {
                return BaseResponse.error((String)"\u5df2\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            orderViewId = UniqueKeyGenerator.generateViewId();
            PayBill payBill = this.payBillService.getByCreateOrder(requestCreateOrderVo);
            log.info("\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
            payBill.setDealTradeNo(orderViewId);
            log.info("orderViewId**********" + orderViewId);
            log.info("createOrders****update***");
            PayBill payBill1 = this.payBillService.getByOutTradeNo(requestCreateOrderVo.getOutTradeNo());
            log.info("\u67e5\u8be2\u7684\u8ba2\u5355\u4fe1\u606f" + payBill1.toString());
            payBill.setId(payBill1.getId());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(orderViewId, requestCreateOrderVo.getServiceCode(), RecordsEnum.DID_NOT_PAY);
            MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
            String param = mchChan.getParam();
            WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
            HyPublicParameReqVO publicParameReqVO = this.pubilcParamCompose(hyParam.getHyApplyId(), hyParam.getUHyId());
            BaseResponse baseResponse = this.startHyPay(publicParameReqVO, requestCreateOrderVo, mchChan, orderViewId);
            if (WechatTradeTypeEnum.JSPAI.getDisplay().equals(requestCreateOrderVo.getPayType())) {
                HyPayCreateOrderRespVO respVO = (HyPayCreateOrderRespVO)baseResponse.getData();
                String params = respVO.getHy_js_auth_pay_url();
                return BaseResponse.success((Object)params);
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u9884\u652f\u4ed8\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u5f02\u5e38\u539f\u56e0:{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{orderViewId, e.getMessage(), e});
            this.redisTemplateService.del(redisKey);
            return BaseResponse.error((String)("\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage()));
        }
    }

    public void afterPropertiesSet() throws Exception {
        PayFactory.register((String)PayChanEnum.MYBANK.getDisplay(), (TradeService)this);
    }
}

