/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.ebaiyihui.aggregation.payment.common.vo.BusinessDataVO;
import com.ebaiyihui.aggregation.payment.common.vo.ConfigKeyVO;
import com.ebaiyihui.aggregation.payment.common.vo.CountVO;
import com.ebaiyihui.aggregation.payment.common.vo.GoodsVO;
import com.ebaiyihui.aggregation.payment.common.vo.ListVO;
import com.ebaiyihui.aggregation.payment.common.vo.MerchantPurchaseVO;
import com.ebaiyihui.aggregation.payment.common.vo.QualificationsVO;
import com.ebaiyihui.aggregation.payment.common.vo.QueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.SettlementBankAccountVO;
import com.ebaiyihui.aggregation.payment.common.vo.SettlementRulesVO;
import com.ebaiyihui.aggregation.payment.common.vo.SubjectDataVO;
import com.ebaiyihui.aggregation.payment.common.vo.SuperAdministratorInformationVO;
import com.ebaiyihui.aggregation.payment.common.vo.SupplementaryMaterialsVO;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyMentStateEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.MerchantPurchaseMapper;
import com.ebaiyihui.aggregation.payment.server.service.MerchantPurchaseService;
import com.ebaiyihui.aggregation.payment.server.service.impl.MerchantPurchaseServiceImpl;
import com.ebaiyihui.aggregation.payment.server.utils.PagingUtils;
import com.ebaiyihui.framework.page.PageResult;
import com.github.binarywang.wxpay.bean.applyment.WxPayApplyment4SubCreateRequest;
import com.github.binarywang.wxpay.bean.applyment.enums.ApplymentStateEnum;
import com.github.binarywang.wxpay.bean.applyment.enums.BankAccountTypeEnum;
import com.github.binarywang.wxpay.bean.applyment.enums.CertTypeEnum;
import com.github.binarywang.wxpay.bean.applyment.enums.IdTypeEnum;
import com.github.binarywang.wxpay.bean.applyment.enums.SalesScenesTypeEnum;
import com.github.binarywang.wxpay.bean.applyment.enums.SubjectTypeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="MerchantPurchaseService")
public class MerchantPurchaseServiceImpl
implements MerchantPurchaseService {
    @Resource
    MerchantPurchaseMapper merchantPurchaseMapper;

    public PageResult<ListVO> listQuery(ListVO listVO) {
        PageResult result = new PageResult();
        List listDisplay = null;
        listDisplay = !StringUtils.isEmpty((Object)listVO.getQueryInfo()) ? this.merchantPurchaseMapper.selectByQueryInfo(listVO.getQueryInfo()) : (!StringUtils.isEmpty((Object)listVO.getStartTime()) && !StringUtils.isEmpty((Object)listVO.getEndTime()) ? (!StringUtils.isEmpty((Object)listVO.getStatus()) ? (!StringUtils.isEmpty((Object)listVO.getMerchantType()) ? this.merchantPurchaseMapper.selectListDisplayByInfo(listVO.getStartTime(), listVO.getEndTime(), listVO.getMerchantType(), listVO.getStatus().intValue()) : this.merchantPurchaseMapper.selectListDisplayByInfos(listVO.getStartTime(), listVO.getEndTime(), listVO.getStatus().intValue())) : (!StringUtils.isEmpty((Object)listVO.getMerchantType()) ? this.merchantPurchaseMapper.selectWithoutStatus(listVO.getStartTime(), listVO.getEndTime(), listVO.getMerchantType()) : this.merchantPurchaseMapper.selectWithoutSta(listVO.getStartTime(), listVO.getEndTime()))) : (!StringUtils.isEmpty((Object)listVO.getStatus()) ? (!StringUtils.isEmpty((Object)listVO.getMerchantType()) ? this.merchantPurchaseMapper.selectWithout(listVO.getMerchantType(), listVO.getStatus().intValue()) : this.merchantPurchaseMapper.selectWithouts(listVO.getStatus().intValue())) : (!StringUtils.isEmpty((Object)listVO.getMerchantType()) ? this.merchantPurchaseMapper.selectWithoutTimeStatus(listVO.getMerchantType()) : this.merchantPurchaseMapper.selectListDisplay())));
        result = PagingUtils.paging((Integer)listVO.getPageNum(), (List)listDisplay, (Integer)listVO.getPageSize());
        return result;
    }

    public List<CountVO> countList() {
        return this.merchantPurchaseMapper.countList();
    }

    public void fixList(String subMchid, String uuid) {
        this.merchantPurchaseMapper.updateList(subMchid, uuid);
    }

    public void fix(String applymentId, int status, String uuid) {
        this.merchantPurchaseMapper.updateDisplay(applymentId, status, uuid);
    }

    public void updateStatus(ApplymentStateEnum applymentState, String uuid, String subMchid) {
        int resultState;
        int state = 0;
        switch (1.$SwitchMap$com$github$binarywang$wxpay$bean$applyment$enums$ApplymentStateEnum[applymentState.ordinal()]) {
            case 1: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_EDITTING.getIndex();
                break;
            }
            case 2: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_AUDITING.getIndex();
                break;
            }
            case 3: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_REJECTED.getIndex();
                break;
            }
            case 4: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_TO_BE_CONFIRMED.getIndex();
                break;
            }
            case 5: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_TO_BE_SIGNED.getIndex();
                break;
            }
            case 6: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_SIGNING.getIndex();
                break;
            }
            case 7: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_FINISHED.getIndex();
                break;
            }
            case 8: {
                state = ApplyMentStateEnum.APPLYMENT_STATE_CANCELED.getIndex();
            }
        }
        if (state > 0 && state != (resultState = this.merchantPurchaseMapper.selectDisplayByIdAndMerchantId(uuid).intValue())) {
            this.merchantPurchaseMapper.updateDisplayByStatus(uuid, state, subMchid);
        }
    }

    public List<String> accountTypeQuery() {
        return this.merchantPurchaseMapper.selectBankName();
    }

    public List<String> otherBank() {
        return this.merchantPurchaseMapper.selectOtherBank();
    }

    public List<GoodsVO> selectGoods() {
        return this.merchantPurchaseMapper.selectGoodsName();
    }

    public List<QualificationsVO> settlementRulesIdQuery(String settlementRulesId) {
        return this.merchantPurchaseMapper.selectSpecialQualification(settlementRulesId);
    }

    public List<QueryVO> queryBySubjectType(String subjectType) {
        return this.merchantPurchaseMapper.selectBySubjectType(subjectType);
    }

    public List<String> provinceCityQuery(String city, String bankName) {
        for (int i = 0; i < city.length(); ++i) {
            if (!city.split("")[i].equals("\u5e02")) continue;
            city = city.substring(0, i);
        }
        return this.merchantPurchaseMapper.selectByProvinceAndCity(city, bankName);
    }

    public void insertDraft(MerchantPurchaseVO merchantPurchaseVO, String uuid) {
        if (merchantPurchaseVO.getType().equals("subject") && !StringUtils.isEmpty((Object)merchantPurchaseVO.getSubjectDataVO())) {
            merchantPurchaseVO.getSubjectDataVO().setUuid(uuid);
            merchantPurchaseVO.getSubjectDataVO().setBusinessCode(uuid);
            merchantPurchaseVO.getSubjectDataVO().setType(merchantPurchaseVO.getType());
            this.merchantPurchaseMapper.insertSubjectData(merchantPurchaseVO.getSubjectDataVO());
            ListVO isListAlive = this.merchantPurchaseMapper.selectListDisplayById(uuid);
            if (!StringUtils.isEmpty((Object)merchantPurchaseVO.getSubjectDataVO().getBusinessLicenseInfoMerchantName())) {
                merchantPurchaseVO.getListVO().setBusinessLicenseInfoMerchantName(merchantPurchaseVO.getSubjectDataVO().getBusinessLicenseInfoMerchantName());
            }
            merchantPurchaseVO.getListVO().setMerchantId(merchantPurchaseVO.getMerchantId());
            if (StringUtils.isEmpty((Object)isListAlive)) {
                merchantPurchaseVO.getListVO().setUuid(uuid);
                this.merchantPurchaseMapper.insertListDisplay(merchantPurchaseVO.getListVO());
            } else if (!StringUtils.isEmpty((Object)merchantPurchaseVO.getListVO().getBusinessLicenseInfoMerchantName())) {
                this.merchantPurchaseMapper.updateListDisplay(merchantPurchaseVO.getListVO().getBusinessLicenseInfoMerchantName(), uuid);
            }
        } else if (merchantPurchaseVO.getType().equals("business") && !StringUtils.isEmpty((Object)merchantPurchaseVO.getBusinessDataVO())) {
            merchantPurchaseVO.getBusinessDataVO().setUuid(uuid);
            merchantPurchaseVO.getBusinessDataVO().setType(merchantPurchaseVO.getType());
            this.merchantPurchaseMapper.insertBusinessData(merchantPurchaseVO.getBusinessDataVO());
            this.selectIfAlive(merchantPurchaseVO, uuid);
        } else if (merchantPurchaseVO.getType().equals("settlementRules") && !StringUtils.isEmpty((Object)merchantPurchaseVO.getSettlementRulesVO())) {
            merchantPurchaseVO.getSettlementRulesVO().setUuid(uuid);
            merchantPurchaseVO.getSettlementRulesVO().setType(merchantPurchaseVO.getType());
            this.merchantPurchaseMapper.insertSettlementRules(merchantPurchaseVO.getSettlementRulesVO());
            this.selectIfAlive(merchantPurchaseVO, uuid);
        } else if (merchantPurchaseVO.getType().equals("settlementBank") && !StringUtils.isEmpty((Object)merchantPurchaseVO.getSettlementBankAccountVO())) {
            merchantPurchaseVO.getSettlementBankAccountVO().setUuid(uuid);
            merchantPurchaseVO.getSettlementBankAccountVO().setType(merchantPurchaseVO.getType());
            this.merchantPurchaseMapper.insertSettlementBankAccount(merchantPurchaseVO.getSettlementBankAccountVO());
            this.selectIfAlive(merchantPurchaseVO, uuid);
        } else if (merchantPurchaseVO.getType().equals("superAdministrator") && !StringUtils.isEmpty((Object)merchantPurchaseVO.getSuperAdministratorInformationVO())) {
            merchantPurchaseVO.getSuperAdministratorInformationVO().setUuid(uuid);
            merchantPurchaseVO.getSuperAdministratorInformationVO().setType(merchantPurchaseVO.getType());
            this.merchantPurchaseMapper.insertSuperAdministratorInformation(merchantPurchaseVO.getSuperAdministratorInformationVO());
            ListVO isListAlive = this.merchantPurchaseMapper.selectListDisplayById(uuid);
            if (!StringUtils.isEmpty((Object)merchantPurchaseVO.getSuperAdministratorInformationVO().getContactName())) {
                merchantPurchaseVO.getListVO().setContactName(merchantPurchaseVO.getSuperAdministratorInformationVO().getContactName());
            }
            merchantPurchaseVO.getListVO().setMerchantId(merchantPurchaseVO.getMerchantId());
            if (StringUtils.isEmpty((Object)isListAlive)) {
                merchantPurchaseVO.getListVO().setUuid(uuid);
                this.merchantPurchaseMapper.insertListDisplay(merchantPurchaseVO.getListVO());
            } else if (!StringUtils.isEmpty((Object)merchantPurchaseVO.getSuperAdministratorInformationVO().getContactName())) {
                this.merchantPurchaseMapper.updateListDisplays(merchantPurchaseVO.getListVO().getContactName(), uuid);
            }
        } else if (merchantPurchaseVO.getType().equals("supplementary") && !StringUtils.isEmpty((Object)merchantPurchaseVO.getSupplementaryMaterialsVO())) {
            merchantPurchaseVO.getSupplementaryMaterialsVO().setUuid(uuid);
            merchantPurchaseVO.getSupplementaryMaterialsVO().setType(merchantPurchaseVO.getType());
            this.merchantPurchaseMapper.insertSupplementaryMaterials(merchantPurchaseVO.getSupplementaryMaterialsVO());
            this.selectIfAlive(merchantPurchaseVO, uuid);
        }
    }

    private void selectIfAlive(MerchantPurchaseVO merchantPurchaseVO, String uuid) {
        ListVO isListAlive = this.merchantPurchaseMapper.selectListDisplayById(uuid);
        merchantPurchaseVO.getListVO().setMerchantId(merchantPurchaseVO.getMerchantId());
        if (StringUtils.isEmpty((Object)isListAlive)) {
            merchantPurchaseVO.getListVO().setUuid(uuid);
            this.merchantPurchaseMapper.insertListDisplay(merchantPurchaseVO.getListVO());
        }
    }

    public MerchantPurchaseVO showDraft(String uuid) {
        SubjectDataVO subjectDataVO = this.merchantPurchaseMapper.selectSubjectData(uuid);
        BusinessDataVO businessDataVO = this.merchantPurchaseMapper.selectBusinessData(uuid);
        SettlementRulesVO settlementRules = this.merchantPurchaseMapper.selectSettlementRules(uuid);
        SettlementBankAccountVO settlementBankAccount = this.merchantPurchaseMapper.selectSettlementBankAccount(uuid);
        SuperAdministratorInformationVO superAdminInfo = this.merchantPurchaseMapper.selectSuperAdminInfo(uuid);
        SupplementaryMaterialsVO supplementaryMaterials = this.merchantPurchaseMapper.selectSupplementaryMaterials(uuid);
        ListVO listVO = this.merchantPurchaseMapper.selectListDisplayById(uuid);
        MerchantPurchaseVO merchantPurchaseVO = new MerchantPurchaseVO();
        merchantPurchaseVO.setSubjectDataVO(subjectDataVO);
        merchantPurchaseVO.setBusinessDataVO(businessDataVO);
        merchantPurchaseVO.setSettlementRulesVO(settlementRules);
        merchantPurchaseVO.setSettlementBankAccountVO(settlementBankAccount);
        merchantPurchaseVO.setSuperAdministratorInformationVO(superAdminInfo);
        merchantPurchaseVO.setSupplementaryMaterialsVO(supplementaryMaterials);
        merchantPurchaseVO.setListVO(listVO);
        return merchantPurchaseVO;
    }

    public void deleteDraft(String uuid, String type) {
        if (type.equals("subject")) {
            this.merchantPurchaseMapper.deleteSubjectData(uuid);
        } else if (type.equals("business")) {
            this.merchantPurchaseMapper.deleteBusinessData(uuid);
        } else if (type.equals("settlementRules")) {
            this.merchantPurchaseMapper.deleteSettlementRules(uuid);
        } else if (type.equals("settlementBank")) {
            this.merchantPurchaseMapper.deleteSettlementBankAccount(uuid);
        } else if (type.equals("superAdministrator")) {
            this.merchantPurchaseMapper.deleteSuperAdminInfo(uuid);
        } else if (type.equals("supplementary")) {
            this.merchantPurchaseMapper.deleteSupplementaryMaterials(uuid);
        }
    }

    public WxPayApplyment4SubCreateRequest.ContactInfo contactInfo(SuperAdministratorInformationVO superAdministratorInformationVO) {
        WxPayApplyment4SubCreateRequest.ContactInfo contactInfo = new WxPayApplyment4SubCreateRequest.ContactInfo();
        if (!StringUtils.isEmpty((Object)superAdministratorInformationVO.getContactName())) {
            contactInfo.setContactName(superAdministratorInformationVO.getContactName());
        }
        if (!StringUtils.isEmpty((Object)superAdministratorInformationVO.getContactIdNumber())) {
            contactInfo.setContactIdNumber(superAdministratorInformationVO.getContactIdNumber());
        }
        if (!StringUtils.isEmpty((Object)superAdministratorInformationVO.getOpenid())) {
            contactInfo.setOpenid(superAdministratorInformationVO.getOpenid());
        }
        if (!StringUtils.isEmpty((Object)superAdministratorInformationVO.getMobilePhone())) {
            contactInfo.setMobilePhone(superAdministratorInformationVO.getMobilePhone());
        }
        if (!StringUtils.isEmpty((Object)superAdministratorInformationVO.getContactEmail())) {
            contactInfo.setContactEmail(superAdministratorInformationVO.getContactEmail());
        }
        return contactInfo;
    }

    public WxPayApplyment4SubCreateRequest.SubjectInfo subjectInfo(SubjectDataVO subjectDataVO) {
        WxPayApplyment4SubCreateRequest.SubjectInfo.BusinessLicenseInfo businessLicenseInfo = new WxPayApplyment4SubCreateRequest.SubjectInfo.BusinessLicenseInfo();
        if (!StringUtils.isEmpty((Object)subjectDataVO.getLicenseCopyMedia())) {
            businessLicenseInfo.setLicenseCopy(subjectDataVO.getLicenseCopyMedia());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getLicenseNumber())) {
            businessLicenseInfo.setLicenseNumber(subjectDataVO.getLicenseNumber());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getBusinessLicenseInfoMerchantName())) {
            businessLicenseInfo.setMerchantName(subjectDataVO.getBusinessLicenseInfoMerchantName());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getBusinessLicenseInfoLegalPerson())) {
            businessLicenseInfo.setLegalPerson(subjectDataVO.getBusinessLicenseInfoLegalPerson());
        }
        WxPayApplyment4SubCreateRequest.SubjectInfo.CertificateInfo certificateInfo = new WxPayApplyment4SubCreateRequest.SubjectInfo.CertificateInfo();
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCertCopyMedia())) {
            certificateInfo.setCertCopy(subjectDataVO.getCertCopyMedia());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCertType())) {
            certificateInfo.setCertType(CertTypeEnum.valueOf((String)subjectDataVO.getCertType()));
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCertNumber())) {
            certificateInfo.setCertNumber(subjectDataVO.getCertNumber());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCertificateInfoMerchantName())) {
            certificateInfo.setMerchantName(subjectDataVO.getCertificateInfoMerchantName());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCompanyAddress())) {
            certificateInfo.setCompanyAddress(subjectDataVO.getCompanyAddress());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCertificateInfoLegalPerson())) {
            certificateInfo.setLegalPerson(subjectDataVO.getCertificateInfoLegalPerson());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getPeriodBegin())) {
            certificateInfo.setPeriodBegin(subjectDataVO.getPeriodBegin());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getPeriodEnd())) {
            certificateInfo.setPeriodEnd(subjectDataVO.getPeriodEnd());
        }
        WxPayApplyment4SubCreateRequest.SubjectInfo.OrganizationInfo organizationInfo = new WxPayApplyment4SubCreateRequest.SubjectInfo.OrganizationInfo();
        if (!StringUtils.isEmpty((Object)subjectDataVO.getOrganizationCopyMedia())) {
            organizationInfo.setOrganizationCopy(subjectDataVO.getOrganizationCopyMedia());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getOrganizationCode())) {
            organizationInfo.setOrganizationCode(subjectDataVO.getOrganizationCode());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getOrgPeriodBegin())) {
            organizationInfo.setOrgPeriodBegin(subjectDataVO.getOrgPeriodBegin());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getOrgPeriodEnd())) {
            organizationInfo.setOrgPeriodEnd(subjectDataVO.getOrgPeriodEnd());
        }
        WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdCardInfo idCardInfo = new WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdCardInfo();
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdCardInfoIdCardCopyMedia())) {
            idCardInfo.setIdCardCopy(subjectDataVO.getIdCardInfoIdCardCopyMedia());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdCardInfoIdCardNationalMedia())) {
            idCardInfo.setIdCardNational(subjectDataVO.getIdCardInfoIdCardNationalMedia());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdCardName())) {
            idCardInfo.setIdCardName(subjectDataVO.getIdCardName());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdCardNumber())) {
            idCardInfo.setIdCardNumber(subjectDataVO.getIdCardNumber());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCardPeriodBegin())) {
            idCardInfo.setCardPeriodBegin(subjectDataVO.getCardPeriodBegin());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCardPeriodEnd())) {
            idCardInfo.setCardPeriodEnd(subjectDataVO.getCardPeriodEnd());
        }
        WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdDocInfo idDocInfo = new WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo.IdDocInfo();
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdDocInfoIdDocCopyMedia())) {
            idDocInfo.setIdDocCopy(subjectDataVO.getIdDocInfoIdDocCopyMedia());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdDocName())) {
            idDocInfo.setIdDocName(subjectDataVO.getIdDocName());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdDocNumber())) {
            idDocInfo.setIdDocNumber(subjectDataVO.getIdDocNumber());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getDocPeriodBegin())) {
            idDocInfo.setDocPeriodBegin(subjectDataVO.getDocPeriodBegin());
        }
        if (!StringUtils.isEmpty((Object)subjectDataVO.getDocPeriodEnd())) {
            idDocInfo.setDocPeriodEnd(subjectDataVO.getDocPeriodEnd());
        }
        WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo identityInfo = new WxPayApplyment4SubCreateRequest.SubjectInfo.IdentityInfo();
        if (!StringUtils.isEmpty((Object)subjectDataVO.getIdDocType())) {
            identityInfo.setIdDocType(IdTypeEnum.valueOf((String)subjectDataVO.getIdDocType()));
        }
        identityInfo.setIdCardInfo(idCardInfo);
        identityInfo.setIdDocInfo(idDocInfo);
        if (!StringUtils.isEmpty((Object)subjectDataVO.getOwner())) {
            identityInfo.setOwner(Boolean.valueOf(Boolean.parseBoolean(subjectDataVO.getOwner())));
        }
        WxPayApplyment4SubCreateRequest.SubjectInfo subjectInfo = new WxPayApplyment4SubCreateRequest.SubjectInfo();
        if (!StringUtils.isEmpty((Object)subjectDataVO.getSubjectType())) {
            subjectInfo.setSubjectType(SubjectTypeEnum.valueOf((String)subjectDataVO.getSubjectType()));
        }
        subjectInfo.setBusinessLicenseInfo(businessLicenseInfo);
        subjectInfo.setCertificateInfo(certificateInfo);
        subjectInfo.setOrganizationInfo(organizationInfo);
        if (!StringUtils.isEmpty((Object)subjectDataVO.getCertificateLetterCopyMedia())) {
            subjectInfo.setCertificateLetterCopy(subjectDataVO.getCertificateLetterCopyMedia());
        }
        subjectInfo.setIdentityInfo(identityInfo);
        return subjectInfo;
    }

    public WxPayApplyment4SubCreateRequest.BusinessInfo businessInfo(BusinessDataVO businessDataVO) {
        ArrayList<String> storeEntrancePic = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)businessDataVO.getStoreEntrancePicMedia())) {
            storeEntrancePic.add(businessDataVO.getStoreEntrancePicMedia());
        }
        ArrayList<String> indoorPic = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)businessDataVO.getIndoorPicMedia())) {
            indoorPic.add(businessDataVO.getIndoorPicMedia());
        }
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.BizStoreInfo bizStoreInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.BizStoreInfo();
        if (!StringUtils.isEmpty((Object)businessDataVO.getBizStoreName())) {
            bizStoreInfo.setBizStoreName(businessDataVO.getBizStoreName());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getBizAddressCode())) {
            bizStoreInfo.setBizAddressCode(businessDataVO.getBizAddressCode());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getBizStoreAddress())) {
            bizStoreInfo.setBizStoreAddress(businessDataVO.getBizStoreAddress());
        }
        bizStoreInfo.setStoreEntrancePic(storeEntrancePic);
        bizStoreInfo.setIndoorPic(indoorPic);
        if (!StringUtils.isEmpty((Object)businessDataVO.getBizSubAppid())) {
            bizStoreInfo.setBizSubAppid(businessDataVO.getBizSubAppid());
        }
        ArrayList<String> mpPics = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)businessDataVO.getMpPics())) {
            mpPics.add(businessDataVO.getMpPics());
        }
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MpInfo mpInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MpInfo();
        if (!StringUtils.isEmpty((Object)businessDataVO.getMpAppid())) {
            mpInfo.setMpAppid(businessDataVO.getMpAppid());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getMpSubAppid())) {
            mpInfo.setMpSubAppid(businessDataVO.getMpSubAppid());
        }
        mpInfo.setMpPics(mpPics);
        ArrayList<String> miniProgramPics = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)businessDataVO.getMiniProgramPics())) {
            miniProgramPics.add(businessDataVO.getMiniProgramPics());
        }
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MiniProgramInfo miniProgramInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MiniProgramInfo();
        if (!StringUtils.isEmpty((Object)businessDataVO.getMiniProgramAppid())) {
            miniProgramInfo.setMiniProgramAppid(businessDataVO.getMiniProgramAppid());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getMiniProgramSubAppid())) {
            miniProgramInfo.setMiniProgramSubAppid(businessDataVO.getMiniProgramSubAppid());
        }
        miniProgramInfo.setMiniProgramPics(miniProgramPics);
        ArrayList<String> appPics = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)businessDataVO.getAppPics())) {
            appPics.add(businessDataVO.getAppPics());
        }
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.AppInfo appInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.AppInfo();
        if (!StringUtils.isEmpty((Object)businessDataVO.getAppAppid())) {
            appInfo.setAppAppid(businessDataVO.getAppAppid());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getAppSubAppid())) {
            appInfo.setAppSubAppid(businessDataVO.getAppSubAppid());
        }
        appInfo.setAppPics(appPics);
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WebInfo webInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WebInfo();
        if (!StringUtils.isEmpty((Object)businessDataVO.getDomain())) {
            webInfo.setDomain(businessDataVO.getDomain());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getWebAuthorisation())) {
            webInfo.setWebAuthorisation(businessDataVO.getWebAuthorisation());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getWebAppid())) {
            webInfo.setWebAppid(businessDataVO.getWebAppid());
        }
        ArrayList<String> weworkPics = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)businessDataVO.getWeworkPics())) {
            weworkPics.add(businessDataVO.getWeworkPics());
        }
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WeworkInfo weworkInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WeworkInfo();
        if (!StringUtils.isEmpty((Object)businessDataVO.getSubCorpId())) {
            weworkInfo.setSubCorpId(businessDataVO.getSubCorpId());
        }
        weworkInfo.setWeworkPics(weworkPics);
        ArrayList<SalesScenesTypeEnum> salesScenesType = new ArrayList<SalesScenesTypeEnum>();
        if (!StringUtils.isEmpty((Object)businessDataVO.getSalesScenesType())) {
            String str = businessDataVO.getSalesScenesType();
            String[] result = str.split(",");
            for (int i = 0; i < result.length; ++i) {
                salesScenesType.add(SalesScenesTypeEnum.valueOf((String)result[i]));
            }
        }
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo salesInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo();
        salesInfo.setSalesScenesType(salesScenesType);
        salesInfo.setBizStoreInfo(bizStoreInfo);
        salesInfo.setMpInfo(mpInfo);
        salesInfo.setMiniProgramInfo(miniProgramInfo);
        salesInfo.setAppInfo(appInfo);
        salesInfo.setWebInfo(webInfo);
        salesInfo.setWeworkInfo(weworkInfo);
        WxPayApplyment4SubCreateRequest.BusinessInfo businessInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo();
        if (!StringUtils.isEmpty((Object)businessDataVO.getMerchantShortname())) {
            businessInfo.setMerchantShortname(businessDataVO.getMerchantShortname());
        }
        if (!StringUtils.isEmpty((Object)businessDataVO.getServicePhone())) {
            businessInfo.setServicePhone(businessDataVO.getServicePhone());
        }
        businessInfo.setSalesInfo(salesInfo);
        return businessInfo;
    }

    public WxPayApplyment4SubCreateRequest.SettlementInfo settlementInfo(SettlementRulesVO settlementRulesVO) {
        ArrayList<String> qualifications = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)settlementRulesVO.getQualificationsMedia())) {
            qualifications.add(settlementRulesVO.getQualificationsMedia());
        }
        ArrayList<String> activitiesAdditions = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)settlementRulesVO.getActivitiesAdditions())) {
            activitiesAdditions.add(settlementRulesVO.getActivitiesAdditions());
        }
        WxPayApplyment4SubCreateRequest.SettlementInfo settlementInfo = new WxPayApplyment4SubCreateRequest.SettlementInfo();
        if (!StringUtils.isEmpty((Object)settlementRulesVO.getSettlementId())) {
            settlementInfo.setSettlementId(settlementRulesVO.getSettlementId());
        }
        if (!StringUtils.isEmpty((Object)settlementRulesVO.getQualificationType())) {
            settlementInfo.setQualificationType(settlementRulesVO.getQualificationType());
        }
        settlementInfo.setQualifications(qualifications);
        if (!StringUtils.isEmpty((Object)settlementRulesVO.getActivitiesId())) {
            settlementInfo.setActivitiesId(settlementRulesVO.getActivitiesId());
        }
        if (!StringUtils.isEmpty((Object)settlementRulesVO.getActivitiesRate())) {
            settlementInfo.setActivitiesRate(settlementRulesVO.getActivitiesRate());
        }
        settlementInfo.setActivitiesAdditions(activitiesAdditions);
        return settlementInfo;
    }

    public WxPayApplyment4SubCreateRequest.BankAccountInfo bankAccountInfo(SettlementBankAccountVO settlementBankAccountVO) {
        WxPayApplyment4SubCreateRequest.BankAccountInfo bankAccountInfo = new WxPayApplyment4SubCreateRequest.BankAccountInfo();
        if (!StringUtils.isEmpty((Object)settlementBankAccountVO.getBankAccountType())) {
            bankAccountInfo.setBankAccountType(BankAccountTypeEnum.valueOf((String)settlementBankAccountVO.getBankAccountType()));
        }
        if (!StringUtils.isEmpty((Object)settlementBankAccountVO.getAccountName())) {
            bankAccountInfo.setAccountName(settlementBankAccountVO.getAccountName());
        }
        if (!StringUtils.isEmpty((Object)settlementBankAccountVO.getAccountBank())) {
            bankAccountInfo.setAccountBank(settlementBankAccountVO.getAccountBank());
        }
        if (!StringUtils.isEmpty((Object)settlementBankAccountVO.getBankAddressCode())) {
            bankAccountInfo.setBankAddressCode(settlementBankAccountVO.getBankAddressCode());
        }
        if (!StringUtils.isEmpty((Object)settlementBankAccountVO.getBankBranchId())) {
            bankAccountInfo.setBankBranchId(settlementBankAccountVO.getBankBranchId());
        }
        if (!StringUtils.isEmpty((Object)settlementBankAccountVO.getBankName())) {
            bankAccountInfo.setBankName(settlementBankAccountVO.getBankName());
        }
        if (!StringUtils.isEmpty((Object)settlementBankAccountVO.getAccountNumber())) {
            bankAccountInfo.setAccountNumber(settlementBankAccountVO.getAccountNumber());
        }
        return bankAccountInfo;
    }

    public WxPayApplyment4SubCreateRequest.AdditionInfo additionInfo(SupplementaryMaterialsVO supplementaryMaterialsVO) {
        ArrayList<String> businessAdditionPics = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)supplementaryMaterialsVO.getBusinessAdditionPics())) {
            businessAdditionPics.add(supplementaryMaterialsVO.getBusinessAdditionPics());
        }
        WxPayApplyment4SubCreateRequest.AdditionInfo additionInfo = new WxPayApplyment4SubCreateRequest.AdditionInfo();
        if (!StringUtils.isEmpty((Object)supplementaryMaterialsVO.getLegalPersonCommitmentMedia())) {
            additionInfo.setLegalPersonCommitment(supplementaryMaterialsVO.getLegalPersonCommitmentMedia());
        }
        if (!StringUtils.isEmpty((Object)supplementaryMaterialsVO.getLegalPersonVideo())) {
            additionInfo.setLegalPersonVideo(supplementaryMaterialsVO.getLegalPersonVideo());
        }
        additionInfo.setBusinessAdditionPics(businessAdditionPics);
        if (!StringUtils.isEmpty((Object)supplementaryMaterialsVO.getBusinessAdditionPicsMedia())) {
            additionInfo.setBusinessAdditionMsg(supplementaryMaterialsVO.getBusinessAdditionPicsMedia());
        }
        return additionInfo;
    }

    public WxPayApplyment4SubCreateRequest putDataToParam(MerchantPurchaseVO showDraft) {
        WxPayApplyment4SubCreateRequest wxPayApplyment4SubCreateRequest = new WxPayApplyment4SubCreateRequest();
        if (!StringUtils.isEmpty((Object)showDraft.getSubjectDataVO()) && !StringUtils.isEmpty((Object)showDraft.getSubjectDataVO().getBusinessCode())) {
            wxPayApplyment4SubCreateRequest.setBusinessCode(showDraft.getSubjectDataVO().getBusinessCode());
        }
        if (!StringUtils.isEmpty((Object)showDraft.getSubjectDataVO())) {
            wxPayApplyment4SubCreateRequest.setSubjectInfo(this.subjectInfo(showDraft.getSubjectDataVO()));
        }
        if (!StringUtils.isEmpty((Object)showDraft.getBusinessDataVO())) {
            wxPayApplyment4SubCreateRequest.setBusinessInfo(this.businessInfo(showDraft.getBusinessDataVO()));
        }
        if (!StringUtils.isEmpty((Object)showDraft.getSettlementRulesVO())) {
            wxPayApplyment4SubCreateRequest.setSettlementInfo(this.settlementInfo(showDraft.getSettlementRulesVO()));
        }
        if (!StringUtils.isEmpty((Object)showDraft.getSettlementBankAccountVO())) {
            wxPayApplyment4SubCreateRequest.setBankAccountInfo(this.bankAccountInfo(showDraft.getSettlementBankAccountVO()));
        }
        if (!StringUtils.isEmpty((Object)showDraft.getSuperAdministratorInformationVO())) {
            wxPayApplyment4SubCreateRequest.setContactInfo(this.contactInfo(showDraft.getSuperAdministratorInformationVO()));
        }
        if (!StringUtils.isEmpty((Object)showDraft.getSupplementaryMaterialsVO())) {
            wxPayApplyment4SubCreateRequest.setAdditionInfo(this.additionInfo(showDraft.getSupplementaryMaterialsVO()));
        }
        return wxPayApplyment4SubCreateRequest;
    }

    public ConfigKeyVO getConfigKeyVO(String merchantId) {
        return this.merchantPurchaseMapper.selectConfigKey(merchantId);
    }
}

