/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.mybank;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.BaseEntity;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayIsvThird;
import com.ebaiyihui.aggregation.payment.server.addition.Addition;
import com.ebaiyihui.aggregation.payment.server.addition.IAddition;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayIsvThirdMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.MyBankConfigBO;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.SharingSftpBO;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.mybank.AddOrderService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AddOrderServiceImpl
implements AddOrderService {
    private static final Logger log = LoggerFactory.getLogger(AddOrderServiceImpl.class);
    @Resource
    private MchChanMapper mchChanMapper;
    @Resource
    private PayBillService payBillService;
    @Resource
    private PayIsvThirdMapper payIsvThirdMapper;

    @Async
    public BaseResponse saveAddOrder(String outTradeNo) {
        PayBill payBill = this.payBillService.getByOutTradeNo(outTradeNo);
        MchChan mchChan = this.mchChanMapper.selectThirdMchChan(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        if (mchChan == null) {
            return BaseResponse.error((String)"Not configured addition!");
        }
        IAddition iAddition = Addition.get((String)mchChan.getChanCode());
        return iAddition.addOrder(payBill, mchChan);
    }

    public BaseResponse<?> uploadBkcloudfundBill(String totayBilldate) {
        List mchChanList = this.mchChanMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MchChan::getChanCode, (Object)PayChanEnum.MYBANK.getDisplay())).eq(BaseEntity::getStatus, (Object)1));
        if (Objects.isNull(mchChanList) || mchChanList.isEmpty()) {
            log.info("\u7f51\u5546\u67e5\u8be2\u4e3a\u7a7a \u8bf7\u68c0\u67e5\uff01");
            return BaseResponse.success();
        }
        List sftpList = mchChanList.stream().map(mchChan -> {
            MyBankConfigBO myBankConfigBO = (MyBankConfigBO)JSONObject.parseObject((String)mchChan.getParam(), MyBankConfigBO.class);
            SharingSftpBO sharingSftpBO = new SharingSftpBO();
            sharingSftpBO.setIsvOrgId(myBankConfigBO.getIsvOrgId());
            sharingSftpBO.setApplyCode(mchChan.getMchCode());
            return sharingSftpBO;
        }).collect(Collectors.toList());
        List payIsvThirds = this.payIsvThirdMapper.selectListByIsvOrgId(sftpList);
        block0: for (SharingSftpBO sharingSftpBO : sftpList) {
            for (PayIsvThird payIsvThird : payIsvThirds) {
                if (!sharingSftpBO.getIsvOrgId().equals(payIsvThird.getIsvOrgId())) continue;
                sharingSftpBO.setPassword(payIsvThird.getSftpPassword());
                sharingSftpBO.setUserName(payIsvThird.getSftpUserName());
                continue block0;
            }
        }
        Map<String, List<SharingSftpBO>> isvMap = sftpList.stream().collect(Collectors.groupingBy(SharingSftpBO::getIsvOrgId));
        isvMap.entrySet().stream().forEach(map -> {
            IAddition iAddition = Addition.get((String)PayChanEnum.MYBANK.getDisplay());
            String isvOrgId = (String)map.getKey();
            String applyCodeStr = JSONObject.toJSONString(map.getValue());
            log.info("one isv upload applyCodes:{}", (Object)applyCodeStr);
            boolean flag = iAddition.uploadBkcloudBill(totayBilldate, isvOrgId, (List)map.getValue());
            if (flag) {
                log.info("isv upload sftp finished,isvOrgId:{}", (Object)isvOrgId);
            } else {
                log.error("isv upload sftp error,isvOrgId:{}", (Object)isvOrgId);
            }
        });
        return BaseResponse.success();
    }
}

