/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.common.vo.icbc.ICBCNoticeBizContentVo;
import com.ebaiyihui.aggregation.payment.common.vo.icbc.ICBCNoticeReqVo;
import com.ebaiyihui.aggregation.payment.server.constant.URLConstant;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.notify.INotify;
import com.ebaiyihui.aggregation.payment.server.service.notify.NotifyFactory;
import com.ebaiyihui.aggregation.payment.server.service.notify.RabbitMqPusher;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.icbc.api.utils.IcbcSignature;
import com.icbc.api.utils.WebUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ICBCPayNotify
implements INotify,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ICBCPayNotify.class);
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PayApplyService payApplyService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitMqPusher rabbitMqPusher;
    @Autowired
    private URLConstant urlConstant;
    @Autowired
    private PayMchService payMchService;

    public String notify(HttpServletRequest request) {
        log.info("=====\u3010ICBC\u3011\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03=====");
        HashMap<String, String> params = new HashMap<String, String>();
        String from = request.getParameter("from");
        String api = request.getParameter("api");
        String app_id = request.getParameter("app_id");
        String charset = request.getParameter("charset");
        String format = request.getParameter("format");
        String encrypt_type = request.getParameter("encrypt_type");
        String timestamp = request.getParameter("timestamp");
        String biz_content = request.getParameter("biz_content");
        String sign_type = request.getParameter("sign_type");
        String sign = request.getParameter("sign");
        params.put("from", from);
        params.put("api", api);
        params.put("app_id", app_id);
        params.put("charset", charset);
        params.put("format", format);
        params.put("encrypt_type", encrypt_type);
        params.put("timestamp", timestamp);
        params.put("biz_content", biz_content);
        params.put("sign_type", sign_type);
        log.info("===ICBC\u56de\u8c03\u53c2\u6570:{}", (Object)JSONObject.toJSONString(params));
        ICBCNoticeBizContentVo bizContentVo = (ICBCNoticeBizContentVo)JSONObject.parseObject((String)biz_content, ICBCNoticeBizContentVo.class);
        String out_trade_no = bizContentVo.getOut_trade_no();
        String msg_id = bizContentVo.getMsg_id();
        PayBill payBill = this.payBillService.getByOutTradeNo(out_trade_no);
        log.info("===\u6839\u636e\u56de\u8c03\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f:{}", (Object)payBill);
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType())), WxPayParam.class);
        String results = null;
        try {
            String path = "/notify/icbcpaynotify";
            String signStr = WebUtils.buildOrderedSignStr((String)path, params);
            String responseBizContent = null;
            boolean flag = IcbcSignature.verify((String)signStr, (String)sign_type, (String)wxPayParam.getMchPublicKey(), (String)charset, (String)sign);
            if (!flag) {
                log.error("icbc payment notify verify sign error!!");
            } else {
                this.handleBusiness(bizContentVo, payBill);
                int return_code = 0;
                String return_msg = "success.";
                responseBizContent = "{\"return_code\":" + return_code + ",\"return_msg\":\"" + return_msg + "\",\"msg_id\":\"" + msg_id + "\"}";
                signStr = "\"response_biz_content\":" + responseBizContent + ",\"sign_type\":\"RSA2\"";
                sign = IcbcSignature.sign((String)signStr, (String)"RSA2", (String)wxPayParam.getAppPrivateKey(), (String)charset, (String)"12345678");
                results = "{" + signStr + ",\"sign\":\"" + sign + "\"}";
            }
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u901a\u77e5\u5f02\u5e38\uff1ae={}", (Object)e.getMessage());
        }
        return results;
    }

    private void handleBusiness(ICBCNoticeBizContentVo vo, PayBill payBill) {
        try {
            Date date = new Date();
            String payTime = DateUtils.dateToString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            Date payTimeDate = DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime);
            payBill.setTradeNo(vo.getThird_trade_no());
            payBill.setStatus(OrderStatusEnum.PAID.getValue());
            payBill.setPayTime(payTimeDate);
            log.info("\u3010ICBC\u3011\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
            log.info("-------------\u3010ICBC\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
            responseNotifyRestVo.setTradeNo(vo.getThird_trade_no());
            responseNotifyRestVo.setReturnCode("SUCCESS");
            responseNotifyRestVo.setReturnMsg(null);
            responseNotifyRestVo.setResultCode("SUCCESS");
            responseNotifyRestVo.setErrCode(null);
            responseNotifyRestVo.setErrCodeDes(null);
            responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                responseNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseNotifyRestVo.setMchCode(payBill.getMchCode());
            responseNotifyRestVo.setMchId(vo.getMer_id());
            responseNotifyRestVo.setMchName(payMch.getName());
            responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime));
            responseNotifyRestVo.setNotifyResultStr(JSON.toJSONString((Object)vo));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
            log.info("\u3010ICBC\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
            this.rabbitMqPusher.notify("pay", JSON.toJSONString((Object)responseNotifyRestVo));
            String rediskey = payBill.getServiceCode() + "_" + payBill.getOutTradeNo();
            this.redisTemplateService.del(rediskey);
        }
        catch (Exception e) {
            log.error("ICBC\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5f02\u5e38 , e={}", (Object)e.getMessage());
        }
    }

    private ICBCNoticeReqVo queryParam(HttpServletRequest req) {
        String charset = req.getParameter("charset");
        String encryptType = req.getParameter("encrypt_type");
        String bizContentStr = req.getParameter("biz_content");
        String signType = req.getParameter("sign_type");
        String sign = req.getParameter("sign");
        ICBCNoticeBizContentVo bizContent = (ICBCNoticeBizContentVo)JSON.parseObject((String)bizContentStr, ICBCNoticeBizContentVo.class);
        ICBCNoticeReqVo vo = ICBCNoticeReqVo.builder().charset(charset).encrypt_type(encryptType).biz_content(bizContentStr).bizContent(bizContent).sign_type(signType).sign(sign).build();
        return vo;
    }

    public void afterPropertiesSet() throws Exception {
        NotifyFactory.register((String)this.getClass().getSimpleName().toLowerCase(), (INotify)this);
    }
}

