/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.BaseEntity;
import com.ebaiyihui.aggregation.payment.common.model.ChannelBill;
import com.ebaiyihui.aggregation.payment.common.model.ErrorBill;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PlatformBill;
import com.ebaiyihui.aggregation.payment.common.model.Reconciliation;
import com.ebaiyihui.aggregation.payment.common.model.ReconciliationPolymerization;
import com.ebaiyihui.aggregation.payment.common.vo.BaseAliSmsReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.ReWriteBillVO;
import com.ebaiyihui.aggregation.payment.server.enums.ContrastEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.ChannelBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ErrorBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PlatformBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ReconciliationMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ReconciliationPolymerizationMapper;
import com.ebaiyihui.aggregation.payment.server.pojo.BillEnvironmentEntity;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.AReconciliationBill;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationRule;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.BillFilter;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ChannelBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.PlatformBillBO;
import com.ebaiyihui.aggregation.payment.server.utils.PushInfoUtil;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AReconciliationBill {
    private static final Logger log = LoggerFactory.getLogger(AReconciliationBill.class);
    @Resource
    private ErrorBillMapper errorBillMapper;
    @Resource
    private ReconciliationMapper reconciliationMapper;
    @Resource
    private ReconciliationPolymerizationMapper reconciliationPolymerizationMapper;
    @Resource
    MchChanMapper mchChanMapper;
    @Resource
    ChannelBillMapper channelBillMapper;
    @Resource
    PlatformBillMapper platformBillMapper;
    @Resource
    PayBillMapper payBillMapper;
    @Resource
    private PushInfoUtil pushInfoUtil;
    @Value(value="${pay.bill.environment}")
    protected String payEnvironment;

    abstract void saveChannelBill(String var1);

    abstract void savePlatformBill(String var1);

    abstract void reconciliationBill(String var1, String var2);

    protected List<MchChan> uniqAppId(List<MchChan> mchChans) {
        if (mchChans.isEmpty()) {
            return mchChans;
        }
        return mchChans.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(new MchChanApplyCompartor())), ArrayList::new));
    }

    BillFilter filterBill(String attach, String payEnvironment) {
        BillFilter billFilter = new BillFilter();
        if (attach.startsWith("{")) {
            BillEnvironmentEntity billEnvironmentEntity = (BillEnvironmentEntity)JSONObject.parseObject((String)(attach = StringEscapeUtils.unescapeJava((String)attach.replace(' ', ','))), BillEnvironmentEntity.class);
            if (StringUtils.isNotBlank((CharSequence)billEnvironmentEntity.getS())) {
                billFilter.setEnv(Boolean.valueOf(billEnvironmentEntity.getE().equals(payEnvironment)));
                String mark = billEnvironmentEntity.getM();
                int index = mark.lastIndexOf("-");
                String tradeType = mark.substring(index + 1);
                String applyCode = mark.substring(0, index).replace("-".concat(billEnvironmentEntity.getS()), "");
                billFilter.setApplyCode(applyCode);
                billFilter.setServiceCode(billEnvironmentEntity.getS());
                billFilter.setPayType(tradeType);
            } else {
                billFilter.setEnv(Boolean.valueOf(billEnvironmentEntity.getEnv().equals(payEnvironment)));
                String mark = billEnvironmentEntity.getMark();
                int index = mark.lastIndexOf("-");
                String tradeType = mark.substring(index + 1);
                String applyCode = mark.substring(0, index).replace("-".concat(billEnvironmentEntity.getServiceCode()), "");
                billFilter.setApplyCode(applyCode);
                billFilter.setServiceCode(billEnvironmentEntity.getServiceCode());
                billFilter.setPayType(tradeType);
            }
        } else {
            billFilter.setEnv(Boolean.valueOf(false));
        }
        return billFilter;
    }

    public void reconciliationHandler(String billDate, String batchNumber, MchChan mchChan, int errorCount, List<ChannelBill> channelBillList, List<PlatformBill> platformBillList, String channel) {
        if ((errorCount = this.saveErrorBill(billDate, batchNumber, errorCount, channelBillList, platformBillList)) > 0) {
            this.notifyErrorPush(mchChan, "\u9519\u8bef\u8d26\u5355\u6570\u91cf:" + errorCount);
        }
        this.saveReconciliation(billDate, batchNumber, mchChan, channelBillList, platformBillList, errorCount, channel);
    }

    private int saveErrorBill(String billDate, String batchNumber, int errorCount, List<ChannelBill> channelBillList, List<PlatformBill> platformBillList) {
        HashMap paymentMap = new HashMap();
        HashMap refundMap = new HashMap();
        platformBillList.stream().filter(platformBill -> "SUCCESS".equals(platformBill.getTradeState())).forEach(platformBill -> {
            PlatformBillBO platformBillBO = new PlatformBillBO(platformBill);
            paymentMap.put(platformBillBO.getTradeNo(), platformBillBO);
        });
        platformBillList.stream().filter(platformBill -> "REFUND".equals(platformBill.getTradeState())).forEach(platformBill -> {
            PlatformBillBO platformBillBO = new PlatformBillBO(platformBill);
            refundMap.put(platformBillBO.getTradeNo().concat("_").concat(platformBillBO.getRefundNo()), platformBillBO);
        });
        for (ChannelBill channelBill : channelBillList) {
            PlatformBillBO platformBillBO;
            ChannelBillBO channelBillBO = new ChannelBillBO(channelBill);
            ReconciliationRule reconciliationRule = channelBillBO.getReconciliationRule();
            if ("SUCCESS".equals(channelBillBO.getTradeState())) {
                platformBillBO = (PlatformBillBO)paymentMap.get(channelBillBO.getTransactionId());
            } else {
                String refundId = channelBillBO.getRefundId();
                if (refundId == null) {
                    refundId = "0";
                }
                platformBillBO = (PlatformBillBO)refundMap.get(channelBillBO.getTransactionId().concat("_").concat(refundId));
            }
            if (platformBillBO == null) {
                this.insertErrorBill(billDate, batchNumber, channelBillBO);
                ++errorCount;
                continue;
            }
            if (platformBillBO.getReconciliationRule().equals(reconciliationRule)) continue;
            channelBillBO.setPlatformBillBO(platformBillBO);
            this.insertErrorBill(billDate, batchNumber, channelBillBO);
            ++errorCount;
        }
        return errorCount;
    }

    private void saveReconciliation(String billDate, String batchNumber, MchChan mchChan, List<ChannelBill> channelBillList, List<PlatformBill> platformBillList, int errCount, String channel) {
        Reconciliation reconciliation = new Reconciliation();
        BigDecimal channelPoundage = channelBillList.stream().map(ChannelBill::getPoundage).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal channelPayAmount = channelBillList.stream().filter(item -> "SUCCESS".equals(item.getTradeState())).map(ChannelBill::getTotalFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        int channelPayCount = Integer.parseInt(String.valueOf(channelBillList.stream().filter(item -> "SUCCESS".equals(item.getTradeState())).count()));
        BigDecimal channelRefundAmount = channelBillList.stream().filter(item -> "REFUND".equals(item.getTradeState())).map(item -> item.getRefundFee().abs()).reduce(BigDecimal.ZERO, BigDecimal::add);
        int channelRefundCount = Integer.parseInt(String.valueOf(channelBillList.stream().filter(item -> "REFUND".equals(item.getTradeState())).count()));
        reconciliation.setChannel(channel);
        reconciliation.setApplyCode(mchChan.getMchCode());
        reconciliation.setBatchNumber(batchNumber);
        reconciliation.setContrastDate(billDate);
        reconciliation.setStatus(Integer.valueOf(1));
        reconciliation.setChannelPoundage(channelPoundage);
        reconciliation.setChannelPayAmount(channelPayAmount);
        reconciliation.setChannelPayCount(channelPayCount);
        reconciliation.setChannelRefundAmount(channelRefundAmount);
        reconciliation.setChannelRefundCount(channelRefundCount);
        reconciliation.setChannelTradeAmount(reconciliation.getChannelPayAmount().subtract(reconciliation.getChannelRefundAmount()));
        reconciliation.setChannelTradeCount(reconciliation.getChannelPayCount() - reconciliation.getChannelRefundCount());
        BigDecimal platformPayAmount = platformBillList.stream().filter(item -> "SUCCESS".equals(item.getTradeState())).map(PlatformBill::getDealAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        int platformPayCount = Integer.parseInt(String.valueOf(platformBillList.stream().filter(item -> "SUCCESS".equals(item.getTradeState())).count()));
        BigDecimal platformRefundAmount = platformBillList.stream().filter(item -> "REFUND".equals(item.getTradeState())).map(PlatformBill::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        int platformRefundCount = Integer.parseInt(String.valueOf(platformBillList.stream().filter(item -> "REFUND".equals(item.getTradeState())).count()));
        reconciliation.setPlatformPayAmount(platformPayAmount);
        reconciliation.setPlatformPayCount(platformPayCount);
        reconciliation.setPlatformRefundAmount(platformRefundAmount);
        reconciliation.setPlatformRefundCount(platformRefundCount);
        reconciliation.setPlatformTradeAmount(reconciliation.getPlatformPayAmount().subtract(reconciliation.getPlatformRefundAmount()));
        reconciliation.setPlatformTradeCount(reconciliation.getPlatformPayCount() - reconciliation.getPlatformRefundCount());
        reconciliation.setTradeAmountPoor(reconciliation.getChannelTradeAmount().subtract(reconciliation.getPlatformTradeAmount()));
        reconciliation.setTradeCountPoor(reconciliation.getChannelTradeCount() - reconciliation.getPlatformTradeCount());
        reconciliation.setPayAmountPoor(reconciliation.getChannelPayAmount().subtract(reconciliation.getPlatformPayAmount()));
        reconciliation.setPayCountPoor(reconciliation.getChannelPayCount() - reconciliation.getPlatformPayCount());
        reconciliation.setRefundAmountPoor(reconciliation.getChannelRefundAmount().subtract(reconciliation.getPlatformRefundAmount()));
        reconciliation.setRefundCountPoor(reconciliation.getChannelRefundCount() - reconciliation.getPlatformRefundCount());
        reconciliation.setErrorCount(errCount);
        reconciliation.setUntreatedErrorCount(errCount);
        if (errCount > 0) {
            reconciliation.setResults(ContrastEnum.CONTRAST_FAIL.getValue());
        } else {
            reconciliation.setResults(ContrastEnum.CONTRAST_SUCCESS.getValue());
        }
        reconciliation.setContrastAmount(reconciliation.getChannelPayAmount().add(reconciliation.getChannelRefundAmount()));
        reconciliation.setContrastCount(reconciliation.getChannelPayCount() + reconciliation.getChannelRefundCount());
        reconciliation.setErrorAmount(reconciliation.getTradeAmountPoor());
        reconciliation.setTradeType(mchChan.getType());
        log.info("saveReconciliation reconciliation save data={}", (Object)reconciliation);
        this.reconciliationMapper.insert((Object)reconciliation);
    }

    private void insertErrorBill(String billDate, String batchNumber, ChannelBillBO channelBillBO) {
        channelBillBO.reconciliationWithBill(batchNumber, billDate);
        ErrorBill errorBill = channelBillBO.getErrorBillBO().getErrorBill();
        log.info("insertErrorBill errorBill save data ={}", (Object)errorBill);
        this.errorBillMapper.insert((Object)errorBill);
    }

    public void insertChannelBill(List<ChannelBill> channelBills) {
        if (channelBills.isEmpty()) {
            return;
        }
        List parts = Lists.partition(channelBills, (int)20);
        parts.forEach(part -> this.channelBillMapper.insertList(part));
    }

    public void insertPlatformBill(List<PlatformBill> platformBills) {
        if (platformBills.isEmpty()) {
            return;
        }
        List parts = Lists.partition(platformBills, (int)20);
        parts.forEach(part -> this.platformBillMapper.insertList(part));
    }

    public boolean savePlatformBillByMchCode(ReWriteBillVO reWriteBillVO) {
        List payBillList = this.payBillMapper.selectListByMchChan(reWriteBillVO);
        if (payBillList.isEmpty()) {
            return false;
        }
        ArrayList<PlatformBill> list = new ArrayList<PlatformBill>();
        String billDate = reWriteBillVO.getBillDate();
        for (PayBill payBill : payBillList) {
            PlatformBillBO platformBillBO = new PlatformBillBO();
            platformBillBO.init(payBill, billDate);
            list.add(platformBillBO.getPlatformBill());
        }
        if (list.isEmpty()) {
            return false;
        }
        log.info("savePlatformBillByMchCode platformBill save list={}", list);
        this.platformBillMapper.insertList(list);
        return true;
    }

    public Boolean reWriteBills(ReWriteBillVO reWriteBillVO) {
        String billDate = reWriteBillVO.getBillDate();
        String plantform = reWriteBillVO.getPlantform();
        String mchCode = reWriteBillVO.getMchCode();
        int delete = this.channelBillMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ChannelBill::getContrastDate, (Object)billDate)).eq(ChannelBill::getPayChannel, (Object)plantform)).eq(ChannelBill::getApplyCode, (Object)mchCode)).eq(BaseEntity::getStatus, (Object)1));
        log.info("channelBillMapper.delete number={}", (Object)delete);
        PlatformBill platformBill = new PlatformBill();
        platformBill.setStatus(Integer.valueOf(0));
        int update0 = this.platformBillMapper.update((Object)platformBill, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PlatformBill::getContrastDate, (Object)billDate)).eq(PlatformBill::getTradeChannel, (Object)plantform)).eq(PlatformBill::getMchCode, (Object)mchCode)).eq(BaseEntity::getStatus, (Object)1));
        log.info("platformBillMapper.update number={}", (Object)update0);
        Reconciliation reconciliation = new Reconciliation();
        reconciliation.setStatus(Integer.valueOf(0));
        int update1 = this.reconciliationMapper.update((Object)reconciliation, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Reconciliation::getContrastDate, (Object)billDate)).eq(Reconciliation::getChannel, (Object)plantform)).eq(Reconciliation::getApplyCode, (Object)mchCode)).eq(BaseEntity::getStatus, (Object)1));
        log.info("reconciliationMapper.update number={}", (Object)update1);
        ReconciliationPolymerization rp = new ReconciliationPolymerization();
        rp.setStatus(Integer.valueOf(0));
        int update = this.reconciliationPolymerizationMapper.update((Object)rp, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ReconciliationPolymerization::getContrastDate, (Object)billDate)).eq(ReconciliationPolymerization::getChannel, (Object)plantform)).eq(ReconciliationPolymerization::getApplyCode, (Object)mchCode)).eq(BaseEntity::getStatus, (Object)1));
        log.info("reconciliationPolymerizationMapper.update number={}", (Object)update);
        return true;
    }

    public void reconBillByMchChan(ReWriteBillVO reWriteBillVO, String merchantsMark) {
        String billDate = reWriteBillVO.getBillDate();
        String mchCode = reWriteBillVO.getMchCode();
        String channel = reWriteBillVO.getPlantform();
        String batchNumber = UniqueKeyGenerator.generateViewId();
        List allList = this.mchChanMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MchChan::getChanCode, (Object)channel)).eq(MchChan::getMchCode, (Object)mchCode)).eq(BaseEntity::getStatus, (Object)1)).eq(MchChan::getMerchantsMark, (Object)merchantsMark));
        List mchChansByAppId = this.uniqAppId(allList);
        for (MchChan mchChan : mchChansByAppId) {
            int errorCount = 0;
            LambdaQueryWrapper c = new LambdaQueryWrapper();
            c.eq(ChannelBill::getContrastDate, (Object)billDate);
            c.eq(ChannelBill::getPayChannel, (Object)channel);
            c.eq(ChannelBill::getApplyCode, (Object)mchCode);
            c.eq(ChannelBill::getPayType, (Object)mchChan.getType());
            c.eq(BaseEntity::getStatus, (Object)1);
            List channelBillList = this.channelBillMapper.selectList((Wrapper)c);
            LambdaQueryWrapper p = new LambdaQueryWrapper();
            p.eq(PlatformBill::getContrastDate, (Object)billDate);
            p.eq(PlatformBill::getTradeChannel, (Object)channel);
            p.eq(PlatformBill::getMchCode, (Object)mchCode);
            p.eq(PlatformBill::getTradeType, (Object)mchChan.getType());
            p.eq(BaseEntity::getStatus, (Object)1);
            List platformBillList = this.platformBillMapper.selectList((Wrapper)p);
            this.reconciliationHandler(billDate, batchNumber, mchChan, errorCount, channelBillList, platformBillList, channel);
        }
    }

    public void reconciSavePoly(String billDate) {
        List reconciliations = this.reconciliationMapper.selectListByBillDate(billDate);
        if (Objects.isNull(reconciliations) || reconciliations.isEmpty()) {
            log.info("\u5bf9\u8d26\u63a5\u53e3\u805a\u5408\u5199\u5165\u5bf9\u8d26\u805a\u5408\u8868 reconciliations\u96c6\u5408\u4e3a\u7a7a billDate={}", (Object)billDate);
            return;
        }
        this.reconciliationPolymerizationMapper.insertList(reconciliations);
    }

    public void reconciSavePoly(ReWriteBillVO reWriteBillVO) {
        List reconciliations = this.reconciliationMapper.selectListByMchChan(reWriteBillVO);
        if (Objects.isNull(reconciliations) || reconciliations.isEmpty()) {
            log.info("\u5bf9\u8d26\u63a5\u53e3\u805a\u5408\u5199\u5165\u5bf9\u8d26\u805a\u5408\u8868 Reconciliation \u7ed3\u679c\u4e3a\u7a7a mchCode={}", (Object)reWriteBillVO.getMchCode());
            return;
        }
        this.reconciliationPolymerizationMapper.insertList(reconciliations);
    }

    public void notifyErrorPush(MchChan mchChan, String errorMsg) {
        if ("test".equals(this.payEnvironment)) {
            return;
        }
        new Thread(() -> {
            try {
                log.info("notifyErrorPush \u5f02\u6b65\u8c03\u7528\u77ed\u4fe1\u63a5\u53e3\u5165\u53c2 mchChan={},errorMsg={}", (Object)mchChan, (Object)errorMsg);
                String templateCode = "middle_rec_nofity";
                String appCode = "BYCS";
                String signCode = "BYH_BY";
                String[] phones = new String[]{"15510002724", "15809280425"};
                HashMap<String, String> pushMap = new HashMap<String, String>();
                pushMap.put("mch_name", mchChan.getMchName());
                pushMap.put("mch_code", mchChan.getMchCode());
                pushMap.put("pay_chan", PayChanEnum.getByDisplay((String)mchChan.getChanCode()).getName());
                pushMap.put("error_msg", errorMsg);
                for (String phone : phones) {
                    this.pushInfoUtil.aliSmsPush(appCode, new BaseAliSmsReqVO(templateCode, phone, pushMap), signCode);
                }
            }
            catch (Exception e) {
                log.error("\u5bf9\u8d26\u5f02\u5e38\u77ed\u4fe1\u901a\u77e5\u5931\u8d25 e=", (Throwable)e);
            }
        }).start();
    }
}

