/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.task;

import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.mybank.AddOrderService;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.IReconciliationService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Async
@Component
@EnableScheduling
public class ReconciliationTask {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationTask.class);
    @Autowired
    private IReconciliationService iReconciliationService;
    @Resource
    private RedisTemplateService templateService;
    @Resource
    private AddOrderService addOrderServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 30 10 * * ?")
    public void run() {
        log.info("\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        String beforeDate = DateUtils.getBeforeDay();
        try {
            boolean flag = this.templateService.addLock(beforeDate, beforeDate, 3600L);
            if (!flag) {
                log.info("reconciliation has launched!");
                return;
            }
            long startTime = System.currentTimeMillis();
            this.iReconciliationService.launcher(beforeDate);
            this.iReconciliationService.polymerization(beforeDate);
            long endTime = System.currentTimeMillis();
            log.info("\u603b\u8017\u65f6:{}\u79d2", (Object)((endTime - startTime) / 1000L));
        }
        catch (Exception e) {
            log.error("reconciliationTask error,e=", (Throwable)e);
        }
        finally {
            this.templateService.del(beforeDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 40 10 * * ?")
    public void runBkcloudBill() {
        log.info("=========\u4e91\u8d44\u91d1\u5bf9\u8d26\u5355\u4e0a\u4f20\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c=============");
        String yesterday = DateUtils.getBeforeDay();
        try {
            boolean flag = this.templateService.addLock(yesterday, yesterday, 3600L);
            if (!flag) {
                log.info("runBkcloudBill has executed!");
                return;
            }
            long startTime = System.currentTimeMillis();
            this.addOrderServiceImpl.uploadBkcloudfundBill(yesterday);
            long endTime = System.currentTimeMillis();
            log.info("\u603b\u8017\u65f6:{}\u79d2", (Object)((endTime - startTime) / 1000L));
        }
        catch (Exception e) {
            log.error("runBkcloudBill error,e=", (Throwable)e);
        }
        finally {
            this.templateService.del(yesterday);
        }
    }
}

