/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.bo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.DiscountVo;
import com.ebaiyihui.aggregation.payment.server.utils.MapToJsonUtils;
import com.ebaiyihui.aggregation.payment.server.wxpay.wxbo.WxPayMicropayRequestBO;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RequestCreateOrderBO {
    private static final Logger log = LoggerFactory.getLogger(RequestCreateOrderBO.class);
    private String payChannel;
    private String payType;
    private String mchCode;
    private String serviceCode;
    @ApiModelProperty(value="")
    private String userSign;
    private String subUserSign;
    private String outTradeNo;
    private BigDecimal totalAmount;
    private BigDecimal actuallyAmount;
    private String productInfo;
    private DiscountVo discountVo;
    private String authCode;
    private String sign;
    private String nonceStr;
    private String payNotifyUrl;
    private String applyCode;

    public WxPayUnifiedOrderRequest getWxPayCreateOrder(String requestIp, String timeExpire, String dealTradeNo) {
        String body = this.productInfo;
        Integer amout = BaseWxPayRequest.yuanToFen((String)this.actuallyAmount.toString());
        String attach = MapToJsonUtils.mapInitAndToJsonString((String)this.serviceCode, (String)(StringUtils.isBlank((CharSequence)this.applyCode) ? this.mchCode : this.applyCode), (String)this.payType);
        String subOpenid = this.subUserSign;
        String openid = this.userSign;
        String productId = this.outTradeNo;
        WxPayUnifiedOrderRequest build = WxPayUnifiedOrderRequest.newBuilder().body(body).outTradeNo(dealTradeNo).totalFee(amout).attach(attach).subOpenid(subOpenid).openid(openid).productId(productId).timeExpire(timeExpire).spbillCreateIp(requestIp).build();
        return build;
    }

    public WxPayMicropayRequestBO getWxMicropayOrder(WxPayParam wxPayParam, String requestIp, String timeExpire, String dealTradeNo) {
        String body = this.productInfo;
        Integer amout = BaseWxPayRequest.yuanToFen((String)this.actuallyAmount.toString());
        String attach = MapToJsonUtils.mapInitAndToJsonString((String)this.serviceCode, (String)(StringUtils.isBlank((CharSequence)this.applyCode) ? this.mchCode : this.applyCode), (String)this.payType);
        WxPayMicropayRequestBO build = WxPayMicropayRequestBO.newBuilder().body(body).outTradeNo(dealTradeNo).totalFee(amout).attach(attach).timeExpire(timeExpire).spbillCreateIp(requestIp).authCode(this.authCode).build();
        build.setMchId(wxPayParam.getMchAccount());
        build.setPublicKey(wxPayParam.getMchPublicKey());
        build.setAppid(wxPayParam.getAppId());
        build.setSignType("MD5");
        build.setNonceStr(UUID.randomUUID().toString().replaceAll("-", ""));
        if (null != wxPayParam.getSubMchId() && !"".equals(wxPayParam.getSubMchId().trim())) {
            build.setSubMchId(wxPayParam.getSubMchId());
        } else {
            build.setSubMchId(null);
        }
        if (null != wxPayParam.getSubAppId() && !"".equals(wxPayParam.getSubAppId().trim())) {
            build.setSubAppId(wxPayParam.getSubAppId());
        } else {
            build.setSubAppId(null);
        }
        return build;
    }

    public AlipayTradePagePayRequest getAliPayPageCreateOrder(String dealTradeNo) {
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("out_trade_no", dealTradeNo);
        map.put("product_code", "FAST_INSTANT_TRADE_PAY");
        map.put("total_amount", this.actuallyAmount.toString());
        map.put("subject", this.productInfo);
        map.put("body", this.serviceCode);
        alipayRequest.setBizContent(JSONObject.toJSONString(map));
        return alipayRequest;
    }

    public AlipayTradePrecreateRequest getAliPayPrecreateCreateOrder(String dealTradeNo) {
        AlipayTradePrecreateRequest alipayRequest = new AlipayTradePrecreateRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("out_trade_no", dealTradeNo);
        map.put("total_amount", this.actuallyAmount.toString());
        map.put("subject", this.productInfo);
        map.put("body", this.serviceCode);
        map.put("timeout_express", "90m");
        alipayRequest.setBizContent(JSON.toJSONString(map));
        return alipayRequest;
    }

    public AlipayTradePayRequest getAliMicropayOrder(String outTradeNo) {
        AlipayTradePayRequest alipayRequest = new AlipayTradePayRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("out_trade_no", outTradeNo);
        map.put("scene", "bar_code");
        map.put("auth_code", this.authCode);
        map.put("total_amount", this.actuallyAmount.toString());
        map.put("subject", this.productInfo);
        map.put("body", MapToJsonUtils.mapInitAndToJsonString((String)this.serviceCode, (String)(StringUtils.isBlank((CharSequence)this.applyCode) ? this.mchCode : this.applyCode), (String)this.payType));
        map.put("timeout_express", "5m");
        alipayRequest.setBizContent(JSON.toJSONString(map));
        return alipayRequest;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public void setMchCode(String mchCode) {
        this.mchCode = mchCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public void setUserSign(String userSign) {
        this.userSign = userSign;
    }

    public void setSubUserSign(String subUserSign) {
        this.subUserSign = subUserSign;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setActuallyAmount(BigDecimal actuallyAmount) {
        this.actuallyAmount = actuallyAmount;
    }

    public void setProductInfo(String productInfo) {
        this.productInfo = productInfo;
    }

    public void setDiscountVo(DiscountVo discountVo) {
        this.discountVo = discountVo;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public void setPayNotifyUrl(String payNotifyUrl) {
        this.payNotifyUrl = payNotifyUrl;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public String getPayChannel() {
        return this.payChannel;
    }

    public String getPayType() {
        return this.payType;
    }

    public String getMchCode() {
        return this.mchCode;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public String getUserSign() {
        return this.userSign;
    }

    public String getSubUserSign() {
        return this.subUserSign;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getActuallyAmount() {
        return this.actuallyAmount;
    }

    public String getProductInfo() {
        return this.productInfo;
    }

    public DiscountVo getDiscountVo() {
        return this.discountVo;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getSign() {
        return this.sign;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public String getPayNotifyUrl() {
        return this.payNotifyUrl;
    }

    public String getApplyCode() {
        return this.applyCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestCreateOrderBO)) {
            return false;
        }
        RequestCreateOrderBO other = (RequestCreateOrderBO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$payChannel = this.getPayChannel();
        String other$payChannel = other.getPayChannel();
        if (this$payChannel == null ? other$payChannel != null : !this$payChannel.equals(other$payChannel)) {
            return false;
        }
        String this$payType = this.getPayType();
        String other$payType = other.getPayType();
        if (this$payType == null ? other$payType != null : !this$payType.equals(other$payType)) {
            return false;
        }
        String this$mchCode = this.getMchCode();
        String other$mchCode = other.getMchCode();
        if (this$mchCode == null ? other$mchCode != null : !this$mchCode.equals(other$mchCode)) {
            return false;
        }
        String this$serviceCode = this.getServiceCode();
        String other$serviceCode = other.getServiceCode();
        if (this$serviceCode == null ? other$serviceCode != null : !this$serviceCode.equals(other$serviceCode)) {
            return false;
        }
        String this$userSign = this.getUserSign();
        String other$userSign = other.getUserSign();
        if (this$userSign == null ? other$userSign != null : !this$userSign.equals(other$userSign)) {
            return false;
        }
        String this$subUserSign = this.getSubUserSign();
        String other$subUserSign = other.getSubUserSign();
        if (this$subUserSign == null ? other$subUserSign != null : !this$subUserSign.equals(other$subUserSign)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        BigDecimal this$actuallyAmount = this.getActuallyAmount();
        BigDecimal other$actuallyAmount = other.getActuallyAmount();
        if (this$actuallyAmount == null ? other$actuallyAmount != null : !((Object)this$actuallyAmount).equals(other$actuallyAmount)) {
            return false;
        }
        String this$productInfo = this.getProductInfo();
        String other$productInfo = other.getProductInfo();
        if (this$productInfo == null ? other$productInfo != null : !this$productInfo.equals(other$productInfo)) {
            return false;
        }
        DiscountVo this$discountVo = this.getDiscountVo();
        DiscountVo other$discountVo = other.getDiscountVo();
        if (this$discountVo == null ? other$discountVo != null : !this$discountVo.equals(other$discountVo)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$nonceStr = this.getNonceStr();
        String other$nonceStr = other.getNonceStr();
        if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
            return false;
        }
        String this$payNotifyUrl = this.getPayNotifyUrl();
        String other$payNotifyUrl = other.getPayNotifyUrl();
        if (this$payNotifyUrl == null ? other$payNotifyUrl != null : !this$payNotifyUrl.equals(other$payNotifyUrl)) {
            return false;
        }
        String this$applyCode = this.getApplyCode();
        String other$applyCode = other.getApplyCode();
        return !(this$applyCode == null ? other$applyCode != null : !this$applyCode.equals(other$applyCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestCreateOrderBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $payChannel = this.getPayChannel();
        result = result * 59 + ($payChannel == null ? 43 : $payChannel.hashCode());
        String $payType = this.getPayType();
        result = result * 59 + ($payType == null ? 43 : $payType.hashCode());
        String $mchCode = this.getMchCode();
        result = result * 59 + ($mchCode == null ? 43 : $mchCode.hashCode());
        String $serviceCode = this.getServiceCode();
        result = result * 59 + ($serviceCode == null ? 43 : $serviceCode.hashCode());
        String $userSign = this.getUserSign();
        result = result * 59 + ($userSign == null ? 43 : $userSign.hashCode());
        String $subUserSign = this.getSubUserSign();
        result = result * 59 + ($subUserSign == null ? 43 : $subUserSign.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        BigDecimal $actuallyAmount = this.getActuallyAmount();
        result = result * 59 + ($actuallyAmount == null ? 43 : ((Object)$actuallyAmount).hashCode());
        String $productInfo = this.getProductInfo();
        result = result * 59 + ($productInfo == null ? 43 : $productInfo.hashCode());
        DiscountVo $discountVo = this.getDiscountVo();
        result = result * 59 + ($discountVo == null ? 43 : $discountVo.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $nonceStr = this.getNonceStr();
        result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
        String $payNotifyUrl = this.getPayNotifyUrl();
        result = result * 59 + ($payNotifyUrl == null ? 43 : $payNotifyUrl.hashCode());
        String $applyCode = this.getApplyCode();
        result = result * 59 + ($applyCode == null ? 43 : $applyCode.hashCode());
        return result;
    }

    public String toString() {
        return "RequestCreateOrderBO(payChannel=" + this.getPayChannel() + ", payType=" + this.getPayType() + ", mchCode=" + this.getMchCode() + ", serviceCode=" + this.getServiceCode() + ", userSign=" + this.getUserSign() + ", subUserSign=" + this.getSubUserSign() + ", outTradeNo=" + this.getOutTradeNo() + ", totalAmount=" + this.getTotalAmount() + ", actuallyAmount=" + this.getActuallyAmount() + ", productInfo=" + this.getProductInfo() + ", discountVo=" + this.getDiscountVo() + ", authCode=" + this.getAuthCode() + ", sign=" + this.getSign() + ", nonceStr=" + this.getNonceStr() + ", payNotifyUrl=" + this.getPayNotifyUrl() + ", applyCode=" + this.getApplyCode() + ")";
    }
}

