/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.notify;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.config.WxPayConfiguration;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.notify.INotify;
import com.ebaiyihui.aggregation.payment.server.service.notify.NotifyFactory;
import com.ebaiyihui.aggregation.payment.server.service.notify.RabbitMqPusher;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.service.WxPayService;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatRefund
implements INotify,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WechatRefund.class);
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private PayMchService payMchService;
    @Autowired
    private PayApplyService payApplyService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitMqPusher rabbitMqPusher;
    @Autowired
    private WxPayConfiguration wxPayConfiguration;

    public String notify(HttpServletRequest request) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        log.info("=====\u8fdb\u5165\u4e86\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03=====");
        try {
            String xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u7ed3\u679c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)xmlResult);
            WxPayRefundNotifyResult result = (WxPayRefundNotifyResult)BaseWxPayResult.fromXML((String)xmlResult, WxPayRefundNotifyResult.class);
            WxPayParam wxPayParam = this.mchChanService.getByMerchantsId(result.getMchId());
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            WxPayRefundNotifyResult refundResult = wxPayService.parseRefundNotifyResult(xmlResult);
            log.info("\u3010\u5fae\u4fe1\u3011\u8c03\u7528SDK\u9a8c\u7b7e\u7ed3\u679c\uff1a{}", (Object)refundResult.toString());
            String orderId = refundResult.getReqInfo().getOutTradeNo();
            log.info("\u8ba2\u5355\u53f7\uff1a{}", (Object)orderId);
            PayBill payBill = this.payBillService.getByDealTradeNo(orderId);
            if (null == payBill) {
                log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u56de\u8c03\uff0c\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25{}", (Object)payBill.toString());
                return WxPayNotifyResponse.fail((String)"\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
            }
            if (payBill.getStatus().equals(OrderStatusEnum.PAID.getValue())) {
                payBill.setRemake("\u6807\u8bb0:\u53c2\u6570\u6821\u9a8c\u5931\u8d25,\u9000\u6b3e\u6210\u529f\u8ba2\u5355!");
            }
            payBill.setStatus(OrderStatusEnum.HAVE_A_REFUND.getValue());
            payBill.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)refundResult.getReqInfo().getSuccessTime()));
            payBill.setRefundNo(refundResult.getReqInfo().getRefundId());
            payBill.setOutRefundNo(refundResult.getReqInfo().getOutRefundNo());
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            log.info("\u3010\u5fae\u4fe1\u3011\u9000\u6b3e\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND);
            log.info("-------------\u6784\u5efaResponseRefundNotifyRestVo\uff0c\u51c6\u5907\u9000\u6b3e\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u9000\u6b3e\u6d41\u7a0b-----------");
            ResponseRefundNotifyRestVo responseRefundNotifyRestVo = new ResponseRefundNotifyRestVo();
            responseRefundNotifyRestVo.setMchCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setMchId(refundResult.getMchId());
            responseRefundNotifyRestVo.setMchName(payMch.getName());
            responseRefundNotifyRestVo.setReturnCode(refundResult.getReturnCode());
            responseRefundNotifyRestVo.setReturnMsg(refundResult.getReturnMsg());
            responseRefundNotifyRestVo.setErrCode(refundResult.getErrCode());
            responseRefundNotifyRestVo.setErrCodeDes(refundResult.getErrCodeDes());
            responseRefundNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseRefundNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseRefundNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseRefundNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseRefundNotifyRestVo.setRefundNo(refundResult.getReqInfo().getRefundId());
            responseRefundNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            responseRefundNotifyRestVo.setRefundMoney(BigDecimal.valueOf(Long.valueOf(refundResult.getReqInfo().getSettlementRefundFee().toString())).divide(new BigDecimal(100)));
            responseRefundNotifyRestVo.setRefundTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)refundResult.getReqInfo().getSuccessTime()));
            if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                responseRefundNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseRefundNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseRefundNotifyRestVo.setNotifyResultStr(JSON.toJSONString((Object)refundResult));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseRefundNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseRefundNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseRefundNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.REFUND_IN_THE_CALLBACK);
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseRefundNotifyRestVo.toString());
            this.rabbitMqPusher.notify("refund", JSON.toJSONString((Object)responseRefundNotifyRestVo));
            return WxPayNotifyResponse.success((String)"OK");
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
    }

    public void afterPropertiesSet() throws Exception {
        String name = this.getClass().getSimpleName();
        String concatName = name.substring(0, 1).toLowerCase().concat(name.substring(1));
        NotifyFactory.register((String)concatName, (INotify)this);
    }
}

