/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.mybank.manage;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.server.mapper.MchChanMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankApiException;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankApiExceptionEnum;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.MyBankConfigBO;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RequestHead;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RespInfo;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.Response;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.ResponseBody;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.ResponseDocument;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.ResponseHead;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.mapping.DefaultSigner;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.util.JaxbUtil;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.util.MybankSignature;
import com.ebaiyihui.aggregation.payment.server.mybank.manage.StrategyFactory;
import com.ebaiyihui.aggregation.payment.server.mybank.response.notify.BkcloudfundsNotifyResponseBody;
import com.ebaiyihui.aggregation.payment.server.service.mybank.notify.FunctionEnum;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class CommonRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(CommonRequestHandler.class);
    @Autowired
    private StrategyFactory strategyFactory;
    @Resource
    private MchChanMapper mchChanMapper;

    public String getXmlContextString(HttpServletRequest httpServletRequest) throws MybankApiException {
        StringWriter writer = new StringWriter();
        BufferedReader reader = null;
        try {
            reader = httpServletRequest.getReader();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SDK_SYSTEM_EXCEPTION, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new MybankApiException(MybankApiExceptionEnum.SDK_SYSTEM_EXCEPTION, (Throwable)e);
                }
            }
        }
        return writer.toString();
    }

    public String notifyRequstHandle(String xmlContext) throws MybankApiException {
        String functionName = null;
        String result = null;
        try {
            functionName = this.getNotifyFunction(xmlContext);
            String notifyAppId = this.getNotifyAppId(xmlContext);
            log.info("notify functionName:{},notifyAppId:{}", (Object)functionName, (Object)notifyAppId);
            String param = this.mchChanMapper.selectParamByAppId(notifyAppId);
            MyBankConfigBO myBankConfigBO = (MyBankConfigBO)JSONObject.parseObject((String)param, MyBankConfigBO.class);
            result = this.strategyFactory.getStrategy(FunctionEnum.getStrategyValue((String)functionName)).notifyHandle(xmlContext, functionName, myBankConfigBO.getPrivateKey());
        }
        catch (Exception e) {
            throw new MybankApiException((Throwable)e);
        }
        return result;
    }

    public TreeMap<String, String> getNotifyHead(String xmlContext) throws MybankApiException {
        TreeMap<String, String> headMap = new TreeMap<String, String>();
        Document doc = MybankSignature.parseDocumentByString((String)xmlContext);
        Element root = doc.getDocumentElement();
        Node head = root.getElementsByTagName("head").item(0);
        NodeList childNodes = head.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 1) continue;
            headMap.put(childNodes.item(i).getNodeName(), childNodes.item(i).getTextContent());
        }
        return headMap;
    }

    public String getNotifyAppId(String xmlContext) throws MybankApiException {
        TreeMap notifyHead = this.getNotifyHead(xmlContext);
        return (String)notifyHead.get("Appid");
    }

    public String getNotifyFunction(String xmlContext) throws MybankApiException {
        TreeMap notifyHead = this.getNotifyHead(xmlContext);
        return (String)notifyHead.get("Function");
    }

    public String getSignResult(boolean flag, RequestHead head, String privateKey) throws MybankApiException {
        RespInfo respInfo = new RespInfo();
        if (flag) {
            respInfo.setResultCode("0000");
            respInfo.setResultMsg("\u6210\u529f");
            respInfo.setResultStatus("S");
        } else {
            respInfo.setResultCode("9000");
            respInfo.setResultMsg("\u5931\u8d25");
            respInfo.setResultStatus("F");
        }
        BkcloudfundsNotifyResponseBody responseBody = new BkcloudfundsNotifyResponseBody();
        responseBody.setRespInfo(respInfo);
        return this.responseAndSign(head, (ResponseBody)responseBody, privateKey);
    }

    public String responseAndSign(RequestHead head, ResponseBody responseBody, String privateKey) throws MybankApiException {
        ResponseHead responseHead = ResponseHead.builder((String)head.getVersion(), (String)head.getAppId(), (String)head.getFunction(), (String)head.getReqMsgId()).inputCharset("UTF-8").respTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"))).respTimeZone("UTC+8").reserve("").signType("RSA").build();
        ResponseDocument responseDocument = new ResponseDocument(new Response(responseHead, responseBody));
        DefaultSigner signer = new DefaultSigner(privateKey);
        String result = null;
        String xml = null;
        try {
            xml = JaxbUtil.convertToXml((Object)responseDocument, (String)"UTF-8");
            result = signer.notifyResponseSign(xml, "UTF-8", "RSA");
        }
        catch (MybankApiException e) {
            throw new MybankApiException((Throwable)e);
        }
        return result;
    }
}

